/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteMappingsListener;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.PathMappingProviderEx;
import com.intellij.remote.ext.PathMappingType;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.SwingHelper;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshCredentialsUtil;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.ui.MappingsGatherer;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsConfiguration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteMappingsHolder {
    private static final Logger LOG = Logger.getInstance(RemoteMappingsHolder.class);
    @NotNull
    protected final Project myProject;
    protected final String myInterpreterKindPrefix;
    @NotNull
    protected final Consumer<String> myErrorConsumer;
    @Nullable
    protected RemoteSdkAdditionalData mySdkAdditionalData;
    protected RemoteMappingsConfiguration.Builder myBuilder;
    @Nullable
    protected String myServerId;

    public RemoteMappingsHolder(@NotNull Project project, String interpreterKindPrefix, @NotNull Consumer<String> errorConsumer) {
        if (project == null) {
            RemoteMappingsHolder.$$$reportNull$$$0(0);
        }
        if (errorConsumer == null) {
            RemoteMappingsHolder.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myInterpreterKindPrefix = interpreterKindPrefix;
        this.myErrorConsumer = errorConsumer;
    }

    protected void addMappingsFromProducers() {
        boolean hasTypedProviders = false;
        List providers = PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)this.mySdkAdditionalData);
        for (PathMappingProvider provider : providers) {
            if (!(provider instanceof PathMappingProviderEx)) continue;
            hasTypedProviders = true;
            List mappings = provider.getPathMappingSettings(this.myProject, this.mySdkAdditionalData).getPathMappings();
            if (mappings.isEmpty()) continue;
            this.myBuilder.withMappings(((PathMappingProviderEx)provider).getMappingType(), mappings);
        }
        if (!hasTypedProviders) {
            CredentialsType connectionType = this.mySdkAdditionalData.getRemoteConnectionType();
            if (!SshCredentialsUtil.producesSshSdkCredentials(this.mySdkAdditionalData)) {
                return;
            }
            List<PathMappingSettings.PathMapping> list = new MappingsGatherer(this.myProject, this.mySdkAdditionalData, this.myInterpreterKindPrefix).addUserDefined(false).addDisabled(true).assemble();
            if (list.isEmpty()) {
                return;
            }
            if (connectionType == VagrantCredentialsType.getInstance()) {
                this.myBuilder.withMappings(PathMappingType.REPLICATED_FOLDER, list);
            } else if (RemoteSdkUtil.isSshCredentialType(connectionType)) {
                this.myBuilder.withMappings(PathMappingType.DEPLOYMENT, list);
            }
        }
    }

    @NotNull
    public JComponent getDescriptionComponent(@NotNull String serverId) {
        if (serverId == null) {
            RemoteMappingsHolder.$$$reportNull$$$0(2);
        }
        @NlsSafe String style = "color:#" + Integer.toHexString(NamedColorUtil.getInactiveTextColor().getRGB()).substring(2);
        String html = new HtmlBuilder().append(RemoteSdkBundle.message("project.path.mappings.for.all.usages.of.the.selected.interpreter", new Object[0])).wrapWith(HtmlChunk.tag((String)"font").attr("style", style)).toString();
        JEditorPane jEditorPane = SwingHelper.createHtmlLabel((String)html, null, null);
        if (jEditorPane == null) {
            RemoteMappingsHolder.$$$reportNull$$$0(3);
        }
        return jEditorPane;
    }

    public void clearAndShowDisabled(@Nullable String fieldText, @Nullable String problemText) {
        this.myServerId = null;
        this.mySdkAdditionalData = null;
        this.setVisible(true);
        this.setEnabled(false);
        this.updatePresentation(StringUtil.notNullize((String)fieldText));
        this.setToolTipText(problemText);
        this.myErrorConsumer.consume((Object)problemText);
    }

    public void updateServerId(@NotNull String serverId, @NotNull RemoteSdkAdditionalData sdkAdditionalData) {
        if (serverId == null) {
            RemoteMappingsHolder.$$$reportNull$$$0(4);
        }
        if (sdkAdditionalData == null) {
            RemoteMappingsHolder.$$$reportNull$$$0(5);
        }
        this.myServerId = serverId;
        this.mySdkAdditionalData = sdkAdditionalData;
        this.myErrorConsumer.consume(null);
        this.setEnabled(true);
        this.setVisible(this.myServerId != null && this.mySdkAdditionalData != null);
        this.myBuilder = new RemoteMappingsConfiguration.Builder(this.myProject, this.myInterpreterKindPrefix, this.myServerId, this.mySdkAdditionalData);
        try {
            this.myBuilder.withDescriptionComponent(this.getDescriptionComponent(this.myServerId));
            this.addMappingsFromProducers();
            this.updatePresentation(this.myBuilder.getPresentation());
            this.setToolTipText(this.myBuilder.getTooltipText());
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            this.clearAndShowDisabled(e.getMessage(), e.getMessage());
        }
    }

    protected abstract void setToolTipText(String var1);

    protected abstract void setVisible(boolean var1);

    protected abstract void setEnabled(boolean var1);

    protected abstract void updatePresentation(@Nullable String var1);

    protected abstract String getPresentation();

    public void editPathMappings() {
        if (this.myServerId == null || this.mySdkAdditionalData == null || this.myBuilder == null) {
            return;
        }
        this.myErrorConsumer.consume(null);
        String value = this.getPresentation();
        try {
            value = this.myBuilder.configureAndSelect();
            this.updateServerId(this.myServerId, this.mySdkAdditionalData);
            this.updatePresentation(value);
            ((RemoteMappingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RemoteMappingsListener.REMOTE_MAPPINGS_CHANGED)).mappingsChanged(this.myInterpreterKindPrefix, this.myServerId);
        }
        catch (ExecutionException e1) {
            LOG.info((Throwable)e1);
            this.clearAndShowDisabled(value, e1.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorConsumer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionComponent";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateServerId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

