/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.ui.ClickListener;
import com.intellij.ui.StatusPanel;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkUIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001aF\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e\u001a8\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0015\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u00162\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0019H\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "doTestConnection", "", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "useReferencedCredentials", "", "statusPanel", "Lcom/intellij/ui/StatusPanel;", "validator", "Ljava/lang/Runnable;", "hostLabel", "Ljavax/swing/JLabel;", "hostUrl", "testConnectionCallBack", "validateUsingRemoteSdkCredentials", "", "supplier", "Ljava/util/function/Supplier;", "Lcom/intellij/remote/RemoteSdkAdditionalData;", "helpersPathUpdateCallback", "Ljava/util/function/Consumer;", "intellij.remoteRun"})
@JvmName(name="CreateRemoteSdkUIUtil")
public final class CreateRemoteSdkUIUtil {
    @NotNull
    private static final Logger LOG;

    public static final void useReferencedCredentials(@Nullable Project project, @NotNull StatusPanel statusPanel, @Nullable Runnable validator, @Nullable RemoteCredentials credentials, @NotNull JLabel hostLabel, @NotNull JLabel hostUrl, @Nullable Runnable testConnectionCallBack) {
        Intrinsics.checkNotNullParameter((Object)statusPanel, (String)"statusPanel");
        Intrinsics.checkNotNullParameter((Object)hostLabel, (String)"hostLabel");
        Intrinsics.checkNotNullParameter((Object)hostUrl, (String)"hostUrl");
        if (credentials != null) {
            hostUrl.setVisible(true);
            hostLabel.setVisible(true);
            String credentialsString = StringUtil.isNotEmpty((String)credentials.getUserName()) && StringUtil.isNotEmpty((String)credentials.getHost()) ? RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)credentials) : "";
            hostUrl.setText(new HtmlBuilder().appendLink("#", credentialsString).wrapWithHtmlBody().toString());
            hostUrl.setCursor(Cursor.getPredefinedCursor(12));
            MouseListener[] mouseListenerArray = hostUrl.getMouseListeners();
            Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
            for (MouseListener ml : mouseListenerArray) {
                hostUrl.removeMouseListener(ml);
            }
            new ClickListener(statusPanel, testConnectionCallBack, project, credentials, hostLabel, validator){
                final /* synthetic */ StatusPanel $statusPanel;
                final /* synthetic */ Runnable $testConnectionCallBack;
                final /* synthetic */ Project $project;
                final /* synthetic */ RemoteCredentials $credentials;
                final /* synthetic */ JLabel $hostLabel;
                final /* synthetic */ Runnable $validator;
                {
                    this.$statusPanel = $statusPanel;
                    this.$testConnectionCallBack = $testConnectionCallBack;
                    this.$project = $project;
                    this.$credentials = $credentials;
                    this.$hostLabel = $hostLabel;
                    this.$validator = $validator;
                }

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (clickCount == 1) {
                        StatusPanel.Action action = this.$statusPanel.progress(RemoteSdkBundle.message("progress.text.testing.connection", new Object[0]));
                        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"progress(...)");
                        StatusPanel.Action testConnectionAction = action;
                        Runnable runnable = this.$testConnectionCallBack;
                        if (runnable != null) {
                            runnable.run();
                        }
                        ApplicationManager.getApplication().executeOnPooledThread(() -> useReferencedCredentials.1.onClick$lambda$1(this.$project, this.$credentials, testConnectionAction, this.$hostLabel, this.$validator));
                        return true;
                    }
                    return false;
                }

                private static final void onClick$lambda$1$lambda$0(Runnable $validator) {
                    block0: {
                        Runnable runnable = $validator;
                        if (runnable == null) break block0;
                        runnable.run();
                    }
                }

                private static final void onClick$lambda$1(Project $project, RemoteCredentials $credentials, StatusPanel.Action $testConnectionAction, JLabel $hostLabel, Runnable $validator) {
                    Intrinsics.checkNotNullParameter((Object)$testConnectionAction, (String)"$testConnectionAction");
                    Intrinsics.checkNotNullParameter((Object)$hostLabel, (String)"$hostLabel");
                    if (CreateRemoteSdkUIUtil.access$doTestConnection($project, $credentials)) {
                        Object[] objectArray = new Object[]{$credentials.getHost()};
                        $testConnectionAction.doneWithResult(WDBundle.message((String)"connection.to.successful", (Object[])objectArray));
                    } else {
                        Object[] objectArray = new Object[]{$credentials.getHost(), ""};
                        $testConnectionAction.failed(WDBundle.message((String)"connection.to.failed", (Object[])objectArray));
                        ApplicationManager.getApplication().invokeLater(() -> useReferencedCredentials.1.onClick$lambda$1$lambda$0($validator), ModalityState.stateForComponent((Component)$hostLabel));
                    }
                }
            }.installOn((Component)hostUrl);
        } else {
            hostUrl.setVisible(false);
            hostLabel.setVisible(false);
        }
    }

    private static final boolean doTestConnection(Project project, RemoteCredentials credentials) {
        try {
            return RemoteSdkUtil.doTestConnection(project, credentials, 10L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static final String validateUsingRemoteSdkCredentials(@Nullable Project project, @NotNull Supplier<? extends RemoteSdkAdditionalData<?>> supplier, @NotNull Consumer<? super String> helpersPathUpdateCallback) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        Intrinsics.checkNotNullParameter(helpersPathUpdateCallback, (String)"helpersPathUpdateCallback");
        try {
            RemoteSdkAdditionalData<?> sdkData = supplier.get();
            RemoteSdkCredentials data = sdkData.getRemoteSdkCredentials(project, true);
            if (!RemoteSdkUtil.testConnectionAndCreateHelpersPath(project, data, RemoteSdkBundle.message("dialog.title.connecting.to.remote.host", new Object[0]), arg_0 -> CreateRemoteSdkUIUtil.validateUsingRemoteSdkCredentials$lambda$0(helpersPathUpdateCallback, data, arg_0))) {
                return RemoteSdkBundle.message("can.t.connect.to.remote.host", new Object[0]);
            }
        }
        catch (FileSystemException e) {
            LOG.info((Throwable)e);
            return e.getMessage();
        }
        catch (RemoteCancelledException e) {
            return RemoteSdkBundle.message("connection.cancelled", new Object[0]);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return e.getMessage();
        }
        return null;
    }

    private static final void validateUsingRemoteSdkCredentials$lambda$0(Consumer $helpersPathUpdateCallback, RemoteSdkCredentials $data, RemoteSdkCredentials it) {
        Intrinsics.checkNotNullParameter((Object)$helpersPathUpdateCallback, (String)"$helpersPathUpdateCallback");
        String string = $data.getHelpersPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHelpersPath(...)");
        $helpersPathUpdateCallback.accept(string);
    }

    public static final /* synthetic */ boolean access$doTestConnection(Project project, RemoteCredentials credentials) {
        return CreateRemoteSdkUIUtil.doTestConnection(project, credentials);
    }

    static {
        Logger logger = Logger.getInstance((String)"com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkUIUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

