/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target;

import com.intellij.execution.target.BrowsableTargetEnvironmentType;
import com.intellij.execution.target.CustomToolLanguageRuntimeType;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetBrowserHints;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentWizardStepKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.rsync.RsyncStatusService;
import com.intellij.ssh.ui.unified.SshCredentialsEditorEx;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshRemoteEnvironmentRequest;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetConfigurable;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfiguration;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfigurationBase;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshConfigureCustomToolStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetAuthStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetConnectionStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetIntrospectionStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetLanguageStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetWizardModel;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.ServerDeployableWithTempCredentials;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0004JU\u0010\r\u001a\u00020\u000e\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00152\u0006\u0010\u0016\u001a\u0002H\u000f2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ0\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00022\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\u0002H\u0016J\u001a\u0010%\u001a\u00020&2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J,\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00022\f\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010!H\u0016J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u001e\u00100\u001a\u0002012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010!H\u0016R\u0016\u0010\u0005\u001a\u00020\u00068\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00063"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetType;", "Lcom/intellij/execution/target/TargetEnvironmentType;", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfiguration;", "Lcom/intellij/execution/target/BrowsableTargetEnvironmentType;", "()V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "createBrowser", "Ljava/awt/event/ActionListener;", "T", "Ljava/awt/Component;", "project", "Lcom/intellij/openapi/project/Project;", "title", "textComponentAccessor", "Lcom/intellij/openapi/ui/TextComponentAccessor;", "component", "configurationSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "targetBrowserHints", "Lcom/intellij/execution/target/TargetBrowserHints;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/ui/TextComponentAccessor;Ljava/awt/Component;Ljava/util/function/Supplier;Lcom/intellij/execution/target/TargetBrowserHints;)Ljava/awt/event/ActionListener;", "createConfigurable", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurable;", "config", "defaultLanguage", "Lcom/intellij/execution/target/LanguageRuntimeType;", "parentConfigurable", "Lcom/intellij/openapi/options/Configurable;", "createDefaultConfig", "createEnvironmentRequest", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshRemoteEnvironmentRequest;", "createSerializer", "createStepsForNewWizard", "", "Lcom/intellij/ide/wizard/AbstractWizardStepEx;", "configToConfigure", "runtimeType", "duplicateConfig", "initializeNewlyCreated", "", "providesNewWizard", "", "Companion", "intellij.remoteRun"})
public final class SshTargetType
extends TargetEnvironmentType<SshTargetEnvironmentConfiguration>
implements BrowsableTargetEnvironmentType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Icon icon;
    @NlsSafe
    @NotNull
    private final String displayName;
    @NonNls
    @NotNull
    private static final String TYPE_ID = "ssh/sftp";

    public SshTargetType() {
        super(TYPE_ID);
        Icon icon = AllIcons.Debugger.Console;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Console");
        this.icon = icon;
        this.displayName = "SSH";
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public SshTargetEnvironmentConfiguration createSerializer(@NotNull SshTargetEnvironmentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        return config;
    }

    @NotNull
    public SshTargetEnvironmentConfiguration createDefaultConfig() {
        return new SshTargetEnvironmentConfiguration();
    }

    public void initializeNewlyCreated(@NotNull SshTargetEnvironmentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        config.setUseRsync(RsyncStatusService.getInstance().getCachedRsyncStatus() == RsyncStatusService.Status.INSTALLED_AND_CONFIGURED);
    }

    @NotNull
    public SshTargetConfigurable createConfigurable(@NotNull Project project, @NotNull SshTargetEnvironmentConfiguration config, @Nullable LanguageRuntimeType<?> defaultLanguage, @Nullable Configurable parentConfigurable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        return new SshTargetConfigurable(project, config, true);
    }

    @NotNull
    public SshRemoteEnvironmentRequest createEnvironmentRequest(@Nullable Project project, @NotNull SshTargetEnvironmentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        return new SshRemoteEnvironmentRequest(project, config, null, 4, null);
    }

    @NotNull
    public SshTargetEnvironmentConfiguration duplicateConfig(@NotNull SshTargetEnvironmentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        return (SshTargetEnvironmentConfiguration)TargetEnvironmentType.Companion.duplicateTargetConfiguration((TargetEnvironmentType)this, (TargetEnvironmentConfiguration)config);
    }

    public boolean providesNewWizard(@NotNull Project project, @Nullable LanguageRuntimeType<?> runtimeType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @NotNull
    public List<AbstractWizardStepEx> createStepsForNewWizard(@NotNull Project project, @NotNull SshTargetEnvironmentConfiguration configToConfigure, @Nullable LanguageRuntimeType<?> runtimeType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)configToConfigure), (String)"configToConfigure");
        boolean isCustomToolConfiguration = runtimeType instanceof CustomToolLanguageRuntimeType;
        SshTargetWizardModel model = new SshTargetWizardModel(project, configToConfigure, null, 4, null);
        model.setLanguageType(runtimeType);
        model.setCustomToolConfiguration(isCustomToolConfiguration);
        Object[] objectArray = new TargetEnvironmentWizardStepKt[]{new SshTargetConnectionStep(model, null, 2, null), new SshTargetAuthStep(model, null, 2, null), new SshTargetIntrospectionStep(model, null, 2, null), isCustomToolConfiguration ? (TargetEnvironmentWizardStepKt)new SshConfigureCustomToolStep(model, null, 2, null) : (TargetEnvironmentWizardStepKt)new SshTargetLanguageStep(model, true)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public <T extends Component> ActionListener createBrowser(@NotNull Project project, @NotNull String title, @NotNull TextComponentAccessor<T> textComponentAccessor, @NotNull T component, @NotNull Supplier<? extends TargetEnvironmentConfiguration> configurationSupplier, @NotNull TargetBrowserHints targetBrowserHints) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(textComponentAccessor, (String)"textComponentAccessor");
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(configurationSupplier, (String)"configurationSupplier");
        Intrinsics.checkNotNullParameter((Object)targetBrowserHints, (String)"targetBrowserHints");
        return arg_0 -> SshTargetType.createBrowser$lambda$0(configurationSupplier, project, title, component, textComponentAccessor, arg_0);
    }

    private static final void createBrowser$lambda$0(Supplier $configurationSupplier, Project $project, String $title, Component $component, TextComponentAccessor $textComponentAccessor, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$configurationSupplier, (String)"$configurationSupplier");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        Intrinsics.checkNotNullParameter((Object)$textComponentAccessor, (String)"$textComponentAccessor");
        TargetEnvironmentConfiguration configuration = (TargetEnvironmentConfiguration)$configurationSupplier.get();
        if (configuration instanceof SshTargetEnvironmentConfigurationBase) {
            Companion.handleBrowsing$intellij_remoteRun(((SshTargetEnvironmentConfigurationBase)configuration).getSshUiData(), $project, $title, $component, $textComponentAccessor);
            return;
        }
        throw new IllegalArgumentException("Unexpected configuration " + configuration);
    }

    @NotNull
    public static final String getTYPE_ID() {
        return Companion.getTYPE_ID();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\r\b\u0001\u0010\u0010\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u0002H\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u0014H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetType$Companion;", "", "()V", "TYPE_ID", "", "getTYPE_ID$annotations", "getTYPE_ID", "()Ljava/lang/String;", "handleBrowsing", "", "C", "Ljava/awt/Component;", "sshUiData", "Lcom/intellij/ssh/ui/unified/SshUiData;", "project", "Lcom/intellij/openapi/project/Project;", "title", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "component", "textComponentAccessor", "Lcom/intellij/openapi/ui/TextComponentAccessor;", "handleBrowsing$intellij_remoteRun", "(Lcom/intellij/ssh/ui/unified/SshUiData;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/awt/Component;Lcom/intellij/openapi/ui/TextComponentAccessor;)V", "intellij.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTYPE_ID() {
            return TYPE_ID;
        }

        @JvmStatic
        public static /* synthetic */ void getTYPE_ID$annotations() {
        }

        public final <C extends Component> void handleBrowsing$intellij_remoteRun(@Nullable SshUiData sshUiData, @Nullable Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull C component, @NotNull TextComponentAccessor<C> textComponentAccessor) {
            WebServerConfig.RemotePath path;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(component, (String)"component");
            Intrinsics.checkNotNullParameter(textComponentAccessor, (String)"textComponentAccessor");
            if (sshUiData == null) {
                Messages.showWarningDialog((Project)project, (String)RemoteSdkBundle.message("dialog.message.failed.to.find.ssh.settings", new Object[0]), (String)title);
                return;
            }
            ErrorMessageAndField errorMessageAndField = SshCredentialsEditorEx.validate((SshUiData)sshUiData, (SshCredentialsVerifier.ValidationMode)SshCredentialsVerifier.ValidationMode.WITHOUT_SLOW_KEY_CHECKS);
            if (errorMessageAndField != null) {
                Object[] objectArray = new Object[]{errorMessageAndField.getErrorMessage()};
                Messages.showWarningDialog((Project)project, (String)RemoteSdkBundle.message("dialog.message.please.fill.ssh.settings.0", objectArray), (String)title);
                return;
            }
            SshConfig sshConfig = sshUiData.getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)sshConfig, (String)"getConfig(...)");
            SshConfig sshConfig2 = sshConfig;
            WebServerConfig server = new WebServerConfig(WebServerConfig.getNextId());
            server.setName(sshConfig2.getPresentableFullName());
            server.getFileTransferConfig().setAccessType(AccessType.SFTP);
            server.getFileTransferConfig().setSshConfig(sshConfig2);
            ServerDeployableWithTempCredentials deployable = new ServerDeployableWithTempCredentials(server, sshUiData);
            if (!AuthHelper.ensureAuthSpecified((Project)project, (Deployable)((Deployable)deployable), component)) {
                return;
            }
            ServerBrowserDialog dialog = new ServerBrowserDialog(component, (Deployable)deployable, title, false, FileTransferConfig.Origin.Default, new WebServerConfig.RemotePath(textComponentAccessor.getText(component)));
            dialog.show();
            if (dialog.isOK() && (path = dialog.getPath()) != null) {
                textComponentAccessor.setText(component, path.path);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

