/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target;

import com.intellij.execution.ExecutionException;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.rsync.RsyncConfigurable;
import com.intellij.ssh.rsync.RsyncStatusService;
import com.intellij.ssh.ui.unified.SshConfigComboBox;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.target.ssh.target.RsyncOutputDialog;
import com.jetbrains.plugins.remotesdk.target.ssh.target.RsyncPredicate;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetConfigurable;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetConfigurableBase;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfigurationBase;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J \u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@TX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurable;", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfigurationBase;", "suggestRsync", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfigurationBase;Z)V", "value", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;", "connectionStatus", "getConnectionStatus", "()Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;", "setConnectionStatus", "(Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;)V", "rsyncInstalled", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/RsyncPredicate;", "rsyncNotInstalled", "rsyncOutput", "", "useRsyncCheckBox", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBCheckBox;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "doTestConnection", "", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "reportTestResult", "success", "wholeOutput", "Companion", "intellij.remoteRun"})
@SourceDebugExtension(value={"SMAP\nSshTargetConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshTargetConfigurable.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurable\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,154:1\n11#2:155\n*S KotlinDebug\n*F\n+ 1 SshTargetConfigurable.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurable\n*L\n146#1:155\n*E\n"})
public final class SshTargetConfigurable
extends SshTargetConfigurableBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean suggestRsync;
    @NotNull
    private SshTargetConfigurableBase.ConnectionStatus connectionStatus;
    @Nullable
    private String rsyncOutput;
    private Cell<? extends JBCheckBox> useRsyncCheckBox;
    @NotNull
    private final RsyncPredicate rsyncInstalled;
    @NotNull
    private final RsyncPredicate rsyncNotInstalled;
    @NotNull
    private static final Logger LOG;

    @JvmOverloads
    public SshTargetConfigurable(@NotNull Project project, @NotNull SshTargetEnvironmentConfigurationBase config, boolean suggestRsync) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super(project, config);
        this.suggestRsync = suggestRsync;
        this.connectionStatus = SshTargetConfigurableBase.ConnectionStatus.NON_REQUESTED;
        this.rsyncInstalled = RsyncPredicate.Companion.createRsyncInstalledPredicate(this.getComboBoxDisposable());
        this.rsyncNotInstalled = RsyncPredicate.Companion.createRsyncNotInstalledPredicate(this.getComboBoxDisposable());
    }

    public /* synthetic */ SshTargetConfigurable(Project project, SshTargetEnvironmentConfigurationBase sshTargetEnvironmentConfigurationBase, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(project, sshTargetEnvironmentConfigurationBase, bl);
    }

    @Override
    @NotNull
    protected SshTargetConfigurableBase.ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    protected void setConnectionStatus(@NotNull SshTargetConfigurableBase.ConnectionStatus value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.connectionStatus = value;
        if (value != SshTargetConfigurableBase.ConnectionStatus.FAILURE) {
            this.rsyncOutput = null;
        }
        ((SshTargetConfigurableBase.Listener)this.getEventDispatcher().getMulticaster()).connectionCheckEvent();
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ SshTargetConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                this.this$0.setSshConfigCombo(new SshConfigComboBox(this.this$0.getProject(), this.this$0.getComboBoxDisposable(), SshConfigVisibility.App));
                String string = RemoteSdkBundle.message("label.ssh.server", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ SshTargetConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        this.this$0.getSshConfigCombo().reload();
                        this.this$0.getSshConfigCombo().getComboBox().setPreferredSize(new Dimension(300, this.this$0.getSshConfigCombo().getPreferredSize().height));
                        this.this$0.getSshConfigCombo().select(this.this$0.getConfig().findSshConfig(this.this$0.getProject()));
                        Cell sshConfigCell2 = $this$row.cell((JComponent)this.this$0.getSshConfigCombo()).bind((Function1)createPanel.sshConfigCell.1.INSTANCE, (Function2)createPanel.sshConfigCell.2.INSTANCE, MutablePropertyKt.MutableProperty((Function0)((Function0)new Function0<SshConfig>(this.this$0){
                            final /* synthetic */ SshTargetConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @Nullable
                            public final SshConfig invoke() {
                                return this.this$0.getConfig().findSshConfig(this.this$0.getProject());
                            }
                        }), (Function1)((Function1)new Function1<SshConfig, Unit>((Object)((Object)this.this$0.getConfig())){

                            public final void invoke(@Nullable SshConfig p0) {
                                ((SshTargetEnvironmentConfigurationBase)((Object)this.receiver)).setSshConfig(p0);
                            }
                        })));
                        if (SshTargetConfigurable.access$getSuggestRsync$p(this.this$0)) {
                            Object[] objectArray = new Object[]{DocumentationMarkup.INFORMATION_ICON};
                            Cell.comment$default((Cell)sshConfigCell2, (String)RemoteSdkBundle.message("ssh.target.rsync.label.to.reduce.upload.time.configure", objectArray), (int)0, arg_0 -> createPanel.1.invoke$lambda$0(this.this$0, arg_0), (int)2, null);
                        }
                        SshTargetConfigurable.access$getRsyncNotInstalled$p(this.this$0).addListener((Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Cell<? extends SshConfigComboBox>)sshConfigCell2){
                            final /* synthetic */ Cell<SshConfigComboBox> $sshConfigCell;
                            {
                                this.$sshConfigCell = $sshConfigCell;
                                super(1);
                            }

                            public final void invoke(boolean it) {
                                JEditorPane jEditorPane = this.$sshConfigCell.getComment();
                                if (jEditorPane != null) {
                                    jEditorPane.setVisible(it);
                                }
                            }
                        }));
                        JEditorPane jEditorPane = sshConfigCell2.getComment();
                        if (jEditorPane != null) {
                            jEditorPane.setVisible(RsyncStatusService.getInstance().getCachedRsyncStatus() == RsyncStatusService.Status.NOT_INSTALLED_OR_CONFIGURED);
                        }
                    }

                    private static final void invoke$lambda$0(SshTargetConfigurable this$0, HyperlinkEvent it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ShowSettingsUtil.getInstance().editConfigurable(this$0.getProject(), (Configurable)new RsyncConfigurable());
                    }
                });
                $this$panel.row("", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ SshTargetConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = RemoteSdkBundle.message("ssh.target.rsync.checkbox.use.rsync", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        SshTargetConfigurable.access$setUseRsyncCheckBox$p(this.this$0, ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0.getConfig())){

                            @Nullable
                            public Object get() {
                                return ((SshTargetEnvironmentConfigurationBase)((Object)this.receiver)).getUseRsync();
                            }

                            public void set(@Nullable Object value) {
                                ((SshTargetEnvironmentConfigurationBase)((Object)this.receiver)).setUseRsync((Boolean)value);
                            }
                        })).visibleIf((ComponentPredicate)SshTargetConfigurable.access$getRsyncInstalled$p(this.this$0)));
                        String string2 = RemoteSdkBundle.message("ssh.target.button.test.connection", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        $this$row.button(string2, (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ SshTargetConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.this$0.onTestConnectionButtonClicked();
                            }
                        }).enabledIf(ComponentPredicateKt.not((ComponentPredicate)this.this$0.getConnectionInProgress())).visibleIf((ComponentPredicate)SshTargetConfigurable.access$getRsyncInstalled$p(this.this$0));
                        this.this$0.connectionStatusLabels($this$row);
                        String string3 = RemoteSdkBundle.message("ssh.target.link.label.details", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                        $this$row.link(string3, (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ SshTargetConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                new RsyncOutputDialog(this.this$0.getProject(), SshTargetConfigurable.access$getRsyncOutput$p(this.this$0)).show();
                            }
                        }).visibleIf(this.this$0.getConnectionFailed());
                    }
                });
                $this$panel.row("", (Function1)createPanel.3.INSTANCE);
                String string2 = RemoteSdkBundle.message("label.application.directory", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ SshTargetConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
                        ActionListener browser = arg_0 -> createPanel.4.invoke$lambda$0(this.this$0, textFieldWithBrowseButton, arg_0);
                        textFieldWithBrowseButton.addActionListener(browser);
                        textFieldWithBrowseButton.setText(this.this$0.getConfig().getProjectRootOnTarget());
                        Cell.comment$default((Cell)TextFieldWithBrowseButtonKt.bindText((Cell)$this$row.cell((JComponent)textFieldWithBrowseButton), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0.getConfig())){

                            @Nullable
                            public Object get() {
                                return ((SshTargetEnvironmentConfigurationBase)((Object)this.receiver)).getProjectRootOnTarget();
                            }

                            public void set(@Nullable Object value) {
                                ((SshTargetEnvironmentConfigurationBase)((Object)this.receiver)).setProjectRootOnTarget((String)value);
                            }
                        })), (String)RemoteSdkBundle.message("label.application.directory.comment", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE);
                    }

                    private static final void invoke$lambda$0(SshTargetConfigurable this$0, TextFieldWithBrowseButton $textFieldWithBrowseButton, ActionEvent it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$textFieldWithBrowseButton, (String)"$textFieldWithBrowseButton");
                        Pair pair = this$0.getSshConfigCombo().getSelectedUiDataAndName();
                        Object object = pair != null ? (SshUiData)pair.first : null;
                        Project project = this$0.getProject();
                        String string = RemoteSdkBundle.message("title.application.directory", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Component component = $textFieldWithBrowseButton.getTextField();
                        TextComponentAccessor textComponentAccessor = TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT;
                        Intrinsics.checkNotNullExpressionValue((Object)textComponentAccessor, (String)"TEXT_FIELD_WHOLE_TEXT");
                        SshTargetType.Companion.handleBrowsing$intellij_remoteRun((SshUiData)object, project, string, component, textComponentAccessor);
                    }
                });
            }
        }));
    }

    @Override
    protected void doTestConnection(@NotNull RemoteCredentials credentials, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Cell<? extends JBCheckBox> cell = this.useRsyncCheckBox;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useRsyncCheckBox");
            cell = null;
        }
        if (((JBCheckBox)cell.getComponent()).isSelected()) {
            try {
                RSyncUtil.testConnection((RemoteCredentials)credentials, (RSyncUtil.IndicatorWrapper)new RSyncUtil.IndicatorWrapper(this, modalityState){
                    @NotNull
                    private final List<String> output;
                    final /* synthetic */ SshTargetConfigurable this$0;
                    final /* synthetic */ ModalityState $modalityState;
                    {
                        this.this$0 = $receiver;
                        this.$modalityState = $modalityState;
                        this.output = new ArrayList<E>();
                    }

                    @NotNull
                    public final List<String> getOutput() {
                        return this.output;
                    }

                    public boolean isCanceled() {
                        return false;
                    }

                    public void checkCanceled() {
                    }

                    public void addText(@NotNull String text, @NotNull Key<?> key) {
                        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                        Intrinsics.checkNotNullParameter(key, (String)"key");
                        SshTargetConfigurable.access$getLOG$cp().trace("RSync output: " + text);
                        this.output.add(text);
                    }

                    public void finished(int exitCode) {
                        SshTargetConfigurable.access$getLOG$cp().debug("RSync connection testing finished with exit code " + exitCode);
                        this.output.add("\n");
                        Object[] objectArray = new Object[]{exitCode};
                        String string = RemoteSdkBundle.message("message.process.finished.with.exit.code.0", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.output.add(string);
                        String wholeOutput = CollectionsKt.joinToString$default((Iterable)this.output, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                        this.output.clear();
                        SshTargetConfigurable.access$reportTestResult(this.this$0, exitCode == 0, wholeOutput, this.$modalityState);
                    }
                });
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
                String string = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
                this.reportTestResult(false, string, modalityState);
            }
        } else {
            boolean test = RemoteSdkUtil.doTestConnection(this.getProject(), credentials, 10L, TimeUnit.SECONDS);
            this.reportTestResult(test, "", modalityState);
        }
    }

    private final void reportTestResult(boolean success, String wholeOutput, ModalityState modalityState) {
        ApplicationManager.getApplication().invokeLater(() -> SshTargetConfigurable.reportTestResult$lambda$0(success, this, wholeOutput), modalityState);
    }

    @JvmOverloads
    public SshTargetConfigurable(@NotNull Project project, @NotNull SshTargetEnvironmentConfigurationBase config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        this(project, config, false, 4, null);
    }

    private static final void reportTestResult$lambda$0(boolean $success, SshTargetConfigurable this$0, String $wholeOutput) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$wholeOutput, (String)"$wholeOutput");
        if ($success) {
            this$0.setConnectionStatus(SshTargetConfigurableBase.ConnectionStatus.SUCCESS);
        } else {
            this$0.rsyncOutput = $wholeOutput;
            this$0.setConnectionStatus(SshTargetConfigurableBase.ConnectionStatus.FAILURE);
        }
    }

    public static final /* synthetic */ boolean access$getSuggestRsync$p(SshTargetConfigurable $this) {
        return $this.suggestRsync;
    }

    public static final /* synthetic */ RsyncPredicate access$getRsyncNotInstalled$p(SshTargetConfigurable $this) {
        return $this.rsyncNotInstalled;
    }

    public static final /* synthetic */ void access$setUseRsyncCheckBox$p(SshTargetConfigurable $this, Cell cell) {
        $this.useRsyncCheckBox = cell;
    }

    public static final /* synthetic */ RsyncPredicate access$getRsyncInstalled$p(SshTargetConfigurable $this) {
        return $this.rsyncInstalled;
    }

    public static final /* synthetic */ String access$getRsyncOutput$p(SshTargetConfigurable $this) {
        return $this.rsyncOutput;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$reportTestResult(SshTargetConfigurable $this, boolean success, String wholeOutput, ModalityState modalityState) {
        $this.reportTestResult(success, wholeOutput, modalityState);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshTargetConfigurable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

