/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.execution.CommandLineUtil;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.ShellChannelBuilder;
import com.intellij.ssh.SshException;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.process.SshShellProcess;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.plugins.remotesdk.console.JschProcessTtyConnector;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

public class SshTerminalDirectRunner
extends AbstractTerminalRunner<SshShellProcess> {
    private final RemoteCredentials myCredentials;
    private final Charset myDefaultCharset;

    public SshTerminalDirectRunner(Project project, RemoteCredentials credentials, Charset charset) {
        super(project);
        this.myCredentials = credentials;
        this.myDefaultCharset = charset;
    }

    @NotNull
    public SshShellProcess createProcess(@NotNull ShellStartupOptions options) throws ExecutionException {
        if (options == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        try {
            ShellChannel channel = this.getShellChannel();
            String directory = options.getWorkingDirectory();
            if (directory != null) {
                SshTerminalDirectRunner.issueCdCommand(channel, directory);
            }
            TerminalUsageTriggerCollector.triggerSshShellStarted((Project)this.myProject);
            return new SshShellProcess(channel);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), e);
        }
    }

    @NotNull
    protected ShellChannel getShellChannel() throws RemoteSdkException {
        return this.createShellChannel();
    }

    @NotNull
    protected final ShellChannel createShellChannel() throws RemoteSdkException {
        ShellChannel shellChannel;
        try {
            shellChannel = ((ShellChannelBuilder)RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)this.myCredentials, (Project)this.myProject).shellBuilder().withAllocatePty(true)).openChannel();
        }
        catch (SshException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        if (shellChannel == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        return shellChannel;
    }

    protected static void issueCdCommand(@NotNull ShellChannel channel, @NotNull String directory) throws IOException {
        if (channel == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(3);
        }
        String cdCommand = "cd " + CommandLineUtil.posixQuote((String)directory) + "\n";
        channel.getOutputStream().write(cdCommand.getBytes(StandardCharsets.UTF_8));
        channel.getOutputStream().flush();
    }

    @Nullable
    public String getCurrentWorkingDir(@Nullable TerminalTabState state) {
        return state == null ? null : state.myWorkingDirectory;
    }

    @NotNull
    public TtyConnector createTtyConnector(@NotNull SshShellProcess process) {
        if (process == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(4);
        }
        return new JschProcessTtyConnector(process, this.myDefaultCharset);
    }

    @NotNull
    public String getDefaultTabTitle() {
        String string = this.myCredentials.getHost() + ":" + this.myCredentials.getLiteralPort();
        if (string == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isTerminalSessionPersistent() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/console/SshTerminalDirectRunner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/SshTerminalDirectRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellChannel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "issueCdCommand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTtyConnector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

