/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import com.jetbrains.plugins.remotesdk.console.SshTerminalCachingRunner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

public class RunSshConsoleAction
extends AnAction
implements DumbAware {
    private static final Logger LOGGER = Logger.getInstance(RunSshConsoleAction.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunSshConsoleAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunSshConsoleAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            RunSshConsoleAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)event.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        SshConsoleOptionsProvider optionsProvider = SshConsoleOptionsProvider.getInstance(project);
        RemoteCredentials credentials = this.getRemoteCredentials(event);
        if (credentials != null) {
            this.connectToSsh(project, optionsProvider, credentials);
        } else {
            new RemoteDataProducer().withActionEvent(event).withShowProjectLevelServers(true).produceRemoteData(optionsProvider.getConnectionType(), optionsProvider.getConnectionId(), optionsProvider.getAdditionalData(), (Consumer<? super RemoteCredentials>)((Consumer)data -> {
                if (data == null) {
                    return;
                }
                this.connectToSsh(project, optionsProvider, (RemoteCredentials)data);
            }));
        }
    }

    private void connectToSsh(Project project, SshConsoleOptionsProvider optionsProvider, RemoteCredentials credentials) {
        SshTerminalCachingRunner runner = this.getRunner(project, optionsProvider, credentials);
        UIUtil.invokeLaterIfNeeded(() -> RunSshConsoleAction.connectToSshUnderProgress(project, runner, credentials));
    }

    @NotNull
    protected SshTerminalCachingRunner getRunner(Project project, SshConsoleOptionsProvider optionsProvider, RemoteCredentials data) {
        return new SshTerminalCachingRunner(project, data, optionsProvider.getCharset());
    }

    @Nullable
    protected RemoteCredentials getRemoteCredentials(@NotNull AnActionEvent event) {
        if (event == null) {
            RunSshConsoleAction.$$$reportNull$$$0(3);
        }
        return null;
    }

    public static void connectToSshUnderProgress(final @NotNull Project project, final @NotNull SshTerminalCachingRunner runner, final @NotNull RemoteCredentials data) {
        if (project == null) {
            RunSshConsoleAction.$$$reportNull$$$0(4);
        }
        if (runner == null) {
            RunSshConsoleAction.$$$reportNull$$$0(5);
        }
        if (data == null) {
            RunSshConsoleAction.$$$reportNull$$$0(6);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, RemoteSdkBundle.message("progress.title.connecting.to", runner.getDefaultTabTitle()), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunSshConsoleAction.createTerminalSession(indicator, runner, data, project, this.getTitle());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction$1", "run"));
            }
        });
    }

    private static void createTerminalSession(@NotNull ProgressIndicator indicator, SshTerminalCachingRunner runner, RemoteCredentials data, Project project, @NlsContexts.DialogTitle String title) {
        block3: {
            if (indicator == null) {
                RunSshConsoleAction.$$$reportNull$$$0(7);
            }
            try {
                runner.connect();
                AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> TerminalToolWindowManager.getInstance((Project)project).createNewSession((AbstractTerminalRunner)runner));
            }
            catch (RemoteSdkException e) {
                if (indicator.isCanceled()) break block3;
                LOGGER.warn("unable to get session for " + data, (Throwable)e);
                AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)title));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteCredentials";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "connectToSshUnderProgress";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalSession";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

