/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionExceptionWithAttachments;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.SshConfigCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ui.RemoteSdkUpdatedCallback;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshException;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsType;
import com.jetbrains.plugins.remotesdk.SshCredentialsType;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.JTextField;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteSdkUtil {
    private static final Logger LOG = Logger.getInstance(RemoteSdkUtil.class);
    public static final long TEST_CONNECTION_POLL_TIMEOUT = 100L;
    private static final int MAX_CREATE_DIR_ATTEMPTS = 5;
    public static final long TEST_CONNECTION_TIMEOUT = 10L;

    private RemoteSdkUtil() {
    }

    public static void createFromRemoteCredentials(@NotNull WebServerConfig server, @NotNull RemoteCredentials data) {
        if (server == null) {
            RemoteSdkUtil.$$$reportNull$$$0(0);
        }
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(1);
        }
        FileTransferConfig config = server.getFileTransferConfig();
        config.setAccessType(AccessType.SFTP);
        config.setHost(data.getHost());
        config.setLiteralPort(data.getLiteralPort());
        config.setAnonymous(false);
        config.setAuthType(data.getAuthType());
        config.setPrivateKeyFile(data.getPrivateKeyFile());
        WebDeploymentCredentialHelper.saveCredentials((WebServerConfig)server, (String)data.getUserName(), (String)RemoteSdkUtil.getDataPassword(data), (boolean)RemoteSdkUtil.isMemoryOnly(data));
    }

    @Nullable
    private static String getDataPassword(@NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(2);
        }
        return switch (data.getAuthType()) {
            default -> throw new IncompatibleClassChangeError();
            case AuthType.PASSWORD -> data.getPassword();
            case AuthType.KEY_PAIR -> data.getPassphrase();
            case AuthType.OPEN_SSH -> null;
        };
    }

    private static boolean isMemoryOnly(@NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(3);
        }
        return switch (data.getAuthType()) {
            default -> throw new IncompatibleClassChangeError();
            case AuthType.PASSWORD -> {
                if (!data.isStorePassword()) {
                    yield true;
                }
                yield false;
            }
            case AuthType.KEY_PAIR -> {
                if (!data.isStorePassphrase()) {
                    yield true;
                }
                yield false;
            }
            case AuthType.OPEN_SSH -> true;
        };
    }

    @NotNull
    public static List<WebServerConfig> getSftpServerList(@Nullable Project project) {
        List config = GroupedServersConfigManager.getInstance((Project)project).getFlattenedServers();
        Predicate filter = input -> input != null && input.getFileTransferConfig().getAccessType() == AccessType.SFTP;
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter((Iterable)config, (Predicate)filter));
        if (arrayList == null) {
            RemoteSdkUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static List<SshConfig> getSshConfigList(@Nullable Project project) {
        List list = SshConfigManager.getInstance((Project)project).getConfigs();
        if (list == null) {
            RemoteSdkUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    public static boolean testConnectionAndCreateHelpersPath(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NlsContexts.DialogTitle String title) throws RemoteCancelledException, FileSystemException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(6);
        }
        return RemoteSdkUtil.testConnectionAndCreateHelpersPath(project, data, title, null);
    }

    public static boolean testConnection(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(7);
        }
        if (EDT.isCurrentThreadEdt()) {
            return RemoteSdkUtil.testConnectionFromEDT(project, data);
        }
        return RemoteSdkUtil.testConnectionFromNonEDT(project, data);
    }

    private static boolean testConnectionFromEDT(final @Nullable Project project, final @NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(8);
        }
        @NlsContexts.DialogTitle String title = RemoteSdkBundle.message("connecting.to", String.format("%s@%s:%s", data.getUserName(), data.getHost(), data.getPort()));
        return (Boolean)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Boolean, RuntimeException>(project, title, true){

            @NotNull
            protected Boolean compute(@NotNull ProgressIndicator indicator) throws RuntimeException {
                Boolean bl;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    bl = RemoteSdkUtil.doTestConnection(project, data, 10L, TimeUnit.SECONDS);
                }
                catch (RuntimeException e) {
                    LOG.warn((Throwable)e);
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return bl2;
                }
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "compute";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static boolean testConnectionFromNonEDT(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(9);
        }
        Future result = ApplicationManager.getApplication().executeOnPooledThread(() -> RemoteSdkUtil.doTestConnection(project, data, 10L, TimeUnit.SECONDS));
        try {
            return (Boolean)result.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean doTestConnection(@Nullable Project project, @NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(10);
        }
        if (timeUnit == null) {
            RemoteSdkUtil.$$$reportNull$$$0(11);
        }
        try {
            void timeUnit2;
            return RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project).connect(timeout, (TimeUnit)timeUnit2).isConnected();
        }
        catch (SshException sshException) {
            return false;
        }
    }

    public static boolean testConnectionAndCreateHelpersPath(final @Nullable Project project, final @NotNull RemoteSdkCredentials data, @NlsContexts.DialogTitle String title, final @Nullable RemoteSdkUpdatedCallback updatedCallback) throws FileSystemException, RemoteCancelledException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(12);
        }
        final Ref error = new Ref();
        final Ref result = new Ref();
        result.set((Object)false);
        Task.Modal task = new Task.Modal(project, title, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    2.$$$reportNull$$$0(0);
                }
                Semaphore done = new Semaphore();
                done.down();
                EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        pi.setText(RemoteSdkBundle.message("connecting.to", data.getHost()));
                        RemoteSdkUtil.checkInterpreterAndCreateHelpersDir(project, data, (Ref<? super Exception>)error, (Ref<? super Boolean>)result, updatedCallback);
                    }
                    finally {
                        done.up();
                    }
                });
                try {
                    ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)done, (ProgressIndicator)pi);
                }
                finally {
                    ((ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                }
            }

            public void onCancel() {
                error.set((Object)new RemoteCancelledException(RemoteSdkBundle.message("dialog.message.connection.was.canceled", new Object[0])));
            }

            public void onThrowable(@NotNull Throwable err) {
                Exception ex;
                if (err == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((ex = (Exception)ObjectUtils.tryCast((Object)err, Exception.class)) == null) {
                    ex = new Exception(err);
                }
                error.set((Object)ex);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pi";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "err";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)task));
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!error.isNull()) {
            Exception exception = (Exception)error.get();
            if (exception instanceof RemoteCancelledException) {
                throw (RemoteCancelledException)exception;
            }
            if (exception instanceof FileSystemException) {
                throw (FileSystemException)exception;
            }
            throw new FileSystemException("Exception:", (Throwable)exception);
        }
        return (Boolean)result.get();
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static String testConnectionAndCreateHelpersPath(@Nullable Project project, @NotNull RemoteCredentials credentials, @NotNull @NlsContexts.DialogTitle String title, @Nullable String helpersPath, @NotNull String defaultHelpersName) throws Exception {
        if (credentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(13);
        }
        if (title == null) {
            RemoteSdkUtil.$$$reportNull$$$0(14);
        }
        if (defaultHelpersName == null) {
            RemoteSdkUtil.$$$reportNull$$$0(15);
        }
        String string = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
            try {
                progressIndicator.setText(RemoteSdkBundle.message("connecting.to", credentials.getHost()));
                String string = RemoteSdkUtil.checkInterpreterAndCreateHelpersDir(project, credentials, helpersPath, defaultHelpersName, progressIndicator);
                return string;
            }
            finally {
                ((ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
            }
        }, title, true, project);
        if (string == null) {
            RemoteSdkUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static boolean checkInterpreterAndCreateHelpersDir(@Nullable Project project, @NotNull RemoteSdkCredentials sdkCredentials, @NotNull Ref<? super Exception> error, @NotNull Ref<? super Boolean> result, @Nullable RemoteSdkUpdatedCallback updateCallback) {
        if (sdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(17);
        }
        if (error == null) {
            RemoteSdkUtil.$$$reportNull$$$0(18);
        }
        if (result == null) {
            RemoteSdkUtil.$$$reportNull$$$0(19);
        }
        try {
            SftpChannel channel = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)sdkCredentials, (Project)project).withConnectionTimeout(0L).openSftpChannel(60);
            return RemoteSdkUtil.checkInterpreterAndCreateHelpersDir(sdkCredentials, error, result, updateCallback, channel);
        }
        catch (Exception e) {
            error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
            return false;
        }
    }

    @NotNull
    private static String checkInterpreterAndCreateHelpersDir(@Nullable Project project, @NotNull RemoteCredentials credentials, @Nullable String helpersPath, @NotNull String defaultHelpersName, @NotNull ProgressIndicator pi) throws Exception {
        if (credentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(20);
        }
        if (defaultHelpersName == null) {
            RemoteSdkUtil.$$$reportNull$$$0(21);
        }
        if (pi == null) {
            RemoteSdkUtil.$$$reportNull$$$0(22);
        }
        String string = (String)ApplicationUtil.runWithCheckCanceled(() -> {
            SftpChannel sftpChannel;
            try (SftpChannel sftpChannel2 = sftpChannel = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, (Project)project).withConnectionTimeout(0L).openSftpChannel(60);){
                String string = RemoteSdkUtil.checkInterpretersAndCreateHelpersDir(sftpChannel, helpersPath, defaultHelpersName);
                return string;
            }
        }, (ProgressIndicator)pi);
        if (string == null) {
            RemoteSdkUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkInterpreterAndCreateHelpersDir(@NotNull RemoteSdkCredentials sdkCredentials, @NotNull Ref<? super Exception> error, @NotNull Ref<? super Boolean> result, @Nullable RemoteSdkUpdatedCallback updateCallback, @NotNull SftpChannel sftpChannel) throws SshException {
        if (sdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(24);
        }
        if (error == null) {
            RemoteSdkUtil.$$$reportNull$$$0(25);
        }
        if (result == null) {
            RemoteSdkUtil.$$$reportNull$$$0(26);
        }
        if (sftpChannel == null) {
            RemoteSdkUtil.$$$reportNull$$$0(27);
        }
        try (SftpChannel sftpChannel2 = sftpChannel;){
            String interpreterPath = sdkCredentials.getInterpreterPath();
            String pathForHelpers = sdkCredentials.getHelpersPath();
            if (updateCallback != null) {
                RemoteFileObject fileObject = sftpChannel.file(interpreterPath);
                if (!fileObject.exists() || fileObject.isDir()) {
                    error.set((Object)new CustomFileSystemException("Interpreter '" + interpreterPath + "' doesn't exist on remote server"));
                    boolean bl = false;
                    return bl;
                }
                String defaultHelpersName = sdkCredentials.getDefaultHelpersName();
                String path = RemoteSdkUtil.checkInterpretersAndCreateHelpersDir(sftpChannel, pathForHelpers, defaultHelpersName);
                if (!path.equals(sdkCredentials.getHelpersPath())) {
                    sdkCredentials.setHelpersPath(path);
                    updateCallback.updated(sdkCredentials);
                }
            }
            result.set((Object)true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            error.set((Object)e);
            return false;
        }
    }

    @NotNull
    private static String checkInterpretersAndCreateHelpersDir(@NotNull SftpChannel sftpChannel, @Nullable String pathForHelpers, @NotNull String defaultHelpersName) throws IOException {
        if (sftpChannel == null) {
            RemoteSdkUtil.$$$reportNull$$$0(28);
        }
        if (defaultHelpersName == null) {
            RemoteSdkUtil.$$$reportNull$$$0(29);
        }
        if (!StringUtil.isEmpty((String)pathForHelpers)) {
            RemoteFileObject fileObject = sftpChannel.file(pathForHelpers);
            if (!fileObject.exists() || !fileObject.isDir()) {
                throw new IOException("Directory '" + pathForHelpers + "' doesn't exist on remote server");
            }
            String string = pathForHelpers;
            if (string == null) {
                RemoteSdkUtil.$$$reportNull$$$0(30);
            }
            return string;
        }
        String initialPath = new RemoteFile(sftpChannel.getHome(), defaultHelpersName).getPath();
        Object path = initialPath;
        int i = 0;
        while (true) {
            ProgressManager.checkCanceled();
            RemoteFileObject fileObject = sftpChannel.file((String)path);
            if (fileObject.exists() && fileObject.isDir()) break;
            try {
                fileObject.mkdir();
            }
            catch (SshException e) {
                path = initialPath + "_" + ++i;
                if (i <= 5) continue;
                throw e;
            }
            break;
        }
        String string = path;
        if (string == null) {
            RemoteSdkUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureCanWriteFile(@NotNull ConnectionOwner connectionOwner, @NotNull RemoteSdkCredentials data, @NotNull String path) {
        boolean bl;
        if (connectionOwner == null) {
            RemoteSdkUtil.$$$reportNull$$$0(32);
        }
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(33);
        }
        if (path == null) {
            RemoteSdkUtil.$$$reportNull$$$0(34);
        }
        SftpChannel sftp = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data).withConnectionTimeout(60L).openSftpChannel(60);
        try {
            RemoteFileObject fileObject = sftp.file(path);
            bl = (fileObject.getPermissions() & 0x80) != 0 && fileObject.getUId() != 0;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    sftp.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    return true;
                }
            }
            sftp.close();
            return bl2;
        }
        sftp.close();
        return bl;
    }

    public static CredentialsDeployable createDeployable(RemoteCredentials data) {
        CredentialsDeployable config = new CredentialsDeployable(data);
        config.setName(RemoteSdkBundle.message("config.name.remote.host", new Object[0]));
        return config;
    }

    public static boolean testConnection(@NotNull Component component, RemoteSdkCredentials data, boolean reportOnSuccess) {
        String error;
        if (component == null) {
            RemoteSdkUtil.$$$reportNull$$$0(35);
        }
        CredentialsDeployable config = RemoteSdkUtil.createDeployable((RemoteCredentials)data);
        String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getAccessType().getTitle()});
        String validationInfo = config.validateFast();
        if (validationInfo != null) {
            error = validationInfo;
        } else {
            try {
                error = RemoteSdkUtil.testConnectionAndCreateHelpersPath(null, data, title) ? null : RemoteSdkBundle.message("error.text.connection.failed", new Object[0]);
            }
            catch (FileSystemException e) {
                error = StringUtil.capitalize((String)PublishUtils.getMessage((Throwable)e, (boolean)false));
            }
            catch (RemoteCancelledException e) {
                error = RemoteSdkBundle.message("error.text.connection.was.cancelled", new Object[0]);
            }
        }
        if (error == null) {
            if (reportOnSuccess) {
                Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title);
            }
            return true;
        }
        Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), error}), (String)title);
        return false;
    }

    public static boolean testConnection(@NotNull Component component, @Nullable RemoteCredentials data, boolean reportOnSuccess) {
        if (component == null) {
            RemoteSdkUtil.$$$reportNull$$$0(36);
        }
        if (data == null) {
            return false;
        }
        CredentialsDeployable config = RemoteSdkUtil.createDeployable(data);
        String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getAccessType().getTitle()});
        String validationInfo = config.validateFast();
        Object error = validationInfo != null ? validationInfo : (RemoteSdkUtil.testConnection(null, data) ? null : "");
        if (error == null) {
            if (reportOnSuccess) {
                UIUtil.invokeLaterIfNeeded(() -> Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title));
            }
            return true;
        }
        UIUtil.invokeLaterIfNeeded(() -> RemoteSdkUtil.lambda$testConnection$6(component, data, (String)error, title));
        return false;
    }

    public static ServerBrowserDialog showBrowseRemoteDialog(@NotNull @NlsContexts.DialogTitle String title, @NotNull JTextField field, boolean foldersOnly, @NotNull Deployable deployable) {
        if (title == null) {
            RemoteSdkUtil.$$$reportNull$$$0(37);
        }
        if (field == null) {
            RemoteSdkUtil.$$$reportNull$$$0(38);
        }
        if (deployable == null) {
            RemoteSdkUtil.$$$reportNull$$$0(39);
        }
        WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(field.getText());
        @Nullable Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)field));
        ServerBrowserDialog d = project != null ? new ServerBrowserDialog(project, deployable, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath) : new ServerBrowserDialog((Component)field, deployable, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath);
        d.show();
        return d;
    }

    @NotNull
    public static RemoteTransfer.HelpersTransferConfig newHelpersTransferConfigFromRemoteCredentials(final @NotNull RemoteSdkCredentials myRemoteSdkCredentials) {
        if (myRemoteSdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(40);
        }
        return new RemoteTransfer.HelpersTransferConfig(){

            @Override
            @NotNull
            public String getHelpersPath() {
                String string = myRemoteSdkCredentials.getHelpersPath();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void createFileTransferConfig(@NotNull CredentialsDeployable deployable) {
                if (deployable == null) {
                    3.$$$reportNull$$$0(1);
                }
                deployable.resetCredentials(myRemoteSdkCredentials);
            }

            @Override
            public boolean isHelpersVersionChecked() {
                return myRemoteSdkCredentials.isHelpersVersionChecked();
            }

            @Override
            public void setHelpersVersionChecked(boolean checked) {
                myRemoteSdkCredentials.setHelpersVersionChecked(checked);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deployable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHelpersPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createFileTransferConfig";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NonNls GeneralCommandLine command) throws RemoteSdkException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(41);
        }
        ConnectionBuilder connectionBuilder2 = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        RemoteSdkSessionUtil.checkConnectionInBackground(connectionBuilder2);
        SshExecProcess process = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder2, (GeneralCommandLine)command).withChangeDir(false).withAllocatePty(false).start();
        CapturingSshProcessHandler processHandler = new CapturingSshProcessHandler((SshProcess)process, null, command.getCommandLineString());
        ProcessOutput processOutput = processHandler.runProcess();
        if (processOutput == null) {
            RemoteSdkUtil.$$$reportNull$$$0(42);
        }
        return processOutput;
    }

    @Nullable
    public static String chooseRemoteFile(@NotNull Project project, @NotNull RemoteCredentials credentials, boolean foldersOnly) {
        WebServerConfig.RemotePath path;
        if (project == null) {
            RemoteSdkUtil.$$$reportNull$$$0(43);
        }
        if (credentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(44);
        }
        CredentialsDeployable deployable = RemoteSdkUtil.createDeployable(credentials);
        ServerBrowserDialog d = new ServerBrowserDialog(project, (Deployable)deployable, RemoteSdkBundle.message("dialog.title.choose.remote.path", new Object[0]), foldersOnly, FileTransferConfig.Origin.Default, null);
        d.show();
        if (d.isOK() && (path = d.getPath()) != null) {
            return path.path;
        }
        return null;
    }

    public static void updateSshConfigData(@Nullable SdkAdditionalData additionalData, final @NotNull SshConfigManager manager) {
        if (manager == null) {
            RemoteSdkUtil.$$$reportNull$$$0(45);
        }
        if (!(additionalData instanceof RemoteSdkAdditionalData)) {
            return;
        }
        ((RemoteSdkAdditionalData)additionalData).switchOnConnectionType(new CredentialsCase[]{new CredentialsCase<SshConfigCredentialsHolder>(){

            public CredentialsType<SshConfigCredentialsHolder> getType() {
                return SshConfigCredentialsType.getInstance();
            }

            public void process(SshConfigCredentialsHolder credentials) {
                PresentableId presentableId = credentials.getSshId();
                if (presentableId == null || !presentableId.hasId()) {
                    return;
                }
                SshUiData data = manager.findCurrentDataById(presentableId.getId());
                credentials.setSshId(data == null ? presentableId : data.getConfig().createPresentableId());
            }
        }});
    }

    public static void fullyLoadCredentials(@NotNull SdkAdditionalData data, final @Nullable Project project) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(46);
        }
        if (!(data instanceof RemoteSdkAdditionalData)) {
            return;
        }
        ((RemoteSdkAdditionalData)data).switchOnConnectionType(new CredentialsCase[]{new CredentialsCase<SshConfigCredentialsHolder>(){

            public CredentialsType<SshConfigCredentialsHolder> getType() {
                return SshConfigCredentialsType.getInstance();
            }

            public void process(SshConfigCredentialsHolder credentials) {
                if (credentials.getSshId() == null || credentials.getSshId().getId() != null || credentials.getSshId().getName() == null) {
                    return;
                }
                SshConfig config = SshConfigManager.getInstance((Project)project).getConfigFromInitialMappingNameToId(credentials.getSshId().getName());
                if (config != null) {
                    credentials.setSshId(config.createPresentableId());
                }
            }
        }});
    }

    public static boolean isSshCredentialType(CredentialsType<?> type) {
        return type == SshCredentialsType.getInstance() || type == SshConfigCredentialsType.getInstance() || type == WebDeploymentCredentialsType.getInstance();
    }

    public static boolean isSshOrVagrantCredentialType(CredentialsType<?> type) {
        return type == VagrantCredentialsType.getInstance() || RemoteSdkUtil.isSshCredentialType(type);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull Throwable err, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title) {
        String moreInfo;
        if (err == null) {
            RemoteSdkUtil.$$$reportNull$$$0(47);
        }
        if (title == null) {
            RemoteSdkUtil.$$$reportNull$$$0(48);
        }
        String message = Optional.ofNullable(err.getLocalizedMessage()).or(() -> Optional.ofNullable(err.getMessage())).orElse("");
        if (err instanceof ExecutionExceptionWithAttachments && !(moreInfo = (((ExecutionExceptionWithAttachments)err).getStderr() + "\n\n" + ((ExecutionExceptionWithAttachments)err).getStdout()).trim()).isEmpty()) {
            Messages.showDialog((Project)project, (String)message, (String)title, (String)moreInfo, (String[])new String[]{Messages.getOkButton()}, (int)0, (int)0, (Icon)Messages.getErrorIcon());
            return;
        }
        Messages.showErrorDialog((String)message, (String)title);
    }

    private static /* synthetic */ void lambda$testConnection$6(Component component, RemoteCredentials data, String error, String title) {
        Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), error}), (String)title);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 16, 23, 30, 31, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 33: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 23: 
            case 30: 
            case 31: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 13: 
            case 20: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 14: 
            case 37: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 15: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHelpersName";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCredentials";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sftpChannel";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myRemoteSdkCredentials";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "err";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSftpServerList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshConfigList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "testConnectionAndCreateHelpersPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "checkInterpreterAndCreateHelpersDir";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "checkInterpretersAndCreateHelpersDir";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromRemoteCredentials";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDataPassword";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMemoryOnly";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 23: 
            case 30: 
            case 31: 
            case 42: {
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "testConnectionAndCreateHelpersPath";
                break;
            }
            case 7: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "testConnection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "testConnectionFromEDT";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "testConnectionFromNonEDT";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doTestConnection";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkInterpreterAndCreateHelpersDir";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkInterpretersAndCreateHelpersDir";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanWriteFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showBrowseRemoteDialog";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "newHelpersTransferConfigFromRemoteCredentials";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "chooseRemoteFile";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateSshConfigData";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "fullyLoadCredentials";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 16, 23, 30, 31, 42 -> new IllegalStateException(string);
        };
    }
}

