/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.PathMappingProviderEx;
import com.intellij.remote.ext.PathMappingType;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsType;
import com.jetbrains.plugins.remotesdk.SshCredentialsType;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PublishConfigMappingProvider
extends PathMappingProviderEx {
    @NotNull
    public PathMappingType getMappingType() {
        PathMappingType pathMappingType = PathMappingType.DEPLOYMENT;
        if (pathMappingType == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(0);
        }
        return pathMappingType;
    }

    @NotNull
    public String getProviderPresentableName(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(1);
        }
        final Ref name = new Ref();
        data.switchOnConnectionType(new CredentialsCase[]{new CredentialsCase<RemoteCredentialsHolder>(){

            public CredentialsType<RemoteCredentialsHolder> getType() {
                return SshCredentialsType.getInstance();
            }

            public void process(RemoteCredentialsHolder credentials) {
                name.set((Object)RemoteSdkBundle.message("provider.name.sftp.deployment.configurations", new Object[0]));
            }
        }, CredentialsCase.create((CredentialsType)WebDeploymentCredentialsType.getInstance(), cred -> name.set((Object)RemoteSdkBundle.message("provider.name.0.deployment.configuration", cred.getWebServerConfigName()))), CredentialsCase.create((CredentialsType)SshConfigCredentialsType.getInstance(), cred -> name.set((Object)RemoteSdkBundle.message("provider.name.sftp.deployment.configurations", new Object[0])))});
        String string = (String)name.get();
        if (string == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean accepts(@Nullable RemoteSdkAdditionalData data) {
        return data != null && RemoteSdkUtil.isSshCredentialType(data.connectionCredentials().getRemoteConnectionType());
    }

    @NotNull
    public PathMappingSettings getPathMappingSettings(final @NotNull Project project, final @NotNull RemoteSdkAdditionalData data) {
        if (project == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(3);
        }
        if (data == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(4);
        }
        final PathMappingSettings mappingSettings = new PathMappingSettings();
        data.switchOnConnectionType(new CredentialsCase[]{new CredentialsCase<RemoteCredentialsHolder>(){

            public CredentialsType<RemoteCredentialsHolder> getType() {
                return SshCredentialsType.getInstance();
            }

            public void process(RemoteCredentialsHolder cred) {
                try {
                    RemoteSdkCredentials credentials = data.getRemoteSdkCredentials(project, false);
                    mappingSettings.addAll(PublishConfigMappingProvider.getPathMappingsForDeploymentConfigurations(project, (RemoteCredentials)credentials));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, CredentialsCase.create((CredentialsType)WebDeploymentCredentialsType.getInstance(), cred -> {
            PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
            for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
                if (!cred.getWebServerConfigId().equals(webConfig.getId())) continue;
                PublishConfigMappingProvider.addMappings(webConfig, publishConfig, mappingSettings);
            }
        }), CredentialsCase.create((CredentialsType)SshConfigCredentialsType.getInstance(), cred -> {
            PresentableId presentableId = cred.getSshId();
            if (presentableId == null || presentableId.getId() == null) {
                return;
            }
            PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
            for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
                if (!presentableId.equals((Object)webConfig.getFileTransferConfig().getSshPresentableId())) continue;
                PublishConfigMappingProvider.addMappings(webConfig, publishConfig, mappingSettings);
            }
        })});
        PathMappingSettings pathMappingSettings = mappingSettings;
        if (pathMappingSettings == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(5);
        }
        return pathMappingSettings;
    }

    private static void addMappings(@NotNull WebServerConfig webConfig, @NotNull PublishConfig publishConfig, @NotNull PathMappingSettings mappingSettings) {
        if (webConfig == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(6);
        }
        if (publishConfig == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(7);
        }
        if (mappingSettings == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(8);
        }
        PublishConfigMappingProvider.collectMappings(webConfig, publishConfig).forEach(mapping -> mappingSettings.add(mapping));
    }

    @NotNull
    public static List<PathMappingSettings.PathMapping> collectMappings(@NotNull WebServerConfig webConfig, @NotNull PublishConfig publishConfig) {
        if (webConfig == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(9);
        }
        if (publishConfig == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(10);
        }
        ArrayList<PathMappingSettings.PathMapping> result = new ArrayList<PathMappingSettings.PathMapping>();
        List mappings = publishConfig.getPathMappings(webConfig.getId());
        for (DeploymentPathMapping mapping : mappings) {
            String rootFolder = webConfig.getFileTransferConfig().getRootFolder();
            rootFolder = rootFolder.replaceAll("\\\\", "/").trim();
            rootFolder = StringUtil.trimEnd((String)rootFolder, (String)"/");
            if (StringUtil.isEmpty((String)mapping.getLocalPath()) || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
            result.add(new PathMappingSettings.PathMapping(mapping.getLocalPath(), PublishConfigMappingProvider.resolveDeployPath(rootFolder, mapping.getDeployPath())));
        }
        ArrayList<PathMappingSettings.PathMapping> arrayList = result;
        if (arrayList == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    static String resolveDeployPath(@NotNull String rootFolder, @NotNull String deployPath) {
        if (rootFolder == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(12);
        }
        if (deployPath == null) {
            PublishConfigMappingProvider.$$$reportNull$$$0(13);
        }
        String relativeDeployPath = StringUtil.trimStart((String)deployPath, (String)"/");
        return new RemoteFile(rootFolder, relativeDeployPath).getPath();
    }

    public static PathMappingSettings getPathMappingsForDeploymentConfigurations(Project project, RemoteCredentials data) {
        PathMappingSettings mappingSettings = new PathMappingSettings();
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
            if (!StringUtil.equals((CharSequence)PublishConfigMappingProvider.normalizeHost(webConfig.getFileTransferConfig().getHost()), (CharSequence)PublishConfigMappingProvider.normalizeHost(data.getHost()))) continue;
            PublishConfigMappingProvider.addMappings(webConfig, publishConfig, mappingSettings);
        }
        return mappingSettings;
    }

    @Nullable
    private static CharSequence normalizeHost(@NonNls @Nullable String host) {
        if ("localhost".equals(host)) {
            return "127.0.0.1";
        }
        return host;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 6, 7, 8, 9, 10, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webConfig";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFolder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingType";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderPresentableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappingSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMappings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProviderPresentableName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingSettings";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMappings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectMappings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveDeployPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6, 7, 8, 9, 10, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

