/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormats;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.csv.ui.preview.TableAndTextCsvFormatPreview;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.settings.AppearanceComponents;
import com.intellij.database.settings.DataGridAppearanceConfigurable;
import com.intellij.database.settings.DataGridAppearanceConfigurableKt;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.database.settings.DataGridAppearanceSettingsImpl;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/settings/DataGridAppearanceConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "()V", "components", "Lcom/intellij/database/settings/AppearanceComponents;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "isResetting", "", "useCustomFont", "getUseCustomFont", "()Z", "apply", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "isModified", "reset", "updateGrid", "Companion", "intellij.grid.impl"})
public final class DataGridAppearanceConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isResetting;
    private AppearanceComponents components;
    private DataGrid grid;
    @NotNull
    public static final String ID = "database.data.views.appearance";

    public DataGridAppearanceConfigurable() {
        String string = IdeBundle.message((String)"configurable.DatabaseSettingsConfigurable.DataViews.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "preferences.database.dataViews", ID);
    }

    private final boolean getUseCustomFont() {
        AppearanceComponents appearanceComponents = this.components;
        if (appearanceComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents = null;
        }
        return ((JBCheckBox)appearanceComponents.getUseCustomFontCell().getComponent()).isSelected();
    }

    public void apply() {
        super.apply();
        AppearanceComponents appearanceComponents = this.components;
        if (appearanceComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents = null;
        }
        appearanceComponents.getCustomFontOptionsPanel().apply(this.getUseCustomFont());
        DataGridAppearanceSettingsImpl.fireSettingsChanged();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        if (super.isModified()) return true;
        AppearanceComponents appearanceComponents = this.components;
        if (appearanceComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents = null;
        }
        if (!appearanceComponents.getCustomFontOptionsPanel().isModified(this.getUseCustomFont())) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            this.isResetting = true;
            super.reset();
            AppearanceComponents appearanceComponents = this.components;
            if (appearanceComponents == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"components");
                appearanceComponents = null;
            }
            appearanceComponents.getCustomFontOptionsPanel().reset();
            this.updateGrid();
        }
        finally {
            this.isResetting = false;
        }
    }

    private final void updateGrid() {
        AppearanceComponents appearanceComponents = this.components;
        if (appearanceComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents = null;
        }
        boolean striped = ((JBCheckBox)appearanceComponents.isStripeRowsCheckBox().getComponent()).isSelected();
        DataGrid dataGrid = this.grid;
        if (dataGrid == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid = null;
        }
        dataGrid.getAppearance().setResultViewStriped(striped);
        DataGrid dataGrid2 = this.grid;
        if (dataGrid2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid2 = null;
        }
        DataGridAppearance dataGridAppearance = dataGrid2.getAppearance();
        AppearanceComponents appearanceComponents2 = this.components;
        if (appearanceComponents2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents2 = null;
        }
        dataGridAppearance.setBooleanMode((DataGridAppearanceSettings.BooleanMode)((ComboBox)appearanceComponents2.getBooleanMode().getComponent()).getItem());
        DataGrid dataGrid3 = this.grid;
        if (dataGrid3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid3 = null;
        }
        dataGrid3.getAppearance().setResultViewSetShowHorizontalLines(!striped);
        DataGrid dataGrid4 = this.grid;
        if (dataGrid4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid4 = null;
        }
        GridColorsScheme gridColorsScheme = dataGrid4.getColorsScheme();
        boolean bl = this.getUseCustomFont();
        AppearanceComponents appearanceComponents3 = this.components;
        if (appearanceComponents3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents3 = null;
        }
        gridColorsScheme.updateFromScheme(bl, appearanceComponents3.getCustomFontOptionsPanel().getScheme());
        DataGrid dataGrid5 = this.grid;
        if (dataGrid5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid5 = null;
        }
        dataGrid5.getResultView().reinitSettings();
        DataGrid dataGrid6 = this.grid;
        if (dataGrid6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid6 = null;
        }
        dataGrid6.getPanel().getComponent().revalidate();
        DataGrid dataGrid7 = this.grid;
        if (dataGrid7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid7 = null;
        }
        dataGrid7.getPanel().getComponent().repaint();
    }

    @NotNull
    public DialogPanel createPanel() {
        DataGridAppearanceSettings settings = DataGridAppearanceSettings.getSettings();
        DialogPanel panel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, settings){
            final /* synthetic */ DataGridAppearanceConfigurable this$0;
            final /* synthetic */ DataGridAppearanceSettings $settings;
            {
                this.this$0 = $receiver;
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                DataGridAppearanceSettings dataGridAppearanceSettings = this.$settings;
                Intrinsics.checkNotNullExpressionValue((Object)dataGridAppearanceSettings, (String)"$settings");
                DataGridAppearanceConfigurable.access$setComponents$p(this.this$0, DataGridAppearanceConfigurableKt.produceAppearanceSettings($this$panel, dataGridAppearanceSettings, (Function0<Boolean>)((Function0)new Function0<Boolean>(this.this$0){
                    final /* synthetic */ DataGridAppearanceConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return DataGridAppearanceConfigurable.access$isResetting$p(this.this$0);
                    }
                }), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ DataGridAppearanceConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        DataGridAppearanceConfigurable.access$updateGrid(this.this$0);
                    }
                })));
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DataGridAppearanceConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
                        CsvFormat csvFormat = CsvFormatter.setFirstRowIsHeader((CsvFormat)((CsvFormat)CsvFormats.CSV_FORMAT.getValue()), (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)csvFormat, (String)"setFirstRowIsHeader(...)");
                        CsvFormat format = csvFormat;
                        Document document = EditorFactory.getInstance().createDocument((CharSequence)TableAndTextCsvFormatPreview.formatData(format));
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
                        Document document2 = document;
                        CsvDocumentDataHookUp hookUp = new CsvDocumentDataHookUp(project, format, document2, null);
                        Disposable disposable = DataGridAppearanceConfigurable.access$getDisposable(this.this$0);
                        Intrinsics.checkNotNull((Object)disposable);
                        Disposable disposable2 = disposable;
                        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)hookUp));
                        DataGrid dataGrid = GridUtil.createPreviewDataGrid(project, (GridDataHookUp<GridRow, GridColumn>)((GridDataHookUp)hookUp), GridUtil.configureCsvTable().andThen((arg_0, arg_1) -> createPanel.panel.3.invoke$lambda$0(createPanel.panel.1.INSTANCE, arg_0, arg_1)));
                        Intrinsics.checkNotNullExpressionValue((Object)dataGrid, (String)"createPreviewDataGrid(...)");
                        DataGridAppearanceConfigurable.access$setGrid$p(this.this$0, dataGrid);
                        DataGrid dataGrid2 = DataGridAppearanceConfigurable.access$getGrid$p(this.this$0);
                        if (dataGrid2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
                            dataGrid2 = null;
                        }
                        dataGrid2.setPresentationMode(GridPresentationMode.TABLE);
                        DataGrid dataGrid3 = DataGridAppearanceConfigurable.access$getGrid$p(this.this$0);
                        if (dataGrid3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
                            dataGrid3 = null;
                        }
                        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)dataGrid3));
                        DataGrid dataGrid4 = DataGridAppearanceConfigurable.access$getGrid$p(this.this$0);
                        if (dataGrid4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
                            dataGrid4 = null;
                        }
                        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)UiNotifyConnector.Once.installOn((Component)((Component)dataGrid4.getPanel().getComponent()), (Activatable)new Activatable(this.this$0, hookUp){
                            final /* synthetic */ DataGridAppearanceConfigurable this$0;
                            final /* synthetic */ CsvDocumentDataHookUp $hookUp;
                            {
                                this.this$0 = $receiver;
                                this.$hookUp = $hookUp;
                            }

                            public void showNotify() {
                                DataGrid dataGrid = DataGridAppearanceConfigurable.access$getGrid$p(this.this$0);
                                if (dataGrid == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
                                    dataGrid = null;
                                }
                                GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)dataGrid));
                                this.$hookUp.getLoader().loadFirstPage(source);
                            }
                        })));
                        DataGrid dataGrid5 = DataGridAppearanceConfigurable.access$getGrid$p(this.this$0);
                        if (dataGrid5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
                            dataGrid5 = null;
                        }
                        $this$row.cell((JComponent)dataGrid5.getPanel().getComponent()).align(Align.FILL);
                    }

                    private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0, p1);
                    }
                }), (int)1, null).topGap(TopGap.MEDIUM);
            }
        }));
        return panel2;
    }

    public static final /* synthetic */ void access$setComponents$p(DataGridAppearanceConfigurable $this, AppearanceComponents appearanceComponents) {
        $this.components = appearanceComponents;
    }

    public static final /* synthetic */ boolean access$isResetting$p(DataGridAppearanceConfigurable $this) {
        return $this.isResetting;
    }

    public static final /* synthetic */ void access$updateGrid(DataGridAppearanceConfigurable $this) {
        $this.updateGrid();
    }

    public static final /* synthetic */ Disposable access$getDisposable(DataGridAppearanceConfigurable $this) {
        return $this.getDisposable();
    }

    public static final /* synthetic */ void access$setGrid$p(DataGridAppearanceConfigurable $this, DataGrid dataGrid) {
        $this.grid = dataGrid;
    }

    public static final /* synthetic */ DataGrid access$getGrid$p(DataGridAppearanceConfigurable $this) {
        return $this.grid;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/settings/DataGridAppearanceConfigurable$Companion;", "", "()V", "ID", "", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

