/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.text;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.text.TextRawIndexConverter;
import com.intellij.database.util.Out;
import com.intellij.find.FindModel;
import com.intellij.find.SearchSession;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TextResultView
implements ResultView {
    private static final Logger LOG = Logger.getInstance(TextResultView.class);
    private final DataGrid myResultPanel;
    private final EditorEx myViewer;
    private final TextRawIndexConverter myRawIndexConverter;
    private final ThreadPoolExecutor myExecutor;
    private Future<?> myLastExtractorTask;
    private boolean myTransposed;

    public TextResultView(@NotNull DataGrid resultPanel) {
        if (resultPanel == null) {
            TextResultView.$$$reportNull$$$0(0);
        }
        this.myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)this.getClass().getSimpleName());
        this.myLastExtractorTask = null;
        this.myResultPanel = resultPanel;
        this.myViewer = TextResultView.createEditor(this.myResultPanel.getProject(), "textView");
        this.myViewer.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        DataManager.registerDataProvider((JComponent)this.myViewer.getComponent(), dataId -> {
            if (CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId)) {
                return this.myViewer;
            }
            return null;
        });
        this.myViewer.setColorsScheme(this.myViewer.createBoundColorSchemeDelegate((EditorColorsScheme)this.myResultPanel.getEditorColorsScheme()));
        TextResultView.updateColorScheme(this.myViewer);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme -> {
            this.myResultPanel.getPanel().globalSchemeChange(scheme);
            this.reinitSettings();
        });
        this.myRawIndexConverter = new TextRawIndexConverter();
        GridModel model2 = this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        this.updateText(model2.getRows());
    }

    @Override
    public void setValueAt(@Nullable Object v, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, boolean allowImmediateUpdate, @NotNull GridRequestSource source) {
        if (row == null) {
            TextResultView.$$$reportNull$$$0(1);
        }
        if (column == null) {
            TextResultView.$$$reportNull$$$0(2);
        }
        if (source == null) {
            TextResultView.$$$reportNull$$$0(3);
        }
    }

    private static void updateColorScheme(@NotNull EditorEx editor) {
        if (editor == null) {
            TextResultView.$$$reportNull$$$0(4);
        }
        Color backgroundColor = editor.getColorsScheme().getDefaultBackground();
        editor.setBackgroundColor(backgroundColor);
        editor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, backgroundColor);
    }

    @Override
    public void defaultBackgroundChanged() {
        TextResultView.updateColorScheme(this.myViewer);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            TextResultView.$$$reportNull$$$0(5);
        }
        if (name == null) {
            TextResultView.$$$reportNull$$$0(6);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, (Language)PlainTextLanguage.INSTANCE, (CharSequence)"");
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        document = document != null ? document : EditorFactory.getInstance().createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createViewer(document, project);
        editor.setEmbeddedIntoDialogWrapper(true);
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getSettings().setCaretRowShown(true);
        editor.setCaretEnabled(true);
        editor.setHorizontalScrollbarVisible(true);
        editor.setVerticalScrollbarVisible(true);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            TextResultView.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    @Override
    public void setTransposed(boolean transposed) {
        if (this.myTransposed == transposed) {
            return;
        }
        this.myTransposed = transposed;
        this.dataUpdated();
    }

    @Override
    public boolean isTransposed() {
        return this.myTransposed;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myViewer.getContentComponent();
        if (jComponent == null) {
            TextResultView.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    @Override
    public void registerEscapeAction(@NotNull AbstractAction action) {
        if (action == null) {
            TextResultView.$$$reportNull$$$0(9);
        }
        String actionId = "grid.escape";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.myViewer.getContentComponent().getInputMap(0).put(keyStroke, actionId);
        this.myViewer.getContentComponent().getActionMap().put(actionId, action);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewer.getComponent();
        if (jComponent == null) {
            TextResultView.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    @NotNull
    public EditorEx getViewer() {
        EditorEx editorEx = this.myViewer;
        if (editorEx == null) {
            TextResultView.$$$reportNull$$$0(11);
        }
        return editorEx;
    }

    @Override
    public void resetLayout() {
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<GridColumn> columnIdx, boolean state) {
        if (columnIdx == null) {
            TextResultView.$$$reportNull$$$0(12);
        }
    }

    @Override
    public void setRowEnabled(@NotNull ModelIndex<GridRow> rowIdx, boolean state) {
        if (rowIdx == null) {
            TextResultView.$$$reportNull$$$0(13);
        }
    }

    @Override
    public void showFirstCell(int rowNumOnCurrentPage) {
    }

    @Override
    public void growSelection() {
    }

    @Override
    public void shrinkSelection() {
    }

    @Override
    public void addSelectionChangedListener(@NotNull Consumer<Boolean> listener) {
        if (listener == null) {
            TextResultView.$$$reportNull$$$0(14);
        }
    }

    @Override
    public void restoreColumnsOrder(Map<Integer, ModelIndex<GridColumn>> expectedToModel) {
    }

    @Override
    public boolean isEditing() {
        return false;
    }

    @Override
    public boolean isMultiEditingAllowed() {
        return false;
    }

    @Override
    @NotNull
    public ModelIndexSet<GridRow> getVisibleRows() {
        ModelIndexSet modelIndexSet = ModelIndexSet.forRows((CoreGrid)this.myResultPanel, (int[])new int[0]);
        if (modelIndexSet == null) {
            TextResultView.$$$reportNull$$$0(15);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<GridColumn> getVisibleColumns() {
        ModelIndexSet modelIndexSet = ModelIndexSet.forColumns((CoreGrid)this.myResultPanel, (int[])new int[0]);
        if (modelIndexSet == null) {
            TextResultView.$$$reportNull$$$0(16);
        }
        return modelIndexSet;
    }

    @Override
    public int getViewColumnCount() {
        return 0;
    }

    @Override
    public int getViewRowCount() {
        return 0;
    }

    @Override
    public boolean stopEditing() {
        return false;
    }

    @Override
    public void cancelEditing() {
    }

    @Override
    public boolean isViewModified() {
        return false;
    }

    @Override
    public void contentLanguageUpdated(@NotNull ModelIndex<GridColumn> idx, @NotNull Language language) {
        if (idx == null) {
            TextResultView.$$$reportNull$$$0(17);
        }
        if (language == null) {
            TextResultView.$$$reportNull$$$0(18);
        }
    }

    @Override
    public void displayTypeUpdated(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull DisplayType displayType) {
        if (columnIdx == null) {
            TextResultView.$$$reportNull$$$0(19);
        }
        if (displayType == null) {
            TextResultView.$$$reportNull$$$0(20);
        }
    }

    @Override
    @NotNull
    public ModelIndex<GridColumn> getContextColumn() {
        ModelIndex modelIndex = ModelIndex.forColumn((CoreGrid)this.myResultPanel, (int)-1);
        if (modelIndex == null) {
            TextResultView.$$$reportNull$$$0(21);
        }
        return modelIndex;
    }

    @Override
    public void updateSortKeysFromColumnAttributes() {
    }

    @Override
    public void orderingAndVisibilityChanged() {
    }

    @Override
    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        TextRawIndexConverter textRawIndexConverter = this.myRawIndexConverter;
        if (textRawIndexConverter == null) {
            TextResultView.$$$reportNull$$$0(22);
        }
        return textRawIndexConverter;
    }

    @Override
    public void addMouseListenerToComponents(final @NotNull MouseListener listener) {
        if (listener == null) {
            TextResultView.$$$reportNull$$$0(23);
        }
        this.myViewer.addEditorMouseListener(new EditorMouseListener(){

            public void mousePressed(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                listener.mousePressed(event.getMouseEvent());
            }

            public void mouseClicked(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                listener.mouseClicked(event.getMouseEvent());
            }

            public void mouseReleased(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                listener.mouseReleased(event.getMouseEvent());
            }

            public void mouseEntered(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                listener.mouseEntered(event.getMouseEvent());
            }

            public void mouseExited(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                listener.mouseExited(event.getMouseEvent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/database/run/ui/text/TextResultView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseClicked";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseEntered";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public boolean supportsCustomSearchSession() {
        return false;
    }

    @Override
    @Nullable
    public SearchSession createSearchSession(@Nullable FindModel findModel, @Nullable Component previousFilterComponent) {
        return null;
    }

    public void columnsAdded(ModelIndexSet<GridColumn> columns) {
    }

    @Override
    public void columnAttributesUpdated() {
    }

    @Override
    public void reinitSettings() {
        this.myViewer.reinitSettings();
    }

    public void columnsRemoved(ModelIndexSet<GridColumn> columns) {
    }

    public void rowsAdded(ModelIndexSet<GridRow> rows) {
        this.dataUpdated();
    }

    public void rowsRemoved(ModelIndexSet<GridRow> rows) {
        this.dataUpdated();
    }

    public void cellsUpdated(ModelIndexSet<GridRow> rows, ModelIndexSet<GridColumn> columns, @Nullable GridRequestSource.RequestPlace place) {
        this.dataUpdated();
    }

    public void extractorFactoryChanged() {
        this.dataUpdated();
    }

    private void dataUpdated() {
        GridModel model2 = this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        this.updateText(ContainerUtil.copyList((List)model2.getRows()));
    }

    private void updateText(@NotNull List<GridRow> rows) {
        if (rows == null) {
            TextResultView.$$$reportNull$$$0(24);
        }
        Condition disposed = __ -> Disposer.isDisposed((Disposable)this);
        ApplicationManager.getApplication().invokeLater(() -> {
            ExtractorConfig config;
            if (disposed.value(null)) {
                return;
            }
            DataExtractorFactory extractorFactory = DataExtractorFactories.getExtractorFactory((CoreGrid)this.myResultPanel, GridUtil::suggestPlugin);
            DataExtractor extractor = extractorFactory.createExtractor(config = ExtractorsHelper.getInstance((CoreGrid)this.myResultPanel).createExtractorConfig((CoreGrid)this.myResultPanel, this.myResultPanel.getObjectFormatter()));
            if (extractor == null) {
                LOG.error("Cannot create data extractor. DataExtractorFactory: " + extractorFactory.getName());
                TextResultView.updateEditorText(this.myViewer, this.myResultPanel.getProject(), "", (Language)PlainTextLanguage.INSTANCE);
                return;
            }
            Language guessedLanguage = LanguageUtil.getFileTypeLanguage((FileType)FileTypeRegistry.getInstance().getFileTypeByExtension(extractor.getFileExtension()));
            Language language = (Language)ObjectUtils.notNull((Object)guessedLanguage, (Object)PlainTextLanguage.INSTANCE);
            GridModel model2 = this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            List allColumns = model2.getColumns();
            int[] cols = model2.getColumnIndices().asArray();
            Out.Readable out = new Out.Readable();
            JBIterable iterable = JBIterable.from((Iterable)rows);
            if (this.myLastExtractorTask != null) {
                this.myLastExtractorTask.cancel(false);
            }
            PageSpec pageOfThisExtractor = this.getCurrentPage();
            this.myLastExtractorTask = this.myExecutor.submit(() -> {
                int chunkSize;
                DataExtractor.Extraction e = extractor.startExtraction((Out)out, allColumns, "", ExtractionConfigKt.builder().setTransposed(this.myTransposed).build(), cols);
                int size = iterable.size();
                int showedRowsCount = 0;
                for (int i = 0; i < size; i += chunkSize) {
                    chunkSize = TextResultView.chunkSize(i, extractor instanceof TranspositionAwareExtractor);
                    e.addData(iterable.skip(i).take(chunkSize).toList());
                    showedRowsCount += chunkSize;
                    if (out.sizeInBytes() > (long)(FileUtilRt.LARGE_FOR_CONTENT_LOADING / 2)) break;
                }
                e.complete();
                Object postfix = size > showedRowsCount ? "\nResult is too big. Only first " + showedRowsCount + " entries are shown" : "";
                ApplicationManager.getApplication().invokeLater(() -> this.lambda$updateText$3(pageOfThisExtractor, out, (String)postfix, language), disposed);
            });
        }, disposed);
    }

    public static void updateEditorText(@NotNull EditorEx editor, @NotNull Project project, @NotNull String text, @NotNull Language language) {
        if (editor == null) {
            TextResultView.$$$reportNull$$$0(25);
        }
        if (project == null) {
            TextResultView.$$$reportNull$$$0(26);
        }
        if (text == null) {
            TextResultView.$$$reportNull$$$0(27);
        }
        if (language == null) {
            TextResultView.$$$reportNull$$$0(28);
        }
        DocumentEx document = editor.getDocument();
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            document.replaceString(0, document.getTextLength(), (CharSequence)StringUtil.convertLineSeparators((String)text));
            CaretModel caretModel = editor.getCaretModel();
            if (caretModel.getOffset() >= document.getTextLength()) {
                caretModel.moveToOffset(document.getTextLength());
            }
        }), null, null);
        LightVirtualFile virtualFile = (LightVirtualFile)ObjectUtils.tryCast((Object)FileDocumentManager.getInstance().getFile((Document)document), LightVirtualFile.class);
        if (virtualFile == null) {
            return;
        }
        if (virtualFile.getLanguage() == language) {
            return;
        }
        virtualFile.setLanguage(language);
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)virtualFile);
        editor.setHighlighter(highlighter);
        FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{virtualFile});
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)document);
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled(psiFile, !language.getID().equals("SQL"));
        }
    }

    private static int chunkSize(int startIdx, boolean isTranspositionAware) {
        if (isTranspositionAware) {
            return 100;
        }
        if (startIdx < 20) {
            return 2;
        }
        if (startIdx < 100) {
            return 5;
        }
        return 20;
    }

    @NotNull
    private PageSpec getCurrentPage() {
        GridPagingModel pageModel = this.myResultPanel.getDataHookup().getPageModel();
        return new PageSpec(pageModel.getPageStart(), pageModel.getPageEnd());
    }

    @Override
    public void searchSessionUpdated() {
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myViewer);
        this.myExecutor.shutdown();
    }

    @TestOnly
    public void shutdownAndAwaitTermination() {
        this.myExecutor.shutdown();
        try {
            this.myExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Text result view termination interrupted", (Throwable)e);
        }
    }

    @Override
    public void resetScroll() {
        this.myViewer.getScrollPane().getHorizontalScrollBar().setValue(0);
        this.myViewer.getScrollPane().getVerticalScrollBar().setValue(0);
    }

    private /* synthetic */ void lambda$updateText$3(PageSpec pageOfThisExtractor, Out.Readable out, String postfix, Language language) {
        if (!this.getCurrentPage().equals(pageOfThisExtractor)) {
            return;
        }
        TextResultView.updateEditorText(this.myViewer, this.myResultPanel.getProject(), out.getString() + postfix, language);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10, 11, 15, 16, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/text/TextResultView";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/text/TextResultView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRows";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextColumn";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIndexConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateColorScheme";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerEscapeAction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setColumnEnabled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setRowEnabled";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionChangedListener";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "contentLanguageUpdated";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "displayTypeUpdated";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListenerToComponents";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateEditorText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10, 11, 15, 16, 21, 22 -> new IllegalStateException(string);
        };
    }

    private static class PageSpec {
        final int myPageStart;
        final int myPageEnd;

        PageSpec(int pageStart, int pageEnd) {
            this.myPageStart = pageStart;
            this.myPageEnd = pageEnd;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageSpec spec = (PageSpec)o;
            return this.myPageStart == spec.myPageStart && this.myPageEnd == spec.myPageEnd;
        }

        public int hashCode() {
            return Objects.hash(this.myPageStart, this.myPageEnd);
        }

        public String toString() {
            return "PageSpec{" + this.myPageStart + ", " + this.myPageEnd + "}";
        }
    }
}

