/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/run/ui/table/TrimmedLabelWithFallbackFont;", "Lcom/intellij/database/run/ui/table/TableResultView$LabelWithFallbackFont;", "tableResultView", "Lcom/intellij/database/run/ui/table/TableResultView;", "(Lcom/intellij/database/run/ui/table/TableResultView;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "renderWithText", "text", "", "intellij.grid.impl"})
public class TrimmedLabelWithFallbackFont
extends TableResultView.LabelWithFallbackFont {
    public TrimmedLabelWithFallbackFont(@NotNull TableResultView tableResultView) {
        Intrinsics.checkNotNullParameter((Object)tableResultView, (String)"tableResultView");
        super(tableResultView);
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (!(g instanceof Graphics2D)) {
            return;
        }
        UISettings.Companion.setupAntialiasing(g);
        int textWidth = fm.stringWidth(this.getText());
        int availableWidth = 0;
        availableWidth = this.getWidth() - this.getInsets().right - this.getInsets().left;
        Icon icon = this.getIcon();
        if (icon != null) {
            Icon it = icon;
            boolean bl = false;
            availableWidth -= this.getIconTextGap() + it.getIconWidth();
        }
        if (textWidth <= availableWidth) {
            super.paintComponent(g);
            return;
        }
        int low = -1;
        int high = this.getText().length();
        while (high - low > 1) {
            int mid = (low + high) / 2;
            int width = fm.stringWidth(StringUtil.shortenTextWithEllipsis((String)this.getText(), (int)(mid + 1), (int)0, (boolean)true));
            if (width > availableWidth) {
                high = mid;
                continue;
            }
            low = mid;
        }
        if (low > -1) {
            String string = StringUtil.shortenTextWithEllipsis((String)this.getText(), (int)(low + 1), (int)0, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            this.renderWithText(string, g);
        } else {
            this.renderWithText("", g);
        }
    }

    private final void renderWithText(@NlsSafe String text, Graphics g) {
        String originalText = this.getText();
        this.setText(text);
        super.paintComponent(g);
        this.setText(originalText);
    }
}

