/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridWithNestedTables;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridColumnLayout;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.GridUtilKt;
import com.intellij.database.datagrid.HierarchicalColumnsCollapseManager;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.HierarchicalReader;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.ResultViewColumn;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelUtil;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.run.actions.ColumnLocalFilterAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.database.run.ui.EditMaximizedViewKt;
import com.intellij.database.run.ui.GridTableCellEditor;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.ResultViewWithColumns;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.run.ui.TableAggregatorWidgetHelper;
import com.intellij.database.run.ui.ValueTabInfoProvider;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellRenderingUtils;
import com.intellij.database.run.ui.grid.DataGridSearchSession;
import com.intellij.database.run.ui.grid.DummyGridColumnLayout;
import com.intellij.database.run.ui.grid.GridColorSchemeUtil;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.database.run.ui.grid.JBTableWithResizableCells;
import com.intellij.database.run.ui.grid.ResizableCellEditorsSupport;
import com.intellij.database.run.ui.grid.TableCellImageCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactories;
import com.intellij.database.run.ui.table.GridSelectionGrower;
import com.intellij.database.run.ui.table.GridTableModel;
import com.intellij.database.run.ui.table.LocalFilterState;
import com.intellij.database.run.ui.table.MoveColumnListener;
import com.intellij.database.run.ui.table.RegularGridTableModel;
import com.intellij.database.run.ui.table.SingleRowModeHelper;
import com.intellij.database.run.ui.table.TableGoToRowHelper;
import com.intellij.database.run.ui.table.TablePositionWidgetHelper;
import com.intellij.database.run.ui.table.TableRawIndexConverter;
import com.intellij.database.run.ui.table.TableResultRowHeader;
import com.intellij.database.run.ui.table.TableResultViewColumn;
import com.intellij.database.run.ui.table.TableScrollPane;
import com.intellij.database.run.ui.table.TableScrollPositionManager;
import com.intellij.database.run.ui.table.TableSelectionModel;
import com.intellij.database.run.ui.table.TransposedGridTableModel;
import com.intellij.database.run.ui.table.TrimmedLabelWithFallbackFont;
import com.intellij.database.run.ui.table.UnparsedValueHoverListener;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsPanelMode;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsTableHeader;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.find.FindModel;
import com.intellij.find.SearchSession;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableCell;
import com.intellij.ui.TableExpandableItemsHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.CellRendererPane;
import javax.swing.DefaultRowSorter;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TableResultView
extends JBTableWithResizableCells
implements ResultView,
ResultViewWithCells,
ResultViewWithColumns,
ResultViewWithRows,
EditorColorsListener,
UISettingsListener {
    private final DataGrid myResultPanel;
    private final MyTableColumnCache myColumnCache;
    private final Renderers myRenderers;
    private final TableCellImageCache myCellImageCache;
    private final TableRawIndexConverter myRawIndexConverter;
    private final ActionGroup myColumnHeaderPopupActions;
    private final ActionGroup myRowHeaderPopupActions;
    private final GridColumnLayout<GridRow, GridColumn> myColumnLayout;
    private final GridSelectionGrower myGrower;
    private final List<Consumer<Boolean>> mySelectionListeners;
    private ModelIndex<GridColumn> myClickedHeaderColumnIdx;
    private Point myClickedHeaderPoint;
    private double myFontSizeIncrement;
    private double myFontSizeScale;
    private final UpdateScaleHelper myUpdateScaleHelper;
    private int myColumnsHashCode;
    private PaintingSession myPaintingSession;
    private Ref<Object> myCommonValue;
    private boolean myWasAutomaticallyTransposed;
    private boolean myDisableSelectionListeners;
    private boolean myIsShowRowNumbers;
    private Consumer<Boolean> myColumnHeaderBgListener;
    private Boolean myIsTransparentColumnHeaderBg;
    private boolean myAllowMultilineColumnLabel;
    private final AtomicInteger editingBlocked;
    private ResultView.HoveredRowBgHighlightMode myHoveredRowMode;
    private StatisticsTableHeader myStatisticsHeader;

    public TableResultView(@NotNull DataGrid resultPanel, @NotNull ActionGroup columnHeaderPopupActions, @NotNull ActionGroup rowHeaderPopupActions) {
        DataGridWithNestedTables dataGridWithNestedTables;
        if (resultPanel == null) {
            TableResultView.$$$reportNull$$$0(0);
        }
        if (columnHeaderPopupActions == null) {
            TableResultView.$$$reportNull$$$0(1);
        }
        if (rowHeaderPopupActions == null) {
            TableResultView.$$$reportNull$$$0(2);
        }
        super(new RegularGridTableModel(resultPanel), new MyTableColumnModel());
        this.mySelectionListeners = new ArrayList<Consumer<Boolean>>();
        this.myFontSizeIncrement = 0.0;
        this.myFontSizeScale = 1.0;
        this.myUpdateScaleHelper = new UpdateScaleHelper();
        this.myWasAutomaticallyTransposed = false;
        this.myDisableSelectionListeners = false;
        this.myAllowMultilineColumnLabel = false;
        this.editingBlocked = new AtomicInteger(0);
        this.myHoveredRowMode = ResultView.HoveredRowBgHighlightMode.AUTO;
        this.myResultPanel = resultPanel;
        this.myCellImageCache = new TableCellImageCache(this, this);
        this.myColumnHeaderPopupActions = columnHeaderPopupActions;
        this.myRowHeaderPopupActions = rowHeaderPopupActions;
        this.myRawIndexConverter = new TableRawIndexConverter(this, () -> this.isTransposed());
        this.myColumnCache = new MyTableColumnCache();
        this.myRenderers = new Renderers(this.myResultPanel, this);
        this.myClickedHeaderColumnIdx = ModelIndex.forColumn((CoreGrid)this.myResultPanel, (int)-1);
        this.myColumnLayout = ApplicationManager.getApplication().isUnitTestMode() ? new DummyGridColumnLayout() : GridHelper.get(this.myResultPanel).createColumnLayout(this, this.myResultPanel);
        this.myGrower = new GridSelectionGrower(this.myResultPanel, this, this);
        this.getTableHeader().setDefaultRenderer(this.createHeaderRenderer());
        ComponentWithExpandableItems tableHeader = (ComponentWithExpandableItems)ObjectUtils.tryCast((Object)this.getTableHeader(), ComponentWithExpandableItems.class);
        if (tableHeader != null) {
            tableHeader.setExpandableItemsEnabled(false);
        }
        this.putClientProperty(BookmarksManager.ALLOWED, true);
        new ResizableCellEditorsSupport(this);
        this.setupFocusListener();
        this.setupMagnificator();
        this.setEnableAntialiasing(true);
        this.setShowLastHorizontalLine(true);
        this.setFont(this.getColorsScheme().getFont(EditorFontType.PLAIN));
        this.updateFonts();
        this.adjustDefaultActions();
        this.addPropertyChangeListener("tableCellEditor", e -> GridUtil.activeGridChanged(resultPanel));
        new TableSelectionModel(this, this.myResultPanel);
        new TableGoToRowHelper(this, this.myResultPanel);
        new TableAggregatorWidgetHelper(this, this.myResultPanel);
        new TablePositionWidgetHelper(this, this.myResultPanel);
        new TableScrollPositionManager(this, this.myResultPanel);
        this.getColumnModel().getSelectionModel().addListSelectionListener(e -> this.myGrower.reset());
        this.myResultPanel.addDataGridListener(new DataGridListener(){

            @Override
            public void onValueEdited(DataGrid dataGrid, @Nullable Object object) {
                TableResultView.this.myCommonValue = Ref.create((Object)object);
            }
        }, this);
        this.addSelectionChangedListener(isAdjusting -> this.getScrollPane().repaint());
        new UnparsedValueHoverListener(UnparsedValueHoverListener.Companion.Place.CENTER, this).addTo((JComponent)((Object)this));
        MessageBusConnection connection = resultPanel.getProject().getMessageBus().connect((Disposable)this);
        this.setShowHorizontalLines(false);
        GridUtil.addDataProvider((JComponent)((Object)this), this::getData);
        MoveColumnListener moveColumnListener = new MoveColumnListener(this.myResultPanel, this);
        this.getTableHeader().addMouseListener(moveColumnListener);
        this.columnModel.addColumnModelListener(moveColumnListener);
        DataGrid dataGrid = this.myResultPanel;
        if (dataGrid instanceof DataGridWithNestedTables && (dataGridWithNestedTables = (DataGridWithNestedTables)((Object)dataGrid)).isNestedTableSupportEnabled()) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ModelIndex col;
                    if (e.getButton() == 3) {
                        return;
                    }
                    ModelIndex row = ViewIndex.forRow((CoreGrid)TableResultView.this.myResultPanel, (int)TableResultView.this.rowAtPoint(e.getPoint())).toModel((CoreGrid)TableResultView.this.myResultPanel);
                    if (dataGridWithNestedTables.onCellClick((ModelIndex<GridRow>)row, (ModelIndex<GridColumn>)(col = ViewIndex.forColumn((CoreGrid)TableResultView.this.myResultPanel, (int)TableResultView.this.columnAtPoint(e.getPoint())).toModel((CoreGrid)TableResultView.this.myResultPanel)))) {
                        e.consume();
                    }
                }
            });
        }
    }

    @Nullable
    private Object getData(@NonNls @NotNull String dataId) {
        if (dataId == null) {
            TableResultView.$$$reportNull$$$0(3);
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            return this.myClickedHeaderPoint;
        }
        return null;
    }

    @Override
    public void setShowHorizontalLines(boolean v) {
        if (v) {
            this.setIntercellSpacing(new Dimension(this.getIntercellSpacing().width, 1));
        }
        super.setShowHorizontalLines(v);
    }

    @Override
    public void setShowVerticalLines(boolean showVerticalLines) {
        if (showVerticalLines) {
            this.setIntercellSpacing(new Dimension(1, this.getIntercellSpacing().height));
        }
        super.setShowVerticalLines(showVerticalLines);
    }

    @Override
    public void setStriped(boolean striped) {
        super.setStriped(striped);
        if (striped) {
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
    }

    @Nullable
    protected Color getStripeColor() {
        return this.myResultPanel.getStripeRowBackground();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        TableResultView tableResultView = this;
        if (tableResultView == null) {
            TableResultView.$$$reportNull$$$0(4);
        }
        return tableResultView;
    }

    @Override
    public void showRowNumbers(boolean v) {
        this.myIsShowRowNumbers = v;
        TableScrollPane parent = (TableScrollPane)((Object)ComponentUtil.getParentOfType(TableScrollPane.class, (Component)((Object)this)));
        if (parent == null) {
            return;
        }
        if (this.isTransposed()) {
            parent.setRowHeaderView(this.myResultPanel.createRowHeader(this));
            return;
        }
        if (this.myIsShowRowNumbers) {
            parent.setRowHeaderView(this.myResultPanel.createRowHeader(this));
        } else {
            parent.setRowHeader(null);
        }
    }

    @Override
    public void setTransparentColumnHeaderBackground(boolean v) {
        this.myIsTransparentColumnHeaderBg = v;
        if (this.myColumnHeaderBgListener != null) {
            this.myColumnHeaderBgListener.accept(this.myIsTransparentColumnHeaderBg);
        }
    }

    public void addColumnHeaderBackgroundChangedListener(@NotNull Consumer<Boolean> listener) {
        if (listener == null) {
            TableResultView.$$$reportNull$$$0(5);
        }
        this.myColumnHeaderBgListener = listener;
        if (this.myIsTransparentColumnHeaderBg != null) {
            this.myColumnHeaderBgListener.accept(this.myIsTransparentColumnHeaderBg);
        }
    }

    @Override
    public void setAllowMultilineLabel(boolean v) {
        this.myAllowMultilineColumnLabel = v;
    }

    @NotNull
    protected ExpandableItemsHandler<TableCell> createExpandableItemsHandler() {
        return new TableExpandableItemsHandler((JTable)((Object)this)){

            protected void handleSelectionChange(TableCell selected, boolean processIfUnfocused) {
                if (selected == null) {
                    super.handleSelectionChange(null, processIfUnfocused);
                    return;
                }
                SelectionModel selectionModel = SelectionModelUtil.get(TableResultView.this.myResultPanel, TableResultView.this);
                ViewIndex row = ViewIndex.forRow((CoreGrid)TableResultView.this.myResultPanel, (int)(TableResultView.this.isTransposed() ? selected.column : selected.row));
                ViewIndex column = ViewIndex.forColumn((CoreGrid)TableResultView.this.myResultPanel, (int)(TableResultView.this.isTransposed() ? selected.row : selected.column));
                Object val = TableResultView.this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row.toModel((CoreGrid)TableResultView.this.myResultPanel), column.toModel((CoreGrid)TableResultView.this.myResultPanel));
                if (val instanceof NestedTable) {
                    super.handleSelectionChange(null, processIfUnfocused);
                    return;
                }
                boolean isSelected = selectionModel.isSelected(row, column);
                EditMaximizedView view = (EditMaximizedView)TableResultView.this.myResultPanel.getUserData(EditMaximizedViewKt.EDIT_MAXIMIZED_GRID_KEY);
                boolean suppress = isSelected && view != null && view.getCurrentTabInfoProvider() instanceof ValueTabInfoProvider;
                super.handleSelectionChange((Object)(suppress ? null : selected), processIfUnfocused);
            }
        };
    }

    @Override
    public void setValueAt(@Nullable Object v, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, boolean allowImmediateUpdate, @NotNull GridRequestSource source) {
        if (row == null) {
            TableResultView.$$$reportNull$$$0(6);
        }
        if (column == null) {
            TableResultView.$$$reportNull$$$0(7);
        }
        if (source == null) {
            TableResultView.$$$reportNull$$$0(8);
        }
        int viewRowIdx = this.isTransposed() ? column.toView((CoreGrid)this.myResultPanel).asInteger() : row.toView((CoreGrid)this.myResultPanel).asInteger();
        int viewColumnIdx = this.isTransposed() ? row.toView((CoreGrid)this.myResultPanel).asInteger() : column.toView((CoreGrid)this.myResultPanel).asInteger();
        this.setValueAt(v, viewRowIdx, viewColumnIdx, allowImmediateUpdate, source);
    }

    @Override
    public void setTransposed(boolean transposed) {
        this.myWasAutomaticallyTransposed = false;
        if (this.isTransposed() == transposed) {
            return;
        }
        GridUtil.saveAndRestoreSelection(this.myResultPanel, () -> {
            this.doTranspose();
            this.createDefaultColumnsFromModel();
        });
    }

    public boolean isEditingBlocked() {
        return this.editingBlocked.get() > 0;
    }

    public void setEditingBlocked(boolean editingBlocked) {
        if (editingBlocked) {
            this.editingBlocked.incrementAndGet();
        } else {
            this.editingBlocked.decrementAndGet();
        }
    }

    @Override
    @NotNull
    public JScrollBar getVerticalScrollBar() {
        JScrollBar jScrollBar = this.getScrollPane().getVerticalScrollBar();
        if (jScrollBar == null) {
            TableResultView.$$$reportNull$$$0(9);
        }
        return jScrollBar;
    }

    @NotNull
    private JScrollPane getScrollPane() {
        JScrollPane jScrollPane = Objects.requireNonNull((JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, (Component)((Object)this)));
        if (jScrollPane == null) {
            TableResultView.$$$reportNull$$$0(10);
        }
        return jScrollPane;
    }

    @Override
    @NotNull
    public JScrollBar getHorizontalScrollBar() {
        JScrollBar jScrollBar = this.getScrollPane().getHorizontalScrollBar();
        if (jScrollBar == null) {
            TableResultView.$$$reportNull$$$0(11);
        }
        return jScrollBar;
    }

    @Override
    public void resetLayout() {
        this.myColumnLayout.resetLayout();
    }

    @Override
    public void growSelection() {
        this.myGrower.growSelection();
    }

    @Override
    public void shrinkSelection() {
        this.myGrower.shrinkSelection();
    }

    @Override
    public void addSelectionChangedListener(@NotNull Consumer<Boolean> listener) {
        if (listener == null) {
            TableResultView.$$$reportNull$$$0(12);
        }
        ListSelectionListener l = e -> {
            if (!this.myDisableSelectionListeners) {
                listener.accept(e.getValueIsAdjusting());
            }
        };
        this.getColumnModel().getSelectionModel().addListSelectionListener(l);
        this.getSelectionModel().addListSelectionListener(l);
        this.mySelectionListeners.add(listener);
    }

    @Override
    public void restoreColumnsOrder(Map<Integer, ModelIndex<GridColumn>> expectedToModel) {
        if (this.isTransposed()) {
            return;
        }
        IntUnaryOperator column2View = this.getRawIndexConverter().column2View();
        int columnsCount = this.myResultPanel.getVisibleColumnCount();
        for (int expectedPos = 0; expectedPos < columnsCount; ++expectedPos) {
            int actualPos;
            ModelIndex<GridColumn> modelIndex = expectedToModel.get(expectedPos);
            if (modelIndex == null || (actualPos = column2View.applyAsInt(modelIndex.value)) == -1 || actualPos == expectedPos) continue;
            this.moveColumn(actualPos, expectedPos);
        }
    }

    private void removeViewColumnFromColumnModel(ViewIndex<?> viewColumnIdx) {
        this.getTableHeader().setDraggedColumn(null);
        this.myResultPanel.runWithIgnoreSelectionChanges(() -> this.getColumnModel().removeColumn(this.getColumnModel().getColumn(viewColumnIdx.asInteger())));
    }

    private void addColumnAndMoveToTheCorrectPosition(ModelIndex<?> modelColumnIdx) {
        this.addColumn(this.getColumnCache().getOrCreateColumn(modelColumnIdx.asInteger()));
        int lastColumnIndex = this.getColumnCount() - 1;
        this.myResultPanel.runWithIgnoreSelectionChanges(() -> {
            for (int viewTargetColumnIdx = 0; viewTargetColumnIdx < lastColumnIndex; ++viewTargetColumnIdx) {
                if (this.getColumnModel().getColumn(viewTargetColumnIdx).getModelIndex() <= modelColumnIdx.asInteger()) continue;
                this.moveColumn(lastColumnIndex, viewTargetColumnIdx);
                break;
            }
        });
    }

    public void setViewColumnVisible(ModelIndex<?> modelColumnIdx, boolean visible) {
        ViewIndex viewColumnIdx = modelColumnIdx.toView((CoreGrid)this.myResultPanel);
        if (visible && viewColumnIdx.asInteger() < 0) {
            boolean firstTimeShown = !this.getColumnCache().hasCachedColumn(modelColumnIdx.asInteger());
            this.addColumnAndMoveToTheCorrectPosition(modelColumnIdx);
            if (firstTimeShown) {
                this.myColumnLayout.columnsShown(this.isTransposed() ? ModelIndexSet.forRows((CoreGrid)this.myResultPanel, (int[])new int[]{modelColumnIdx.asInteger()}) : ModelIndexSet.forColumns((CoreGrid)this.myResultPanel, (int[])new int[]{modelColumnIdx.asInteger()}));
            }
        } else if (!visible && viewColumnIdx.asInteger() >= 0) {
            this.removeViewColumnFromColumnModel(viewColumnIdx);
        }
    }

    @NotNull
    public ModelIndex<GridColumn> uiColumn(int uiColumn) {
        int modelIndex = uiColumn < 1 || uiColumn >= this.myResultPanel.getVisibleColumnCount() + 1 ? -1 : this.getRawIndexConverter().column2Model().applyAsInt(uiColumn - 1);
        ModelIndex modelIndex2 = ModelIndex.forColumn((CoreGrid)this.myResultPanel, (int)modelIndex);
        if (modelIndex2 == null) {
            TableResultView.$$$reportNull$$$0(13);
        }
        return modelIndex2;
    }

    public int fromRealRowIdx(int uiRow) {
        return uiRow < 1 ? -1 : uiRow - 1;
    }

    @Override
    public void showFirstCell(int rowNumOnCurrentPage) {
        this.myResultPanel.showCell(this.fromRealRowIdx(rowNumOnCurrentPage), this.uiColumn(0));
    }

    @NotNull
    private GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myResultPanel.getColorsScheme();
        if (gridColorsScheme == null) {
            TableResultView.$$$reportNull$$$0(14);
        }
        return gridColorsScheme;
    }

    @Override
    public void searchSessionUpdated() {
        this.updateRowFilter();
        this.getComponent().repaint();
    }

    @Nullable
    public JComponent getCellRendererComponent(@NotNull ViewIndex<GridRow> viewRow, @NotNull ViewIndex<GridColumn> viewColumn, boolean forDisplay) {
        int column;
        if (viewRow == null) {
            TableResultView.$$$reportNull$$$0(15);
        }
        if (viewColumn == null) {
            TableResultView.$$$reportNull$$$0(16);
        }
        if (!viewRow.isValid((CoreGrid)this.myResultPanel) || !viewColumn.isValid((CoreGrid)this.myResultPanel)) {
            return null;
        }
        int row = (this.isTransposed() ? viewColumn : viewRow).asInteger();
        TableCellRenderer renderer2 = this.getCellRenderer(row, column = (this.isTransposed() ? viewRow : viewColumn).asInteger());
        if (renderer2 == null) {
            return null;
        }
        return (JComponent)this.prepareRenderer(renderer2, row, column, forDisplay);
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<GridColumn> columnIdx, boolean state) {
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(17);
        }
        if (this.isTransposed()) {
            this.getModel().fireTableDataChanged();
        } else {
            this.setViewColumnVisible(columnIdx, state);
        }
    }

    @Override
    public void setRowEnabled(@NotNull ModelIndex<GridRow> rowIdx, boolean state) {
        if (rowIdx == null) {
            TableResultView.$$$reportNull$$$0(18);
        }
        if (this.isTransposed()) {
            this.setViewColumnVisible(rowIdx, state);
        } else {
            this.getModel().fireTableDataChanged();
        }
    }

    @NotNull
    private MyCellRenderer createHeaderRenderer() {
        return new MyCellRenderer(this);
    }

    public void startPaintingSession() {
        this.myPaintingSession = new PaintingSession();
    }

    public void endPaintingSession() {
        this.myPaintingSession = null;
    }

    private void dropCaches() {
        this.myCellImageCache.reset();
    }

    public MyTableColumnCache getColumnCache() {
        return this.myColumnCache;
    }

    @Override
    @NotNull
    public ModelIndex<GridColumn> getContextColumn() {
        ModelIndex<GridColumn> modelIndex = this.myClickedHeaderColumnIdx;
        if (modelIndex == null) {
            TableResultView.$$$reportNull$$$0(19);
        }
        return modelIndex;
    }

    @Override
    public void updateSortKeysFromColumnAttributes() {
        RowSorter rowSorter = this.getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(this.isTransposed() || this.myResultPanel.isSortViaOrderBy() ? null : this.createSortKeys());
        }
    }

    @Override
    public void orderingAndVisibilityChanged() {
        this.getModel().fireTableDataChanged();
    }

    @NotNull
    private List<RowSorter.SortKey> createSortKeys() {
        if (this.isTransposed()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TableResultView.$$$reportNull$$$0(20);
            }
            return list;
        }
        TreeMap<Integer, GridColumn> sortOrderMap = this.myResultPanel.getSortOrderMap();
        int orderIdx = 0;
        RowSorter.SortKey[] keys = new RowSorter.SortKey[sortOrderMap.size()];
        for (GridColumn column : sortOrderMap.values()) {
            RowSorter.SortKey key = new RowSorter.SortKey(column.getColumnNumber(), this.myResultPanel.getSortOrder(column) < 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING);
            keys[orderIdx++] = key;
        }
        List<RowSorter.SortKey> list = List.of(keys);
        if (list == null) {
            TableResultView.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Override
    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        TableRawIndexConverter tableRawIndexConverter = this.myRawIndexConverter;
        if (tableRawIndexConverter == null) {
            TableResultView.$$$reportNull$$$0(22);
        }
        return tableRawIndexConverter;
    }

    @Override
    public void addMouseListenerToComponents(@NotNull MouseListener listener) {
        if (listener == null) {
            TableResultView.$$$reportNull$$$0(23);
        }
        this.getScrollPane().addMouseListener(listener);
        this.addMouseListener(listener);
    }

    @Override
    public boolean supportsCustomSearchSession() {
        return true;
    }

    @Override
    @NotNull
    public DataGridSearchSession createSearchSession(@Nullable FindModel findModel, @Nullable Component previousFilterComponent) {
        FindModel newFindModel = new FindModel();
        if (findModel != null) {
            newFindModel.copyFrom(findModel);
        }
        DataGridSearchSession.configureFindModel(this.myResultPanel, newFindModel);
        return new DataGridSearchSession(this.myResultPanel.getProject(), this.myResultPanel, newFindModel, previousFilterComponent);
    }

    @Override
    public void searchSessionStarted(@NotNull SearchSession searchSession) {
        if (searchSession == null) {
            TableResultView.$$$reportNull$$$0(24);
        }
        if (!(searchSession instanceof GridSearchSession)) {
            return;
        }
        ((GridSearchSession)searchSession).addListener(this, this);
    }

    public void doTranspose() {
        this.myColumnCache.retainColumns(ContainerUtil.emptyList());
        this.myColumnLayout.invalidateCache();
        this.setModel(this.isTransposed() ? new RegularGridTableModel(this.myResultPanel) : new TransposedGridTableModel(this.myResultPanel));
        this.showRowNumbers(this.myIsShowRowNumbers);
        this.myResultPanel.updateSortKeysFromColumnAttributes();
        this.getModel().fireTableDataChanged();
    }

    public void addNotify() {
        super.addNotify();
        this.layoutColumnsIfNeeded();
    }

    public void doLayout() {
        super.doLayout();
        if (this.getWidth() != 0) {
            this.layoutColumnsIfNeeded();
        }
    }

    private void layoutColumnsIfNeeded() {
        if (this.myColumnsHashCode != 0) {
            return;
        }
        int hash = this.computeColumnsHashCode();
        if (hash == 0) {
            return;
        }
        this.layoutColumns().doWhenDone(() -> {
            this.myColumnsHashCode = hash;
        });
    }

    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            TableResultView.$$$reportNull$$$0(25);
        }
        this.adjustCacheSize();
        super.paintComponent(g);
        this.paintCellsEffects(g);
    }

    private void adjustCacheSize() {
        if (!this.myCellImageCache.isCacheEnabled()) {
            return;
        }
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = columnModel == null ? 0 : columnModel.getColumnCount();
        int rowCount = this.getRowCount();
        Rectangle visibleRect = this.getVisibleRect();
        if (columnCount == 0 || rowCount == 0 || visibleRect.isEmpty()) {
            return;
        }
        int minColumnWidth = Integer.MAX_VALUE;
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = columnModel.getColumn(i);
            minColumnWidth = Math.min(minColumnWidth, column.getMinWidth());
        }
        int rowHeight = this.getRowHeight();
        int rowsMax = rowHeight == 0 ? rowCount : Math.min(rowCount, (int)Math.ceil((float)visibleRect.height / (float)rowHeight));
        rowsMax = Math.min(100, rowsMax);
        int colsMax = minColumnWidth == 0 ? columnCount : Math.min(columnCount, (int)Math.ceil((float)visibleRect.width / (float)minColumnWidth));
        colsMax = Math.min(30, colsMax);
        int factor = Math.max(1, Registry.intValue((String)"database.grid.cache.factor"));
        this.myCellImageCache.adjustCacheSize(rowsMax * colsMax * factor);
    }

    private void paintCellsEffects(Graphics g) {
        Rectangle visibleArea = g.getClipBounds();
        Point at = new Point((int)visibleArea.getMinX(), (int)visibleArea.getMinY());
        int fromRow = this.rowAtPoint(at);
        int fromColumn = this.columnAtPoint(at);
        at.setLocation(visibleArea.getMaxX(), visibleArea.getMaxY());
        int toRow = this.rowAtPoint(at);
        int toColumn = this.columnAtPoint(at);
        if (fromColumn == -1) {
            fromColumn = 0;
        }
        if (toRow == -1) {
            toRow = 0;
        }
        if (toColumn == -1) {
            toColumn = this.getColumnCount() - 1;
        }
        if (fromRow == -1) {
            toRow = this.getRowCount() - 1;
        }
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column = fromColumn; column <= toColumn; ++column) {
                this.paintCellEffects(g, row, column);
            }
        }
    }

    private void paintCellEffects(Graphics g, int row, int column) {
        CellAttributes attributes = this.myResultPanel.getMarkupModel().getCellAttributes((ModelIndex<GridRow>)ViewIndex.forRow((CoreGrid)this.myResultPanel, (int)(this.isTransposed() ? column : row)).toModel((CoreGrid)this.myResultPanel), (ModelIndex<GridColumn>)ViewIndex.forColumn((CoreGrid)this.myResultPanel, (int)(this.isTransposed() ? row : column)).toModel((CoreGrid)this.myResultPanel), this.getColorsScheme());
        if (attributes != null) {
            CellRenderingUtils.paintCellEffect(g, this.getCellRect(row, column, true), attributes);
        }
    }

    private int computeColumnsHashCode() {
        int hash = 0;
        List columns = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        for (GridColumn column : columns) {
            hash = System.identityHashCode(column) + 31 * hash;
        }
        return hash;
    }

    @Override
    public boolean isViewModified() {
        for (int viewColumnIdx = 0; viewColumnIdx < this.getColumnCount(); ++viewColumnIdx) {
            ViewIndex viewIndex = this.isTransposed() ? ViewIndex.forRow((CoreGrid)this.myResultPanel, (int)viewColumnIdx) : ViewIndex.forColumn((CoreGrid)this.myResultPanel, (int)viewColumnIdx);
            ModelIndex modelIndex = viewIndex.toModel((CoreGrid)this.myResultPanel);
            if (!modelIndex.isValid((CoreGrid)this.myResultPanel) || !viewIndex.isValid((CoreGrid)this.myResultPanel) || modelIndex.asInteger() == viewIndex.asInteger()) continue;
            return true;
        }
        for (TableResultViewColumn tableColumn : this.myColumnCache) {
            if (tableColumn.isWidthSetByLayout()) continue;
            return true;
        }
        int defaultRowHeight = this.getRowHeight();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getRowHeight(i) == defaultRowHeight) continue;
            return true;
        }
        return false;
    }

    @Override
    public void contentLanguageUpdated(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull Language language) {
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(26);
        }
        if (language == null) {
            TableResultView.$$$reportNull$$$0(27);
        }
        this.clearCache(columnIdx);
    }

    @Override
    public void displayTypeUpdated(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull DisplayType displayType) {
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(28);
        }
        if (displayType == null) {
            TableResultView.$$$reportNull$$$0(29);
        }
        this.clearCache(columnIdx);
    }

    private void clearCache(@NotNull ModelIndex<GridColumn> columnIdx) {
        int viewColumn;
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(30);
        }
        if (this.isTransposed() ? this.getColumnCount() == 0 : this.getRowCount() == 0) {
            return;
        }
        int viewRow = this.isTransposed() ? columnIdx.toView((CoreGrid)this.myResultPanel).asInteger() : 0;
        int n = viewColumn = this.isTransposed() ? 0 : columnIdx.toView((CoreGrid)this.myResultPanel).asInteger();
        if (viewRow == -1 || viewColumn == -1) {
            return;
        }
        TableCellImageCache.CachingCellRendererWrapper renderer2 = (TableCellImageCache.CachingCellRendererWrapper)ObjectUtils.tryCast((Object)this.getCellRenderer(viewRow, viewColumn), TableCellImageCache.CachingCellRendererWrapper.class);
        if (renderer2 != null) {
            renderer2.clearCache();
            GridCellRendererWrapper rendererWrapper = (GridCellRendererWrapper)ObjectUtils.tryCast((Object)renderer2.getDelegate(), GridCellRendererWrapper.class);
            if (rendererWrapper != null) {
                rendererWrapper.delegate.clearCache();
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void setupFocusListener() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                Component component;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (TableResultView.this.isEditing() && (component = TableResultView.this.getEditorComponent()) != null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component, true));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultView$4", "focusGained"));
            }
        });
    }

    private void setupMagnificator() {
        this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, (scale, at) -> {
            Rectangle r1;
            int column = this.columnAtPoint(at);
            int row = this.rowAtPoint(at);
            Rectangle rectangle = r1 = column < 0 || row < 0 ? this.getBounds() : this.getCellRect(row, column, true);
            if (r1.width == 0 || r1.height == 0) {
                return at;
            }
            double xPerc = (double)(at.x - r1.x) / (double)r1.width;
            double yPerc = (double)(at.y - r1.y) / (double)r1.height;
            this.changeFontSize(0, scale);
            Rectangle r2 = column < 0 || row < 0 ? this.getBounds() : this.getCellRect(row, column, true);
            return new Point((int)((double)r2.x + (double)r2.width * xPerc), (int)((double)r2.y + (double)r2.height * yPerc));
        });
    }

    private void adjustDefaultActions() {
        ActionMap actionMap = this.getActionMap();
        final Action selectPreviousRowCell = actionMap.get("selectPreviousRowCell");
        actionMap.put("selectPreviousRowCell", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                selectPreviousRowCell.actionPerformed(e);
            }
        });
        final Action startEditing = actionMap.get("startEditing");
        actionMap.put("startEditing", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                startEditing.actionPerformed(e);
            }
        });
    }

    public void columnMarginChanged(ChangeEvent e) {
        TableColumn resizingColumn;
        JTableHeader tableHeader = this.getTableHeader();
        TableColumn tableColumn = resizingColumn = tableHeader != null ? tableHeader.getResizingColumn() : null;
        if (resizingColumn != null && this.autoResizeMode == 0) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        if (event == null) {
            TableResultView.$$$reportNull$$$0(31);
        }
        return "";
    }

    public void setRowHeight(int row, int rowHeight) {
        JViewport rowHeader;
        Container grandParent;
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        super.setRowHeight(row, rowHeight);
        Container parent = this.getParent();
        if (parent instanceof JViewport && (grandParent = parent.getParent()) instanceof JScrollPane && (rowHeader = ((JScrollPane)grandParent).getRowHeader()) != null) {
            rowHeader.revalidate();
            rowHeader.repaint();
        }
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        return new MyTableHeader();
    }

    public void columnsAdded(ModelIndexSet<GridColumn> columnIndices) {
        this.columnAttributesUpdated();
        this.getModel().columnsAdded(columnIndices);
        this.dropCaches();
        this.myColumnLayout.newColumnsAdded(columnIndices);
    }

    @Override
    public void columnAttributesUpdated() {
        List columns = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        if (!this.isTransposed()) {
            this.getColumnCache().retainColumns(columns);
            this.createDefaultColumnsFromModel();
        }
    }

    public void columnsRemoved(ModelIndexSet<GridColumn> columns) {
        this.getModel().columnsRemoved(columns);
        if (!this.isTransposed()) {
            this.createDefaultColumnsFromModel();
        }
        this.dropCaches();
    }

    public void rowsAdded(ModelIndexSet<GridRow> rows) {
        this.getModel().rowsAdded(rows);
        if (this.isTransposed()) {
            this.createDefaultColumnsFromModel();
        }
        this.myColumnLayout.newRowsAdded(rows);
    }

    public void afterLastRowAdded() {
        Component rowHeader;
        DataGridSettings settings = GridUtil.getSettings(this.myResultPanel);
        if (!this.isTransposed() && this.getViewRowCount() == 1 && settings != null && settings.getAutoTransposeMode() == DataGridSettings.AutoTransposeMode.ONE_ROW) {
            this.setTransposed(true);
            this.myWasAutomaticallyTransposed = true;
            return;
        }
        if (this.myWasAutomaticallyTransposed && this.isTransposed() && this.getViewRowCount() != 1) {
            this.setTransposed(false);
            return;
        }
        SingleRowModeHelper.expandRowIfNeeded(this.myResultPanel);
        JComponent mainResultViewComponent = this.myResultPanel.getMainResultViewComponent();
        JViewport header = mainResultViewComponent instanceof JScrollPane ? ((JScrollPane)mainResultViewComponent).getRowHeader() : null;
        Component component = rowHeader = header == null ? null : header.getView();
        if (rowHeader == null) {
            return;
        }
        if (rowHeader instanceof TableResultRowHeader) {
            ((TableResultRowHeader)rowHeader).updatePreferredSize();
        }
        rowHeader.revalidate();
        rowHeader.repaint();
    }

    @Override
    public void addSpaceForHorizontalScrollbar(boolean v) {
        JComponent jComponent = this.myResultPanel.getMainResultViewComponent();
        if (jComponent instanceof TableScrollPane) {
            TableScrollPane scrollPane = (TableScrollPane)((Object)jComponent);
            scrollPane.addSpaceForHorizontalScrollbar(v);
        }
    }

    @Override
    public void expandMultilineRows(boolean v) {
        if (v) {
            GridUtilKt.setupDynamicRowHeight((JTable)((Object)this));
        }
    }

    public void rowsRemoved(ModelIndexSet<GridRow> rows) {
        this.getModel().rowsRemoved(rows);
        if (this.isTransposed()) {
            this.createDefaultColumnsFromModel();
        }
    }

    public void cellsUpdated(ModelIndexSet<GridRow> rows, ModelIndexSet<GridColumn> columns, @Nullable GridRequestSource.RequestPlace place) {
        this.getModel().cellsUpdated(rows, columns, place);
        this.myColumnLayout.newRowsAdded(rows);
    }

    public void dispose() {
        this.removeEditor();
    }

    public void changeSelectedColumnsWidth(int delta) {
        int[] columns = this.getSelectedColumns();
        TableColumnModel columnModel = this.getColumnModel();
        for (int column : columns) {
            if (column < 0) continue;
            ResultViewColumn tableColumn = (ResultViewColumn)columnModel.getColumn(column);
            int width = tableColumn.getColumnWidth();
            tableColumn.setColumnWidth(Math.max(0, width + delta));
        }
    }

    @Override
    public void resetRowHeights() {
        int defaultRowHeight = this.getRowHeight();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getRowHeight(i) == defaultRowHeight) continue;
            this.setRowHeight(i, defaultRowHeight);
        }
    }

    public void disableSelectionListeners(Runnable runnable) {
        try {
            this.myDisableSelectionListeners = true;
            runnable.run();
        }
        finally {
            this.myDisableSelectionListeners = false;
        }
    }

    public void fireSelectionChanged() {
        for (Consumer<Boolean> listener : this.mySelectionListeners) {
            listener.accept(false);
        }
    }

    @NotNull
    public LocalFilterState getLocalFilterState() {
        LocalFilterState localFilterState = this.myResultPanel.getLocalFilterState();
        if (localFilterState == null) {
            TableResultView.$$$reportNull$$$0(32);
        }
        return localFilterState;
    }

    public void setModel(@NotNull TableModel model2) {
        if (model2 == null) {
            TableResultView.$$$reportNull$$$0(33);
        }
        super.setModel(model2);
        TableRowSorter<TableModel> rowSorter = this.createRowSorter(model2);
        rowSorter.setMaxSortKeys(1);
        rowSorter.setSortsOnUpdates(this.isSortOnUpdates());
        SwingUtilities.invokeLater(() -> {
            if (this.getRowSorter() == rowSorter) {
                this.updateRowFilter();
            }
        });
        this.setRowSorter(rowSorter);
    }

    public void updateRowFilter() {
        DefaultRowSorter sorter2 = (DefaultRowSorter)this.getRowSorter();
        sorter2.setRowFilter(this.createFilter());
    }

    @NotNull
    private RowFilter<TableModel, Integer> createFilter() {
        final RowFilter baseFilter = this.isTransposed() ? new MyTransposedViewColumnFilter(this.myResultPanel) : new MySearchRowFilter(this.myResultPanel, this.getLocalFilterState());
        return new RowFilter<TableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                if (!baseFilter.include(entry)) {
                    return false;
                }
                int intIdx = entry.getIdentifier();
                ModelIndex rowIdx = TableResultView.this.isTransposed() ? ModelIndex.forColumn((CoreGrid)TableResultView.this.myResultPanel, (int)intIdx) : ModelIndex.forRow((CoreGrid)TableResultView.this.myResultPanel, (int)intIdx);
                return !TableResultView.this.myResultPanel.isRowFilteredOut(rowIdx);
            }
        };
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer2, int row, int column) {
        if (renderer2 == null) {
            TableResultView.$$$reportNull$$$0(34);
        }
        Component component = this.prepareRenderer(renderer2, row, column, true);
        if (component == null) {
            TableResultView.$$$reportNull$$$0(35);
        }
        return component;
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer2, int row, int column, boolean forDisplay) {
        if (renderer2 == null) {
            TableResultView.$$$reportNull$$$0(36);
        }
        Component component = super.prepareRenderer(renderer2, row, column);
        ViewIndex rowIdx = ViewIndex.forRow((CoreGrid)this.myResultPanel, (int)(this.isTransposed() ? column : row));
        ViewIndex columnIdx = ViewIndex.forColumn((CoreGrid)this.myResultPanel, (int)(this.isTransposed() ? row : column));
        Component component2 = ResultViewWithCells.prepareComponent(component, this.myResultPanel, this, (ViewIndex<GridRow>)rowIdx, (ViewIndex<GridColumn>)columnIdx, forDisplay);
        if (component2 == null) {
            TableResultView.$$$reportNull$$$0(37);
        }
        return component2;
    }

    @Override
    @Nullable
    public Color getCellBackground(@NotNull ViewIndex<GridRow> row, @NotNull ViewIndex<GridColumn> column, boolean selected) {
        if (row == null) {
            TableResultView.$$$reportNull$$$0(38);
        }
        if (column == null) {
            TableResultView.$$$reportNull$$$0(39);
        }
        return selected ? this.getSelectionBackground() : this.myResultPanel.getColorModel().getCellBackground(row.toModel((CoreGrid)this.myResultPanel), column.toModel((CoreGrid)this.myResultPanel));
    }

    @Override
    @NotNull
    public Color getCellForeground(boolean selected) {
        Color color = selected ? this.getSelectionForeground() : this.getForeground();
        if (color == null) {
            TableResultView.$$$reportNull$$$0(40);
        }
        return color;
    }

    @Override
    public void reinitSettings() {
        GridCellRendererFactories.get(this.myResultPanel).reinitSettings();
        this.dropCaches();
        this.updateFonts();
    }

    public boolean isCellEditable(int row, int column) {
        return this.myResultPanel.isCellEditingAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editCellAt(int row, int column, EventObject e) {
        ClientProperty.put((JComponent)((Object)this), GridTableCellEditor.EDITING_STARTER_CLIENT_PROPERTY_KEY, (Object)e);
        try {
            boolean bl = super.editCellAt(row, column, e);
            return bl;
        }
        finally {
            ClientProperty.put((JComponent)((Object)this), GridTableCellEditor.EDITING_STARTER_CLIENT_PROPERTY_KEY, null);
        }
    }

    public void createDefaultColumnsFromModel() {
        GridTableModel model2 = this.getModel();
        if (model2 == null) {
            return;
        }
        this.getTableHeader().setDraggedColumn(null);
        ((MyTableColumnModel)this.getColumnModel()).removeAllColumns();
        IntArrayList newColumnIndices = new IntArrayList();
        for (int columnDataIdx = 0; columnDataIdx < model2.getColumnCount(); ++columnDataIdx) {
            boolean notShownEarlier = !this.myColumnCache.hasCachedColumn(columnDataIdx);
            this.myColumnCache.getOrCreateColumn(columnDataIdx);
            HierarchicalColumnsCollapseManager collapseManager = this.myResultPanel.getHierarchicalColumnsCollapseManager();
            boolean enabled = this.isTransposed() || this.myResultPanel.isColumnEnabled(ModelIndex.forColumn((CoreGrid)this.myResultPanel, (int)columnDataIdx)) && (collapseManager == null || !collapseManager.isColumnHiddenDueToCollapse((ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)this.myResultPanel, (int)columnDataIdx)));
            ModelIndex modelColumnIdx = this.isTransposed() ? ModelIndex.forRow((CoreGrid)this.myResultPanel, (int)columnDataIdx) : ModelIndex.forColumn((CoreGrid)this.myResultPanel, (int)columnDataIdx);
            this.setViewColumnVisible(modelColumnIdx, enabled);
            if (!notShownEarlier || !enabled) continue;
            newColumnIndices.add(columnDataIdx);
        }
        if (!newColumnIndices.isEmpty()) {
            ModelIndexSet dataIndices = this.isTransposed() ? ModelIndexSet.forRows((CoreGrid)this.myResultPanel, (int[])newColumnIndices.toIntArray()) : ModelIndexSet.forColumns((CoreGrid)this.myResultPanel, (int[])newColumnIndices.toIntArray());
            this.myColumnLayout.columnsShown(dataIndices);
        }
    }

    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        if (visibleRect == null) {
            TableResultView.$$$reportNull$$$0(41);
        }
        if (orientation == 1) {
            return this.getColorsScheme().getEditorFontSize();
        }
        return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public Font getFont() {
        return this.myPaintingSession != null ? this.myPaintingSession.getFont() : (this.myResultPanel == null ? super.getFont() : this.doGetFont());
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        this.updateFonts();
    }

    public void updateUI() {
        super.updateUI();
        if (this.getParent() != null) {
            this.myUpdateScaleHelper.saveScaleAndRunIfChanged(() -> this.updateFonts());
        }
    }

    public void changeFontSize(int increment, double scale) {
        int oldFontSize;
        double newIncrement = this.myFontSizeIncrement * scale + (double)increment;
        double newScale = this.myFontSizeScale * scale;
        int newFontSize = this.fontSize(newIncrement, newScale);
        if (newFontSize == (oldFontSize = this.getFont().getSize())) {
            return;
        }
        this.myFontSizeIncrement = newIncrement;
        this.myFontSizeScale = newScale;
        this.updateFonts();
    }

    private void updateFonts() {
        Font font = this.getFont();
        this.setFont(font);
        this.setRowHeight(this.getRowHeight());
        JTableHeader tableHeader = this.getTableHeader();
        if (tableHeader != null) {
            tableHeader.setFont(this.getScaledFont(font));
        }
        this.myResultPanel.trueLayout();
        this.layoutColumns();
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            TableResultView.$$$reportNull$$$0(42);
        }
        if (this.changeHeaderFont(uiSettings)) {
            this.myResultPanel.trueLayout();
            this.layoutColumns();
        }
    }

    private boolean changeHeaderFont(UISettings settings) {
        boolean normalMode;
        boolean presentationMode;
        JTableHeader header = this.getTableHeader();
        if (settings == null || header == null || header.getFont() == null) {
            return false;
        }
        int fontSize = header.getFont().getSize();
        float scaledFontSize = UISettingsUtils.with((UISettings)settings).getPresentationModeFontSize();
        boolean bl = presentationMode = settings.getPresentationMode() && (float)fontSize != scaledFontSize;
        if (presentationMode) {
            header.setFont(header.getFont().deriveFont(scaledFontSize));
        }
        boolean bl2 = normalMode = !settings.getPresentationMode() && (float)fontSize == scaledFontSize;
        if (normalMode) {
            header.setFont(this.getScaledFont(header.getFont()));
        }
        return presentationMode || normalMode;
    }

    private int fontSize(double fontSizeIncrement, double fontSizeScale) {
        int baseFontSize = Math.round(UISettingsUtils.getInstance().scaleFontSize((float)this.getColorsScheme().getEditorFontSize()));
        int newFontSize = (int)Math.max(fontSizeScale * (double)baseFontSize + fontSizeIncrement, 8.0);
        return Math.min(Math.max(EditorFontsConstants.getMaxEditorFontSize(), baseFontSize), newFontSize);
    }

    @Override
    public int getRowHeight() {
        return this.myPaintingSession != null ? this.myPaintingSession.getRowHeight() : this.doGetRowHeight();
    }

    public int getTextLineHeight() {
        return (int)Math.ceil((float)this.getFontMetrics(this.getFont()).getHeight() * this.getColorsScheme().getLineSpacing());
    }

    public Color getSelectionForeground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getSelectionForeground() : (this.myResultPanel == null ? super.getSelectionForeground() : GridColorSchemeUtil.doGetSelectionForeground(this.getColorsScheme()));
    }

    public Color getSelectionBackground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getSelectionBackground() : (this.myResultPanel == null ? super.getSelectionBackground() : GridColorSchemeUtil.doGetSelectionBackground(this.getColorsScheme()));
    }

    public Color getForeground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getForeground() : (this.myResultPanel == null ? super.getBackground() : GridColorSchemeUtil.doGetForeground(this.getColorsScheme()));
    }

    public Color getBackground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getBackground() : (this.myResultPanel == null ? super.getForeground() : GridColorSchemeUtil.doGetBackground(this.getColorsScheme()));
    }

    public void setBackground(@NotNull Color bg) {
        if (bg == null) {
            TableResultView.$$$reportNull$$$0(43);
        }
    }

    public Color getGridColor() {
        return this.myPaintingSession != null ? this.myPaintingSession.getGridColor() : (this.myResultPanel == null ? super.getGridColor() : GridColorSchemeUtil.doGetGridColor(this.getColorsScheme()));
    }

    public void tableChanged(TableModelEvent e) {
        if (this.myResultPanel == null) {
            super.tableChanged(e);
            return;
        }
        this.myResultPanel.getAutoscrollLocker().runWithLock(() -> super.tableChanged(e));
        this.myResultPanel.fireContentChanged(e instanceof GridTableModel.RequestedTableModelEvent ? ((GridTableModel.RequestedTableModelEvent)e).getPlace() : null);
    }

    public GridTableModel getModel() {
        return (GridTableModel)super.getModel();
    }

    public Object getValueAt(int row, int column) {
        boolean commonValue = this.isEditing() && this.isCellSelected(row, column) && this.isMultiEditingAllowed();
        return commonValue ? this.myCommonValue.get() : super.getValueAt(row, column);
    }

    public void removeEditor() {
        try {
            super.removeEditor();
        }
        finally {
            this.myCommonValue = null;
        }
    }

    @Override
    public boolean isTransposed() {
        return this.getModel() instanceof TransposedGridTableModel;
    }

    private void onRowHeaderClicked(ModelIndex<GridRow> rowIdx, MouseEvent e) {
        if (e.getID() != 501) {
            return;
        }
        if (this.myResultPanel.isHeaderSelecting() && this.isTransposed()) {
            int tableViewColumnIdx = this.myRawIndexConverter.row2View().applyAsInt(rowIdx.value);
            this.selectViewColumnInterval(tableViewColumnIdx, e);
        }
        if (e.isPopupTrigger()) {
            this.invokeRowPopup(e.getComponent(), e.getX(), e.getY());
        }
    }

    void invokeRowPopup(@NotNull Component component, int x, int y) {
        if (component == null) {
            TableResultView.$$$reportNull$$$0(44);
        }
        if (this.myRowHeaderPopupActions != ActionGroup.EMPTY_GROUP) {
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("TableResultViewHeader", this.myRowHeaderPopupActions);
            popupMenu.getComponent().show(component, x, y);
        }
    }

    private void onColumnHeaderClicked(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull MouseEvent e) {
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(45);
        }
        if (e == null) {
            TableResultView.$$$reportNull$$$0(46);
        }
        if (e.getID() == 500 && e.getButton() == 1) {
            this.handleClickOnColumnHeader(columnIdx, e);
            return;
        }
        if (e.getID() != 500 && e.getButton() == 2 && e.getClickCount() == 1) {
            if (columnIdx.value >= 0) {
                this.myResultPanel.setColumnEnabled(columnIdx, false);
            }
            return;
        }
        if (e.isPopupTrigger()) {
            if (this.myResultPanel.isHeaderSelecting() && !this.isTransposed()) {
                int tableViewColumnIdx = this.myRawIndexConverter.column2View().applyAsInt(columnIdx.value);
                this.selectViewColumnInterval(tableViewColumnIdx, e);
            }
            this.invokeColumnPopup(columnIdx, e.getComponent(), new Point(e.getX(), e.getY()));
        }
    }

    private void handleClickOnColumnHeader(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull MouseEvent e) {
        GridColumn column;
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(47);
        }
        if (e == null) {
            TableResultView.$$$reportNull$$$0(48);
        }
        if ((column = (GridColumn)this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx)) instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn) {
            HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)column;
            this.handleClickOnHierarchicalColumnHeader(hierarchicalColumn, columnIdx, e);
        } else {
            int currentViewIdx = columnIdx.toView((CoreGrid)this.myResultPanel).value;
            TableResultViewColumn tableColumn = ((MyTableColumnModel)this.columnModel).getColumn(currentViewIdx);
            int offsetX = TableResultView.calculateClickedColumnX(this, currentViewIdx);
            MyHeaderCellComponent currentHeader = this.renderWithActualBounds(this.tableHeader, currentViewIdx, tableColumn);
            Point point = e.getPoint();
            Point relativePoint = new Point(point.x - offsetX, point.y);
            JLabel filterLabel = currentHeader.filterLabel;
            if (filterLabel.getBounds().contains(relativePoint)) {
                JBPopup popup = ColumnLocalFilterAction.createFilterPopup(this.myResultPanel, columnIdx);
                if (popup != null) {
                    popup.show(new RelativePoint(e.getComponent(), point));
                }
            } else {
                this.handleClickToSortColumn(columnIdx, e);
            }
        }
    }

    private void handleClickOnHierarchicalColumnHeader(@NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn, @NotNull ModelIndex<GridColumn> columnIdx, @NotNull MouseEvent e) {
        OptionalInt clickedHeaderLineIndex;
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(49);
        }
        if (e == null) {
            TableResultView.$$$reportNull$$$0(50);
        }
        if (hierarchicalColumn == null) {
            TableResultView.$$$reportNull$$$0(51);
        }
        if ((clickedHeaderLineIndex = this.getIndexOfClickedHeaderLine(columnIdx, e)).isEmpty()) {
            return;
        }
        if (this.isLeafColumnHeaderLineClicked(hierarchicalColumn, clickedHeaderLineIndex.getAsInt())) {
            this.handleClickToSortColumn(columnIdx, e);
        } else {
            this.myResultPanel.getAutoscrollLocker().runWithLock(() -> GridUtil.collapseColumnsSubtree(this.myResultPanel, columnIdx, clickedHeaderLineIndex.getAsInt()));
        }
    }

    private boolean isLeafColumnHeaderLineClicked(@NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn, int clickedLineIdx) {
        int leafColumnHeaderLineIdx;
        if (hierarchicalColumn == null) {
            TableResultView.$$$reportNull$$$0(52);
        }
        return (leafColumnHeaderLineIdx = hierarchicalColumn.getPathFromRoot().length - 1) == clickedLineIdx;
    }

    private void handleClickToSortColumn(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull MouseEvent e) {
        boolean supportsAdditiveSorting;
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(53);
        }
        if (e == null) {
            TableResultView.$$$reportNull$$$0(54);
        }
        if (!GridHelper.get(this.myResultPanel).isSortingApplicable(columnIdx)) {
            return;
        }
        boolean alt = e.getModifiersEx() == 512;
        DataGridSettings settings = GridUtil.getSettings(this.myResultPanel);
        GridSortingModel model2 = this.myResultPanel.getDataHookup().getSortingModel();
        boolean bl = supportsAdditiveSorting = model2 == null || !model2.isSortingEnabled() || model2.supportsAdditiveSorting();
        this.toggleSortOrder(columnIdx, supportsAdditiveSorting && (settings == null || settings.isAddToSortViaAltClick()) == alt);
    }

    private OptionalInt getIndexOfClickedHeaderLine(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull MouseEvent e) {
        ResultView resultView;
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(55);
        }
        if (e == null) {
            TableResultView.$$$reportNull$$$0(56);
        }
        if (!((resultView = this.myResultPanel.getResultView()) instanceof TableResultView)) {
            return OptionalInt.empty();
        }
        TableResultView table2 = (TableResultView)resultView;
        int viewIdx = columnIdx.toView((CoreGrid)this.myResultPanel).asInteger();
        Component headerRenderer = this.getHeaderRenderer(table2, viewIdx);
        if (!(headerRenderer instanceof MyHeaderCellComponent)) {
            return OptionalInt.empty();
        }
        MyHeaderCellComponent customHeaderComponent = (MyHeaderCellComponent)((Object)headerRenderer);
        int clickedColumnX = TableResultView.calculateClickedColumnX(table2, viewIdx);
        int columnWidth = table2.getColumnModel().getColumn(viewIdx).getWidth();
        return this.findIndexOfClickedHeaderLineWithNonEmptyLabel(e, customHeaderComponent, clickedColumnX, columnWidth);
    }

    private Component getHeaderRenderer(@NotNull TableResultView table2, int viewIdx) {
        if (table2 == null) {
            TableResultView.$$$reportNull$$$0(57);
        }
        TableColumn column = this.getColumnModel().getColumn(viewIdx);
        return table2.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)((Object)table2), column.getHeaderValue(), false, false, -1, viewIdx);
    }

    private MyHeaderCellComponent renderWithActualBounds(JTableHeader header, int columnViewIndex, TableResultViewColumn tableColumn) {
        MyHeaderCellComponent currentHeaderCell = (MyHeaderCellComponent)((Object)this.getHeaderRenderer(this, columnViewIndex));
        CellRendererPane cellRendererPane = new CellRendererPane();
        cellRendererPane.add((Component)((Object)currentHeaderCell));
        header.add(cellRendererPane);
        currentHeaderCell.setBounds(0, 0, tableColumn.getColumnWidth(), this.tableHeader.getHeight());
        currentHeaderCell.validate();
        header.remove(cellRendererPane);
        return currentHeaderCell;
    }

    private static int calculateClickedColumnX(@NotNull TableResultView table2, int viewIdx) {
        if (table2 == null) {
            TableResultView.$$$reportNull$$$0(58);
        }
        int clickedColumnX = 0;
        for (int i = 0; i < viewIdx; ++i) {
            clickedColumnX += table2.getColumnModel().getColumn(i).getWidth();
        }
        return clickedColumnX;
    }

    private OptionalInt findIndexOfClickedHeaderLineWithNonEmptyLabel(@NotNull MouseEvent e, @NotNull MyHeaderCellComponent customHeaderComponent, int clickedColumnX, int columnWidth) {
        if (e == null) {
            TableResultView.$$$reportNull$$$0(59);
        }
        if (customHeaderComponent == null) {
            TableResultView.$$$reportNull$$$0(60);
        }
        for (int idx = 0; idx < customHeaderComponent.myNameLabels.size(); ++idx) {
            JLabel nameLabel = customHeaderComponent.myNameLabels.get(idx);
            if (!TableResultView.isColumnNameLabelNotEmpty(nameLabel) || !this.isClickedWithinHeaderLine(e, clickedColumnX, columnWidth, idx)) continue;
            return OptionalInt.of(idx);
        }
        return OptionalInt.empty();
    }

    private static boolean isColumnNameLabelNotEmpty(@NotNull JLabel nameLabel) {
        String labelText;
        if (nameLabel == null) {
            TableResultView.$$$reportNull$$$0(61);
        }
        return (labelText = nameLabel.getText()) != null && !labelText.isBlank();
    }

    private boolean isClickedWithinHeaderLine(@NotNull MouseEvent e, int clickedColumnX, int columnWidth, int idx) {
        if (e == null) {
            TableResultView.$$$reportNull$$$0(62);
        }
        Rectangle bounds = this.getHeaderLineBounds(clickedColumnX, columnWidth, idx);
        return bounds.contains(e.getPoint());
    }

    private Rectangle getHeaderLineBounds(int clickedColumnX, int columnWidth, int idx) {
        Rectangle headerLineBounds = new Rectangle();
        int rowHeight = this.getRowHeight();
        headerLineBounds.setLocation(clickedColumnX, rowHeight * idx);
        headerLineBounds.height = rowHeight;
        headerLineBounds.width = columnWidth;
        return headerLineBounds;
    }

    void invokeColumnPopup(final @NotNull ModelIndex<GridColumn> columnIdx, @NotNull Component component, @NotNull Point point) {
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(63);
        }
        if (component == null) {
            TableResultView.$$$reportNull$$$0(64);
        }
        if (point == null) {
            TableResultView.$$$reportNull$$$0(65);
        }
        if (this.myColumnHeaderPopupActions != ActionGroup.EMPTY_GROUP) {
            this.myClickedHeaderColumnIdx = columnIdx;
            this.myClickedHeaderPoint = point;
            ListPopup popupMenu = JBPopupFactory.getInstance().createActionGroupPopup(null, this.myColumnHeaderPopupActions, DataManager.getInstance().getDataContext((Component)this.getComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            popupMenu.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    SwingUtilities.invokeLater(() -> {
                        if (TableResultView.this.myClickedHeaderColumnIdx.equals((Object)columnIdx)) {
                            TableResultView.this.myClickedHeaderColumnIdx = ModelIndex.forColumn((CoreGrid)TableResultView.this.myResultPanel, (int)-1);
                            TableResultView.this.myClickedHeaderPoint = null;
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/table/TableResultView$8", "onClosed"));
                }
            });
            popupMenu.show(new RelativePoint(component, point));
        }
    }

    private void selectViewColumnInterval(int viewColumn, @NotNull MouseEvent e) {
        if (e == null) {
            TableResultView.$$$reportNull$$$0(66);
        }
        boolean interval = GridUtil.isIntervalModifierSet(e);
        boolean exclusive = GridUtil.isExclusiveModifierSet(e);
        TableSelectionModel selectionModel = (TableSelectionModel)ObjectUtils.tryCast(SelectionModelUtil.get(this.myResultPanel, this), TableSelectionModel.class);
        if (selectionModel == null) {
            return;
        }
        if (interval) {
            int lead = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (exclusive) {
                selectionModel.addRowSelectionInterval(this.getRowCount() - 1, 0);
                selectionModel.addColumnSelectionInterval(viewColumn, lead);
            } else {
                selectionModel.setRowSelectionInterval(this.getRowCount() - 1, 0);
                selectionModel.setColumnSelectionInterval(viewColumn, lead);
            }
        } else if (exclusive) {
            this.removeColumnSelectionInterval(viewColumn, viewColumn);
        } else {
            selectionModel.setRowSelectionInterval(this.getRowCount() - 1, 0);
            selectionModel.setColumnSelectionInterval(viewColumn, viewColumn);
        }
    }

    @Nullable
    public ResultViewColumn getLayoutColumn(@NotNull ModelIndex<?> column) {
        if (column == null) {
            TableResultView.$$$reportNull$$$0(67);
        }
        return this.getLayoutColumn(column, column.toView((CoreGrid)this.myResultPanel));
    }

    @Nullable
    public ResultViewColumn getLayoutColumn(@NotNull ModelIndex<?> column, @NotNull ViewIndex<?> viewColumnIdx) {
        if (column == null) {
            TableResultView.$$$reportNull$$$0(68);
        }
        if (viewColumnIdx == null) {
            TableResultView.$$$reportNull$$$0(69);
        }
        return viewColumnIdx.asInteger() != -1 ? this.getColumnCache().getOrCreateColumn(column.asInteger()) : null;
    }

    @Override
    @NotNull
    public ModelIndexSet<GridRow> getVisibleRows() {
        int rowCount = this.isTransposed() ? this.getModel().getColumnCount() : this.getModel().getRowCount();
        int[] viewRowIndices = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            viewRowIndices[i] = i;
        }
        ModelIndexSet rowIndices = ViewIndexSet.forRows((CoreGrid)this.myResultPanel, (int[])viewRowIndices).toModel((CoreGrid)this.myResultPanel);
        return this.validIndexSet(rowIndices, rowIndices1 -> ModelIndexSet.forRows((CoreGrid)this.myResultPanel, (int[])rowIndices1));
    }

    @Override
    @NotNull
    public ModelIndexSet<GridColumn> getVisibleColumns() {
        int visibleColumns = this.getViewColumnCount();
        int[] viewIndices = new int[visibleColumns];
        for (int i = 0; i < visibleColumns; ++i) {
            viewIndices[i] = i;
        }
        ModelIndexSet columnIndices = ViewIndexSet.forColumns((CoreGrid)this.myResultPanel, (int[])viewIndices).toModel((CoreGrid)this.myResultPanel);
        return this.validIndexSet(columnIndices, columnIndices1 -> ModelIndexSet.forColumns((CoreGrid)this.myResultPanel, (int[])columnIndices1));
    }

    @Override
    public int getViewColumnCount() {
        return this.isTransposed() ? this.getRowCount() : this.getColumnCount();
    }

    @Override
    public int getViewRowCount() {
        return this.isTransposed() ? this.getColumnCount() : this.getRowCount();
    }

    @NotNull
    private <T> ModelIndexSet<T> validIndexSet(@NotNull ModelIndexSet<T> indexSet, @NotNull Function<int[], ModelIndexSet<T>> factory) {
        if (indexSet == null) {
            TableResultView.$$$reportNull$$$0(70);
        }
        if (factory == null) {
            TableResultView.$$$reportNull$$$0(71);
        }
        IntArrayList validIndices = new IntArrayList(indexSet.size());
        for (ModelIndex idx : indexSet.asIterable()) {
            if (!idx.isValid((CoreGrid)this.myResultPanel)) continue;
            validIndices.add(idx.asInteger());
        }
        ModelIndexSet modelIndexSet = (ModelIndexSet)factory.fun((Object)validIndices.toIntArray());
        if (modelIndexSet == null) {
            TableResultView.$$$reportNull$$$0(72);
        }
        return modelIndexSet;
    }

    @Override
    public boolean stopEditing() {
        int[] nArray;
        int[] nArray2;
        TableCellEditor editor = this.getCellEditor();
        if (editor == null) {
            return true;
        }
        if (!this.isMultiEditingAllowed()) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = this.getEditingColumn();
        } else {
            nArray2 = this.getSelectedColumns();
        }
        int[] columnDataIdx = Arrays.stream(nArray2).map(arg_0 -> this.convertColumnIndexToModel(arg_0)).toArray();
        if (!this.isMultiEditingAllowed()) {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = this.getEditingRow();
        } else {
            nArray = this.getSelectedRows();
        }
        int[] rowDataIdx = Arrays.stream(nArray).map(arg_0 -> this.convertRowIndexToModel(arg_0)).toArray();
        ModelIndexSet myEditingRowIdx = ModelIndexSet.forRows((CoreGrid)this.myResultPanel, (int[])(this.isTransposed() ? columnDataIdx : rowDataIdx));
        ModelIndexSet myEditingColumnIdx = ModelIndexSet.forColumns((CoreGrid)this.myResultPanel, (int[])(this.isTransposed() ? rowDataIdx : columnDataIdx));
        return this.myResultPanel.isSafeToUpdate((ModelIndexSet<GridRow>)myEditingRowIdx, (ModelIndexSet<GridColumn>)myEditingColumnIdx, editor.getCellEditorValue()) && editor.stopCellEditing();
    }

    @Override
    public void cancelEditing() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    @Override
    public boolean isCellEditingAllowed() {
        return true;
    }

    @Override
    public void editSelectedCell() {
        int leadRow = this.getSelectionModel().getLeadSelectionIndex();
        int leadColumn = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (leadRow == -1 || leadColumn == -1) {
            return;
        }
        TableUtil.editCellAt((JTable)((Object)this), (int)leadRow, (int)leadColumn);
    }

    @Override
    public boolean isMultiEditingAllowed() {
        int[] selectedColumns = this.isTransposed() ? this.getSelectedRows() : this.getSelectedColumns();
        int[] selectedRows = this.isTransposed() ? this.getSelectedColumns() : this.getSelectedRows();
        ModelIndexSet indexSet = ViewIndexSet.forColumns((CoreGrid)this.myResultPanel, (int[])selectedColumns).toModel((CoreGrid)this.myResultPanel);
        List columns = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumns(indexSet);
        GridColumn uniqueColumn = GridHelper.get(this.myResultPanel).findUniqueColumn(this.myResultPanel, columns);
        return this.myCommonValue != null && (uniqueColumn == null || selectedRows.length == 1) && GridHelper.get(this.myResultPanel).canEditTogether(this.myResultPanel, columns);
    }

    void toggleSortOrder(@NotNull ModelIndex<GridColumn> idx, boolean additive) {
        if (idx == null) {
            TableResultView.$$$reportNull$$$0(73);
        }
        this.myResultPanel.getAutoscrollLocker().runWithLock(() -> this.myResultPanel.toggleSortColumns(Collections.singletonList(idx), additive));
    }

    protected TableRowSorter<TableModel> createRowSorter(TableModel model2) {
        final GridTableModel m = this.getModel();
        return new TableRowSorter<TableModel>((TableModel)m){
            {
                super(arg0);
                this.setModelWrapper(new DefaultRowSorter.ModelWrapper<TableModel, Integer>(){

                    @Override
                    public TableModel getModel() {
                        return m;
                    }

                    @Override
                    public int getColumnCount() {
                        return m.getColumnCount();
                    }

                    @Override
                    public int getRowCount() {
                        return m.getRowCount();
                    }

                    @Override
                    public Object getValueAt(int row, int column) {
                        return TableResultView.this.getRow(row);
                    }

                    @Override
                    public Integer getIdentifier(int row) {
                        return row;
                    }
                });
            }

            @Override
            public void toggleSortOrder(int columnDataIdx) {
            }

            @Override
            protected boolean useToString(int column) {
                return false;
            }

            @Override
            public Comparator<?> getComparator(int modelColumnIdx) {
                Comparator<?> comparator = null;
                if (!TableResultView.this.isTransposed()) {
                    comparator = TableResultView.this.myResultPanel.getComparator((ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)TableResultView.this.myResultPanel, (int)modelColumnIdx));
                }
                return comparator != null ? comparator : super.getComparator(modelColumnIdx);
            }

            @Override
            public boolean isSortable(int columnDataIdx) {
                return !TableResultView.this.isTransposed() && TableResultView.this.myResultPanel.getComparator((ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)TableResultView.this.myResultPanel, (int)columnDataIdx)) != null;
            }
        };
    }

    public TableCellEditor getCellEditor(int row, int column) {
        ModelIndex rowIdx = ViewIndex.forRow((CoreGrid)this.myResultPanel, (int)(this.isTransposed() ? column : row)).toModel((CoreGrid)this.myResultPanel);
        ModelIndex columnIdx = ViewIndex.forColumn((CoreGrid)this.myResultPanel, (int)(this.isTransposed() ? row : column)).toModel((CoreGrid)this.myResultPanel);
        GridCellEditorFactoryProvider factoryProvider = GridCellEditorFactoryProvider.get(this.myResultPanel);
        GridCellEditorFactory editorFactory = factoryProvider == null ? null : factoryProvider.getEditorFactory(this.myResultPanel, (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx);
        GridColumn dataColumn = (GridColumn)this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        return dataColumn != null && !GridUtilCore.isRowId((GridColumn)dataColumn) && editorFactory != null ? new GridTableCellEditor(this.myResultPanel, (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx, editorFactory) : null;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer2 = this.myRenderers.getRenderer(row, column);
        return this.myCellImageCache.wrapCellRenderer(renderer2);
    }

    public void setValueAt(Object value, int viewRowIdx, int viewColumnIdx) {
        this.setValueAt(value, viewRowIdx, viewColumnIdx, true, new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.myResultPanel)));
    }

    private void setValueAt(Object value, int viewRowIdx, int viewColumnIdx, boolean allowImmediateUpdate, @NotNull GridRequestSource source) {
        int[] nArray;
        int[] nArray2;
        boolean allowed;
        if (source == null) {
            TableResultView.$$$reportNull$$$0(74);
        }
        if (allowed = this.isMultiEditingAllowed()) {
            nArray2 = this.getSelectedRows();
        } else {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = viewRowIdx;
        }
        int[] rows = nArray2;
        if (allowed) {
            nArray = this.getSelectedColumns();
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = viewColumnIdx;
        }
        int[] columns = nArray;
        ViewIndexSet rowsSet = ViewIndexSet.forRows((CoreGrid)this.myResultPanel, (int[])(this.isTransposed() ? columns : rows));
        ViewIndexSet columnsSet = ViewIndexSet.forColumns((CoreGrid)this.myResultPanel, (int[])(this.isTransposed() ? rows : columns));
        GridTableCellEditor editor = (GridTableCellEditor)((Object)ObjectUtils.tryCast((Object)this.getCellEditor(), GridTableCellEditor.class));
        Runnable moveToNextCellRunnable = editor != null && editor.shouldMoveFocus() ? () -> IdeFocusManager.findInstanceByComponent((Component)((Object)this)).doWhenFocusSettlesDown(() -> ApplicationManager.getApplication().invokeLater(() -> this.moveToNextCell((ViewIndex<GridRow>)((ViewIndex)rowsSet.last()), (ViewIndex<GridColumn>)((ViewIndex)columnsSet.last())))) : null;
        this.myResultPanel.setValueAt((ModelIndexSet<GridRow>)rowsSet.toModel((CoreGrid)this.myResultPanel), (ModelIndexSet<GridColumn>)columnsSet.toModel((CoreGrid)this.myResultPanel), value, allowImmediateUpdate, moveToNextCellRunnable, source);
    }

    private void moveToNextCell(@NotNull ViewIndex<GridRow> rowIndex, @NotNull ViewIndex<GridColumn> colIndex) {
        SelectionModel selectionModel;
        if (rowIndex == null) {
            TableResultView.$$$reportNull$$$0(75);
        }
        if (colIndex == null) {
            TableResultView.$$$reportNull$$$0(76);
        }
        if ((selectionModel = this.myResultPanel.getSelectionModel()).getSelectedRowCount() != 1 || selectionModel.getSelectedColumnCount() != 1 || !ApplicationManager.getApplication().isUnitTestMode() && (!UIUtil.isFocusAncestor((Component)((Object)this)) || this.isEditing())) {
            return;
        }
        if (!Comparing.equal((Object)selectionModel.getSelectedRow(), (Object)rowIndex.toModel((CoreGrid)this.myResultPanel)) || !Comparing.equal((Object)selectionModel.getSelectedColumn(), (Object)colIndex.toModel((CoreGrid)this.myResultPanel))) {
            return;
        }
        if (GridUtil.isInsertedRow(this.myResultPanel, (ModelIndex<GridRow>)rowIndex.toModel((CoreGrid)this.myResultPanel))) {
            ViewIndex<GridColumn> nextColumn = ViewIndex.forColumn((CoreGrid)this.myResultPanel, (int)(colIndex.asInteger() + 1));
            colIndex = nextColumn.isValid((CoreGrid)this.myResultPanel) ? nextColumn : colIndex;
        } else {
            ViewIndex<GridRow> nextRow = ViewIndex.forRow((CoreGrid)this.myResultPanel, (int)(rowIndex.asInteger() + 1));
            rowIndex = nextRow.isValid((CoreGrid)this.myResultPanel) ? nextRow : rowIndex;
        }
        GridUtil.scrollToLocally(this.myResultPanel, rowIndex, colIndex);
    }

    private Font doGetFont() {
        return this.getScaledFont(this.getColorsScheme().getFont(EditorFontType.PLAIN));
    }

    private Font getScaledFont(Font font) {
        return UISettings.getInstance().getPresentationMode() ? font : (font == null ? null : font.deriveFont((float)this.fontSize(this.myFontSizeIncrement, this.myFontSizeScale)));
    }

    private int doGetRowHeight() {
        return this.getTextLineHeight() + this.getRowMargin() + (this.isStriped() || !this.showHorizontalLines ? 1 : 0);
    }

    public static Rectangle getLabelTextRect(JLabel label) {
        Dimension pref = label.getPreferredSize();
        Rectangle bounds = label.getBounds();
        Insets insets = label.getInsets();
        int w = Math.min(pref.width, bounds.width);
        bounds.setSize(w - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
        bounds.translate(insets.left, insets.top);
        return bounds;
    }

    @Nullable
    private GridRow getRow(int modelRowIdx) {
        return (GridRow)this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(ModelIndex.forRow((CoreGrid)this.myResultPanel, (int)modelRowIdx));
    }

    @Nullable
    private GridColumn getColumn(int modelColumnIdx) {
        return (GridColumn)this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(ModelIndex.forColumn((CoreGrid)this.myResultPanel, (int)modelColumnIdx));
    }

    @NotNull
    public static Icon getSortOrderIcon(int sortOrder) {
        Icon icon = sortOrder < 0 ? AllIcons.General.ArrowUp : (sortOrder > 0 ? AllIcons.General.ArrowDown : AllIcons.General.ArrowSplitCenterV);
        if (icon == null) {
            TableResultView.$$$reportNull$$$0(77);
        }
        return icon;
    }

    @NotNull
    private ActionCallback layoutColumns() {
        ActionCallback callback = new ActionCallback();
        SwingUtilities.invokeLater(() -> {
            if (SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && this.myColumnLayout.resetLayout()) {
                callback.setDone();
            }
        });
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            TableResultView.$$$reportNull$$$0(78);
        }
        return actionCallback;
    }

    @NlsSafe
    public static String getSortOrderText(int sortOrder) {
        return sortOrder != 0 ? String.valueOf(Math.abs(sortOrder)) : "";
    }

    @Nullable
    protected Color getHoveredRowBackground() {
        return this.myResultPanel.getHoveredRowBackground();
    }

    @Override
    public void resetScroll() {
        this.getHorizontalScrollBar().setValue(0);
        this.getVerticalScrollBar().setValue(0);
    }

    @Override
    public boolean isHoveredRowBgHighlightingEnabled() {
        if (this.isStriped()) {
            return false;
        }
        return switch (this.myHoveredRowMode) {
            default -> throw new IncompatibleClassChangeError();
            case ResultView.HoveredRowBgHighlightMode.AUTO -> ResultView.super.isHoveredRowBgHighlightingEnabled();
            case ResultView.HoveredRowBgHighlightMode.HIGHLIGHT -> true;
            case ResultView.HoveredRowBgHighlightMode.NOT_HIGHLIGHT -> false;
        };
    }

    @Override
    public void setHoveredRowHighlightMode(ResultView.HoveredRowBgHighlightMode mode) {
        this.myHoveredRowMode = mode;
    }

    public void setStatisticsHeader(StatisticsTableHeader statisticsHeader) {
        this.myStatisticsHeader = statisticsHeader;
    }

    public StatisticsTableHeader getStatisticsHeader() {
        return this.myStatisticsHeader;
    }

    public void setStatisticsPanelMode(StatisticsPanelMode panelMode) {
        if (this.myStatisticsHeader != null) {
            this.myStatisticsHeader.setStatisticsPanelMode(panelMode);
        }
        this.myColumnLayout.resetLayout();
    }

    public StatisticsPanelMode getStatisticsPanelMode() {
        if (this.myStatisticsHeader != null) {
            return this.myStatisticsHeader.getStatisticsPanelMode();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10, 11, 13, 14, 19, 20, 21, 22, 32, 35, 37, 40, 72, 77, 78 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnHeaderPopupActions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowHeaderPopupActions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 72: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TableResultView";
                break;
            }
            case 5: 
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 7: 
            case 39: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRow";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewColumn";
                break;
            }
            case 17: 
            case 26: 
            case 28: 
            case 30: 
            case 45: 
            case 47: 
            case 49: 
            case 53: 
            case 55: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchSession";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRect";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 44: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 46: 
            case 48: 
            case 50: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchicalColumn";
                break;
            }
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHeaderComponent";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameLabel";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewColumnIdx";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSet";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndex";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TableResultView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerticalScrollBar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHorizontalScrollBar";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "uiColumn";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextColumn";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSortKeys";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIndexConverter";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFilterState";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRenderer";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellForeground";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "validIndexSet";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrderIcon";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 72: 
            case 77: 
            case 78: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addColumnHeaderBackgroundChangedListener";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionChangedListener";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCellRendererComponent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setColumnEnabled";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setRowEnabled";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListenerToComponents";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStarted";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "paintComponent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "contentLanguageUpdated";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "displayTypeUpdated";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getToolTipText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenderer";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getCellBackground";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getScrollableUnitIncrement";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "invokeRowPopup";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "onColumnHeaderClicked";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "handleClickOnColumnHeader";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "handleClickOnHierarchicalColumnHeader";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isLeafColumnHeaderLineClicked";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "handleClickToSortColumn";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfClickedHeaderLine";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderRenderer";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "calculateClickedColumnX";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findIndexOfClickedHeaderLineWithNonEmptyLabel";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isColumnNameLabelNotEmpty";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isClickedWithinHeaderLine";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "invokeColumnPopup";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "selectViewColumnInterval";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutColumn";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "validIndexSet";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "toggleSortOrder";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "moveToNextCell";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10, 11, 13, 14, 19, 20, 21, 22, 32, 35, 37, 40, 72, 77, 78 -> new IllegalStateException(string);
        };
    }

    static class MyTableColumnModel
    extends DefaultTableColumnModel {
        MyTableColumnModel() {
        }

        @Override
        public void addColumn(TableColumn aColumn) {
            if (!(aColumn instanceof TableResultViewColumn)) {
                throw new IllegalArgumentException("Unexpected column type");
            }
            super.addColumn(aColumn);
        }

        @Override
        public TableResultViewColumn getColumn(int columnIndex) {
            return (TableResultViewColumn)super.getColumn(columnIndex);
        }

        public void removeAllColumns() {
            int columnCount = this.tableColumns.size();
            if (columnCount == 0) {
                return;
            }
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(0, columnCount - 1);
            }
            for (TableColumn column : this.tableColumns) {
                column.removePropertyChangeListener(this);
            }
            this.totalColumnWidth = -1;
            for (int i = columnCount - 1; i >= 0; --i) {
                this.tableColumns.remove(i);
                this.fireColumnRemoved(new TableColumnModelEvent(this, i, 0));
            }
        }
    }

    public class MyTableColumnCache
    implements Iterable<TableResultViewColumn> {
        private final Int2ObjectMap<Entry> myColumnDataIndicesToEntries = new Int2ObjectOpenHashMap();

        public boolean hasCachedColumn(int columnDataIdx) {
            boolean isCached = this.hasValidEntry(columnDataIdx);
            if (!isCached) {
                this.myColumnDataIndicesToEntries.remove(columnDataIdx);
                return false;
            }
            return true;
        }

        public TableResultViewColumn getOrCreateColumn(int columnDataIdx) {
            Entry e = (Entry)this.myColumnDataIndicesToEntries.get(columnDataIdx);
            if (!this.hasCachedColumn(columnDataIdx) || e == null) {
                e = this.createEntry(columnDataIdx);
                this.myColumnDataIndicesToEntries.put(columnDataIdx, (Object)e);
            }
            return e.myTableColumn;
        }

        @NotNull
        private Entry createEntry(int columnDataIdx) {
            TableResultViewColumn tableColumn = TableResultView.this.getModel().createColumn(columnDataIdx);
            Object columnData = this.getColumnData(columnDataIdx);
            return new Entry(Objects.requireNonNull(columnData), tableColumn);
        }

        public void retainColumns(Collection<? extends GridColumn> columnsToRetain) {
            this.myColumnDataIndicesToEntries.values().removeIf(entry -> !columnsToRetain.contains(entry.myColumnData));
        }

        @Override
        public Iterator<TableResultViewColumn> iterator() {
            return this.myColumnDataIndicesToEntries.values().stream().map(entry -> entry.myTableColumn).iterator();
        }

        private boolean hasValidEntry(int columnDataIdx) {
            Entry e = (Entry)this.myColumnDataIndicesToEntries.get(columnDataIdx);
            if (e == null) {
                return false;
            }
            Object cachedColumnData = e.myColumnData;
            Object currentColumnData = this.getColumnData(columnDataIdx);
            if (Comparing.equal((Object)cachedColumnData, (Object)currentColumnData)) {
                return true;
            }
            if (cachedColumnData instanceof GridRow) {
                GridRow cachedRow = (GridRow)cachedColumnData;
                if (currentColumnData instanceof GridRow) {
                    GridRow currentRow = (GridRow)currentColumnData;
                    if (cachedRow.getRowNum() == currentRow.getRowNum() && cachedRow.getSize() == currentRow.getSize()) {
                        int mismatchedValuesCount = 0;
                        for (int i = 0; i < cachedRow.getSize(); ++i) {
                            if (Comparing.equal((Object)cachedRow.getValue(i), (Object)currentRow.getValue(i))) continue;
                            ++mismatchedValuesCount;
                        }
                        if (mismatchedValuesCount < 2) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private Object getColumnData(int columnDataIdx) {
            return TableResultView.this.isTransposed() ? TableResultView.this.getRow(columnDataIdx) : TableResultView.this.getColumn(columnDataIdx);
        }

        private static final class Entry {
            @NotNull
            public final Object myColumnData;
            @NotNull
            public final TableResultViewColumn myTableColumn;

            Entry(@NotNull Object columnData, @NotNull TableResultViewColumn tableColumn) {
                if (columnData == null) {
                    Entry.$$$reportNull$$$0(0);
                }
                if (tableColumn == null) {
                    Entry.$$$reportNull$$$0(1);
                }
                this.myColumnData = columnData;
                this.myTableColumn = tableColumn;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "columnData";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tableColumn";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/ui/table/TableResultView$MyTableColumnCache$Entry";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class Renderers {
        private final DataGrid myGrid;
        final TableResultView myResultView;
        final Map<GridCellRenderer, TableCellRenderer> myTableCellRenderers = new Reference2ObjectOpenHashMap();

        Renderers(DataGrid grid, TableResultView resultView) {
            this.myGrid = grid;
            this.myResultView = resultView;
        }

        @NotNull
        public TableCellRenderer getRenderer(int row, int column) {
            ModelIndex columnIdx;
            ModelIndex rowIdx = ViewIndex.forRow((CoreGrid)this.myGrid, (int)(this.myResultView.isTransposed() ? column : row)).toModel((CoreGrid)this.myGrid);
            GridCellRenderer gridCellRenderer = GridCellRenderer.getRenderer(this.myGrid, (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)(columnIdx = ViewIndex.forColumn((CoreGrid)this.myGrid, (int)(this.myResultView.isTransposed() ? row : column)).toModel((CoreGrid)this.myGrid)));
            TableCellRenderer renderer2 = this.myTableCellRenderers.get(gridCellRenderer);
            if (renderer2 == null) {
                renderer2 = new GridCellRendererWrapper(gridCellRenderer, this.myResultView);
                this.myTableCellRenderers.put(gridCellRenderer, renderer2);
            }
            TableCellRenderer tableCellRenderer = renderer2;
            if (tableCellRenderer == null) {
                Renderers.$$$reportNull$$$0(0);
            }
            return tableCellRenderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/table/TableResultView$Renderers", "getRenderer"));
        }
    }

    public static class MyCellRenderer
    extends MyHeaderCellComponent
    implements TableCellRenderer {
        private final TableCellRenderer myOriginalRenderer;

        public MyCellRenderer(@NotNull TableResultView table2) {
            if (table2 == null) {
                MyCellRenderer.$$$reportNull$$$0(0);
            }
            super(table2);
            this.myOriginalRenderer = table2.getTableHeader().getDefaultRenderer();
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table2 == null) {
                MyCellRenderer.$$$reportNull$$$0(1);
            }
            Component component = row == -1 ? this.getHeaderCellRendererComponent(table2.convertColumnIndexToModel(column), true) : this.myOriginalRenderer.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            if (component == null) {
                MyCellRenderer.$$$reportNull$$$0(2);
            }
            return component;
        }

        public Component getHeaderCellRendererComponent(int columnDataIdx, boolean forDisplay) {
            GridModel model2 = this.myTable.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            HierarchicalReader reader = model2.getHierarchicalReader();
            return this.prepare(columnDataIdx, forDisplay, reader == null ? 1 : reader.getDepthOfHierarchy());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/table/TableResultView$MyCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/table/TableResultView$MyCellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableCellRendererComponent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class PaintingSession {
        private Font myFont;
        private Color myGridColor;
        private Color myForeground;
        private Color myBackground;
        private Color mySelectionForeground;
        private Color mySelectionBackground;
        private int myRowHeight = -1;

        private PaintingSession() {
        }

        public Font getFont() {
            return this.myFont != null ? this.myFont : (this.myFont = TableResultView.this.doGetFont());
        }

        public int getRowHeight() {
            return this.myRowHeight != -1 ? this.myRowHeight : (this.myRowHeight = TableResultView.this.doGetRowHeight());
        }

        public Color getGridColor() {
            return this.myGridColor != null ? this.myGridColor : (this.myGridColor = GridColorSchemeUtil.doGetGridColor(TableResultView.this.getColorsScheme()));
        }

        public Color getForeground() {
            return this.myForeground != null ? this.myForeground : (this.myForeground = GridColorSchemeUtil.doGetForeground(TableResultView.this.getColorsScheme()));
        }

        public Color getBackground() {
            return this.myBackground != null ? this.myBackground : (this.myBackground = GridColorSchemeUtil.doGetBackground(TableResultView.this.getColorsScheme()));
        }

        public Color getSelectionForeground() {
            return this.mySelectionForeground != null ? this.mySelectionForeground : (this.mySelectionForeground = GridColorSchemeUtil.doGetSelectionForeground(TableResultView.this.getColorsScheme()));
        }

        public Color getSelectionBackground() {
            return this.mySelectionBackground != null ? this.mySelectionBackground : (this.mySelectionBackground = GridColorSchemeUtil.doGetSelectionBackground(TableResultView.this.getColorsScheme()));
        }
    }

    private static final class GridCellRendererWrapper
    implements TableCellRenderer {
        final GridCellRenderer delegate;
        final TableResultView myResultView;

        private GridCellRendererWrapper(GridCellRenderer renderer2, TableResultView resultView) {
            this.delegate = renderer2;
            this.myResultView = resultView;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DataGrid grid = this.delegate.myGrid;
            ViewIndex rowIdx = ViewIndex.forRow((CoreGrid)grid, (int)(this.myResultView.isTransposed() ? column : row));
            ViewIndex columnIdx = ViewIndex.forColumn((CoreGrid)grid, (int)(this.myResultView.isTransposed() ? row : column));
            return this.delegate.getComponent((ViewIndex<GridRow>)rowIdx, (ViewIndex<GridColumn>)columnIdx, value);
        }
    }

    protected class MyTableHeader
    extends JBTable.JBTableHeader {
        private int myLastPositiveHeight;
        @Nullable
        private ModelIndex<GridColumn> hoveredFilterLabelIdx;

        protected MyTableHeader() {
            super((JBTable)TableResultView.this);
            this.myLastPositiveHeight = 0;
            this.hoveredFilterLabelIdx = null;
            this.setOpaque(false);
            this.setFocusable(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.processEvent(e);
                }

                @Override
                public void mousePressed(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.processEvent(e);
                }

                @Override
                public void mouseReleased(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    this.processEvent(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (TableResultView.this.isTransposed()) {
                        return;
                    }
                    if (MyTableHeader.this.hoveredFilterLabelIdx != null) {
                        MyTableHeader.this.hoveredFilterLabelIdx = null;
                        MyTableHeader.this.repaint();
                    }
                }

                private void processEvent(MouseEvent e) {
                    if (TableResultView.this.isTransposed()) {
                        int modelRow = TableResultView.this.myRawIndexConverter.row2Model().applyAsInt(MyTableHeader.this.columnAtPoint(e.getPoint()));
                        if (modelRow >= 0) {
                            TableResultView.this.onRowHeaderClicked((ModelIndex<GridRow>)ModelIndex.forRow((CoreGrid)TableResultView.this.myResultPanel, (int)modelRow), e);
                        }
                    } else {
                        int modelColumn = TableResultView.this.myRawIndexConverter.column2Model().applyAsInt(MyTableHeader.this.columnAtPoint(e.getPoint()));
                        if (modelColumn >= 0) {
                            TableResultView.this.onColumnHeaderClicked((ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)TableResultView.this.myResultPanel, (int)modelColumn), e);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/database/run/ui/table/TableResultView$MyTableHeader$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseClicked";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mousePressed";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseReleased";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (TableResultView.this.isTransposed()) {
                        return;
                    }
                    int modelColumn = TableResultView.this.myRawIndexConverter.column2Model().applyAsInt(MyTableHeader.this.columnAtPoint(e.getPoint()));
                    if (modelColumn >= 0) {
                        MyTableHeader.this.onColumnHeaderMouseMoved((ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)TableResultView.this.myResultPanel, (int)modelColumn), e);
                    }
                }
            });
        }

        private void onColumnHeaderMouseMoved(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull MouseEvent e) {
            if (columnIdx == null) {
                MyTableHeader.$$$reportNull$$$0(0);
            }
            if (e == null) {
                MyTableHeader.$$$reportNull$$$0(1);
            }
            int currentViewIdx = columnIdx.toView((CoreGrid)TableResultView.this.myResultPanel).value;
            TableResultViewColumn tableColumn = ((MyTableColumnModel)this.columnModel).getColumn(currentViewIdx);
            int offsetX = TableResultView.calculateClickedColumnX(TableResultView.this, currentViewIdx);
            MyHeaderCellComponent currentHeader = TableResultView.this.renderWithActualBounds(TableResultView.this.tableHeader, currentViewIdx, tableColumn);
            Point point = e.getPoint();
            Point relativePoint = new Point(point.x - offsetX, point.y);
            JLabel filterLabel = currentHeader.filterLabel;
            ModelIndex<GridColumn> previous = this.hoveredFilterLabelIdx;
            this.hoveredFilterLabelIdx = filterLabel.getBounds().contains(relativePoint) ? columnIdx : null;
            if (!Objects.equals(previous, this.hoveredFilterLabelIdx)) {
                TableResultView.this.tableHeader.repaint();
            }
        }

        public boolean getReorderingAllowed() {
            if (TableResultView.this.isTransposed() || TableResultView.this.isEditingBlocked()) {
                return false;
            }
            List columns = TableResultView.this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumns();
            return !ContainerUtil.exists((Iterable)columns, c -> {
                HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn;
                return c instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn && !(hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)c).isTopLevelColumn();
            });
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (!this.isPreferredSizeSet() && d.height > 0 && TableResultView.this.myAllowMultilineColumnLabel) {
                int maxHeight = d.height;
                for (int idx = 0; idx < this.columnModel.getColumnCount(); ++idx) {
                    Component comp = this.getHeaderRenderer(idx);
                    int rendererHeight = comp.getPreferredSize().height;
                    maxHeight = Math.max(maxHeight, rendererHeight);
                }
                d.height = maxHeight;
            } else if (d.height <= 0) {
                d.height = this.myLastPositiveHeight;
            }
            return d;
        }

        private Component getHeaderRenderer(int idx) {
            TableColumn column = this.columnModel.getColumn(idx);
            TableCellRenderer renderer2 = column.getHeaderRenderer();
            if (renderer2 == null) {
                renderer2 = this.getDefaultRenderer();
            }
            return renderer2.getTableCellRendererComponent(this.getTable(), column.getHeaderValue(), false, false, -1, idx);
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
            if (height > 0) {
                this.myLastPositiveHeight = height;
            }
        }

        public void paint(@NotNull Graphics g) {
            if (g == null) {
                MyTableHeader.$$$reportNull$$$0(2);
            }
            Rectangle clip = g.getClipBounds();
            clip.width = Math.max(0, Math.min(clip.width, this.getTable().getWidth() - clip.x));
            g.setClip(clip);
            super.paint(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/table/TableResultView$MyTableHeader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onColumnHeaderMouseMoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTransposedViewColumnFilter
    extends RowFilter<TableModel, Integer> {
        final DataGrid myGrid;

        MyTransposedViewColumnFilter(@NotNull DataGrid grid) {
            if (grid == null) {
                MyTransposedViewColumnFilter.$$$reportNull$$$0(0);
            }
            this.myGrid = grid;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            ModelIndex column = ModelIndex.forColumn((CoreGrid)this.myGrid, (int)entry.getIdentifier());
            return column.isValid((CoreGrid)this.myGrid) && this.myGrid.isColumnEnabled(column);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/table/TableResultView$MyTransposedViewColumnFilter", "<init>"));
        }
    }

    private static class MySearchRowFilter
    extends RowFilter<TableModel, Integer> {
        private final DataGrid myGrid;
        private final LocalFilterState myLocalFilterState;

        MySearchRowFilter(@NotNull DataGrid grid, @NotNull LocalFilterState state) {
            if (grid == null) {
                MySearchRowFilter.$$$reportNull$$$0(0);
            }
            if (state == null) {
                MySearchRowFilter.$$$reportNull$$$0(1);
            }
            this.myGrid = grid;
            this.myLocalFilterState = state;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            ModelIndex row = ModelIndex.forRow((CoreGrid)this.myGrid, (int)entry.getIdentifier());
            if (!this.myLocalFilterState.include(this.myGrid, (ModelIndex<GridRow>)row, null)) {
                return false;
            }
            GridSearchSession searchSession = (GridSearchSession)ObjectUtils.tryCast((Object)this.myGrid.getSearchSession(), GridSearchSession.class);
            if (searchSession == null || !searchSession.isFilteringEnabled() || StringUtil.isEmpty((String)searchSession.getFindModel().getStringToFind())) {
                return true;
            }
            return !this.myGrid.getVisibleColumns().asIterable().filter(column -> searchSession.isMatchedCell(row, column)).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/table/TableResultView$MySearchRowFilter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MyHeaderCellComponent
    extends CellRendererPanel {
        private static final String HEADER_PLACEHOLDER = "    ";
        protected final TableResultView myTable;
        private final List<JLabel> myNameLabels;
        private final JPanel myCompositeLabel;
        private final List<JLabel> myIconLabels;
        private JLabel filterLabel;
        private final Icon filterIconEnabled;
        private final List<JPanel> myHeaderLinePanels;
        private TableResultViewColumn myCurrentColumn;
        private boolean isInitialized;

        public MyHeaderCellComponent(@NotNull TableResultView table2) {
            if (table2 == null) {
                MyHeaderCellComponent.$$$reportNull$$$0(0);
            }
            this.filterIconEnabled = new BadgeIcon(AllIcons.General.Filter, (Paint)JBUI.CurrentTheme.IconBadge.SUCCESS);
            this.isInitialized = false;
            this.myTable = table2;
            this.myCompositeLabel = new JPanel();
            this.myCompositeLabel.setLayout(new BoxLayout(this.myCompositeLabel, 1));
            this.myNameLabels = new ArrayList<JLabel>();
            this.myIconLabels = new ArrayList<JLabel>();
            this.myHeaderLinePanels = new ArrayList<JPanel>();
            this.setLayout(new BorderLayout());
            this.add(this.myCompositeLabel, "Center");
        }

        protected void paintComponent(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            this.setSelected(true);
            super.paintComponent(g);
        }

        protected Rectangle getNameRect() {
            return TableResultView.getLabelTextRect(this.myNameLabels.get(0));
        }

        protected int getModelIdx() {
            return this.myCurrentColumn.getModelIndex();
        }

        public MyHeaderCellComponent prepare(int columnDataIdx, boolean forDisplay, int headerLineNum) {
            this.myCurrentColumn = this.myTable.getColumnCache().getOrCreateColumn(columnDataIdx);
            if (!this.isInitialized) {
                this.initializeLabelsForEachHeaderLine(headerLineNum);
                this.isInitialized = true;
            }
            MyHeaderCellComponent.resetLabelsValues(this.myNameLabels);
            MyHeaderCellComponent.resetLabelsValues(this.myIconLabels);
            this.resetHeaderLinesBg();
            this.setBorder(null);
            List<String> headerLineValues = this.myCurrentColumn.getMultilineHeaderValues();
            if (headerLineValues.size() > this.myNameLabels.size()) {
                this.clearAllLabelsAndPanels();
                this.initializeLabelsForEachHeaderLine(headerLineValues.size());
            }
            if (headerLineValues.isEmpty()) {
                return this;
            }
            GridColumn column = this.myTable.getColumn(columnDataIdx);
            boolean isHierarchicalColumn = column instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn;
            if (isHierarchicalColumn) {
                HierarchicalColumnsCollapseManager collapseManager = this.myTable.myResultPanel.getHierarchicalColumnsCollapseManager();
                boolean isCollapsedSubtree = collapseManager != null && collapseManager.isColumnCollapsedSubtree(column);
                for (int i = 0; i < this.myHeaderLinePanels.size(); ++i) {
                    if (isCollapsedSubtree) {
                        this.prepareHeaderLineForCollapsedColumn(i, headerLineValues, forDisplay);
                    } else {
                        this.prepareHeaderLineForExpandedColumn(i, headerLineValues, (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)column, forDisplay);
                    }
                    this.myHeaderLinePanels.get(i).setBackground(this.getHeaderCellBackground(i));
                }
            } else {
                this.setValueForLastNonEmptyHeaderLine(this.myCurrentColumn.getHeaderValue().trim(), 0, columnDataIdx, forDisplay);
                this.setBorder(IdeBorderFactory.createBorder((int)4));
            }
            this.myCompositeLabel.revalidate();
            return this;
        }

        private void clearAllLabelsAndPanels() {
            this.myCompositeLabel.removeAll();
            this.myIconLabels.clear();
            this.myNameLabels.clear();
            this.myHeaderLinePanels.clear();
        }

        private void prepareHeaderLineForCollapsedColumn(int headerLineIdx, List<String> headerLineValues, boolean forDisplay) {
            this.setHeaderLineContentForCollapsedColumn(headerLineIdx, headerLineValues, forDisplay);
            this.setHeaderLineBorderForCollapsedColumn(headerLineIdx, headerLineValues);
        }

        private void setHeaderLineContentForCollapsedColumn(int headerLineIdx, List<String> headerLineValues, boolean forDisplay) {
            boolean isLeafColumnName = headerLineIdx == headerLineValues.size() - 1;
            boolean isResidualLine = headerLineIdx >= headerLineValues.size();
            this.setPlaceholderIntoHeaderLine(headerLineIdx);
            if (!isLeafColumnName && !isResidualLine) {
                String headerLineValue = headerLineValues.get(headerLineIdx);
                this.setHeaderLineValueExceptLast(headerLineValue, headerLineIdx, forDisplay);
                if (!headerLineValue.isBlank()) {
                    this.myIconLabels.get(headerLineIdx).setIcon(forDisplay ? AllIcons.Actions.ArrowExpand : null);
                }
            }
        }

        private void setHeaderLineBorderForCollapsedColumn(int headerLineIdx, List<String> headerLineValues) {
            boolean isLeafColumnName = headerLineIdx == headerLineValues.size() - 1;
            boolean isResidualLine = headerLineIdx >= headerLineValues.size();
            boolean isLastLine = headerLineIdx == this.myHeaderLinePanels.size() - 1;
            int border = 0;
            border |= 4;
            if (!(isLeafColumnName || isResidualLine || isLastLine)) {
                boolean nextLineIsLeafColumnName;
                String nextLineValue = headerLineValues.get(headerLineIdx + 1);
                boolean bl = nextLineIsLeafColumnName = headerLineIdx == headerLineValues.size() - 2;
                if (!nextLineIsLeafColumnName && !nextLineValue.isBlank()) {
                    border |= 8;
                }
            }
            this.myHeaderLinePanels.get(headerLineIdx).setBorder(IdeBorderFactory.createBorder((int)border));
        }

        private void prepareHeaderLineForExpandedColumn(int headerLineIdx, List<String> headerLineValues, HierarchicalColumnsDataGridModel.HierarchicalGridColumn column, boolean forDisplay) {
            this.setHeaderLineContentForExpandedColumn(headerLineIdx, headerLineValues, column, forDisplay);
            this.setHeaderLineBorderForExpandedColumn(headerLineIdx, headerLineValues, column);
        }

        private void setHeaderLineContentForExpandedColumn(int headerLineIdx, List<String> headerLineValues, HierarchicalColumnsDataGridModel.HierarchicalGridColumn column, boolean forDisplay) {
            boolean isResidualLine;
            boolean isLeafColumnName = headerLineIdx == headerLineValues.size() - 1;
            boolean bl = isResidualLine = headerLineIdx >= headerLineValues.size();
            if (isLeafColumnName) {
                this.setValueForLastNonEmptyHeaderLine(headerLineValues.get(headerLineIdx), headerLineIdx, column.getColumnNumber(), forDisplay);
                return;
            }
            if (isResidualLine) {
                this.setPlaceholderIntoHeaderLine(headerLineIdx);
                return;
            }
            String value = headerLineValues.get(headerLineIdx);
            this.setHeaderLineValueExceptLast(headerLineValues.get(headerLineIdx), headerLineIdx, forDisplay);
            if (!value.isBlank()) {
                this.myIconLabels.get(headerLineIdx).setIcon(forDisplay ? AllIcons.Actions.ArrowCollapse : null);
            }
        }

        private void setHeaderLineBorderForExpandedColumn(int headerLineIdx, List<String> headerLineValues, HierarchicalColumnsDataGridModel.HierarchicalGridColumn column) {
            int[] path;
            int nextSiblingIndex;
            boolean isResidualLine;
            boolean isLeafColumnName = headerLineIdx == headerLineValues.size() - 1;
            boolean bl = isResidualLine = headerLineIdx >= headerLineValues.size();
            if (isLeafColumnName) {
                int border = 4;
                this.myHeaderLinePanels.get(headerLineIdx).setBorder(IdeBorderFactory.createBorder((int)border));
                return;
            }
            if (isResidualLine) {
                int border = 4;
                this.myHeaderLinePanels.get(headerLineIdx).setBorder(IdeBorderFactory.createBorder((int)border));
                return;
            }
            int border = 8;
            if (column.isRightMostChildOfDirectAncestor()) {
                border |= 4;
            }
            if (this.hasAllSiblingsFromIndexDisabled(column, nextSiblingIndex = (path = column.getPathFromRoot())[path.length - 1] + 1)) {
                border |= 4;
            }
            this.myHeaderLinePanels.get(headerLineIdx).setBorder(IdeBorderFactory.createBorder((int)border));
        }

        private boolean hasAllSiblingsFromIndexDisabled(HierarchicalColumnsDataGridModel.HierarchicalGridColumn column, int startIdx) {
            List siblings = column.getSiblings();
            if (startIdx < 0 || startIdx >= siblings.size()) {
                return false;
            }
            for (int i = startIdx; i < siblings.size(); ++i) {
                HierarchicalColumnsDataGridModel.HierarchicalGridColumn leftMostChildOfSibling;
                HierarchicalColumnsDataGridModel.HierarchicalGridColumn sibling = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)siblings.get(i);
                if (!(sibling.isLeaf() ? this.myTable.myResultPanel.isColumnEnabled(this.modelIndexOf((GridColumn)sibling)) : this.myTable.myResultPanel.isColumnEnabled(this.modelIndexOf((GridColumn)(leftMostChildOfSibling = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)sibling.getChildren().get(0)))))) continue;
                return false;
            }
            return true;
        }

        private ModelIndex<GridColumn> modelIndexOf(GridColumn column) {
            return ModelIndex.forColumn((CoreGrid)this.myTable.myResultPanel, (int)column.getColumnNumber());
        }

        private void setPlaceholderIntoHeaderLine(int headerLineIdx) {
            this.myNameLabels.get(headerLineIdx).setText(HEADER_PLACEHOLDER);
        }

        private void initializeLabelsForEachHeaderLine(int headerLineNum) {
            this.filterLabel = new LabelWithFallbackFont(this.myTable);
            this.filterLabel.setVerticalAlignment(0);
            this.filterLabel.setHorizontalAlignment(2);
            this.filterLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
            for (int i = 0; i < headerLineNum; ++i) {
                TrimmedLabelWithFallbackFont nameLabel = new TrimmedLabelWithFallbackFont(this.myTable);
                ((JLabel)((Object)nameLabel)).setHorizontalAlignment(2);
                ((JComponent)((Object)nameLabel)).setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.NAME_LABEL_INSETS));
                this.myNameLabels.add((JLabel)((Object)nameLabel));
                LabelWithFallbackFont sortLabel = new LabelWithFallbackFont(this.myTable);
                ((JLabel)((Object)sortLabel)).setVerticalAlignment(0);
                ((JComponent)((Object)sortLabel)).setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.SORT_LABEL_INSETS));
                this.myIconLabels.add((JLabel)((Object)sortLabel));
                JPanel panel2 = new JPanel();
                GroupLayout layout = new GroupLayout(panel2);
                int tableRowHeight = this.myTable.getRowHeight();
                GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
                hGroup.addComponent((Component)((Object)nameLabel), 0, -1, -1);
                if (i + 1 == headerLineNum) {
                    hGroup.addGap(JBUI.scale((int)2), JBUI.scale((int)2), JBUI.scale((int)2));
                    hGroup.addComponent(this.filterLabel, -2, -2, -2);
                }
                hGroup.addGap(0, 0, Short.MAX_VALUE).addComponent((Component)((Object)sortLabel), -2, -2, -2);
                GroupLayout.ParallelGroup vGroup = layout.createParallelGroup();
                vGroup.addComponent((Component)((Object)nameLabel), tableRowHeight, tableRowHeight, Short.MAX_VALUE);
                if (i + 1 == headerLineNum) {
                    vGroup.addComponent(this.filterLabel, tableRowHeight, tableRowHeight, Short.MAX_VALUE);
                }
                vGroup.addComponent((Component)((Object)sortLabel), tableRowHeight, tableRowHeight, Short.MAX_VALUE);
                layout.setHorizontalGroup(hGroup);
                layout.setVerticalGroup(vGroup);
                panel2.setLayout(layout);
                this.myHeaderLinePanels.add(panel2);
                this.myCompositeLabel.add(panel2);
            }
        }

        private void setHeaderLineValueExceptLast(@NlsSafe String value, int lineIdx, boolean forDisplay) {
            this.myNameLabels.get(lineIdx).setText((String)(this.myTable.myAllowMultilineColumnLabel && StringUtil.containsLineBreak((CharSequence)value) ? "<html>" + StringUtil.replace((String)value, (String)"\n", (String)"<br>") + "</html>" : value));
            if (!value.isBlank()) {
                this.myNameLabels.get(lineIdx).setIcon(forDisplay ? AllIcons.Json.Object : null);
                this.myNameLabels.get(lineIdx).setHorizontalTextPosition(4);
                this.myNameLabels.get(lineIdx).setVerticalTextPosition(0);
                this.myNameLabels.get(lineIdx).setHorizontalAlignment(2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setValueForLastNonEmptyHeaderLine(@NlsSafe String value, int lineIdx, int columnDataIdx, boolean forDisplay) {
            boolean filterLabelNeeded;
            JLabel nameLabel = this.myNameLabels.get(lineIdx);
            JLabel sortLabel = this.myIconLabels.get(lineIdx);
            nameLabel.setIcon(this.myCurrentColumn.getIcon(forDisplay));
            nameLabel.setForeground(this.getHeaderCellForeground());
            nameLabel.setText((String)(this.myTable.myAllowMultilineColumnLabel && StringUtil.containsLineBreak((CharSequence)value) ? "<html>" + StringUtil.replace((String)value, (String)"\n", (String)"<br>") + "</html>" : value));
            Icon sortLabelIcon = null;
            String sortLabelText = "";
            Icon filterLabelIcon = null;
            GridColumn column = this.myTable.getColumn(columnDataIdx);
            if (!this.myTable.isTransposed() && column != null) {
                ModelIndex columnIdx = ModelIndex.forColumn((CoreGrid)this.myTable.myResultPanel, (int)columnDataIdx);
                if (GridHelper.get(this.myTable.myResultPanel).isSortingApplicable(columnIdx) && this.myTable.myResultPanel.getComparator((ModelIndex<GridColumn>)columnIdx) != null) {
                    int sortOrder = this.myTable.myResultPanel.getSortOrder(column);
                    sortLabelIcon = TableResultView.getSortOrderIcon(sortOrder);
                    sortLabelText = this.myTable.myResultPanel.countSortedColumns() > 1 ? TableResultView.getSortOrderText(sortOrder) : "";
                }
                this.myTable.myResultPanel.getLocalFilterState();
                if (this.myTable.myResultPanel.getLocalFilterState().isEnabled()) {
                    filterLabelIcon = this.myTable.myResultPanel.getLocalFilterState().columnFilterEnabled((ModelIndex<GridColumn>)columnIdx) ? this.filterIconEnabled : AllIcons.General.Filter;
                }
            }
            nameLabel.setHorizontalAlignment(2);
            sortLabel.setIcon(sortLabelIcon);
            sortLabel.setText(sortLabelText);
            this.myHeaderLinePanels.get(lineIdx).setBackground(this.getHeaderCellBackground());
            boolean bl = filterLabelNeeded = !(column instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn) && filterLabelIcon != null;
            if (!filterLabelNeeded) {
                this.filterLabel.setVisible(false);
                return;
            }
            this.filterLabel.setIcon(filterLabelIcon);
            this.filterLabel.setVisible(true);
            JTableHeader jTableHeader = this.myTable.tableHeader;
            if (jTableHeader instanceof MyTableHeader) {
                MyTableHeader tableHeader = (MyTableHeader)((Object)jTableHeader);
                if (columnDataIdx == (tableHeader.hoveredFilterLabelIdx != null ? tableHeader.hoveredFilterLabelIdx.value : -1)) {
                    this.filterLabel.setOpaque(true);
                    this.filterLabel.setBackground(UIUtil.getTableSelectionBackground((boolean)false));
                    return;
                }
            }
            this.filterLabel.setOpaque(false);
        }

        private void resetHeaderLinesBg() {
            for (JPanel panel2 : this.myHeaderLinePanels) {
                panel2.setBackground(null);
                panel2.setBorder(null);
            }
        }

        private static void resetLabelsValues(List<JLabel> labels) {
            for (JLabel l : labels) {
                l.setText(null);
                l.setIcon(null);
            }
        }

        public String getToolTipText(MouseEvent event) {
            return this.myCurrentColumn != null ? this.myCurrentColumn.getTooltipText() : super.getToolTipText(event);
        }

        private Color getHeaderCellForeground() {
            if (this.myCurrentColumn == null) {
                return super.getForeground();
            }
            return this.myTable.isTransposed() ? this.myTable.myResultPanel.getColorModel().getRowHeaderForeground(ModelIndex.forRow((CoreGrid)this.myTable.myResultPanel, (int)this.myCurrentColumn.getModelIndex())) : this.myTable.myResultPanel.getColorModel().getColumnHeaderForeground(ModelIndex.forColumn((CoreGrid)this.myTable.myResultPanel, (int)this.myCurrentColumn.getModelIndex()));
        }

        private Color getHeaderCellBackground() {
            return this.getHeaderCellBackground(0);
        }

        private Color getHeaderCellBackground(int headerLine) {
            if (this.myCurrentColumn == null) {
                return super.getBackground();
            }
            Color color = this.myTable.isTransposed() ? this.myTable.myResultPanel.getColorModel().getRowHeaderBackground(ModelIndex.forRow((CoreGrid)this.myTable.myResultPanel, (int)this.myCurrentColumn.getModelIndex())) : this.myTable.myResultPanel.getColorModel().getColumnHeaderBackground(ModelIndex.forColumn((CoreGrid)this.myTable.myResultPanel, (int)this.myCurrentColumn.getModelIndex()), headerLine);
            return color == null ? this.myTable.getBackground() : color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/table/TableResultView$MyHeaderCellComponent", "<init>"));
        }
    }

    public static class LabelWithFallbackFont
    extends JBLabel {
        private final TableResultView myTable;

        public LabelWithFallbackFont(@NotNull TableResultView table2) {
            if (table2 == null) {
                LabelWithFallbackFont.$$$reportNull$$$0(0);
            }
            this.myTable = table2;
        }

        public Font getFont() {
            return this.myTable == null ? super.getFont() : UIUtil.getFontWithFallback((Font)this.myTable.getTableHeader().getFont());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/table/TableResultView$LabelWithFallbackFont", "<init>"));
        }
    }
}

