/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.editor.DataGridColors;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ResultReference;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.Component;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultTextRendererFactory
implements GridCellRendererFactory {
    private final DataGrid myGrid;
    private final Map<String, TextRenderer> myRenderers;
    private final Map<String, TextRenderer> myRenderersWithInlay;

    public DefaultTextRendererFactory(@NotNull DataGrid grid) {
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
        this.myRenderers = this.factory(false);
        this.myRenderersWithInlay = this.factory(true);
    }

    @NotNull
    private Map<String, TextRenderer> factory(boolean withInlay) {
        Map map = FactoryMap.createMap(languageId -> {
            TextRenderer renderer2 = new TextRenderer(this.myGrid, (String)languageId, withInlay);
            Disposer.register((Disposable)this.myGrid, (Disposable)renderer2);
            return renderer2;
        }, () -> new Reference2ObjectOpenHashMap());
        if (map == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Override
    public boolean supports(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(2);
        }
        if (column == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    @NotNull
    public GridCellRenderer getOrCreateRenderer(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(4);
        }
        if (column == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(5);
        }
        Object value = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column);
        String languageId = DefaultTextRendererFactory.getLanguage(this.myGrid, row, column).getID();
        GridCellRenderer gridCellRenderer = TextRenderer.hasInlay(value) ? (GridCellRenderer)this.myRenderersWithInlay.get(languageId) : (GridCellRenderer)this.myRenderers.get(languageId);
        if (gridCellRenderer == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(6);
        }
        return gridCellRenderer;
    }

    @Override
    public void reinitSettings() {
        this.myRenderers.forEach((lang, renderer2) -> renderer2.reinitSettings());
        this.myRenderersWithInlay.forEach((lang, renderer2) -> renderer2.reinitSettings());
    }

    @NotNull
    public static Language getLanguage(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> columnIdx) {
        Language language;
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(7);
        }
        if (row == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(8);
        }
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(9);
        }
        if ((language = grid.getContentLanguage(columnIdx)) != Language.ANY) {
            Language language2 = language;
            if (language2 == null) {
                DefaultTextRendererFactory.$$$reportNull$$$0(10);
            }
            return language2;
        }
        language = GridHelper.get(grid).getCellLanguage(grid, row, columnIdx);
        Object object = language == null ? PlainTextLanguage.INSTANCE : language;
        if (object == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(11);
        }
        return object;
    }

    @Nullable
    private static GridColumn getColumn(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(12);
        }
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(13);
        }
        return (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "factory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRenderer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRenderer";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static class TextRenderer
    extends GridCellRenderer {
        private static final TextAttributes BOLD_TEXT_ATTRIBUTES = new TextAttributes();
        private final Map<Pair<ModelIndex<GridColumn>, Object>, String> myValueTextCache;
        private final Border myEmptyBorder;
        private final String myLanguageId;
        private final boolean myWithInlay;
        private EditorTextFieldCellRenderer.AbbreviatingRendererComponent myComponent;
        private Inlay<HintRenderer> inlay;
        private final HintRenderer myInlayRenderer;

        public TextRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(0);
            }
            this(grid, TextRenderer.defaultEmptyBorder());
        }

        public TextRenderer(@NotNull DataGrid grid, @NotNull Border emptyBorder) {
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(1);
            }
            if (emptyBorder == null) {
                TextRenderer.$$$reportNull$$$0(2);
            }
            this(grid, PlainTextLanguage.INSTANCE.getID(), false, emptyBorder);
        }

        public TextRenderer(@NotNull DataGrid grid, @NotNull String languageId, boolean withInlay) {
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(3);
            }
            if (languageId == null) {
                TextRenderer.$$$reportNull$$$0(4);
            }
            this(grid, languageId, withInlay, TextRenderer.defaultEmptyBorder());
        }

        public TextRenderer(@NotNull DataGrid grid, @NotNull String languageId, boolean withInlay, @NotNull Border emptyBorder) {
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(5);
            }
            if (languageId == null) {
                TextRenderer.$$$reportNull$$$0(6);
            }
            if (emptyBorder == null) {
                TextRenderer.$$$reportNull$$$0(7);
            }
            super(grid);
            this.myValueTextCache = CollectionFactory.createConcurrentWeakKeySoftValueMap((int)10, (float)0.75f, (int)1, (HashingStrategy)new HashingStrategy<Pair<ModelIndex<GridColumn>, Object>>(){

                public int hashCode(Pair<ModelIndex<GridColumn>, Object> object) {
                    return Objects.hash(object.getFirst(), System.identityHashCode(object.getSecond()));
                }

                public boolean equals(Pair<ModelIndex<GridColumn>, Object> o1, Pair<ModelIndex<GridColumn>, Object> o2) {
                    return ((ModelIndex)o1.getFirst()).equals(o2.getFirst()) && o1.getSecond() == o2.getSecond();
                }
            });
            this.myInlayRenderer = new HintRenderer(""){

                protected boolean useEditorFont() {
                    return true;
                }
            };
            this.myLanguageId = languageId;
            this.myWithInlay = withInlay;
            this.myEmptyBorder = emptyBorder;
            UiNotifyConnector.installOn((Component)grid.getPanel().getComponent(), (Activatable)new Activatable(){

                public void hideNotify() {
                    myValueTextCache.clear();
                }
            });
        }

        private static Border defaultEmptyBorder() {
            return JBUI.Borders.empty((int)0, (int)3);
        }

        @Override
        public void clearCache() {
            this.myValueTextCache.clear();
        }

        @Override
        public void reinitSettings() {
            if (this.myComponent != null) {
                this.myComponent.getEditor().reinitSettings();
            }
        }

        @NotNull
        public static EditorTextFieldCellRenderer.AbbreviatingRendererComponent createComponent(@NotNull Project project, @Nullable Language language) {
            if (project == null) {
                TextRenderer.$$$reportNull$$$0(8);
            }
            return language == PlainTextLanguage.INSTANCE ? new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(project, language, false, true) : new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(project, language, false, false, false, ' ');
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
            if (row == null) {
                TextRenderer.$$$reportNull$$$0(9);
            }
            if (column == null) {
                TextRenderer.$$$reportNull$$$0(10);
            }
            return 1;
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<GridRow> rowIdx, @NotNull ViewIndex<GridColumn> columnIdx, @Nullable Object value) {
            if (rowIdx == null) {
                TextRenderer.$$$reportNull$$$0(11);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(12);
            }
            Pair modelRowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2Model().fun((Object)rowIdx.asInteger(), (Object)columnIdx.asInteger());
            ModelIndex modelColumn = ModelIndex.forColumn((CoreGrid)this.myGrid, (int)((Integer)modelRowAndColumn.second));
            JComponent jComponent = this.getComponent(rowIdx, columnIdx, value, (ModelIndex<GridColumn>)modelColumn);
            if (jComponent == null) {
                TextRenderer.$$$reportNull$$$0(13);
            }
            return jComponent;
        }

        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<GridRow> rowIdx, @NotNull ViewIndex<GridColumn> columnIdx, @Nullable Object value, @NotNull ModelIndex<GridColumn> modelColumn) {
            if (rowIdx == null) {
                TextRenderer.$$$reportNull$$$0(14);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(15);
            }
            if (modelColumn == null) {
                TextRenderer.$$$reportNull$$$0(16);
            }
            if (this.myComponent == null) {
                this.myComponent = TextRenderer.createComponent(this.myGrid.getProject(), Language.findLanguageByID((String)this.myLanguageId));
                if (this.myWithInlay) {
                    this.inlay = this.myComponent.getEditor().getInlayModel().addInlineElement(0, (EditorCustomElementRenderer)this.myInlayRenderer);
                }
            }
            EditorEx editor = this.myComponent.getEditor();
            this.configureEditor(editor);
            boolean selected = this.myGrid.getSelectionModel().isSelected(rowIdx, columnIdx);
            GridColumn column = DefaultTextRendererFactory.getColumn(modelColumn, this.myGrid);
            TextAttributes attributes = TextRenderer.getAttributes(value, (TextAttributesScheme)editor.getColorsScheme(), selected, column != null && column.getAttributes().contains(ColumnDescriptor.Attribute.HIGHLIGHTED));
            String valueText = this.getValueText(modelColumn, value == null ? ReservedCellValue.NULL : value);
            this.myComponent.setText(valueText, attributes, selected);
            this.myComponent.setBorder(this.myEmptyBorder);
            if (this.myWithInlay) {
                String inlayMessage = StringUtil.notNullize((String)TextRenderer.getInlayMessage(value, modelColumn, this.myGrid));
                this.myInlayRenderer.setText(inlayMessage.isEmpty() ? " " : inlayMessage);
                this.inlay.update();
            }
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = this.myComponent;
            if (abbreviatingRendererComponent == null) {
                TextRenderer.$$$reportNull$$$0(17);
            }
            return abbreviatingRendererComponent;
        }

        static boolean hasInlay(@Nullable Object value) {
            return value instanceof LobInfo && ((LobInfo)value).isTruncated();
        }

        @Nullable
        private static String getInlayMessage(@Nullable Object value, @NotNull ModelIndex<GridColumn> modelColumn, DataGrid grid) {
            if (modelColumn == null) {
                TextRenderer.$$$reportNull$$$0(18);
            }
            if (!TextRenderer.hasInlay(value)) {
                return null;
            }
            LobInfo info = (LobInfo)value;
            if (info instanceof LobInfo.ClobInfo && ((LobInfo.ClobInfo)info).data == null || info instanceof LobInfo.BlobInfo && ((LobInfo.BlobInfo)info).data == null) {
                GridColumn column = DefaultTextRendererFactory.getColumn(modelColumn, grid);
                return (String)(column == null ? "" : "(" + StringUtil.toUpperCase((String)column.getTypeName()) + ") ") + StringUtil.formatFileSize((long)info.length, (String)"");
            }
            return DataGridBundle.message((String)"Console.TableResult.n.bytes.of.m.bytes.loaded", (Object[])new Object[]{StringUtil.formatFileSize((long)info.getLoadedDataLength(), (String)""), StringUtil.formatFileSize((long)info.length, (String)"")});
        }

        public static TextAttributes getAttributes(@Nullable Object value, @NotNull TextAttributesScheme scheme, boolean selected, boolean highlight) {
            if (scheme == null) {
                TextRenderer.$$$reportNull$$$0(19);
            }
            if (highlight) {
                return BOLD_TEXT_ATTRIBUTES;
            }
            TextAttributesKey attributesKey = TextRenderer.getAttributesKey(value);
            return !selected && attributesKey != null ? scheme.getAttributes(attributesKey) : null;
        }

        protected void configureEditor(@NotNull EditorEx editor) {
            if (editor == null) {
                TextRenderer.$$$reportNull$$$0(20);
            }
            TextRenderer.configureEditor(editor, this.myGrid);
        }

        public static void configureEditor(@NotNull EditorEx editor, @NotNull DataGrid grid) {
            EditorColorsScheme scheme;
            boolean schemeAlreadySet;
            if (editor == null) {
                TextRenderer.$$$reportNull$$$0(21);
            }
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(22);
            }
            boolean bl = schemeAlreadySet = (scheme = editor.getColorsScheme()) instanceof DelegateColorScheme && ((DelegateColorScheme)scheme).getDelegate() == grid.getColorsScheme() && scheme.getEditorFontSize() == grid.getPreferredFocusedComponent().getFont().getSize();
            if (schemeAlreadySet) {
                return;
            }
            EditorColorsScheme bounded = editor.createBoundColorSchemeDelegate((EditorColorsScheme)grid.getColorsScheme());
            bounded.setEditorFontSize(grid.getPreferredFocusedComponent().getFont().getSize());
            editor.setColorsScheme(bounded);
        }

        @NotNull
        protected String getValueText(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull Object value) {
            String cachedText;
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(23);
            }
            if (value == null) {
                TextRenderer.$$$reportNull$$$0(24);
            }
            Pair key = Pair.pair(columnIdx, (Object)value);
            String string = cachedText = value instanceof ReservedCellValue ? null : this.myValueTextCache.get(key);
            if (cachedText != null) {
                String string2 = cachedText;
                if (string2 == null) {
                    TextRenderer.$$$reportNull$$$0(25);
                }
                return string2;
            }
            String text = TextRenderer.getDisplayString(TextRenderer.getText(value, columnIdx, this.myGrid));
            if (!(value instanceof ReservedCellValue)) {
                this.myValueTextCache.put((Pair<ModelIndex<GridColumn>, Object>)key, text);
            }
            String string3 = text;
            if (string3 == null) {
                TextRenderer.$$$reportNull$$$0(26);
            }
            return string3;
        }

        @NotNull
        private static String getText(@NotNull Object value, @NotNull ModelIndex<GridColumn> columnIdx, @NotNull DataGrid grid) {
            GridColumn column;
            if (value == null) {
                TextRenderer.$$$reportNull$$$0(27);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(28);
            }
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(29);
            }
            if ((column = DefaultTextRendererFactory.getColumn(columnIdx, grid)) == null) {
                String string = value.toString();
                if (string == null) {
                    TextRenderer.$$$reportNull$$$0(30);
                }
                return string;
            }
            String stringValue = grid.getObjectFormatter().objectToString(value, column, (ObjectFormatterConfig)GridUtil.createFormatterConfig(grid, columnIdx));
            String string = Objects.requireNonNullElse(stringValue, "null");
            if (string == null) {
                TextRenderer.$$$reportNull$$$0(31);
            }
            return string;
        }

        public static String getDisplayString(@NotNull String str) {
            int lineEnd;
            if (str == null) {
                TextRenderer.$$$reportNull$$$0(32);
            }
            if (GridUtil.isFailedToLoad(str) && (lineEnd = str.indexOf(10, "<failed to load>".length() + 1)) > -1) {
                str = str.substring("<failed to load>".length(), lineEnd).trim();
            }
            return TextRenderer.trimTrailingWhitespace(str);
        }

        private static String trimTrailingWhitespace(String s) {
            int end;
            for (end = s.length(); end > 0 && s.charAt(end - 1) <= ' ' && s.charAt(end - 1) != '\n'; --end) {
            }
            return s.substring(0, end);
        }

        @Override
        public void dispose() {
            if (this.myComponent != null) {
                Disposer.dispose((Disposable)this.myComponent);
            }
        }

        @Nullable
        public static TextAttributesKey getAttributesKey(@Nullable Object value) {
            if (value == null || value == ReservedCellValue.UNSET) {
                return DataGridColors.GRID_NULL_VALUE;
            }
            if (value instanceof ImageInfo) {
                return DataGridColors.GRID_IMAGE_VALUE;
            }
            if (GridUtil.isFailedToLoad(value)) {
                return DataGridColors.GRID_ERROR_VALUE;
            }
            if (value instanceof LobInfo.FileClobInfo || value instanceof LobInfo.FileBlobInfo) {
                return DataGridColors.GRID_UPLOAD_VALUE;
            }
            if (value instanceof ResultReference) {
                return DataGridColors.GRID_RESULT_VALUE;
            }
            return null;
        }

        static {
            BOLD_TEXT_ATTRIBUTES.setFontType(1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 13, 17, 25, 26, 30, 31 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyBorder";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageId";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 12: 
                case 15: 
                case 23: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 13: 
                case 17: 
                case 25: 
                case 26: 
                case 30: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelColumn";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 24: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 13: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 13: 
                case 17: 
                case 25: 
                case 26: 
                case 30: 
                case 31: {
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getInlayMessage";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributes";
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "configureEditor";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueText";
                    break;
                }
                case 27: 
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "getDisplayString";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 13, 17, 25, 26, 30, 31 -> new IllegalStateException(string);
            };
        }
    }
}

