/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorTextField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.util.EventObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridTextCellEditorBase
extends GridCellEditor.Adapter
implements DataProvider,
GridCellEditor.EditorBased {
    protected final DataGrid myGrid;
    private final GridCellEditorFactory.IsEditableChecker myEditableChecker;
    protected final GridColumn myColumn;
    protected final GridCellEditorTextField myTextField;
    protected Object myValue;

    protected GridTextCellEditorBase(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable Object value, EventObject initiator, @NotNull GridCellEditorFactory.IsEditableChecker editableChecker, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        if (grid == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(1);
        }
        if (column == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(2);
        }
        if (editableChecker == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(3);
        }
        if (valueFormatter == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(4);
        }
        this.myGrid = grid;
        this.myEditableChecker = editableChecker;
        this.myColumn = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column);
        this.myValue = value;
        TextCompletionProvider provider = GridUtil.createCompletionProvider(grid, row, column);
        this.myTextField = new MyGridCellEditorTextField(initiator, provider, row, column, valueFormatter);
        Disposer.register((Disposable)this, (Disposable)this.myTextField);
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myTextField.getText();
        if (string == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            GridTextCellEditorBase.$$$reportNull$$$0(6);
        }
        return gridCellEditorTextField;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myTextField.getEditor();
    }

    protected boolean isValueEditable() {
        return this.myEditableChecker.isEditable(this.myValue, this.myGrid, (ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)this.myGrid, (int)this.myColumn.getColumnNumber()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editableChecker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    private class MyGridCellEditorTextField
    extends GridCellEditorTextField {
        MyGridCellEditorTextField(@Nullable EventObject initiator, @NotNull TextCompletionProvider provider, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, GridCellEditorFactory.ValueFormatter valueFormatter) {
            if (row == null) {
                MyGridCellEditorTextField.$$$reportNull$$$0(0);
            }
            if (column == null) {
                MyGridCellEditorTextField.$$$reportNull$$$0(1);
            }
            if (valueFormatter == null) {
                MyGridCellEditorTextField.$$$reportNull$$$0(2);
            }
            super(GridTextCellEditorBase.this.myGrid.getProject(), GridTextCellEditorBase.this.myGrid, row, column, true, initiator, provider, false, valueFormatter);
            this.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GridTextCellEditorBase.this.fireEditing(MyGridCellEditorTextField.this.getDocument().getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase$MyGridCellEditorTextField$1", "documentChanged"));
                }
            });
        }

        @Override
        public Object getData(@NotNull String dataId) {
            Object fromCellEditor;
            if (dataId == null) {
                MyGridCellEditorTextField.$$$reportNull$$$0(3);
            }
            return (fromCellEditor = GridTextCellEditorBase.this.getData(dataId)) != null ? fromCellEditor : super.getData(dataId);
        }

        @Override
        protected boolean isEditable() {
            return super.isEditable() && GridTextCellEditorBase.this.isValueEditable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueFormatter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridTextCellEditorBase$MyGridCellEditorTextField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

