/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.Gray;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Random;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TableCellImageCache {
    public static final int MAX_ROWS = 100;
    public static final int MAX_COLUMNS = 30;
    private CacheImpl myImageCache;
    private Map<TableCellRenderer, CachingCellRendererWrapper> myCellRendererWrappers;
    private final ResultViewWithRows myTable;
    private int myCacheLevel;
    private boolean myWrappedGraphics;
    private final Random myRandom;
    private final boolean myCacheEnabled;

    public TableCellImageCache(@NotNull ResultViewWithRows table2, @NotNull Disposable disposable) {
        if (table2 == null) {
            TableCellImageCache.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            TableCellImageCache.$$$reportNull$$$0(1);
        }
        this.myRandom = new Random();
        this.myTable = table2;
        this.myCacheEnabled = Registry.is((String)"database.grid.render.cache");
        this.reset();
        UiNotifyConnector.installOn((Component)this.myTable.getComponent(), (Activatable)new Activatable(){

            public void hideNotify() {
                TableCellImageCache.this.reset();
            }
        });
        this.installFastScrollingCaching(disposable);
    }

    private void installFastScrollingCaching(@NotNull Disposable disposable) {
        SingleAlarm scrollingAlarm;
        if (disposable == null) {
            TableCellImageCache.$$$reportNull$$$0(2);
        }
        if (!this.myCacheEnabled || !Registry.is((String)"database.grid.render.cache.fast.scroll")) {
            return;
        }
        SingleAlarm[] alarmRef = new SingleAlarm[]{null};
        alarmRef[0] = scrollingAlarm = new SingleAlarm(() -> {
            if (this.myCacheLevel == 0) {
                this.myTable.getComponent().repaint();
            } else {
                this.myCacheLevel -= 25;
                alarmRef[0].cancelAndRequest();
            }
        }, 100);
        Disposer.register((Disposable)disposable, (Disposable)scrollingAlarm);
        int[] xySum = new int[]{0};
        final ChangeListener scrollListener = e -> {
            JScrollBar horizontalScrollBar = this.myTable.getHorizontalScrollBar();
            JScrollBar verticalScrollBar = this.myTable.getVerticalScrollBar();
            int curSum = -((horizontalScrollBar == null ? 0 : horizontalScrollBar.getValue()) + (verticalScrollBar == null ? 0 : verticalScrollBar.getValue()));
            int delta = xySum[0] == 0 ? 0 : Math.abs(curSum - xySum[0]);
            xySum[0] = curSum;
            if (delta <= this.myTable.getRowHeight() * 4) {
                return;
            }
            scrollingAlarm.cancelAndRequest();
            this.myCacheLevel = 100;
        };
        UiNotifyConnector.Once.installOn((Component)this.myTable.getComponent(), (Activatable)new Activatable(){

            public void showNotify() {
                JScrollBar horizontalScrollBar = TableCellImageCache.this.myTable.getHorizontalScrollBar();
                JScrollBar verticalScrollBar = TableCellImageCache.this.myTable.getVerticalScrollBar();
                if (horizontalScrollBar != null) {
                    horizontalScrollBar.getModel().addChangeListener(scrollListener);
                }
                if (verticalScrollBar != null) {
                    verticalScrollBar.getModel().addChangeListener(scrollListener);
                }
            }
        });
    }

    public TableCellRenderer wrapCellRenderer(@NotNull TableCellRenderer renderer2) {
        if (renderer2 == null) {
            TableCellImageCache.$$$reportNull$$$0(3);
        }
        if (!this.myCacheEnabled) {
            return renderer2;
        }
        return this.myCellRendererWrappers.get(renderer2);
    }

    public void reset() {
        this.myImageCache = new CacheImpl();
        this.myCellRendererWrappers = FactoryMap.createMap(x$0 -> new CachingCellRendererWrapper((TableCellRenderer)x$0), () -> new Reference2ObjectOpenHashMap());
    }

    public boolean isCacheEnabled() {
        return this.myCacheEnabled;
    }

    public void adjustCacheSize(int size) {
        if (this.myCacheEnabled) {
            this.myImageCache.adjustCacheSize(size);
        }
    }

    @NotNull
    private static Object getState(@NotNull Component renderer2) {
        if (renderer2 == null) {
            TableCellImageCache.$$$reportNull$$$0(4);
        }
        Color bg = TableCellImageCache.hashSafeColor(renderer2.getBackground());
        Color fg = TableCellImageCache.hashSafeColor(renderer2.getForeground());
        Boolean opaque = renderer2.isOpaque() ? Boolean.TRUE : Boolean.FALSE;
        Trinity trinity = Trinity.create((Object)bg, (Object)fg, (Object)opaque);
        if (trinity == null) {
            TableCellImageCache.$$$reportNull$$$0(5);
        }
        return trinity;
    }

    @Nullable
    private static Color hashSafeColor(@Nullable Color color) {
        Class<?> colorClass;
        Class<?> clazz = colorClass = color != null ? color.getClass() : null;
        if (colorClass == null || colorClass == Color.class || colorClass == ColorUIResource.class) {
            return color;
        }
        return new Color(color.getRed(), color.getBlue(), color.getGreen(), color.getAlpha());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/TableCellImageCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/TableCellImageCache";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installFastScrollingCaching";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static final class CacheImpl {
        private SLRUMap<CellStateInfo, SoftReference<BufferedImage>> myCache = new SLRUMap(0, 0);
        private int myCacheSize = 0;

        private CacheImpl() {
        }

        @Nullable
        public BufferedImage get(@NotNull CellStateInfo key) {
            SoftReference imageRef;
            if (key == null) {
                CacheImpl.$$$reportNull$$$0(0);
            }
            if ((imageRef = (SoftReference)this.myCache.get((Object)key)) == null) {
                return null;
            }
            BufferedImage image = (BufferedImage)imageRef.get();
            if (image == null) {
                this.myCache.remove((Object)key);
            }
            return image;
        }

        public void put(@NotNull CellStateInfo key, @NotNull BufferedImage value) {
            if (key == null) {
                CacheImpl.$$$reportNull$$$0(1);
            }
            if (value == null) {
                CacheImpl.$$$reportNull$$$0(2);
            }
            this.myCache.put((Object)key, new SoftReference<BufferedImage>(value));
        }

        public void clear() {
            this.myCache.clear();
        }

        public void adjustCacheSize(int newMaxSize) {
            int oldCacheSize = this.myCacheSize;
            if (oldCacheSize >= newMaxSize && oldCacheSize / 2 < newMaxSize) {
                return;
            }
            SLRUMap newCache = new SLRUMap(newMaxSize, newMaxSize);
            for (Map.Entry entry : this.myCache.entrySet()) {
                newCache.put((Object)((CellStateInfo)entry.getKey()), (Object)((SoftReference)entry.getValue()));
            }
            this.myCache = newCache;
            this.myCacheSize = newMaxSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/TableCellImageCache$CacheImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class CachingCellRendererWrapper
    extends CellRendererPanel
    implements TableCellRenderer {
        final TableCellRenderer myWrappee;
        Object myValue;
        boolean myIsSelected;
        boolean myHasFocus;

        CachingCellRendererWrapper(TableCellRenderer wrappee) {
            if (wrappee == null) {
                CachingCellRendererWrapper.$$$reportNull$$$0(0);
            }
            this.myWrappee = wrappee;
        }

        public void clearCache() {
            TableCellImageCache.this.myImageCache.clear();
        }

        @NotNull
        public TableCellRenderer getDelegate() {
            TableCellRenderer tableCellRenderer = this.myWrappee;
            if (tableCellRenderer == null) {
                CachingCellRendererWrapper.$$$reportNull$$$0(1);
            }
            return tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myValue = value;
            this.myIsSelected = isSelected;
            this.myHasFocus = hasFocus;
            Component originalComponent = this.myWrappee.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            if (!this.hasWrappeeComponent()) {
                this.add(originalComponent);
            } else if (originalComponent != this.getWrappeeComponent()) {
                this.removeAll();
                this.add(originalComponent);
            }
            return this;
        }

        public AccessibleContext getAccessibleContext() {
            return this.getWrappeeComponent().getAccessibleContext();
        }

        protected void paintChildren(Graphics g) {
            Object userCellState;
            boolean tooLargeToCache;
            boolean wrappedGraphics = g instanceof Graphics2DDelegate;
            JComponent originalComponent = this.getWrappeeComponent();
            originalComponent.validate();
            boolean forceNoCaching = wrappedGraphics && (TableCellImageCache.this.myCacheLevel == 0 || TableCellImageCache.this.myCacheLevel < 100 && TableCellImageCache.this.myRandom.nextInt(100) > TableCellImageCache.this.myCacheLevel) || AppMode.isRemoteDevHost();
            Rectangle visibleRect = TableCellImageCache.this.myTable.getComponent().getVisibleRect();
            int width = this.getWidth();
            int height = this.getHeight();
            boolean paintingExpansionHint = this.getParent() instanceof ExpandedItemRendererComponentWrapper;
            boolean bl = tooLargeToCache = visibleRect.width <= width || visibleRect.height <= height;
            if (paintingExpansionHint || tooLargeToCache || forceNoCaching || UIUtil.isPrinting((Graphics)g)) {
                super.paintChildren(g);
                return;
            }
            if (TableCellImageCache.this.myWrappedGraphics != wrappedGraphics) {
                TableCellImageCache.this.myImageCache.clear();
            }
            TableCellImageCache.this.myWrappedGraphics = wrappedGraphics;
            Graphics2D g2d = (Graphics2D)g;
            boolean isMacRetina = UIUtil.isRetina((Graphics2D)g2d);
            CellStateInfo cacheKey = new CellStateInfo(this, this.myValue, this.myIsSelected, this.myHasFocus, width, height, isMacRetina, userCellState = TableCellImageCache.getState((Component)((Object)this)));
            BufferedImage image = TableCellImageCache.this.myImageCache.get(cacheKey);
            if (image == null) {
                int type = wrappedGraphics ? 2 : 1;
                image = ImageUtil.createImage((Graphics)g2d, (int)width, (int)height, (int)type);
                this.paintComponentOn(originalComponent, image);
                TableCellImageCache.this.myImageCache.put(cacheKey, image);
            }
            StartupUiUtil.drawImage((Graphics)g, (BufferedImage)image, null, (int)0, (int)0);
        }

        public Border getBorder() {
            return this.hasWrappeeComponent() ? this.getWrappeeBorder() : super.getBorder();
        }

        public void setBorder(Border border) {
            if (this.hasWrappeeComponent() && !(border instanceof UIResource)) {
                this.getWrappeeComponent().setBorder(border);
                return;
            }
            super.setBorder(border);
        }

        public void setBackground(Color bg) {
            if (this.hasWrappeeComponent()) {
                this.getWrappeeComponent().setBackground(bg);
            }
            super.setBackground(bg);
        }

        private Border getWrappeeBorder() {
            Border border = this.getWrappeeComponent().getBorder();
            return border instanceof UIResource ? super.getBorder() : border;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintComponentOn(@NotNull JComponent c, @NotNull BufferedImage image) {
            if (c == null) {
                CachingCellRendererWrapper.$$$reportNull$$$0(2);
            }
            if (image == null) {
                CachingCellRendererWrapper.$$$reportNull$$$0(3);
            }
            boolean hasAlpha = image.getColorModel().hasAlpha();
            boolean wasDoubleBuffered = c.isDoubleBuffered();
            c.setDoubleBuffered(false);
            c.setOpaque(true);
            c.setBackground(this.myIsSelected || !hasAlpha ? c.getBackground() : Gray.TRANSPARENT);
            if (c instanceof CellRendererPanel) {
                ((CellRendererPanel)c).setSelected(this.myIsSelected || !hasAlpha);
            }
            Graphics2D g = image.createGraphics();
            try {
                c.paint(g);
            }
            finally {
                g.dispose();
            }
            if (wasDoubleBuffered) {
                c.setDoubleBuffered(true);
            }
        }

        private JComponent getWrappeeComponent() {
            return (JComponent)this.getComponent(0);
        }

        private boolean hasWrappeeComponent() {
            return this.getComponentCount() > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappee";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/TableCellImageCache$CachingCellRendererWrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/TableCellImageCache$CachingCellRendererWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "paintComponentOn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CellStateInfo {
        final TableCellRenderer myRenderer;
        final Object myValue;
        final boolean myIsSelected;
        final boolean myHasFocus;
        final int myWidth;
        final int myHeight;
        final boolean myIsRetina;
        final Object myUserState;

        CellStateInfo(@NotNull TableCellRenderer renderer2, @Nullable Object value, boolean isSelected, boolean hasFocus, int width, int height, boolean isRetina, @Nullable Object userState) {
            if (renderer2 == null) {
                CellStateInfo.$$$reportNull$$$0(0);
            }
            this.myRenderer = renderer2;
            this.myValue = value;
            this.myIsSelected = isSelected;
            this.myHasFocus = hasFocus;
            this.myWidth = width;
            this.myHeight = height;
            this.myIsRetina = isRetina;
            this.myUserState = userState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellStateInfo info = (CellStateInfo)o;
            if (this.myIsSelected != info.myIsSelected) {
                return false;
            }
            if (this.myHasFocus != info.myHasFocus) {
                return false;
            }
            if (this.myWidth != info.myWidth) {
                return false;
            }
            if (this.myHeight != info.myHeight) {
                return false;
            }
            if (this.myRenderer != info.myRenderer) {
                return false;
            }
            if (!CellStateInfo.equalObjectsAndHashCodes(this.myValue, info.myValue)) {
                return false;
            }
            if (this.myIsRetina != info.myIsRetina) {
                return false;
            }
            return CellStateInfo.equalObjectsAndHashCodes(this.myUserState, info.myUserState);
        }

        public int hashCode() {
            int result = System.identityHashCode(this.myRenderer);
            result = 31 * result + (this.myValue != null ? this.myValue.hashCode() : 0);
            result = 31 * result + (this.myIsSelected ? 1 : 0);
            result = 31 * result + (this.myHasFocus ? 1 : 0);
            result = 31 * result + this.myWidth;
            result = 31 * result + this.myHeight;
            result = 31 * result + (this.myIsRetina ? 1 : 0);
            result = 31 * result + (this.myUserState != null ? this.myUserState.hashCode() : 0);
            return result;
        }

        private static boolean equalObjectsAndHashCodes(@Nullable Object o1, @Nullable Object o2) {
            return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2) && o1.hashCode() == o2.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/database/run/ui/grid/TableCellImageCache$CellStateInfo", "<init>"));
        }
    }
}

