/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPanel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMainPanel
extends JBLoadingPanel
implements GridPanel {
    private final DataGrid myGrid;
    private final OnePixelSplitter myHorizontalSplitter;
    private final JPanel myVerticalSplitterWrapper;
    private final OnePixelSplitter myVerticalSplitter;
    private final JPanel myPanelWithFirstHeader;
    private final JPanel myCentralPanel;

    public GridMainPanel(@NotNull DataGrid grid) {
        if (grid == null) {
            GridMainPanel.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new BorderLayout(), (Disposable)grid);
        this.myVerticalSplitterWrapper = new JPanel(new BorderLayout());
        this.myPanelWithFirstHeader = new JPanel(new BorderLayout());
        this.myCentralPanel = new JPanel(new BorderLayout());
        this.myGrid = grid;
        this.add(this.myPanelWithFirstHeader, "Center");
        this.myPanelWithFirstHeader.setOpaque(false);
        this.myVerticalSplitter = new OnePixelSplitter(true, 0.7f);
        this.myHorizontalSplitter = new OnePixelSplitter(false, 0.7f);
        this.myVerticalSplitterWrapper.add((Component)this.myVerticalSplitter, "Center");
        this.myPanelWithFirstHeader.add((Component)this.myVerticalSplitterWrapper, "Center");
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myHorizontalSplitter);
        this.myHorizontalSplitter.setFirstComponent((JComponent)this.myCentralPanel);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension resultViewSize = this.myGrid.getMainResultViewComponent().getPreferredSize();
        Component toolbar = this.getTopComponent();
        JComponent verticalHeader = this.getRightHeaderComponent();
        int verticalHeaderWidth = verticalHeader == null ? 0 : verticalHeader.getPreferredSize().width;
        int bordersWidth = this.getInsets().left + this.getInsets().right;
        int width = Math.max(toolbar == null ? 0 : toolbar.getPreferredSize().width, resultViewSize.width) + bordersWidth + verticalHeaderWidth;
        int toolbarHeight = toolbar == null ? 0 : toolbar.getPreferredSize().height;
        int bordersHeight = this.getInsets().top + this.getInsets().bottom;
        JComponent bottomHeader = this.getBottomHeaderComponent();
        int bottomToolbarHeight = bottomHeader == null ? 0 : bottomHeader.getPreferredSize().height;
        JComponent secondBottomComponent = this.getSecondBottomComponent();
        int secondBottomComponentHeight = secondBottomComponent == null ? 0 : secondBottomComponent.getPreferredSize().height;
        int height = resultViewSize.height + toolbarHeight + bordersHeight + bottomToolbarHeight + secondBottomComponentHeight;
        return new Dimension(width, height);
    }

    @NotNull
    public DataGrid getGrid() {
        DataGrid dataGrid = this.myGrid;
        if (dataGrid == null) {
            GridMainPanel.$$$reportNull$$$0(1);
        }
        return dataGrid;
    }

    public Color getBackground() {
        return (Color)ObjectUtils.chooseNotNull(this.myGrid != null ? this.myGrid.getColorsScheme().getDefaultBackground() : null, (Object)UIUtil.getTableBackground());
    }

    @Override
    @Nullable
    public Component getTopComponent() {
        return GridMainPanel.getComponentAt(this.myPanelWithFirstHeader, "North");
    }

    @Override
    @Nullable
    public Component getSecondTopComponent() {
        return GridMainPanel.getComponentAt(this.myCentralPanel, "North");
    }

    public JComponent getSecondBottomComponent() {
        return (JComponent)ObjectUtils.tryCast((Object)GridMainPanel.getComponentAt(this.getContentPanel(), "South"), JComponent.class);
    }

    public void setCenterComponent(@NotNull JComponent component) {
        if (component == null) {
            GridMainPanel.$$$reportNull$$$0(2);
        }
        GridMainPanel.replaceComponentAt(this.myCentralPanel, "Center", component);
    }

    @Override
    @NotNull
    public JComponent getCenterComponent() {
        JPanel jPanel = this.myVerticalSplitterWrapper;
        if (jPanel == null) {
            GridMainPanel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    public void setTopComponent(@Nullable Component topComponent) {
        GridMainPanel.replaceComponentAt(this.myPanelWithFirstHeader, "North", topComponent);
    }

    @Override
    public void setRightHeaderComponent(@Nullable Component topComponent) {
        GridMainPanel.replaceComponentAt(this.myPanelWithFirstHeader, "East", topComponent);
    }

    @Nullable
    private JComponent getRightHeaderComponent() {
        return (JComponent)ObjectUtils.tryCast((Object)GridMainPanel.getComponentAt(this.myPanelWithFirstHeader, "East"), JComponent.class);
    }

    @Override
    public void setBottomHeaderComponent(@Nullable JComponent topComponent) {
        GridMainPanel.replaceComponentAt(this.myPanelWithFirstHeader, "South", topComponent);
    }

    @Override
    @Nullable
    public JComponent getBottomHeaderComponent() {
        return (JComponent)ObjectUtils.tryCast((Object)GridMainPanel.getComponentAt(this.myPanelWithFirstHeader, "South"), JComponent.class);
    }

    @Override
    public void setSecondTopComponent(@Nullable Component topComponent) {
        GridMainPanel.replaceComponentAt(this.myCentralPanel, "North", topComponent);
    }

    public void setBottomComponent(@Nullable Component bottomComponent) {
        GridMainPanel.replaceComponentAt(this.myCentralPanel, "South", bottomComponent);
    }

    public void setSecondBottomComponent(@Nullable JComponent component) {
        GridMainPanel.replaceComponentAt(this.getContentPanel(), "South", component);
    }

    @Override
    public void setBottomView(@Nullable JComponent bottomComponent) {
        this.myVerticalSplitter.setSecondComponent(bottomComponent);
    }

    @Override
    @NotNull
    public JBLoadingPanel getComponent() {
        GridMainPanel gridMainPanel = this;
        if (gridMainPanel == null) {
            GridMainPanel.$$$reportNull$$$0(4);
        }
        return gridMainPanel;
    }

    @Override
    @Nullable
    public JComponent getBottomView() {
        return this.myVerticalSplitter.getSecondComponent();
    }

    @Override
    @Nullable
    public JComponent getRightView() {
        return this.myHorizontalSplitter.getSecondComponent();
    }

    @Override
    public void setRightView(@Nullable JComponent component) {
        this.myHorizontalSplitter.setSecondComponent(component);
    }

    private static void replaceComponentAt(@NotNull JPanel panel2, @NotNull String location, @Nullable Component with) {
        Component toReplace;
        if (panel2 == null) {
            GridMainPanel.$$$reportNull$$$0(5);
        }
        if (location == null) {
            GridMainPanel.$$$reportNull$$$0(6);
        }
        if ((toReplace = GridMainPanel.getComponentAt(panel2, location)) != null) {
            panel2.remove(toReplace);
        }
        if (with != null) {
            panel2.add(with, location);
        }
        panel2.revalidate();
        panel2.repaint();
    }

    @Nullable
    private static Component getComponentAt(@NotNull JPanel panel2, @NotNull String location) {
        if (panel2 == null) {
            GridMainPanel.$$$reportNull$$$0(7);
        }
        if (location == null) {
            GridMainPanel.$$$reportNull$$$0(8);
        }
        return ((BorderLayout)panel2.getLayout()).getLayoutComponent(location);
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        GridUtil.globalSchemeChange(this.myGrid, scheme);
    }

    @Override
    public void removeComponent(JComponent component) {
        if (this.myHorizontalSplitter.getSecondComponent() == component) {
            this.myHorizontalSplitter.setSecondComponent(null);
        } else if (this.myVerticalSplitter.getSecondComponent() == component) {
            this.myVerticalSplitter.setSecondComponent(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridMainPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridMainPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrid";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCenterComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceComponentAt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

