/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ResultViewColumn;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.DefaultGridColumnLayout;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsPanelMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000e\u001a\u00020\t2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0014R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/run/ui/grid/EqualWidthGridColumnLayout;", "Lcom/intellij/database/run/ui/grid/DefaultGridColumnLayout;", "myResultView", "Lcom/intellij/database/run/ui/table/TableResultView;", "myGrid", "Lcom/intellij/database/datagrid/DataGrid;", "isEqualWidthColumn", "Lkotlin/Function1;", "Lcom/intellij/database/datagrid/GridColumn;", "", "(Lcom/intellij/database/run/ui/table/TableResultView;Lcom/intellij/database/datagrid/DataGrid;Lkotlin/jvm/functions/Function1;)V", "()Lkotlin/jvm/functions/Function1;", "getMyGrid", "()Lcom/intellij/database/datagrid/DataGrid;", "doLayout", "columnDataIndices", "", "Lcom/intellij/database/datagrid/ModelIndex;", "Companion", "intellij.grid.impl"})
public final class EqualWidthGridColumnLayout
extends DefaultGridColumnLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TableResultView myResultView;
    @NotNull
    private final DataGrid myGrid;
    @NotNull
    private final Function1<GridColumn, Boolean> isEqualWidthColumn;
    public static final int MAX_COLUMN_WIDTH = 200;

    public EqualWidthGridColumnLayout(@NotNull TableResultView myResultView, @NotNull DataGrid myGrid, @NotNull Function1<? super GridColumn, Boolean> isEqualWidthColumn) {
        Intrinsics.checkNotNullParameter((Object)myResultView, (String)"myResultView");
        Intrinsics.checkNotNullParameter((Object)myGrid, (String)"myGrid");
        Intrinsics.checkNotNullParameter(isEqualWidthColumn, (String)"isEqualWidthColumn");
        super(myResultView, myGrid);
        this.myResultView = myResultView;
        this.myGrid = myGrid;
        this.isEqualWidthColumn = isEqualWidthColumn;
    }

    @NotNull
    public final DataGrid getMyGrid() {
        return this.myGrid;
    }

    @NotNull
    public final Function1<GridColumn, Boolean> isEqualWidthColumn() {
        return this.isEqualWidthColumn;
    }

    @Override
    protected boolean doLayout(@NotNull List<? extends ModelIndex<?>> columnDataIndices) {
        Intrinsics.checkNotNullParameter(columnDataIndices, (String)"columnDataIndices");
        StatisticsPanelMode curStatisticsPanelMode = this.myResultView.getStatisticsPanelMode();
        if (curStatisticsPanelMode == null || curStatisticsPanelMode == StatisticsPanelMode.OFF || this.myResultView.isTransposed()) {
            return super.doLayout(columnDataIndices);
        }
        for (ModelIndex<?> ind : columnDataIndices) {
            GridModel gridModel = this.myGrid.getDataModel(DataAccessType.DATABASE_DATA);
            Intrinsics.checkNotNull(ind, (String)"null cannot be cast to non-null type com.intellij.database.datagrid.ModelIndex<com.intellij.database.datagrid.GridColumn>");
            GridColumn column = (GridColumn)gridModel.getColumn(ind);
            if (column != null && !((Boolean)this.isEqualWidthColumn.invoke((Object)column)).booleanValue()) {
                super.doLayout(CollectionsKt.listOf(ind));
                continue;
            }
            ResultViewColumn resultViewColumn = this.myResultView.getLayoutColumn(ind);
            if (resultViewColumn == null) continue;
            resultViewColumn.setColumnWidth(200);
        }
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/run/ui/grid/EqualWidthGridColumnLayout$Companion;", "", "()V", "MAX_COLUMN_WIDTH", "", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

