/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.UpdateEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u001cH&J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0014\u0010 \u001a\u00020\u001e2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u001eH\u0004R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/intellij/database/run/ui/TabInfoProvider;", "Lcom/intellij/openapi/Disposable;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Ljava/lang/String;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "isOnTab", "", "()Z", "setOnTab", "(Z)V", "isUpdated", "setUpdated", "panel", "Ljavax/swing/JPanel;", "tabInfo", "Lcom/intellij/ui/tabs/TabInfo;", "Lorg/jetbrains/annotations/NotNull;", "getTabInfo", "()Lcom/intellij/ui/tabs/TabInfo;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getToolbar", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "createToolbar", "getViewer", "Lcom/intellij/database/run/ui/CellViewer;", "onTabEnter", "", "onTabLeave", "update", "event", "Lcom/intellij/database/run/ui/UpdateEvent;", "updateTabInfo", "intellij.grid.impl"})
public abstract class TabInfoProvider
implements Disposable {
    @Nullable
    private final ActionGroup actionGroup;
    @NotNull
    private final JPanel panel;
    @Nullable
    private final ActionToolbar toolbar;
    @NotNull
    private final TabInfo tabInfo;
    private boolean isOnTab;
    private boolean isUpdated;

    public TabInfoProvider(@NotNull String title, @Nullable ActionGroup actionGroup) {
        EditorHeaderComponent editorHeaderComponent;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.actionGroup = actionGroup;
        this.panel = new JPanel(new BorderLayout());
        this.toolbar = this.createToolbar();
        TabInfoProvider tabInfoProvider = this;
        TabInfo tabInfo = new TabInfo((JComponent)new JBPanelWithEmptyText()).setText(title).setComponent((Component)this.panel);
        ActionToolbar actionToolbar = this.toolbar;
        if (actionToolbar != null) {
            EditorHeaderComponent editorHeaderComponent2;
            ActionToolbar actionToolbar2 = actionToolbar;
            TabInfo tabInfo2 = tabInfo;
            TabInfoProvider tabInfoProvider2 = tabInfoProvider;
            boolean bl = false;
            EditorHeaderComponent header = editorHeaderComponent2 = new EditorHeaderComponent();
            boolean bl2 = false;
            header.add((Component)this.toolbar.getComponent(), (Object)"East");
            header.setBorder((Border)JBUI.Borders.empty());
            EditorHeaderComponent editorHeaderComponent3 = editorHeaderComponent2;
            tabInfoProvider = tabInfoProvider2;
            tabInfo = tabInfo2;
            editorHeaderComponent = editorHeaderComponent3;
        } else {
            editorHeaderComponent = null;
        }
        TabInfo tabInfo3 = tabInfo.setSideComponent((JComponent)editorHeaderComponent);
        Intrinsics.checkNotNullExpressionValue((Object)tabInfo3, (String)"setSideComponent(...)");
        tabInfoProvider.tabInfo = tabInfo3;
        this.isUpdated = true;
    }

    @Nullable
    protected final ActionToolbar getToolbar() {
        return this.toolbar;
    }

    @NotNull
    public final TabInfo getTabInfo() {
        return this.tabInfo;
    }

    protected final boolean isOnTab() {
        return this.isOnTab;
    }

    protected final void setOnTab(boolean bl) {
        this.isOnTab = bl;
    }

    protected final boolean isUpdated() {
        return this.isUpdated;
    }

    protected final void setUpdated(boolean bl) {
        this.isUpdated = bl;
    }

    @NotNull
    public abstract CellViewer getViewer();

    public void onTabLeave() {
        this.isOnTab = false;
    }

    public void onTabEnter() {
        this.isOnTab = true;
        if (!this.isUpdated) {
            this.update(UpdateEvent.ContentChanged.INSTANCE);
            this.updateTabInfo();
        }
    }

    public void update(@Nullable UpdateEvent event) {
        this.isUpdated = false;
        CellViewer viewer = this.getViewer();
        if (!this.isUpdated) {
            viewer.update(event);
            this.isUpdated = true;
        }
    }

    public static /* synthetic */ void update$default(TabInfoProvider tabInfoProvider, UpdateEvent updateEvent, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            updateEvent = null;
        }
        tabInfoProvider.update(updateEvent);
    }

    protected final void updateTabInfo() {
        this.panel.removeAll();
        this.panel.add((Component)this.getViewer().getComponent(), "Center");
        this.tabInfo.setPreferredFocusableComponent(this.getViewer().getPreferedFocusComponent());
        ActionToolbar actionToolbar = this.toolbar;
        if (actionToolbar != null) {
            actionToolbar.setTargetComponent(this.getViewer().getToolbarTargetComponent());
        }
    }

    private final ActionToolbar createToolbar() {
        ActionToolbar actionToolbar;
        ActionGroup actionGroup = this.actionGroup;
        if (actionGroup != null) {
            ActionToolbar actionToolbar2;
            ActionGroup it = actionGroup;
            boolean bl = false;
            ActionToolbar $this$createToolbar_u24lambda_u243_u24lambda_u242 = actionToolbar2 = ActionManager.getInstance().createActionToolbar("EditorToolbar", it, true);
            boolean bl2 = false;
            $this$createToolbar_u24lambda_u243_u24lambda_u242.setReservePlaceAutoPopupIcon(false);
            actionToolbar = actionToolbar2;
        } else {
            actionToolbar = null;
        }
        return actionToolbar;
    }
}

