/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.run.ui.FormattedModeHandlerKt;
import com.intellij.database.run.ui.MinimizedFormat;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0006\u0010\u0019\u001a\u00020\u000eR \u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0018\u00010\u0010R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/run/ui/FormattedModeHandler;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "disableUpdateListener", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "enabled", "", "formatCache", "Lcom/intellij/database/run/ui/FormattedModeHandler$FormatCache;", "isEnabled", "minimize", "", "file", "Lcom/intellij/psi/PsiFile;", "reformat", "setEnabled", "v", "supportsCurrentValue", "Companion", "FormatCache", "intellij.grid.impl"})
public final class FormattedModeHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final Document document;
    @NotNull
    private final Project project;
    @NotNull
    private final Function1<Function0<Unit>, Unit> disableUpdateListener;
    private boolean enabled;
    @Nullable
    private FormatCache formatCache;
    @NotNull
    public static final String FORMATTED_MODE_DISABLED = "EditMaximizedView.FORMATTED_MODE_DISABLED";

    public FormattedModeHandler(@NotNull DataGrid grid, @NotNull Document document, @NotNull Project project, @NotNull Function1<? super Function0<Unit>, Unit> disableUpdateListener) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(disableUpdateListener, (String)"disableUpdateListener");
        this.grid = grid;
        this.document = document;
        this.project = project;
        this.disableUpdateListener = disableUpdateListener;
        if (!PropertiesComponent.getInstance().getBoolean(FORMATTED_MODE_DISABLED)) {
            this.enabled = true;
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean v) {
        PropertiesComponent.getInstance().setValue(FORMATTED_MODE_DISABLED, !v);
        this.enabled = v;
    }

    public final boolean supportsCurrentValue() {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(this.document);
        LightVirtualFile lightVirtualFile = virtualFile instanceof LightVirtualFile ? (LightVirtualFile)virtualFile : null;
        if (lightVirtualFile == null) {
            return false;
        }
        LightVirtualFile file = lightVirtualFile;
        Object value = FormattedModeHandlerKt.getSelectedValue(this.grid);
        String string = value instanceof String ? (String)value : null;
        if (string == null) {
            TextInfo textInfo = value instanceof TextInfo ? (TextInfo)value : null;
            string = textInfo != null ? textInfo.text : null;
        }
        String stringValue = string;
        return (value instanceof Map || value instanceof List || stringValue != null && !StringUtil.containsLineBreak((CharSequence)((Object)StringsKt.trim((CharSequence)stringValue)).toString())) && (file.getLanguage() instanceof JsonLanguage || file.getLanguage() instanceof XMLLanguage || Intrinsics.areEqual((Object)file.getLanguage().getID(), (Object)"MongoJS"));
    }

    public final void reformat() {
        if (!this.enabled || !this.supportsCurrentValue()) {
            return;
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> FormattedModeHandler.reformat$lambda$0(this));
    }

    @NotNull
    public final String minimize(@NotNull PsiFile file) {
        String string;
        MinimizedFormat format;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FormatCache formatCache = this.formatCache;
        MinimizedFormat minimizedFormat = format = formatCache != null ? formatCache.get() : null;
        if (format == null || !this.enabled || !this.supportsCurrentValue()) {
            String string2 = file.getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        } else {
            string = format.restore(file);
        }
        return string;
    }

    private static final void reformat$lambda$0(FormattedModeHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PsiDocumentManager.getInstance((Project)this$0.project).commitDocument(this$0.document);
        Object value = FormattedModeHandlerKt.getSelectedValue(this$0.grid);
        MinimizedFormat minimizedFormat = FormattedModeHandlerKt.access$detectFormat(this$0.grid, value, this$0.project, this$0.document);
        if (minimizedFormat == null) {
            return;
        }
        MinimizedFormat format = minimizedFormat;
        this$0.formatCache = this$0.new FormatCache(format);
        format.reformat(this$0.disableUpdateListener);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/run/ui/FormattedModeHandler$Companion;", "", "()V", "FORMATTED_MODE_DISABLED", "", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/run/ui/FormattedModeHandler$FormatCache;", "", "format", "Lcom/intellij/database/run/ui/MinimizedFormat;", "(Lcom/intellij/database/run/ui/FormattedModeHandler;Lcom/intellij/database/run/ui/MinimizedFormat;)V", "column", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridColumn;", "getColumn", "()Lcom/intellij/database/datagrid/ModelIndex;", "getFormat", "()Lcom/intellij/database/run/ui/MinimizedFormat;", "row", "Lcom/intellij/database/datagrid/GridRow;", "getRow", "get", "intellij.grid.impl"})
    private final class FormatCache {
        @NotNull
        private final MinimizedFormat format;
        @NotNull
        private final ModelIndex<GridRow> row;
        @NotNull
        private final ModelIndex<GridColumn> column;

        public FormatCache(MinimizedFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            this.format = format;
            ModelIndex modelIndex = FormattedModeHandler.this.grid.getSelectionModel().getLeadSelectionRow();
            Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionRow(...)");
            this.row = modelIndex;
            ModelIndex modelIndex2 = FormattedModeHandler.this.grid.getSelectionModel().getLeadSelectionColumn();
            Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionColumn(...)");
            this.column = modelIndex2;
        }

        @NotNull
        public final MinimizedFormat getFormat() {
            return this.format;
        }

        @NotNull
        public final ModelIndex<GridRow> getRow() {
            return this.row;
        }

        @NotNull
        public final ModelIndex<GridColumn> getColumn() {
            return this.column;
        }

        @Nullable
        public final MinimizedFormat get() {
            return Intrinsics.areEqual(this.row, (Object)FormattedModeHandler.this.grid.getSelectionModel().getLeadSelectionRow()) && Intrinsics.areEqual(this.column, (Object)FormattedModeHandler.this.grid.getSelectionModel().getLeadSelectionColumn()) ? this.format : null;
        }
    }
}

