/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridCellTypeListener;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.EditMaximizedViewRequestPlace;
import com.intellij.database.run.ui.EditorCellViewer;
import com.intellij.database.run.ui.FormattedModeHandler;
import com.intellij.database.run.ui.UpdateEvent;
import com.intellij.database.run.ui.ValueParserCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\"\u0018\u0000 D2\u00020\u0001:\u0001DB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0*H\u0002J\b\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020(H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0002J\u0016\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0019J\u0006\u00104\u001a\u00020(J,\u00105\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020.2\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\f\u00109\u001a\b\u0012\u0004\u0012\u00020:07H\u0002J\u0012\u0010;\u001a\u00020(2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u001a\u0010>\u001a\u00020(2\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J\b\u0010C\u001a\u00020(H\u0002J.\u0010C\u001a\u00020(2\b\u0010\u0011\u001a\u0004\u0018\u00010.2\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\f\u00109\u001a\b\u0012\u0004\u0012\u00020:07H\u0002R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R$\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/intellij/database/run/ui/EditorCellViewer;", "Lcom/intellij/database/run/ui/CellViewer;", "project", "Lcom/intellij/openapi/project/Project;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "editable", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/datagrid/DataGrid;Z)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "formattedModeHandler", "Lcom/intellij/database/run/ui/FormattedModeHandler;", "value", "isFormattedMode", "()Z", "setFormattedMode", "(Z)V", "isFormattedModeSupported", "isSoftWraps", "setSoftWraps", "", "offset", "getOffset", "()I", "setOffset", "(I)V", "preferedFocusComponent", "getPreferedFocusComponent", "updateDocumentListener", "com/intellij/database/run/ui/EditorCellViewer$updateDocumentListener$1", "Lcom/intellij/database/run/ui/EditorCellViewer$updateDocumentListener$1;", "valueParserCache", "Lcom/intellij/database/run/ui/ValueParserCache;", "createEditor", "disableUpdateListener", "", "action", "Lkotlin/Function0;", "dispose", "documentChanged", "getData", "", "dataId", "", "select", "start", "end", "selectAll", "setText", "rowIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "columnIdx", "Lcom/intellij/database/datagrid/GridColumn;", "update", "event", "Lcom/intellij/database/run/ui/UpdateEvent;", "updateLanguage", "language", "Lcom/intellij/lang/Language;", "fragment", "Lcom/intellij/psi/PsiCodeFragment;", "updateText", "Companion", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nEditorCellViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellViewer.kt\ncom/intellij/database/run/ui/EditorCellViewer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1747#2,3:298\n*S KotlinDebug\n*F\n+ 1 EditorCellViewer.kt\ncom/intellij/database/run/ui/EditorCellViewer\n*L\n89#1:298,3\n*E\n"})
public final class EditorCellViewer
implements CellViewer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final FormattedModeHandler formattedModeHandler;
    @NotNull
    private final ValueParserCache valueParserCache;
    @NotNull
    private final updateDocumentListener.1 updateDocumentListener;
    @NotNull
    private static final String SOFT_WRAPS_DISABLED = "EditMaximizedView.SOFT_WRAPS_DISABLED";
    @NotNull
    private static final Key<LineSeparator> LINE_SEPARATOR_KEY;

    public EditorCellViewer(@NotNull Project project, @NotNull DataGrid grid, boolean editable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.project = project;
        this.grid = grid;
        this.editor = this.createEditor(editable);
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        this.formattedModeHandler = new FormattedModeHandler(this.grid, (Document)documentEx, this.project, (Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>((Object)this){

            public final void invoke(@NotNull Function0<Unit> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                EditorCellViewer.access$disableUpdateListener((EditorCellViewer)this.receiver, p0);
            }
        }));
        this.valueParserCache = new ValueParserCache(this.grid);
        this.updateDocumentListener = new DocumentListener(this){
            final /* synthetic */ EditorCellViewer this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EditorCellViewer.access$documentChanged(this.this$0);
            }
        };
        this.editor.getDocument().addDocumentListener((DocumentListener)this.updateDocumentListener);
        DataManager.registerDataProvider((JComponent)this.editor.getComponent(), this::getData);
        DataGridCellTypeListener.addDataGridListener(this.grid, (arg_0, arg_1) -> EditorCellViewer._init_$lambda$2(this, arg_0, arg_1), this);
        this.grid.addDataGridListener(new DataGridListener(){

            @Override
            public void onCellDisplayTypeChanged(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull DisplayType type) {
                Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                DataGridListener.super.onCellDisplayTypeChanged(columnIdx, type);
            }

            @Override
            public void onContentChanged(@Nullable DataGrid dataGrid, @Nullable GridRequestSource.RequestPlace place) {
                valueParserCache.clearCache();
            }
        }, this);
    }

    public final boolean isSoftWraps() {
        return this.editor.getSettings().isUseSoftWraps();
    }

    public final void setSoftWraps(boolean value) {
        PropertiesComponent.getInstance().setValue(SOFT_WRAPS_DISABLED, !value);
        this.editor.getSettings().setUseSoftWraps(value);
    }

    public final boolean isFormattedModeSupported() {
        return this.formattedModeHandler.supportsCurrentValue();
    }

    public final boolean isFormattedMode() {
        return this.formattedModeHandler.isEnabled();
    }

    public final void setFormattedMode(boolean value) {
        if (value == this.formattedModeHandler.isEnabled()) {
            return;
        }
        this.formattedModeHandler.setEnabled(value);
        if (value) {
            this.formattedModeHandler.reformat();
        } else {
            this.updateText();
        }
    }

    public final int getOffset() {
        return this.editor.getCaretModel().getOffset();
    }

    public final void setOffset(int value) {
        if (value >= 0 && value <= this.editor.getDocument().getTextLength()) {
            this.editor.getCaretModel().moveToOffset(value);
            this.editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent getPreferedFocusComponent() {
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return jComponent;
    }

    private final void disableUpdateListener(Function0<Unit> action) {
        this.editor.getDocument().removeDocumentListener((DocumentListener)this.updateDocumentListener);
        action.invoke();
        this.editor.getDocument().addDocumentListener((DocumentListener)this.updateDocumentListener);
    }

    private final Object getData(String dataId) {
        return CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId) ? this.editor : null;
    }

    public void dispose() {
        if (!this.editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.editor);
        }
    }

    @Override
    public void update(@Nullable UpdateEvent event) {
        if (event instanceof UpdateEvent.ValueChanged) {
            this.editor.getSelectionModel().removeSelection();
            ModelIndex modelIndex = this.grid.getSelectionModel().getLeadSelectionColumn();
            Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionColumn(...)");
            ModelIndex columnIdx = modelIndex;
            ModelIndex modelIndex2 = this.grid.getSelectionModel().getLeadSelectionRow();
            Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionRow(...)");
            ModelIndex rowIdx = modelIndex2;
            this.updateText(((UpdateEvent.ValueChanged)event).getValue(), (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx);
            return;
        }
        this.editor.getSelectionModel().removeSelection();
        this.updateText();
    }

    private final EditorEx createEditor(boolean editable) {
        EditorEx editorEx;
        LightVirtualFile virtualFile = new LightVirtualFile("Value Editor", (Language)PlainTextLanguage.INSTANCE, (CharSequence)"");
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        Document document2 = document;
        Intrinsics.checkNotNull((Object)document2);
        Document document3 = document2;
        if (editable) {
            Editor editor = EditorFactory.getInstance().createEditor(document3, this.project);
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            editorEx = (EditorEx)editor;
        } else {
            Editor editor = EditorFactory.getInstance().createViewer(document3, this.project);
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            editorEx = (EditorEx)editor;
        }
        EditorEx editor = editorEx;
        editor.getScrollPane().setBorder(null);
        editor.setShowPlaceholderWhenFocused(true);
        editor.setContextMenuGroupId("Console.TableResult.CellEditor.Popup");
        editor.getSettings().setUseSoftWraps(!PropertiesComponent.getInstance().getBoolean(SOFT_WRAPS_DISABLED));
        editor.getSettings().setLineNumbersShown(false);
        editor.putUserData(CellViewer.CELL_VIEWER_KEY, (Object)this);
        return editor;
    }

    private final void updateText() {
        ModelIndex modelIndex = this.grid.getSelectionModel().getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionRow(...)");
        ModelIndex rowIdx = modelIndex;
        ModelIndex modelIndex2 = this.grid.getSelectionModel().getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionColumn(...)");
        ModelIndex columnIdx = modelIndex2;
        if (!rowIdx.isValid((CoreGrid)this.grid) || !columnIdx.isValid((CoreGrid)this.grid)) {
            return;
        }
        GridModel gridModel = this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel model2 = gridModel;
        Object value = model2.getValueAt(rowIdx, columnIdx);
        this.updateText(value, (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx);
    }

    private final void updateText(Object value, ModelIndex<GridRow> rowIdx, ModelIndex<GridColumn> columnIdx) {
        Object object = value;
        if (object == null) {
            object = ReservedCellValue.NULL;
        }
        this.setText(object, rowIdx, columnIdx);
        Language language = DefaultTextRendererFactory.getLanguage(this.grid, rowIdx, columnIdx);
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        PsiCodeFragment fragment = GridHelper.get(this.grid).createCellCodeFragment(this.editor.getDocument().getText(), this.project, this.grid, rowIdx, columnIdx);
        this.updateLanguage(language2, fragment);
    }

    private final void updateLanguage(Language language, PsiCodeFragment fragment) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)this.editor.getDocument());
        LightVirtualFile lightVirtualFile = virtualFile instanceof LightVirtualFile ? (LightVirtualFile)virtualFile : null;
        if (lightVirtualFile == null) {
            return;
        }
        LightVirtualFile virtualFile2 = lightVirtualFile;
        if (!Intrinsics.areEqual((Object)virtualFile2.getLanguage(), (Object)language)) {
            virtualFile2.setLanguage(language);
            EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((Project)this.project, (VirtualFile)((VirtualFile)virtualFile2));
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"createHighlighter(...)");
            EditorHighlighter highlighter = editorHighlighter;
            this.editor.setHighlighter(highlighter);
        }
        if (fragment != null) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
            Intrinsics.checkNotNull((Object)psiDocumentManager, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiDocumentManagerBase");
            ((PsiDocumentManagerBase)psiDocumentManager).associatePsi((Document)this.editor.getDocument(), (PsiFile)fragment);
        } else {
            VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile2};
            FileContentUtilCore.reparseFiles((VirtualFile[])virtualFileArray);
        }
        this.formattedModeHandler.reformat();
    }

    public final void select(int start, int end) {
        int len = this.editor.getDocument().getTextLength();
        this.editor.getSelectionModel().setSelection(Math.min(len, Math.max(0, start)), Math.min(len, end));
    }

    public final void selectAll() {
        this.editor.getSelectionModel().setSelection(0, this.editor.getDocument().getTextLength());
    }

    private final void setText(Object value, ModelIndex<GridRow> rowIdx, ModelIndex<GridColumn> columnIdx) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        this.disableUpdateListener((Function0<Unit>)((Function0)new Function0<Unit>(value, this, rowIdx, columnIdx, document){
            final /* synthetic */ Object $value;
            final /* synthetic */ EditorCellViewer this$0;
            final /* synthetic */ ModelIndex<GridRow> $rowIdx;
            final /* synthetic */ ModelIndex<GridColumn> $columnIdx;
            final /* synthetic */ DocumentEx $document;
            {
                this.$value = $value;
                this.this$0 = $receiver;
                this.$rowIdx = $rowIdx;
                this.$columnIdx = $columnIdx;
                this.$document = $document;
                super(0);
            }

            public final void invoke() {
                ApplicationManager.getApplication().runWriteAction(() -> setText.1.invoke$lambda$0(this.this$0, this.$rowIdx, this.$columnIdx, this.$value, this.$document));
                if (this.$value instanceof ReservedCellValue) {
                    EditorCellViewer.access$getEditor$p(this.this$0).setPlaceholder((CharSequence)((ReservedCellValue)this.$value).getDisplayName());
                } else {
                    EditorCellViewer.access$getEditor$p(this.this$0).setPlaceholder(null);
                }
            }

            private static final void invoke$lambda$0(EditorCellViewer this$0, ModelIndex $rowIdx, ModelIndex $columnIdx, Object $value, DocumentEx $document) {
                VirtualFile file;
                GridCellEditorFactory.ValueFormatter valueFormatter;
                GridCellEditorFactory gridCellEditorFactory;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$rowIdx, (String)"$rowIdx");
                Intrinsics.checkNotNullParameter((Object)$columnIdx, (String)"$columnIdx");
                Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
                Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
                int offsetBefore = this$0.getOffset();
                GridCellEditorFactoryProvider gridCellEditorFactoryProvider = GridCellEditorFactoryProvider.get(EditorCellViewer.access$getGrid$p(this$0));
                GridCellEditorFactory.ValueFormatter formatter = gridCellEditorFactoryProvider != null && (gridCellEditorFactory = gridCellEditorFactoryProvider.getEditorFactory(EditorCellViewer.access$getGrid$p(this$0), (ModelIndex<GridRow>)$rowIdx, (ModelIndex<GridColumn>)$columnIdx)) != null && (valueFormatter = gridCellEditorFactory.getValueFormatter(EditorCellViewer.access$getGrid$p(this$0), (ModelIndex<GridRow>)$rowIdx, (ModelIndex<GridColumn>)$columnIdx, $value)) != null ? valueFormatter : (GridCellEditorFactory.ValueFormatter)new GridCellEditorFactory.DefaultValueToText(EditorCellViewer.access$getGrid$p(this$0), (ModelIndex<GridColumn>)$columnIdx, $value);
                GridCellEditorFactory.ValueFormatterResult valueFormatterResult = formatter.format();
                Intrinsics.checkNotNullExpressionValue((Object)valueFormatterResult, (String)"format(...)");
                GridCellEditorFactory.ValueFormatterResult result = valueFormatterResult;
                VirtualFile virtualFile = file = FileDocumentManager.getInstance().getFile((Document)$document);
                if (virtualFile != null) {
                    virtualFile.setCharset(result.charset);
                }
                VirtualFile virtualFile2 = file;
                if (virtualFile2 != null) {
                    virtualFile2.setBOM(result.bom);
                }
                Document document = (Document)$document;
                String string = result.text;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                com.intellij.database.run.ui.EditorCellViewer$Companion.access$setText(EditorCellViewer.Companion, document, string);
                this$0.setOffset(Math.min(offsetBefore, $document.getTextLength()));
            }
        }));
    }

    private final void documentChanged() {
        String string;
        this.editor.setPlaceholder(null);
        ModelIndex modelIndex = this.grid.getSelectionModel().getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionRow(...)");
        ModelIndex row = modelIndex;
        ModelIndex modelIndex2 = this.grid.getSelectionModel().getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionColumn(...)");
        ModelIndex column = modelIndex2;
        if (!row.isValid((CoreGrid)this.grid) || !column.isValid((CoreGrid)this.grid)) {
            return;
        }
        GridCellEditorFactory.ValueParser parser = this.valueParserCache.getValueParser((ModelIndex<GridRow>)row, (ModelIndex<GridColumn>)column);
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        PsiDocumentManager.getInstance((Project)this.project).commitDocument((Document)document);
        PsiFile file = PsiDocumentManager.getInstance((Project)this.project).getPsiFile((Document)document);
        if (file != null) {
            string = EditorCellViewer.Companion.getText((Document)document, this.formattedModeHandler.minimize(file));
        } else {
            Document document2 = (Document)document;
            String string2 = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            string = EditorCellViewer.Companion.getText(document2, string2);
        }
        String text = string;
        Object object = parser.parse(text, (Document)document);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parse(...)");
        Object value = object;
        this.grid.getResultView().setValueAt(value, (ModelIndex<GridRow>)row, (ModelIndex<GridColumn>)column, false, new GridRequestSource((GridRequestSource.RequestPlace)new EditMaximizedViewRequestPlace(this.grid, this)));
    }

    private static final void _init_$lambda$2(EditorCellViewer this$0, ModelIndexSet rows, ModelIndexSet columns) {
        ModelIndex it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block8: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
            Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
            JBIterable jBIterable = rows.asIterable();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"asIterable(...)");
            $this$any$iv = (Iterable)jBIterable;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (ModelIndex)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, this$0.valueParserCache.getRow())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            boolean bl3;
            block9: {
                JBIterable jBIterable = columns.asIterable();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"asIterable(...)");
                $this$any$iv = (Iterable)jBIterable;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ModelIndex)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it, this$0.valueParserCache.getColumn())) continue;
                        bl3 = true;
                        break block9;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                this$0.valueParserCache.clearCache();
            }
        }
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(EditorCellViewer $this) {
        return $this.editor;
    }

    public static final /* synthetic */ DataGrid access$getGrid$p(EditorCellViewer $this) {
        return $this.grid;
    }

    public static final /* synthetic */ void access$disableUpdateListener(EditorCellViewer $this, Function0 action) {
        $this.disableUpdateListener((Function0<Unit>)action);
    }

    public static final /* synthetic */ void access$documentChanged(EditorCellViewer $this) {
        $this.documentChanged();
    }

    static {
        Key key = Key.create((String)"EDIT_MAXIMIZED_ETF_LINE_SEPARATOR");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LINE_SEPARATOR_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/run/ui/EditorCellViewer$Companion;", "", "()V", "LINE_SEPARATOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/util/LineSeparator;", "SOFT_WRAPS_DISABLED", "", "getText", "document", "Lcom/intellij/openapi/editor/Document;", "text", "setText", "", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String getText(Document document, String text) {
            String string;
            LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)document);
            if (separator == null) {
                string = text;
            } else {
                String string2 = StringUtil.convertLineSeparators((String)text, (String)separator.getSeparatorString());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertLineSeparators(...)");
            }
            return string;
        }

        private final void setText(Document document, String text) {
            LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)document);
            if (separator == null) {
                separator = StringUtil.detectSeparators((CharSequence)text);
            }
            LINE_SEPARATOR_KEY.set((UserDataHolder)document, (Object)separator);
            document.setText((CharSequence)StringUtil.convertLineSeparators((String)text));
        }

        public static final /* synthetic */ void access$setText(Companion $this, Document document, String text) {
            $this.setText(document, text);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

