/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.run.actions.ColumnHeaderActionBase;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.table.LocalFilterState;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/database/run/actions/ColumnLocalFilterWithCellAction;", "Lcom/intellij/database/run/actions/ColumnHeaderActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "columnIdxs", "Lcom/intellij/database/datagrid/ModelIndexSet;", "Lcom/intellij/database/datagrid/GridColumn;", "update", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nColumnLocalFilterWithCellAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnLocalFilterWithCellAction.kt\ncom/intellij/database/run/actions/ColumnLocalFilterWithCellAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1855#2,2:40\n*S KotlinDebug\n*F\n+ 1 ColumnLocalFilterWithCellAction.kt\ncom/intellij/database/run/actions/ColumnLocalFilterWithCellAction\n*L\n28#1:40,2\n*E\n"})
public final class ColumnLocalFilterWithCellAction
extends ColumnHeaderActionBase {
    public ColumnLocalFilterWithCellAction() {
        super(true);
    }

    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> columnIdxs) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columnIdxs, (String)"columnIdxs");
        e.getPresentation().setEnabledAndVisible(grid.getPresentationMode() == GridPresentationMode.TABLE && !grid.getResultView().isTransposed() && columnIdxs.size() == 1);
    }

    @Override
    protected void actionPerformed(@Nullable AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> columnIdxs) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columnIdxs, (String)"columnIdxs");
        if (columnIdxs.size() != 1) {
            return;
        }
        ResultView resultView = grid.getResultView();
        Intrinsics.checkNotNullExpressionValue((Object)resultView, (String)"getResultView(...)");
        ResultView resultView2 = resultView;
        if (!(resultView2 instanceof TableResultView)) {
            return;
        }
        Index index = columnIdxs.first();
        Intrinsics.checkNotNullExpressionValue((Object)index, (String)"first(...)");
        ModelIndex columnIdx = (ModelIndex)index;
        List<GridRow> list = GridUtil.getSelectedGridRows(grid);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSelectedGridRows(...)");
        List<GridRow> rows = list;
        ((TableResultView)resultView2).getLocalFilterState().clearFilterForColumn((ModelIndex<GridColumn>)columnIdx);
        Iterable $this$forEach$iv = rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String text;
            GridRow row = (GridRow)element$iv;
            boolean bl = false;
            int rowIdx = GridRow.toRealIdx((GridRow)row);
            Intrinsics.checkNotNullExpressionValue((Object)GridUtil.getText(grid, (ModelIndex<GridRow>)ModelIndex.forRow((CoreGrid)grid, (int)rowIdx), (ModelIndex<GridColumn>)columnIdx, DataAccessType.DATA_WITH_MUTATIONS), (String)"getText(...)");
            ((TableResultView)resultView2).getLocalFilterState().enableForColumn((ModelIndex<GridColumn>)columnIdx, new LocalFilterState.Value(row.getValue(columnIdx.value), text));
        }
        ((TableResultView)resultView2).getLocalFilterState().setEnabled(true);
        ((TableResultView)resultView2).updateRowFilter();
        grid.getPanel().getComponent().repaint();
    }
}

