/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.HideEditMaximizedAction;
import com.intellij.database.actions.ShowEditMaximizedAction;
import com.intellij.database.actions.ToggleEditMaximizedViewAction;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.database.run.ui.EditMaximizedViewKt;
import com.intellij.database.run.ui.TabInfoProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/actions/ToggleEditMaximizedViewAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.grid.impl"})
public final class ToggleEditMaximizedViewAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        DataGrid grid = GridUtil.getDataGrid(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(grid != null);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return EditMaximizedViewKt.findEditMaximized(dataContext) != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid grid = GridUtil.getDataGrid(e.getDataContext());
        if (grid == null) {
            return;
        }
        EditMaximizedView view = ShowEditMaximizedAction.getView(grid, e);
        if (state) {
            view.open((Function1<? super TabInfoProvider, Boolean>)((Function1)setSelected.1.INSTANCE));
            if (grid.isEditable()) {
                JComponent focusComponent;
                JComponent jComponent = focusComponent = view.getPreferedFocusComponent();
                if (jComponent != null) {
                    jComponent.requestFocus();
                }
            }
        } else {
            HideEditMaximizedAction.hideValueEditor(grid, view);
        }
    }
}

