/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.util.ArrayUtil;
import com.intellij.rt.coverage.util.ErrorReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LineMapper<T extends CoverageData> {
    protected abstract T createNewLine(T var1, int var2);

    protected abstract T[] createArray(int var1);

    protected abstract T[] getLines(ClassData var1);

    /*
     * WARNING - void declaration
     */
    public T[] mapLines(LineMapData[] linesMap, ClassData sourceClassData, ClassData targetClassData) {
        CoverageData[] oldLines = this.getLines(sourceClassData);
        if (linesMap == null) {
            return oldLines;
        }
        if (sourceClassData == targetClassData && oldLines == null) {
            return null;
        }
        try {
            void var1_1;
            CoverageData[] sourceLines = this.getSourceLinesArray(linesMap, sourceClassData, targetClassData);
            CoverageData[] targetLines = this.getLines(targetClassData);
            for (void mapData : var1_1) {
                for (int index = 0; index < mapData.getCount(); ++index) {
                    CoverageData source;
                    CoverageData targetLineData;
                    int sourceLineNumber = mapData.getSourceLine(index);
                    if (!sourceClassData.isIgnoredLine(sourceLineNumber) && ArrayUtil.safeLoad(sourceLines, sourceLineNumber) == null && (targetLineData = ArrayUtil.safeLoad(targetLines, mapData.getMappingStart(index))) != null) {
                        source = this.createNewLine(targetLineData, sourceLineNumber);
                        ArrayUtil.safeStore(sourceLines, sourceLineNumber, source);
                    }
                    for (int targetLineNumber = mapData.getMappingStart(index); targetLineNumber < mapData.getMappingEnd(index); ++targetLineNumber) {
                        source = ArrayUtil.safeLoad(sourceLines, sourceLineNumber);
                        CoverageData target = ArrayUtil.safeLoad(targetLines, targetLineNumber);
                        if (target == null) continue;
                        if (source != null) {
                            source.merge(target);
                        }
                        if (sourceClassData == targetClassData && targetLineNumber == sourceLineNumber) continue;
                        targetLines[targetLineNumber] = null;
                    }
                }
            }
            return sourceLines;
        }
        catch (Throwable e) {
            void var3_3;
            ErrorReporter.warn("Error creating line mappings for " + var3_3.getName(), e);
            return oldLines;
        }
    }

    /*
     * WARNING - void declaration
     */
    private T[] getSourceLinesArray(LineMapData[] linesMap, ClassData sourceClassData, ClassData targetClassData) {
        void var1_3;
        void var2_4;
        void var3_5;
        int maxMappedSourceLineNumber = LineMapper.maxSourceLineNumber(linesMap);
        CoverageData[] currentLines = this.getLines(sourceClassData);
        if (var3_5 == var2_4) {
            return currentLines;
        }
        if (currentLines == null) {
            return this.createArray(maxMappedSourceLineNumber + 1);
        }
        if (currentLines.length >= maxMappedSourceLineNumber + 1) {
            return currentLines;
        }
        CoverageData[] sourceLines = this.createArray(maxMappedSourceLineNumber + 1);
        System.arraycopy(currentLines, 0, sourceLines, 0, currentLines.length);
        return var1_3;
    }

    public static <T> void dropMappedLines(FileMapData[] mappings, T[] lines, String className) {
        FileMapData[] fileMapDataArray = mappings;
        int n = mappings.length;
        for (int i = 0; i < n; ++i) {
            FileMapData mapData = fileMapDataArray[i];
            boolean isThisClass = className.equals(mapData.getClassName());
            for (LineMapData lineMapData : mapData.getLines()) {
                for (int index = 0; index < lineMapData.getCount(); ++index) {
                    int sourceLineNumber = lineMapData.getSourceLine(index);
                    for (int i2 = lineMapData.getMappingStart(index); i2 < lineMapData.getMappingEnd(index) && i2 < lines.length; ++i2) {
                        if (isThisClass && i2 == sourceLineNumber) continue;
                        lines[i2] = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int maxSourceLineNumber(LineMapData[] linesMap) {
        void var1_1;
        LineMapData[] lineMapDataArray;
        int max = 0;
        for (LineMapData mapData : lineMapDataArray) {
            for (int index = 0; index < mapData.getCount(); ++index) {
                max = Math.max(max, mapData.getSourceLine(index));
            }
        }
        return (int)var1_1;
    }
}

