/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.thinClientLink;

import com.intellij.idea.LoggerFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.remoteDev.downloader.CodeWithMeGuestLauncher;
import com.intellij.remoteDev.thinClientLink.ClientToGtwMessage;
import com.intellij.remoteDev.thinClientLink.GtwToClientMessage;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.intellij.util.UriUtilKt;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.thinClientLink.ClientLifetimeTracker;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import io.netty.buffer.Unpooled;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.webSocket.WebSocketClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 a2\u00020\u0001:\u0001aB/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010I\u001a\u00020\u00132\u0006\u0010J\u001a\u0002032\u0006\u0010K\u001a\u00020%H\u0000\u00a2\u0006\u0002\bLJ\u0006\u0010M\u001a\u00020\u0013J\b\u0010N\u001a\u00020\u0007H\u0002J\u0006\u0010O\u001a\u00020\u0013J\u0010\u0010P\u001a\u00020\u00132\u0006\u0010Q\u001a\u00020\u0007H\u0002J\u0006\u0010R\u001a\u00020\u0013J\u001d\u0010S\u001a\u00020\u00132\u000e\b\u0002\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00130UH\u0000\u00a2\u0006\u0002\bVJ\b\u0010W\u001a\u00020\u0013H\u0002J\b\u0010X\u001a\u00020\u0013H\u0002J\u000e\u0010Y\u001a\u00020\u00132\u0006\u0010Z\u001a\u00020\u0018J\u0010\u0010[\u001a\u00020\u00132\u0006\u0010\\\u001a\u00020*H\u0002J\u0018\u0010[\u001a\u00020\u00132\u0006\u0010K\u001a\u00020%2\u0006\u0010\\\u001a\u00020*H\u0002J\r\u0010]\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b^J\u0016\u0010_\u001a\u00020\u00132\u0006\u0010Q\u001a\u00020\u00072\u0006\u0010`\u001a\u00020\u001bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010,R\u000e\u0010-\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010/\u001a\u0004\u0018\u00010\u00072\b\u0010.\u001a\u0004\u0018\u00010\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0016R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020<0'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00180'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010B\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00130'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010D\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010E\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u001dR\u000e\u0010G\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\"\u00a8\u0006b"}, d2={"Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "", "uid", "", "lifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "initialGwwsLink", "Ljava/net/URI;", "clientLifetimeTracker", "Lcom/jetbrains/gateway/thinClientLink/ClientLifetimeTracker;", "clientVersion", "(Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Ljava/net/URI;Lcom/jetbrains/gateway/thinClientLink/ClientLifetimeTracker;Ljava/lang/String;)V", "askLongsMessagesCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "clientCapabilities", "Lcom/intellij/remoteDev/thinClientLink/ClientToGtwMessage$ClientCapabilities;", "clientClosed", "Lcom/jetbrains/rd/util/reactive/ISource;", "", "Lcom/jetbrains/rd/util/reactive/IVoidSource;", "getClientClosed", "()Lcom/jetbrains/rd/util/reactive/ISource;", "clientFailedToOpenProject", "", "getClientFailedToOpenProject", "clientPresent", "", "getClientPresent", "()Z", "clientProcessTerminated", "Ljava/util/concurrent/CompletableFuture;", "clientRestartMessagesCounter", "getClientVersion", "()Ljava/lang/String;", "clients", "", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "closedSignalImpl", "Lcom/jetbrains/rd/util/reactive/Signal;", "closingMessagesCounter", "currentConnectionStateMessage", "Lcom/intellij/remoteDev/thinClientLink/GtwToClientMessage;", "currentNewUiState", "Ljava/lang/Boolean;", "gwwsLink", "<set-?>", "lastSeenLink", "getLastSeenLink$intellij_gateway_core", "()Ljava/net/URI;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "linkUpdatedFuture", "meter", "Lio/opentelemetry/api/metrics/Meter;", "onClientPresenceChanged", "getOnClientPresenceChanged", "onMessage", "Lcom/intellij/remoteDev/thinClientLink/ClientToGtwMessage;", "getOnMessage$intellij_gateway_core", "()Lcom/jetbrains/rd/util/reactive/Signal;", "openFailedSignalImpl", "pingLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "pingMessagesCounter", "presenceChangeSignal", "projectOpenFailedMessagesCounter", "restartNeeded", "getRestartNeeded", "timeoutTicks", "getUid", "clientConnected", "clientLifetime", "client", "clientConnected$intellij_gateway_core", "close", "createGwwsLinkWithUpdatedFragmentParams", "focusClientWindow", "handleNewUiSwitch", "newLink", "notifyReconnect", "onClientLaunch", "onStarted", "Lkotlin/Function0;", "onClientLaunch$intellij_gateway_core", "onProcessTermination", "prepareLaunchAfterRestart", "reportNetworkLatency", "latency", "sendMessage", "message", "startPingingClient", "startPingingClient$intellij_gateway_core", "updateJoinLink", "reconnectIfConnected", "Companion", "intellij.gateway.core"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nThinClientHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientHandle.kt\ncom/jetbrains/gateway/thinClientLink/ThinClientHandle\n+ 2 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,341:1\n39#2,5:342\n1855#3,2:347\n11#4:349\n*S KotlinDebug\n*F\n+ 1 ThinClientHandle.kt\ncom/jetbrains/gateway/thinClientLink/ThinClientHandle\n*L\n71#1:342,5\n296#1:347,2\n337#1:349\n*E\n"})
public final class ThinClientHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String uid;
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final ClientLifetimeTracker clientLifetimeTracker;
    @NotNull
    private final String clientVersion;
    @NotNull
    private final Signal<Unit> presenceChangeSignal;
    @NotNull
    private final Signal<Unit> closedSignalImpl;
    @NotNull
    private final Signal<Integer> openFailedSignalImpl;
    @NotNull
    private final Signal<ClientToGtwMessage> onMessage;
    private int timeoutTicks;
    @NotNull
    private final Set<WebSocketClient> clients;
    @NotNull
    private final Meter meter;
    private final LongCounter pingMessagesCounter;
    private final LongCounter closingMessagesCounter;
    private final LongCounter askLongsMessagesCounter;
    private final LongCounter clientRestartMessagesCounter;
    private final LongCounter projectOpenFailedMessagesCounter;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final SequentialLifetimes pingLifetimes;
    @NotNull
    private GtwToClientMessage currentConnectionStateMessage;
    @NotNull
    private ClientToGtwMessage.ClientCapabilities clientCapabilities;
    private boolean restartNeeded;
    @Nullable
    private CompletableFuture<Boolean> linkUpdatedFuture;
    @Nullable
    private CompletableFuture<Boolean> clientProcessTerminated;
    @NotNull
    private final URI gwwsLink;
    @Nullable
    private Boolean currentNewUiState;
    @Nullable
    private URI lastSeenLink;
    @NotNull
    private static final KSerializer<GtwToClientMessage> serializer = GtwToClientMessage.Companion.serializer();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final GtwToClientMessage.GatewayCapabilities gatewayCapabilities;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThinClientHandle(@NotNull String uid, @NotNull LifetimeDefinition lifetimeDef, @NotNull URI initialGwwsLink, @NotNull ClientLifetimeTracker clientLifetimeTracker2, @NotNull String clientVersion) {
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        Intrinsics.checkNotNullParameter((Object)lifetimeDef, (String)"lifetimeDef");
        Intrinsics.checkNotNullParameter((Object)initialGwwsLink, (String)"initialGwwsLink");
        Intrinsics.checkNotNullParameter((Object)clientLifetimeTracker2, (String)"clientLifetimeTracker");
        Intrinsics.checkNotNullParameter((Object)clientVersion, (String)"clientVersion");
        this.uid = uid;
        this.lifetimeDef = lifetimeDef;
        this.clientLifetimeTracker = clientLifetimeTracker2;
        this.clientVersion = clientVersion;
        this.presenceChangeSignal = new Signal();
        this.closedSignalImpl = new Signal();
        this.openFailedSignalImpl = new Signal();
        this.onMessage = new Signal();
        ConcurrentHashMap.KeySetView keySetView = new ConcurrentHashMap().keySet(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"keySet(...)");
        this.clients = keySetView;
        this.meter = TelemetryManager.Companion.getMeter(RdctScopesKt.RDCT);
        this.pingMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.pingMessages").setUnit("messages").build();
        this.closingMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.closingMessages").setUnit("messages").build();
        this.askLongsMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.askLogsMessages").setUnit("messages").build();
        this.clientRestartMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.clientRestartMessages").setUnit("messages").build();
        this.projectOpenFailedMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.projectOpenFailedMessagesMessages").setUnit("messages").build();
        this.lifetime = (Lifetime)this.lifetimeDef;
        ThinClientHandle thinClientHandle = this;
        SequentialLifetimes sequentialLifetimes = (SequentialLifetimes)this.lifetime.executeIfAlive((Function0)new Function0<SequentialLifetimes>(this){
            final /* synthetic */ ThinClientHandle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SequentialLifetimes invoke() {
                return new SequentialLifetimes(this.this$0.getLifetime());
            }
        });
        if (sequentialLifetimes == null) {
            SequentialLifetimes sequentialLifetimes2;
            Lifetime.Companion companion = Lifetime.Companion;
            ThinClientHandle thinClientHandle2 = thinClientHandle;
            boolean $i$f$using = false;
            LifetimeDefinition def$iv = new LifetimeDefinition();
            try {
                Lifetime it = def$iv.getLifetime();
                boolean bl = false;
                sequentialLifetimes2 = new SequentialLifetimes(it);
            }
            finally {
                LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
            }
            sequentialLifetimes = sequentialLifetimes2;
            thinClientHandle = thinClientHandle2;
        }
        thinClientHandle.pingLifetimes = sequentialLifetimes;
        this.currentConnectionStateMessage = (GtwToClientMessage)GtwToClientMessage.GatewayReconnecting.INSTANCE;
        this.clientCapabilities = new ClientToGtwMessage.ClientCapabilities(false, 0L, 2, null);
        this.gwwsLink = UriUtilKt.newURIWithFragmentParameters((URI)initialGwwsLink, (Map)MapsKt.minus((Map)UriUtilKt.getFragmentParameters((URI)initialGwwsLink), (Object)"newUi"));
        String string = (String)UriUtilKt.getFragmentParameters((URI)initialGwwsLink).get("newUi");
        this.currentNewUiState = string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
        this.clientLifetimeTracker.registerClientHandleLifetime(this.lifetime, this.uid);
        this.clientLifetimeTracker.getClientsTerminated().advise(this.lifetime, (Function1)new Function1<Unit, Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Unit it) {
                void $this$debug_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = logger;
                ThinClientHandle thinClientHandle = this;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var7_6 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var7_6.debug("Got process exit notification for client " + thinClientHandle.getUid(), e$iv);
                }
                this.onProcessTermination();
            }
        });
        this.onMessage.advise(this.lifetime, (Function1)new Function1<ClientToGtwMessage, Unit>(){

            public final void invoke(@NotNull ClientToGtwMessage it) {
                ClientToGtwMessage clientToGtwMessage;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)it, (Object)ClientToGtwMessage.Ping.INSTANCE)) {
                    logger.info("Message from thin client " + this.getUid() + ": " + it);
                }
                if (Intrinsics.areEqual((Object)(clientToGtwMessage = it), (Object)ClientToGtwMessage.ClientClosing.INSTANCE)) {
                    closingMessagesCounter.add(1L);
                    InterfacesKt.fire((ISignal)((ISignal)closedSignalImpl));
                } else if (Intrinsics.areEqual((Object)clientToGtwMessage, (Object)ClientToGtwMessage.Ping.INSTANCE)) {
                    pingMessagesCounter.add(1L);
                    timeoutTicks = 0;
                } else if (Intrinsics.areEqual((Object)clientToGtwMessage, (Object)ClientToGtwMessage.ClientAsksLogs.INSTANCE)) {
                    askLongsMessagesCounter.add(1L);
                    Path path2 = LoggerFactory.getLogFilePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getLogFilePath(...)");
                    this.sendMessage((GtwToClientMessage)new GtwToClientMessage.GatewayLogs(((Object)path2).toString()));
                } else if (Intrinsics.areEqual((Object)clientToGtwMessage, (Object)ClientToGtwMessage.ClientRestart.INSTANCE)) {
                    clientRestartMessagesCounter.add(1L);
                    restartNeeded = true;
                    logger.info("starting preparing launch after restart");
                    this.prepareLaunchAfterRestart();
                    this.sendMessage((GtwToClientMessage)GtwToClientMessage.RestartReady.INSTANCE);
                    logger.info("RestartReady message sent");
                } else if (Intrinsics.areEqual((Object)clientToGtwMessage, (Object)ClientToGtwMessage.ClientSelfRestart.INSTANCE)) {
                    clientRestartMessagesCounter.add(1L);
                    logger.info("Client for " + this.getUid() + " will self-restart");
                    restartNeeded = true;
                } else if (clientToGtwMessage instanceof ClientToGtwMessage.ProjectOpenFailed) {
                    projectOpenFailedMessagesCounter.add(1L);
                    openFailedSignalImpl.fire((Object)((ClientToGtwMessage.ProjectOpenFailed)it).getExitCode());
                } else if (clientToGtwMessage instanceof ClientToGtwMessage.ClientCapabilities) {
                    clientCapabilities = (ClientToGtwMessage.ClientCapabilities)it;
                    logger.info("Received client capabilities for " + this.getUid() + ": " + it);
                }
            }
        });
        this.closedSignalImpl.advise(this.lifetime, (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RdCoroutinesUtilKt.startIOBackgroundAsync$default((Lifetime)this.getLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ ThinClientHandle this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = DelayKt.delay((long)2000L, (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if (!this.this$0.getRestartNeeded()) {
                                    ThinClientHandle.access$getLogger$cp().debug("Terminating handle lifetime for " + this.this$0.getUid());
                                    LifetimeDefinition.terminate$default((LifetimeDefinition)ThinClientHandle.access$getLifetimeDef$p(this.this$0), (boolean)false, (int)1, null);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    @NotNull
    public final String getUid() {
        return this.uid;
    }

    @NotNull
    public final String getClientVersion() {
        return this.clientVersion;
    }

    @NotNull
    public final Signal<ClientToGtwMessage> getOnMessage$intellij_gateway_core() {
        return this.onMessage;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public final boolean getRestartNeeded() {
        return this.restartNeeded;
    }

    @Nullable
    public final URI getLastSeenLink$intellij_gateway_core() {
        return this.lastSeenLink;
    }

    public final void startPingingClient$intellij_gateway_core() {
        LifetimeDefinition currentLifetime = this.pingLifetimes.next();
        RdCoroutinesUtilKt.launchNonUrgentBackground$default((Lifetime)((Lifetime)currentLifetime), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentLifetime, this, null){
            int label;
            final /* synthetic */ LifetimeDefinition $currentLifetime;
            final /* synthetic */ ThinClientHandle this$0;
            {
                this.$currentLifetime = $currentLifetime;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                        // 3 sources

                        while (RLifetimeKt.isAlive((Lifetime)((Lifetime)this.$currentLifetime))) {
                            this.label = 1;
                            v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl15
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        var2_3 = this.this$0;
                        var3_4 = ThinClientHandle.access$getTimeoutTicks$p(var2_3);
                        ThinClientHandle.access$setTimeoutTicks$p(var2_3, var3_4 + 1);
                        if (var3_4 <= 5) ** GOTO lbl5
                        ThinClientHandle.access$getLogger$cp().debug("Handle " + this.this$0.getUid() + " timed out, closing");
                        this.this$0.close();
                        ** GOTO lbl5
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onClientLaunch$intellij_gateway_core(@NotNull Function0<Unit> onStarted) {
        Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
        Lifetime lifetime = this.clientLifetimeTracker.getLifetime();
        String string = this.clientLifetimeTracker.getVersion();
        String string2 = this.createGwwsLinkWithUpdatedFragmentParams().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        CodeWithMeGuestLauncher.INSTANCE.downloadCompatibleClientAndLaunch(lifetime, null, string, string2, GatewayBundle.INSTANCE.message("ssh.deploy.dialog.title", new Object[0]), (Function1)new Function1<Lifetime, Unit>(this, onStarted){
            final /* synthetic */ ThinClientHandle this$0;
            final /* synthetic */ Function0<Unit> $onStarted;
            {
                this.this$0 = $receiver;
                this.$onStarted = $onStarted;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Lifetime it) {
                void $this$debug_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger = ThinClientHandle.access$getLogger$cp();
                ThinClientHandle thinClientHandle = this.this$0;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var7_6 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var7_6.debug("Attaching process lifetime for linked client " + thinClientHandle.getUid(), e$iv);
                }
                ThinClientHandle.access$getClientLifetimeTracker$p(this.this$0).registerClientProcessLifetime(it, this.this$0.getUid());
                this.$onStarted.invoke();
                this.this$0.startPingingClient$intellij_gateway_core();
            }
        });
    }

    public static /* synthetic */ void onClientLaunch$intellij_gateway_core$default(ThinClientHandle thinClientHandle, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = onClientLaunch.1.INSTANCE;
        }
        thinClientHandle.onClientLaunch$intellij_gateway_core((Function0<Unit>)function0);
    }

    private final void onProcessTermination() {
        block1: {
            block0: {
                if (this.restartNeeded) break block0;
                this.close();
                break block1;
            }
            this.pingLifetimes.terminateCurrent();
            CompletableFuture<Boolean> completableFuture = this.clientProcessTerminated;
            if (completableFuture == null) break block1;
            completableFuture.complete(true);
        }
    }

    public final boolean getClientPresent() {
        return this.clients.size() > 0;
    }

    @NotNull
    public final ISource<Unit> getOnClientPresenceChanged() {
        return (ISource)this.presenceChangeSignal;
    }

    @NotNull
    public final ISource<Unit> getClientClosed() {
        return (ISource)this.closedSignalImpl;
    }

    @NotNull
    public final ISource<Integer> getClientFailedToOpenProject() {
        return (ISource)this.openFailedSignalImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateJoinLink(@NotNull URI newLink, boolean reconnectIfConnected) {
        Intrinsics.checkNotNullParameter((Object)newLink, (String)"newLink");
        ThinClientHandle thinClientHandle = this;
        synchronized (thinClientHandle) {
            boolean bl = false;
            logger.info("Updating join link for handle " + this.uid + ": " + newLink + " forceReconnect=" + reconnectIfConnected);
            String string = newLink.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.sendMessage((GtwToClientMessage)new GtwToClientMessage.UpdateLink(string, reconnectIfConnected));
            URI lastSeenLinkTemp = this.lastSeenLink;
            this.lastSeenLink = newLink;
            if (this.restartNeeded) {
                if (!Intrinsics.areEqual((Object)this.lastSeenLink, (Object)lastSeenLinkTemp)) {
                    this.handleNewUiSwitch(newLink);
                    CompletableFuture<Boolean> completableFuture = this.linkUpdatedFuture;
                    if (completableFuture != null) {
                        completableFuture.complete(true);
                    }
                    logger.debug("Link updated after restart for handle: " + this.uid);
                } else {
                    logger.debug("Received the same link while restarting. Skipping...");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void notifyReconnect() {
        logger.info("Setting handle " + this.uid + " to reconnecting state");
        this.sendMessage((GtwToClientMessage)GtwToClientMessage.GatewayReconnecting.INSTANCE);
    }

    public final void close() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        logger.info("Closing handle " + this.uid);
        this.sendMessage((GtwToClientMessage)GtwToClientMessage.GatewayClose.INSTANCE);
        Thread.sleep(1000L);
        this.closedSignalImpl.fire((Object)Unit.INSTANCE);
    }

    public final void focusClientWindow() {
        logger.debug("Requesting focus on handle " + this.uid);
        this.sendMessage((GtwToClientMessage)GtwToClientMessage.RequestWindowFocus.INSTANCE);
    }

    private final void prepareLaunchAfterRestart() {
        CompletableFuture<Boolean> completableFuture = this.linkUpdatedFuture;
        if (completableFuture != null) {
            completableFuture.cancel(false);
        }
        CompletableFuture<Boolean> completableFuture2 = this.clientProcessTerminated;
        if (completableFuture2 != null) {
            completableFuture2.cancel(false);
        }
        this.linkUpdatedFuture = new CompletableFuture();
        this.clientProcessTerminated = new CompletableFuture();
        CompletableFuture[] completableFutureArray = new CompletableFuture[]{this.linkUpdatedFuture, this.clientProcessTerminated};
        CompletableFuture.allOf(completableFutureArray).thenAccept(arg_0 -> ThinClientHandle.prepareLaunchAfterRestart$lambda$2((Function1)new Function1<Void, Unit>(this){
            final /* synthetic */ ThinClientHandle this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Void it) {
                ThinClientHandle.onClientLaunch$intellij_gateway_core$default(this.this$0, null, 1, null);
                ThinClientHandle.access$setRestartNeeded$p(this.this$0, false);
                ThinClientHandle.access$setLinkUpdatedFuture$p(this.this$0, null);
                ThinClientHandle.access$setClientProcessTerminated$p(this.this$0, null);
            }
        }, arg_0));
    }

    public final void reportNetworkLatency(int latency) {
        this.sendMessage((GtwToClientMessage)new GtwToClientMessage.NetworkLatency(latency));
    }

    private final void sendMessage(GtwToClientMessage message) {
        if (message instanceof GtwToClientMessage.GatewayReconnecting || message instanceof GtwToClientMessage.UpdateLink || message instanceof GtwToClientMessage.GatewayClose) {
            this.currentConnectionStateMessage = message;
        }
        Iterable $this$forEach$iv = this.clients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebSocketClient client = (WebSocketClient)element$iv;
            boolean bl = false;
            this.sendMessage(client, message);
        }
    }

    private final void sendMessage(WebSocketClient client, GtwToClientMessage message) {
        String serialized;
        String string = serialized = Json.Default.encodeToString((SerializationStrategy)serializer, (Object)message);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        client.sendFrame(Unpooled.wrappedBuffer((byte[])byArray), false);
    }

    public final void clientConnected$intellij_gateway_core(@NotNull Lifetime clientLifetime, @NotNull WebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)clientLifetime, (String)"clientLifetime");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.clients.add(client);
        this.restartNeeded = false;
        clientLifetime.onTermination((Function0)new Function0<Unit>(this, client){
            final /* synthetic */ ThinClientHandle this$0;
            final /* synthetic */ WebSocketClient $client;
            {
                this.this$0 = $receiver;
                this.$client = $client;
                super(0);
            }

            public final void invoke() {
                ThinClientHandle.access$getClients$p(this.this$0).remove(this.$client);
                ThinClientHandle.access$getPresenceChangeSignal$p(this.this$0).fire((Object)Unit.INSTANCE);
            }
        });
        this.presenceChangeSignal.fire((Object)Unit.INSTANCE);
        this.sendMessage(client, (GtwToClientMessage)gatewayCapabilities);
        this.sendMessage(client, this.currentConnectionStateMessage);
    }

    private final void handleNewUiSwitch(URI newLink) {
        Boolean updatedLinkNewUi;
        String string = (String)UriUtilKt.getFragmentParameters((URI)newLink).get("newUi");
        this.currentNewUiState = updatedLinkNewUi = string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    private final URI createGwwsLinkWithUpdatedFragmentParams() {
        Boolean newUiState = this.currentNewUiState;
        if (newUiState != null) {
            return UriUtilKt.newURIWithFragmentParameters((URI)this.gwwsLink, (Map)MapsKt.plus((Map)UriUtilKt.getFragmentParameters((URI)this.gwwsLink), (Pair)TuplesKt.to((Object)"newUi", (Object)newUiState.toString())));
        }
        return this.gwwsLink;
    }

    private static final void prepareLaunchAfterRestart$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$getTimeoutTicks$p(ThinClientHandle $this) {
        return $this.timeoutTicks;
    }

    public static final /* synthetic */ ClientLifetimeTracker access$getClientLifetimeTracker$p(ThinClientHandle $this) {
        return $this.clientLifetimeTracker;
    }

    public static final /* synthetic */ void access$setLinkUpdatedFuture$p(ThinClientHandle $this, CompletableFuture completableFuture) {
        $this.linkUpdatedFuture = completableFuture;
    }

    public static final /* synthetic */ void access$setClientProcessTerminated$p(ThinClientHandle $this, CompletableFuture completableFuture) {
        $this.clientProcessTerminated = completableFuture;
    }

    public static final /* synthetic */ Set access$getClients$p(ThinClientHandle $this) {
        return $this.clients;
    }

    public static final /* synthetic */ Signal access$getPresenceChangeSignal$p(ThinClientHandle $this) {
        return $this.presenceChangeSignal;
    }

    public static final /* synthetic */ LifetimeDefinition access$getLifetimeDef$p(ThinClientHandle $this) {
        return $this.lifetimeDef;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientHandle.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientHandle.logger = logger;
        gatewayCapabilities = new GtwToClientMessage.GatewayCapabilities(true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle$Companion;", "", "()V", "gatewayCapabilities", "Lcom/intellij/remoteDev/thinClientLink/GtwToClientMessage$GatewayCapabilities;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/remoteDev/thinClientLink/GtwToClientMessage;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

