/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.panels;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.remote.AuthType;
import com.intellij.ssh.ui.SshPasswordPrompt;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.ui.JBUI;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001!B$\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\b\u0010 \u001a\u00020\u001cH\u0016R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00150\u00150\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/gateway/ssh/panels/AuthenticationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "host", "", "Lcom/intellij/openapi/util/NlsSafe;", "request", "Lcom/intellij/ssh/ui/SshPasswordPrompt$Request;", "sshUiData", "Lcom/intellij/ssh/ui/unified/SshUiData;", "(Ljava/lang/String;Lcom/intellij/ssh/ui/SshPasswordPrompt$Request;Lcom/intellij/ssh/ui/unified/SshUiData;)V", "getHost", "()Ljava/lang/String;", "password", "", "getPassword", "()[C", "passwordField", "Lcom/intellij/ui/components/JBPasswordField;", "getRequest", "()Lcom/intellij/ssh/ui/SshPasswordPrompt$Request;", "saveOption", "Lcom/jetbrains/gateway/ssh/panels/AuthenticationDialog$SaveOption;", "getSaveOption", "()Lcom/jetbrains/gateway/ssh/panels/AuthenticationDialog$SaveOption;", "saveOptionComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "kotlin.jvm.PlatformType", "createCenterPanel", "Ljavax/swing/JComponent;", "doCancelAction", "", "doOKAction", "getPreferredFocusedComponent", "SaveOption", "intellij.gateway.core"})
public final class AuthenticationDialog
extends DialogWrapper {
    @NotNull
    private final String host;
    @Nullable
    private final SshPasswordPrompt.Request request;
    @NotNull
    private final SshUiData sshUiData;
    @NotNull
    private JBPasswordField passwordField;
    @NotNull
    private ComboBox<SaveOption> saveOptionComboBox;

    /*
     * WARNING - void declaration
     */
    public AuthenticationDialog(@NotNull String host2, @Nullable SshPasswordPrompt.Request request, @NotNull SshUiData sshUiData) {
        void $this$saveOptionComboBox_u24lambda_u241;
        ComboBox comboBox2;
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)sshUiData, (String)"sshUiData");
        super(null);
        this.host = host2;
        this.request = request;
        this.sshUiData = sshUiData;
        this.passwordField = new JBPasswordField();
        ComboBox comboBox3 = comboBox2 = new ComboBox((Object[])SaveOption.values());
        AuthenticationDialog authenticationDialog = this;
        boolean bl = false;
        $this$saveOptionComboBox_u24lambda_u241.setRenderer(AuthenticationDialog::saveOptionComboBox$lambda$1$lambda$0);
        $this$saveOptionComboBox_u24lambda_u241.setSelectedIndex(ArraysKt.indexOf((Object[])SaveOption.values(), (Object)((Object)SaveOption.SAVE_UNTIL_NEXT_RESTART)));
        authenticationDialog.saveOptionComboBox = comboBox2;
        this.setTitle(GatewayBundle.INSTANCE.message("ssh.authentication", new Object[0]));
        this.setOKButtonText(GatewayBundle.INSTANCE.message("ssh.authenticate", new Object[0]));
        this.init();
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final SshPasswordPrompt.Request getRequest() {
        return this.request;
    }

    @NotNull
    public final char[] getPassword() {
        char[] cArray = this.passwordField.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        return cArray;
    }

    private final SaveOption getSaveOption() {
        Object object = this.saveOptionComboBox.getModel().getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.gateway.ssh.panels.AuthenticationDialog.SaveOption");
        return (SaveOption)((Object)object);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.passwordField;
    }

    protected void doOKAction() {
        boolean savePassUntilRestart = this.getSaveOption() == SaveOption.SAVE_UNTIL_NEXT_RESTART;
        boolean notEmptyPassword = !(this.getPassword().length == 0);
        GatewayUsagesCollector.INSTANCE.onAuthenticateDialogOkClick(savePassUntilRestart, !notEmptyPassword);
        if (notEmptyPassword) {
            if (this.request instanceof SshPasswordPrompt.Request.Password) {
                this.sshUiData.setStorePassword(!savePassUntilRestart);
                this.sshUiData.setPassword(new String(this.getPassword()));
                this.sshUiData.setAuthType(AuthType.PASSWORD);
            } else if (this.request instanceof SshPasswordPrompt.Request.Key) {
                this.sshUiData.setStorePassphrase(!savePassUntilRestart);
                this.sshUiData.setPassphrase(new String(this.getPassword()));
                this.sshUiData.setAuthType(AuthType.KEY_PAIR);
                this.sshUiData.setPrivateKeyFile(((Object)((SshPasswordPrompt.Request.Key)this.request).getKeyFilePath()).toString());
            }
            this.sshUiData.saveAuthDataToPasswordSafe();
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        boolean notEmptyPassword = !(this.getPassword().length == 0);
        boolean savePassUntilRestart = this.getSaveOption() == SaveOption.SAVE_UNTIL_NEXT_RESTART;
        GatewayUsagesCollector.INSTANCE.onAuthenticateDialogCancelClick(savePassUntilRestart, !notEmptyPassword);
        super.doCancelAction();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBPanel jBPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ AuthenticationDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ AuthenticationDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.label("<html>" + GatewayBundle.INSTANCE.message("ssh.authenticate.to", new Object[0]) + "<br/>" + this.this$0.getHost() + "<html/>").align((Align)AlignX.LEFT.INSTANCE);
                    }
                }), (int)1, null).layout(RowLayout.PARENT_GRID);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ AuthenticationDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        SshPasswordPrompt.Request request = this.this$0.getRequest();
                        String label = request instanceof SshPasswordPrompt.Request.Password ? GatewayBundle.INSTANCE.message("ssh.password", new Object[0]) : (request instanceof SshPasswordPrompt.Request.Key ? GatewayBundle.INSTANCE.message("ssh.key.passphrase", new Object[0]) + " " + ((SshPasswordPrompt.Request.Key)this.this$0.getRequest()).getKeyFilePath() : (request instanceof SshPasswordPrompt.Request.KeyboardInteractive ? GatewayBundle.INSTANCE.message("ssh.one.time.password", new Object[0]) : new String()));
                        $this$row.cell((JComponent)AuthenticationDialog.access$getPasswordField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE).resizableColumn().label(label, LabelPosition.TOP);
                        $this$row.cell((JComponent)AuthenticationDialog.access$getSaveOptionComboBox$p(this.this$0));
                    }
                }), (int)1, null).layout(RowLayout.INDEPENDENT);
            }
        })).withMinimumWidth(JBUI.scale((int)564));
        DialogPanel $this$createCenterPanel_u24lambda_u242 = (DialogPanel)jBPanel;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u242.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JBPanel jBPanel2 = jBPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel2, (String)"apply(...)");
        return (JComponent)jBPanel2;
    }

    private static final Component saveOptionComboBox$lambda$1$lambda$0(JList jList, SaveOption value, int n, boolean bl, boolean bl2) {
        return new JLabel(value.getMessage());
    }

    public static final /* synthetic */ JBPasswordField access$getPasswordField$p(AuthenticationDialog $this) {
        return $this.passwordField;
    }

    public static final /* synthetic */ ComboBox access$getSaveOptionComboBox$p(AuthenticationDialog $this) {
        return $this.saveOptionComboBox;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0014\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/gateway/ssh/panels/AuthenticationDialog$SaveOption;", "", "message", "", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;ILjava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "SAVE_UNTIL_NEXT_RESTART", "SAVE_PERMANENTLY", "intellij.gateway.core"})
    public static final class SaveOption
    extends Enum<SaveOption> {
        @NotNull
        private final String message;
        public static final /* enum */ SaveOption SAVE_UNTIL_NEXT_RESTART = new SaveOption(GatewayBundle.INSTANCE.message("save.until.next.restart", new Object[0]));
        public static final /* enum */ SaveOption SAVE_PERMANENTLY = new SaveOption(GatewayBundle.INSTANCE.message("save.permanently", new Object[0]));
        private static final /* synthetic */ SaveOption[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SaveOption(String message) {
            this.message = message;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static SaveOption[] values() {
            return (SaveOption[])$VALUES.clone();
        }

        public static SaveOption valueOf(String value) {
            return Enum.valueOf(SaveOption.class, value);
        }

        @NotNull
        public static EnumEntries<SaveOption> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = saveOptionArray = new SaveOption[]{SaveOption.SAVE_UNTIL_NEXT_RESTART, SaveOption.SAVE_PERMANENTLY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

