/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.remoteDev.util.RemoteDevProtocolUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.EDT;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.ConnectionRequestor;
import com.jetbrains.gateway.api.GatewayConnectionHandle;
import com.jetbrains.gateway.api.GatewayConnectionProvider;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.api.GatewayCustomViewConnector;
import com.jetbrains.gateway.api.GatewayUI;
import com.jetbrains.gateway.connection.GatewayConnectionFrameManager;
import com.jetbrains.gateway.impl.GatewayStarter;
import com.jetbrains.gateway.impl.GatewayUIService;
import com.jetbrains.gateway.impl.GatewayUIState;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeScreenPanel;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeScreenSelectTabTopicKt;
import com.jetbrains.gateway.welcomeScreen.WelcomeScreenTabSelectionListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GatewayUIService", storages={@Storage(value="GatewayUIService.xml")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 (2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0014\u001a\u00020\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000eH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J\u001e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u0007H\u0016J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010%\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u000bJ\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0010H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/jetbrains/gateway/impl/GatewayUIService;", "Lcom/jetbrains/gateway/api/GatewayUI;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/jetbrains/gateway/impl/GatewayUIState;", "()V", "connected", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getConnected", "()Lcom/jetbrains/rd/util/reactive/Signal;", "currentPanel", "Lcom/jetbrains/gateway/welcomeScreen/GatewayWelcomeScreenPanel;", "onResetActions", "", "Lkotlin/Function0;", "tempLastConnectorId", "", "token", "getToken", "()Ljava/lang/String;", "connect", "parameters", "", "onDone", "getLastConnectorId", "navigateToConnectorTab", "connectorRecentsId", "onReset", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "action", "reset", "resetEx", "setLastConnectorId", "connectorId", "temp", "", "setupGatewayPanel", "panel", "showConnectorView", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nGatewayUIService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayUIService.kt\ncom/jetbrains/gateway/impl/GatewayUIService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,166:1\n1855#2,2:167\n1549#2:169\n1620#2,3:170\n11#3:173\n*S KotlinDebug\n*F\n+ 1 GatewayUIService.kt\ncom/jetbrains/gateway/impl/GatewayUIService\n*L\n57#1:167,2\n95#1:169\n95#1:170,3\n34#1:173\n*E\n"})
public final class GatewayUIService
extends SimplePersistentStateComponent<GatewayUIState>
implements GatewayUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Signal<Unit> connected = new Signal();
    @Nullable
    private GatewayWelcomeScreenPanel currentPanel;
    @NotNull
    private final List<Function0<Unit>> onResetActions = new ArrayList();
    @NotNull
    private final String token;
    @Nullable
    private String tempLastConnectorId;
    @NotNull
    private static final Logger logger;

    public GatewayUIService() {
        super((BaseState)new GatewayUIState());
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.token = string;
    }

    @NotNull
    public final Signal<Unit> getConnected() {
        return this.connected;
    }

    public final void setupGatewayPanel(@NotNull Lifetime lifetime, @NotNull GatewayWelcomeScreenPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        this.currentPanel = panel2;
        lifetime.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ GatewayUIService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GatewayUIService.access$setCurrentPanel$p(this.this$0, null);
            }
        });
    }

    @Override
    public void reset() {
        block0: {
            EDT.assertIsEdt();
            logger.debug("Reset gateway main panel");
            GatewayWelcomeScreenPanel gatewayWelcomeScreenPanel = this.currentPanel;
            if (gatewayWelcomeScreenPanel == null) break block0;
            gatewayWelcomeScreenPanel.reset();
        }
    }

    @Override
    public void resetEx() {
        this.reset();
        Iterable $this$forEach$iv = this.onResetActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    @Override
    public void onReset(@NotNull Lifetime lifetime, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        lifetime.executeIfAlive((Function0)new Function0<Unit>(this, action, lifetime){
            final /* synthetic */ GatewayUIService this$0;
            final /* synthetic */ Function0<Unit> $action;
            final /* synthetic */ Lifetime $lifetime;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                this.$lifetime = $lifetime;
                super(0);
            }

            public final void invoke() {
                GatewayUIService.access$getOnResetActions$p(this.this$0).add(this.$action);
                this.$lifetime.onTermination((Function0)new Function0<Unit>(this.this$0, this.$action){
                    final /* synthetic */ GatewayUIService this$0;
                    final /* synthetic */ Function0<Unit> $action;
                    {
                        this.this$0 = $receiver;
                        this.$action = $action;
                        super(0);
                    }

                    public final void invoke() {
                        GatewayUIService.access$getOnResetActions$p(this.this$0).remove(this.$action);
                    }
                });
            }
        });
    }

    @Override
    public void navigateToConnectorTab(@Nullable String connectorRecentsId) {
        block0: {
            WelcomeFrame.Companion.showNow();
            String string = connectorRecentsId;
            if (string == null) break block0;
            String id = string;
            boolean bl = false;
            ((WelcomeScreenTabSelectionListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GatewayWelcomeScreenSelectTabTopicKt.getWELCOME_SCREEN_SELECT_TAB_TOPIC())).selectRecentConnectionsTab(id);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void showConnectorView(@NotNull String connectorId) {
        Object v0;
        List<GatewayConnector> connectors;
        block6: {
            Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
            if (this.currentPanel == null) {
                WelcomeFrame.Companion.showNow();
            }
            connectors = GatewayConnector.Companion.getConnectors();
            Iterable iterable = connectors;
            for (Object t : iterable) {
                GatewayConnector it = (GatewayConnector)t;
                boolean bl = false;
                if (!(!(it instanceof GatewayCustomViewConnector) && Intrinsics.areEqual((Object)it.getConnectorId(), (Object)connectorId))) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        GatewayConnector connector2 = v0;
        if (connector2 != null) {
            GatewayWelcomeScreenPanel gatewayWelcomeScreenPanel = this.currentPanel;
            if (gatewayWelcomeScreenPanel != null) {
                gatewayWelcomeScreenPanel.createConnectorView(connector2);
            }
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = connectors;
            String string = connectorId;
            Logger logger = GatewayUIService.logger;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GatewayConnector gatewayConnector = (GatewayConnector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getConnectorId());
            }
            collection = (List)destination$iv$iv;
            logger.error("Registered connector with id: " + string + " not found, existent = " + (List)collection);
        }
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @Override
    public void connect(@NotNull Map<String, String> parameters, @Nullable Function0<Unit> onDone2) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        logger.debug("Connect request...");
        if (PlatformUtils.isGateway()) {
            GatewayConnectionProvider.Companion.connect(parameters, ConnectionRequestor.Local, (Function1<? super GatewayConnectionHandle, Unit>)((Function1)new Function1<GatewayConnectionHandle, Unit>(onDone2, this){
                final /* synthetic */ Function0<Unit> $onDone;
                final /* synthetic */ GatewayUIService this$0;
                {
                    this.$onDone = $onDone;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@Nullable GatewayConnectionHandle handle2) {
                    block1: {
                        if (handle2 == null) break block1;
                        GatewayConnectionFrameManager.Companion.getInstance().closeWelcomeFrame();
                        Function0<Unit> function0 = this.$onDone;
                        if (function0 != null) {
                            Function0<Unit> function02 = function0;
                            GatewayUIService gatewayUIService = this.this$0;
                            Function0<Unit> it = function02;
                            boolean bl = false;
                            gatewayUIService.getConnected().fire((Object)Unit.INSTANCE);
                            it.invoke();
                        }
                    }
                }
            }));
            return;
        }
        Function0 startGatewayFunction2 = (Function0)new Function0<Unit>(parameters, this){
            final /* synthetic */ Map<String, String> $parameters;
            final /* synthetic */ GatewayUIService this$0;
            {
                this.$parameters = $parameters;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                String url2 = RemoteDevProtocolUtil.INSTANCE.createGatewayUrl(MapsKt.plus(this.$parameters, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"runFromIdeToken", (Object)this.this$0.getToken()))));
                GatewayStarter.INSTANCE.runGatewayProcess(url2, (Pair<String, String>)TuplesKt.to((Object)"GTW_FROM_IDE_TOKEN", (Object)this.this$0.getToken()), (Function1<? super String, Unit>)((Function1)connect.startGatewayFunction.1.INSTANCE));
                Thread.sleep(3000L);
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GatewayUIService.connect$lambda$4(startGatewayFunction2), GatewayBundle.INSTANCE.message("ui.service.gateway.process.title", new Object[0]), false, null);
        this.reset();
        this.connected.fire((Object)Unit.INSTANCE);
    }

    @Override
    @Nullable
    public String getLastConnectorId() {
        String tempL = this.tempLastConnectorId;
        if (tempL != null) {
            this.tempLastConnectorId = null;
            return tempL;
        }
        return ((GatewayUIState)this.getState()).getLastSelectedConnectorId();
    }

    @Override
    public void setLastConnectorId(@NotNull String connectorId, boolean temp) {
        Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
        if (temp) {
            this.tempLastConnectorId = connectorId;
        } else {
            ((GatewayUIState)this.getState()).setLastSelectedConnectorId(connectorId);
        }
    }

    private static final void connect$lambda$4(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ void access$setCurrentPanel$p(GatewayUIService $this, GatewayWelcomeScreenPanel gatewayWelcomeScreenPanel) {
        $this.currentPanel = gatewayWelcomeScreenPanel;
    }

    public static final /* synthetic */ List access$getOnResetActions$p(GatewayUIService $this) {
        return $this.onResetActions;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GatewayUIService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GatewayUIService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/gateway/impl/GatewayUIService$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getServiceInstance", "Lcom/jetbrains/gateway/impl/GatewayUIService;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GatewayUIService getServiceInstance() {
            GatewayUI gatewayUI = GatewayUI.Companion.getInstance();
            Intrinsics.checkNotNull((Object)gatewayUI, (String)"null cannot be cast to non-null type com.jetbrains.gateway.impl.GatewayUIService");
            return (GatewayUIService)gatewayUI;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

