/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.EventDispatcher;
import com.jetbrains.firefox.FirefoxListener;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.rdp.FirefoxProtocolReaderImpl;
import com.jetbrains.firefox.rdp.Source;
import com.jetbrains.firefox.rdp.ThreadInterrupted;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.util.AbstractMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.BufferToCharsKt;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.CommandSenderBase;
import org.jetbrains.rpc.MessageManagerBase;
import org.jetbrains.rpc.MessageManagerBaseKt;
import org.jetbrains.rpc.MessageProcessor;
import org.jetbrains.rpc.RequestCallback;
import org.jetbrains.rpc.RequestPromise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 G2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0005GHIJKB\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u001c\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u000b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-J\b\u0010.\u001a\u00020'H\u0016J\u0006\u0010/\u001a\u00020'J\b\u00100\u001a\u00020'H\u0016J0\u00101\u001a\u00020'\"\u0004\b\u0000\u001022\f\u00103\u001a\b\u0012\u0004\u0012\u0002H2042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H206H\u0014J4\u00107\u001a\u00020'\"\u0004\b\u0000\u001022\n\u00103\u001a\u0006\u0012\u0002\b\u0003082\u0006\u00109\u001a\u00020\u000b2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H206J\u000e\u0010:\u001a\u00020'2\u0006\u0010+\u001a\u00020\u000bJ*\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010\u000b2\u0006\u0010?\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u000bH\u0002J@\u0010A\u001a\u00020'2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010\u000b2\u0006\u0010?\u001a\u00020\u000b2\b\u0010B\u001a\u0004\u0018\u00010\u000b2\b\u0010C\u001a\u0004\u0018\u00010\u000b2\b\u0010@\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010D\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u000bH\u0002J\u000e\u0010E\u001a\u00020'2\u0006\u0010<\u001a\u00020=J\u0010\u0010F\u001a\u00020'2\u0006\u0010?\u001a\u00020\u000bH\u0002R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000f\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor;", "Lorg/jetbrains/rpc/CommandSenderBase;", "", "Lorg/jetbrains/rpc/MessageProcessor;", "writer", "Lkotlin/Function1;", "Lio/netty/buffer/ByteBuf;", "", "(Lkotlin/jvm/functions/Function1;)V", "actorToThread", "Ljava/util/HashMap;", "", "getActorToThread", "()Ljava/util/HashMap;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$IFirefoxListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "forcedPause", "getForcedPause", "()Z", "setForcedPause", "(Z)V", "isBreakOnException", "messageManager", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$FirefoxMessageManager;", "threadToState", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$ThreadState;", "getThreadToState", "()Ljava/util/concurrent/ConcurrentHashMap;", "threadsToResume", "Ljava/util/HashSet;", "getThreadsToResume", "()Ljava/util/HashSet;", "addInitialMessageHandler", "Lorg/jetbrains/concurrency/Promise;", "addListener", "", "listener", "Lcom/jetbrains/firefox/FirefoxListener;", "attachToThreadAndExecute", "thread", "runnable", "Lkotlin/Function0;", "cancelWaitingRequests", "clear", "closed", "doSend", "RESULT", "message", "Lorg/jetbrains/jsonProtocol/Request;", "callback", "Lorg/jetbrains/rpc/RequestPromise;", "doSendFromPaused", "Lcom/jetbrains/firefox/FirefoxRequest;", "threadActor", "forcedReleaseThread", "handleEvent", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "nextName", "actor", "type", "handleResponseOrEvent", "error", "errorDescription", "hasPendingRequestRequiringPause", "processIncomingJson", "releaseThreadIfPossible", "Companion", "FirefoxMessageManager", "IFirefoxListener", "RequestItem", "ThreadState", "intellij.javascript.firefox.connector"})
public final class FirefoxCommandProcessor
extends CommandSenderBase<Object>
implements MessageProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<ByteBuf, Boolean> writer;
    @NotNull
    private final FirefoxMessageManager messageManager;
    @NotNull
    private final ConcurrentHashMap<String, ThreadState> threadToState;
    @NotNull
    private final HashMap<String, String> actorToThread;
    @NotNull
    private final HashSet<String> threadsToResume;
    private boolean forcedPause;
    @NotNull
    private final EventDispatcher<IFirefoxListener> dispatcher;
    private final boolean isBreakOnException;
    @NotNull
    private static final FirefoxProtocolReaderImpl READER = new FirefoxProtocolReaderImpl();

    public FirefoxCommandProcessor(@NotNull Function1<? super ByteBuf, Boolean> writer) {
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.writer = writer;
        this.messageManager = new FirefoxMessageManager();
        this.threadToState = new ConcurrentHashMap();
        this.actorToThread = new HashMap();
        this.threadsToResume = new HashSet();
        EventDispatcher eventDispatcher = EventDispatcher.create(IFirefoxListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
    }

    @NotNull
    public final ConcurrentHashMap<String, ThreadState> getThreadToState() {
        return this.threadToState;
    }

    @NotNull
    public final HashMap<String, String> getActorToThread() {
        return this.actorToThread;
    }

    @NotNull
    public final HashSet<String> getThreadsToResume() {
        return this.threadsToResume;
    }

    public final boolean getForcedPause() {
        return this.forcedPause;
    }

    public final void setForcedPause(boolean bl) {
        this.forcedPause = bl;
    }

    public final boolean isBreakOnException() {
        return this.isBreakOnException;
    }

    @NotNull
    public final Promise<?> addInitialMessageHandler() {
        RequestPromise promise = new RequestPromise("initial");
        this.messageManager.getActorToCurrentItem().put("root", new RequestItem(null, FirefoxRequest.Method.INITIAL, (RequestCallback<Object>)((RequestCallback)promise)));
        return (Promise)promise;
    }

    public final void addListener(@NotNull FirefoxListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener);
    }

    public void cancelWaitingRequests() {
        this.messageManager.cancelWaitingRequests();
    }

    public void closed() {
        this.messageManager.closed();
    }

    public final void attachToThreadAndExecute(@NotNull String thread, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        ThreadState state = this.threadToState.get(thread);
        if (state != null) {
            CommandProcessorKt.getLOG().assertTrue(state == ThreadState.PAUSED);
            runnable.invoke();
            return;
        }
        this.send(FirefoxRequest.Companion.attachToThread(thread)).onSuccess(arg_0 -> FirefoxCommandProcessor.attachToThreadAndExecute$lambda$0((Function1)new Function1<ThreadInterrupted, Unit>(runnable){
            final /* synthetic */ Function0<Unit> $runnable;
            {
                this.$runnable = $runnable;
                super(1);
            }

            public final void invoke(ThreadInterrupted it) {
                try {
                    this.$runnable.invoke();
                }
                catch (Exception e) {
                    CommandProcessorKt.getLOG().error((Throwable)e);
                }
            }
        }, arg_0));
    }

    protected <RESULT> void doSend(@NotNull Request<RESULT> message, @NotNull RequestPromise<Object, RESULT> callback) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        FirefoxRequest request = (FirefoxRequest)message;
        this.messageManager.send(request, (RequestCallback<Object>)((RequestCallback)callback));
    }

    public final <RESULT> void doSendFromPaused(@NotNull FirefoxRequest<?> message, @NotNull String threadActor, @NotNull RequestPromise<Object, RESULT> callback) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)threadActor, (String)"threadActor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        CommandProcessorKt.getLOG().assertTrue(message.requiresPause());
        this.actorToThread.put(message.getActor(), threadActor);
        this.messageManager.send(message, (RequestCallback<Object>)((RequestCallback)callback));
    }

    public final void processIncomingJson(@NotNull JsonReaderEx reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        reader.beginObject();
        String actor = null;
        JsonReaderEx subReader = null;
        String nextName = null;
        String error = null;
        String errorMessage = null;
        String type = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (Intrinsics.areEqual((Object)name, (Object)"error")) {
                error = reader.nextString();
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"from")) {
                actor = reader.nextString();
                if (subReader == null) continue;
                this.handleResponseOrEvent(subReader, nextName, actor, error, errorMessage, type);
                return;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"message")) {
                errorMessage = reader.nextString();
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"type")) {
                type = reader.nextString();
                continue;
            }
            if (actor == null) {
                if (subReader == null) {
                    nextName = name;
                    subReader = reader.subReader();
                }
                reader.skipValue();
                continue;
            }
            this.handleResponseOrEvent(reader, name, actor, error, errorMessage, type);
            return;
        }
        String string = actor;
        Intrinsics.checkNotNull(string);
        this.handleResponseOrEvent(reader, null, string, error, errorMessage, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleResponseOrEvent(JsonReaderEx reader, String nextName, String actor, String error, String errorDescription, String type) {
        String nextName2 = nextName;
        if (Intrinsics.areEqual((Object)"newGlobal", (Object)type)) {
            return;
        }
        FirefoxRequest<Object> nextRequest = null;
        RequestItem item = null;
        HashMap<String, RequestItem> hashMap = this.messageManager.getActorToCurrentItem();
        synchronized (hashMap) {
            Object object;
            boolean bl = false;
            item = this.messageManager.getActorToCurrentItem().remove(actor);
            if (item == null) {
                nextRequest = null;
                object = Unit.INSTANCE;
            } else if (type != null && !Intrinsics.areEqual((Object)type, (Object)item.getMethod().getUglyProtocolResponseType())) {
                this.messageManager.getActorToCurrentItem().put(actor, item);
                item = null;
                nextRequest = null;
                object = Unit.INSTANCE;
            } else {
                RequestItem next = item.getNext();
                if (next == null) {
                    nextRequest = null;
                    object = Unit.INSTANCE;
                } else {
                    boolean bl2;
                    nextRequest = next.getMessage();
                    boolean bl3 = bl2 = nextRequest != null;
                    if (_Assertions.ENABLED && !bl2) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    next.setMessage(null);
                    object = this.messageManager.getActorToCurrentItem().put(actor, next);
                }
            }
            Unit unit = object;
        }
        if (item == null) {
            String string = type;
            Intrinsics.checkNotNull((Object)string);
            this.handleEvent(reader, nextName2, actor, string);
            return;
        }
        try {
            if (error == null) {
                FirefoxRequest.Method method = item.getMethod();
                Object response = null;
                block5 : switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (Intrinsics.areEqual((Object)"exited", (Object)type)) {
                            item.getCallback().onError("EXITED");
                            return;
                        }
                        if (Intrinsics.areEqual((Object)type, (Object)"paused")) {
                            this.threadToState.put(actor, ThreadState.PAUSED);
                        }
                        response = method == FirefoxRequest.Method.ATTACH_TO_TAB ? READER.readAttachToTabResult(reader, nextName2) : READER.readThreadInterrupted(reader, nextName2);
                        break;
                    }
                    case 4: {
                        this.threadToState.put(actor, ThreadState.RUNNING);
                        response = null;
                        break;
                    }
                    case 5: {
                        response = READER.readSetBreakpointResult(reader, nextName2);
                        break;
                    }
                    case 6: {
                        response = READER.readSourcesResult(reader, nextName2);
                        break;
                    }
                    case 7: {
                        response = READER.readSourceResult(reader, nextName2);
                        break;
                    }
                    case 8: {
                        response = READER.readFramesResult(reader, nextName2);
                        break;
                    }
                    case 9: {
                        response = READER.readPrototypeAndPropertiesResult(reader, nextName2);
                        break;
                    }
                    case 10: {
                        response = reader.hasNext() ? READER.readPropertyResult(reader, nextName2) : null;
                        break;
                    }
                    case 11: {
                        response = reader.hasNext() ? READER.readPrototypeResult(reader, nextName2) : null;
                        break;
                    }
                    case 12: {
                        if (nextName2 == null) {
                            nextName2 = reader.nextName();
                        }
                        response = null;
                        do {
                            if (Intrinsics.areEqual((Object)nextName2, (Object)"bindings")) {
                                response = READER.readBindings(reader, null);
                                break block5;
                            }
                            reader.skipValue();
                            nextName2 = reader.nextName();
                        } while (reader.hasNext());
                        break;
                    }
                    case 13: {
                        response = READER.readListTabsResult(reader, nextName2);
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        response = null;
                        break;
                    }
                    default: {
                        String rejectError = "Unknown response " + method.getProtocolName() + ", actor " + actor;
                        CommandProcessorKt.getLOG().error(rejectError);
                        item.getCallback().onError(rejectError);
                        return;
                    }
                }
                item.getCallback().onSuccess(response, null);
            } else if (item.getMethod() == FirefoxRequest.Method.RELEASE_MANY && Intrinsics.areEqual((Object)error, (Object)"notReleasable")) {
                item.getCallback().onSuccess(null, null);
            } else {
                String string = errorDescription;
                item.getCallback().onError(error + (String)(string == null ? "" : ", " + string));
            }
        }
        finally {
            if (nextRequest != null) {
                this.writer.invoke((Object)CommandProcessorKt.requestToByteBuf$default((Request)nextRequest, (boolean)false, (int)2, null));
            } else {
                this.releaseThreadIfPossible(actor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseThreadIfPossible(String actor) {
        if (this.forcedPause) {
            return;
        }
        String actorThread = this.actorToThread.get(actor);
        ConcurrentHashMap<String, ThreadState> concurrentHashMap = this.threadToState;
        synchronized (concurrentHashMap) {
            boolean bl = false;
            if (actorThread != null && this.threadsToResume.contains(actorThread) && !this.hasPendingRequestRequiringPause(actorThread)) {
                CommandProcessorKt.getLOG().assertTrue(this.threadToState.get(actorThread) == ThreadState.PAUSED);
                this.send(FirefoxRequest.Companion.resumeThread(actorThread, this.isBreakOnException));
                this.threadToState.put(actorThread, ThreadState.RUNNING);
                this.threadsToResume.remove(actorThread);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void forcedReleaseThread(@NotNull String thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.forcedPause = false;
        this.threadsToResume.add(thread);
        this.releaseThreadIfPossible(thread);
    }

    private final boolean hasPendingRequestRequiringPause(String thread) {
        for (Map.Entry entry : ((Map)this.messageManager.getActorToCurrentItem()).entrySet()) {
            RequestItem item;
            String actor = (String)entry.getKey();
            for (RequestItem currentItem = item = (RequestItem)entry.getValue(); currentItem != null; currentItem = currentItem.getNext()) {
                FirefoxRequest<Object> message = currentItem.getMessage();
                if (message == null || !message.requiresPause() || !Intrinsics.areEqual((Object)this.actorToThread.get(actor), (Object)thread)) continue;
                return true;
            }
        }
        return false;
    }

    private final void handleEvent(JsonReaderEx reader, String nextName, String actor, String type) {
        EventListener eventListener = this.dispatcher.getMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)eventListener, (String)"getMulticaster(...)");
        IFirefoxListener multicaster = (IFirefoxListener)eventListener;
        if (Intrinsics.areEqual((Object)type, (Object)"tabDetached")) {
            multicaster.tabDetached(actor);
        } else if (Intrinsics.areEqual((Object)type, (Object)"paused")) {
            this.threadToState.put(actor, ThreadState.PAUSED);
            multicaster.paused(READER.readThreadInterrupted(reader, nextName));
        } else if (Intrinsics.areEqual((Object)type, (Object)"frameUpdate")) {
            String name = nextName;
            if (name == null && reader.hasNext()) {
                name = reader.nextName();
            }
            boolean destroyAll = false;
            if (name != null) {
                while (true) {
                    if (Intrinsics.areEqual((Object)name, (Object)"destroyAll")) {
                        destroyAll = reader.nextBoolean();
                        break;
                    }
                    reader.skipValue();
                    if (reader.nextNameOrNull() == null) break;
                }
            }
            multicaster.frameUpdated(actor, destroyAll);
        } else if (Intrinsics.areEqual((Object)type, (Object)"newSource")) {
            String name = nextName;
            if (name == null) {
                name = reader.nextName();
            }
            while (true) {
                if (Intrinsics.areEqual((Object)name, (Object)"source")) {
                    multicaster.scriptAdded(READER.readSource(reader, null));
                } else {
                    reader.skipValue();
                    if (reader.nextNameOrNull() != null) {
                        continue;
                    }
                }
                break;
            }
        } else if (!Intrinsics.areEqual((Object)type, (Object)"tabNavigated") && !Intrinsics.areEqual((Object)type, (Object)"tabListChanged")) {
            CommandProcessorKt.getLOG().warn("Unhandled event " + actor + ":" + type);
        }
    }

    public final void clear() {
        this.messageManager.clear();
        for (String key : (ConcurrentHashMap.KeySetView)this.threadToState.keySet()) {
            this.threadToState.put(key, ThreadState.RUNNING);
        }
    }

    private static final void attachToThreadAndExecute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$Companion;", "", "()V", "READER", "Lcom/jetbrains/firefox/rdp/FirefoxProtocolReaderImpl;", "write", "Lio/netty/channel/ChannelFuture;", "contentBuffer", "Lio/netty/buffer/ByteBuf;", "channel", "Lio/netty/channel/Channel;", "intellij.javascript.firefox.connector"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChannelFuture write(@NotNull ByteBuf contentBuffer, @NotNull Channel channel) {
            Intrinsics.checkNotNullParameter((Object)contentBuffer, (String)"contentBuffer");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            ByteBuf lengthBuffer = channel.alloc().ioBuffer(8);
            int n = contentBuffer.readableBytes();
            Intrinsics.checkNotNull((Object)lengthBuffer);
            BufferToCharsKt.writeIntAsAscii((int)n, (ByteBuf)lengthBuffer);
            lengthBuffer.writeByte(58);
            channel.write((Object)lengthBuffer);
            ChannelFuture channelFuture = channel.writeAndFlush((Object)contentBuffer);
            Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"writeAndFlush(...)");
            return channelFuture;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ \u0010\f\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$FirefoxMessageManager;", "Lorg/jetbrains/rpc/MessageManagerBase;", "(Lcom/jetbrains/firefox/FirefoxCommandProcessor;)V", "actorToCurrentItem", "Ljava/util/HashMap;", "", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;", "getActorToCurrentItem", "()Ljava/util/HashMap;", "cancelWaitingRequests", "", "clear", "send", "message", "Lcom/jetbrains/firefox/FirefoxRequest;", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "", "intellij.javascript.firefox.connector"})
    private final class FirefoxMessageManager
    extends MessageManagerBase {
        @NotNull
        private final HashMap<String, RequestItem> actorToCurrentItem = new HashMap();

        @NotNull
        public final HashMap<String, RequestItem> getActorToCurrentItem() {
            return this.actorToCurrentItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void send(@NotNull FirefoxRequest<?> message, @NotNull RequestCallback<Object> callback) {
            AbstractMap abstractMap;
            Intrinsics.checkNotNullParameter(message, (String)"message");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            if (this.rejectIfClosed(callback)) {
                return;
            }
            String actor = message.getActor();
            if (message.requiresPause()) {
                String string = FirefoxCommandProcessor.this.getActorToThread().get(actor);
                Intrinsics.checkNotNull((Object)string);
                String thread = string;
                abstractMap = FirefoxCommandProcessor.this.getThreadToState();
                FirefoxCommandProcessor firefoxCommandProcessor = FirefoxCommandProcessor.this;
                AbstractMap abstractMap2 = abstractMap;
                synchronized (abstractMap2) {
                    boolean bl = false;
                    ThreadState state = firefoxCommandProcessor.getThreadToState().get(thread);
                    if (state == ThreadState.RUNNING) {
                        firefoxCommandProcessor.send(FirefoxRequest.Companion.interrupt(thread)).onSuccess(arg_0 -> FirefoxMessageManager.send$lambda$2$lambda$0((Function1)new Function1<ThreadInterrupted, Unit>(this, message, callback){
                            final /* synthetic */ FirefoxMessageManager this$0;
                            final /* synthetic */ FirefoxRequest<?> $message;
                            final /* synthetic */ RequestCallback<Object> $callback;
                            {
                                this.this$0 = $receiver;
                                this.$message = $message;
                                this.$callback = $callback;
                                super(1);
                            }

                            public final void invoke(ThreadInterrupted it) {
                                this.this$0.send(this.$message, this.$callback);
                            }
                        }, arg_0)).onError(arg_0 -> FirefoxMessageManager.send$lambda$2$lambda$1((Function1)new Function1<Throwable, Unit>(firefoxCommandProcessor, thread, callback){
                            final /* synthetic */ FirefoxCommandProcessor this$0;
                            final /* synthetic */ String $thread;
                            final /* synthetic */ RequestCallback<Object> $callback;
                            {
                                this.this$0 = $receiver;
                                this.$thread = $thread;
                                this.$callback = $callback;
                                super(1);
                            }

                            public final void invoke(Throwable it) {
                                this.this$0.getThreadToState().put(this.$thread, ThreadState.RUNNING);
                                Intrinsics.checkNotNull((Object)it);
                                this.$callback.onError(it);
                            }
                        }, arg_0));
                        firefoxCommandProcessor.getThreadToState().put(thread, ThreadState.PAUSED);
                        firefoxCommandProcessor.getThreadsToResume().add(thread);
                        return;
                    }
                    bl = CommandProcessorKt.getLOG().assertTrue(state == ThreadState.PAUSED, (Object)state);
                }
            }
            message.finalize(-1);
            abstractMap = this.actorToCurrentItem;
            synchronized (abstractMap) {
                boolean bl = false;
                RequestItem item = this.actorToCurrentItem.get(actor);
                if (item != null) {
                    RequestItem prev = item;
                    while (prev.getNext() != null) {
                        Intrinsics.checkNotNull((Object)prev.getNext());
                    }
                    prev.setNext(new RequestItem(message, message.getMethod(), callback));
                    return;
                }
                RequestItem requestItem = this.actorToCurrentItem.put(actor, new RequestItem(null, message.getMethod(), callback));
            }
            FirefoxCommandProcessor.this.writer.invoke((Object)CommandProcessorKt.requestToByteBuf$default((Request)message, (boolean)false, (int)2, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear() {
            HashMap<String, RequestItem> hashMap = this.actorToCurrentItem;
            synchronized (hashMap) {
                boolean bl = false;
                this.cancelWaitingRequests();
                this.actorToCurrentItem.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void cancelWaitingRequests() {
            HashMap<String, RequestItem> hashMap = this.actorToCurrentItem;
            synchronized (hashMap) {
                boolean bl = false;
                block3: for (RequestItem listItem : this.actorToCurrentItem.values()) {
                    Intrinsics.checkNotNull((Object)listItem);
                    RequestItem item = listItem;
                    while (true) {
                        item.setMessage(null);
                        MessageManagerBaseKt.reject(item.getCallback());
                        if (item.getNext() == null) continue block3;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        private static final void send$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void send$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$IFirefoxListener;", "Ljava/util/EventListener;", "frameUpdated", "", "actor", "", "destroyAll", "", "paused", "event", "Lcom/jetbrains/firefox/rdp/ThreadInterrupted;", "scriptAdded", "script", "Lcom/jetbrains/firefox/rdp/Source;", "tabDetached", "intellij.javascript.firefox.connector"})
    public static interface IFirefoxListener
    extends EventListener {
        public void tabDetached(@NotNull String var1);

        public void paused(@NotNull ThreadInterrupted var1);

        public void frameUpdated(@NotNull String var1, boolean var2);

        public void scriptAdded(@NotNull Source var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;", "", "message", "Lcom/jetbrains/firefox/FirefoxRequest;", "method", "Lcom/jetbrains/firefox/FirefoxRequest$Method;", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "(Lcom/jetbrains/firefox/FirefoxRequest;Lcom/jetbrains/firefox/FirefoxRequest$Method;Lorg/jetbrains/rpc/RequestCallback;)V", "getCallback", "()Lorg/jetbrains/rpc/RequestCallback;", "getMessage", "()Lcom/jetbrains/firefox/FirefoxRequest;", "setMessage", "(Lcom/jetbrains/firefox/FirefoxRequest;)V", "getMethod", "()Lcom/jetbrains/firefox/FirefoxRequest$Method;", "next", "getNext", "()Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;", "setNext", "(Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;)V", "intellij.javascript.firefox.connector"})
    private static final class RequestItem {
        @Nullable
        private FirefoxRequest<Object> message;
        @NotNull
        private final FirefoxRequest.Method method;
        @NotNull
        private final RequestCallback<Object> callback;
        @Nullable
        private RequestItem next;

        public RequestItem(@Nullable FirefoxRequest<Object> message, @NotNull FirefoxRequest.Method method, @NotNull RequestCallback<Object> callback) {
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.message = message;
            this.method = method;
            this.callback = callback;
        }

        @Nullable
        public final FirefoxRequest<Object> getMessage() {
            return this.message;
        }

        public final void setMessage(@Nullable FirefoxRequest<Object> firefoxRequest) {
            this.message = firefoxRequest;
        }

        @NotNull
        public final FirefoxRequest.Method getMethod() {
            return this.method;
        }

        @NotNull
        public final RequestCallback<Object> getCallback() {
            return this.callback;
        }

        @Nullable
        public final RequestItem getNext() {
            return this.next;
        }

        public final void setNext(@Nullable RequestItem requestItem) {
            this.next = requestItem;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$ThreadState;", "", "(Ljava/lang/String;I)V", "PAUSED", "RUNNING", "intellij.javascript.firefox.connector"})
    public static final class ThreadState
    extends Enum<ThreadState> {
        public static final /* enum */ ThreadState PAUSED = new ThreadState();
        public static final /* enum */ ThreadState RUNNING = new ThreadState();
        private static final /* synthetic */ ThreadState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ThreadState[] values() {
            return (ThreadState[])$VALUES.clone();
        }

        public static ThreadState valueOf(String value) {
            return Enum.valueOf(ThreadState.class, value);
        }

        @NotNull
        public static EnumEntries<ThreadState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = threadStateArray = new ThreadState[]{ThreadState.PAUSED, ThreadState.RUNNING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirefoxRequest.Method.values().length];
            try {
                nArray[FirefoxRequest.Method.ATTACH_TO_THREAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.ATTACH_TO_TAB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.INTERRUPT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.RESUME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.SET_BREAKPOINT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.SOURCES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.SOURCE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.FRAMES.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.PROTOTYPE_AND_PROPERTIES.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.PROPERTY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.PROTOTYPE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.BINDINGS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.LIST_TABS.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.INITIAL.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.DETACH.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.DELETE.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.CLIENT_EVALUATE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.THREAD_GRIP.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.THREAD_GRIPS.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirefoxRequest.Method.RELEASE_MANY.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

