/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.TaskProblemsHolder;
import com.intellij.plugins.watcher.TaskRunner;
import com.intellij.plugins.watcher.inspections.TaskInspectionBase;
import com.intellij.plugins.watcher.problems.TaskProblemDescription;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskProblemsInspection
extends TaskInspectionBase {
    @NotNull
    public String getShortName() {
        return TaskProblemsInspection.getInspectionShortName();
    }

    @NotNull
    public static String getInspectionShortName() {
        return "TaskProblemsInspection";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<TaskProblemDescription> descriptions;
        if (file == null) {
            TaskProblemsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            TaskProblemsInspection.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        TaskProblemsHolder problemsHolder = TaskRunner.getInstance(file.getProject()).getProblemsHolder();
        List<TaskProblemDescription> list = descriptions = virtualFile != null ? problemsHolder.findProblems(file) : Collections.emptyList();
        if (descriptions.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>(descriptions.size());
        for (TaskProblemDescription description : descriptions) {
            ProblemDescriptor descriptor = TaskProblemsInspection.createProblemDescriptor(description, file, manager, isOnTheFly);
            if (descriptor == null) continue;
            descriptors.add(descriptor);
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private static ProblemDescriptor createProblemDescriptor(TaskProblemDescription taskProblemDescription, @NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement element;
        int lineStartOffset;
        if (file == null) {
            TaskProblemsInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            TaskProblemsInspection.$$$reportNull$$$0(3);
        }
        Document document = file.getViewProvider().getDocument();
        Integer line = taskProblemDescription.getLine();
        if (document == null || line == null) {
            return null;
        }
        if (0 > line || line >= document.getLineCount()) {
            return null;
        }
        int errorStartOffset = lineStartOffset = document.getLineStartOffset(line.intValue());
        boolean afterEndOfLine = false;
        if (taskProblemDescription.getColumn() != null) {
            int lineEndOffset = document.getLineEndOffset(line.intValue());
            boolean bl = afterEndOfLine = (errorStartOffset += taskProblemDescription.getColumn().intValue()) == lineEndOffset;
        }
        if ((element = file.findElementAt(errorStartOffset)) == null && lineStartOffset < errorStartOffset) {
            element = file.findElementAt(errorStartOffset - 1);
        }
        if (element != null) {
            if (afterEndOfLine) {
                element = TaskProblemsInspection.findLastElementInLine(element, document, line);
            }
            @NlsSafe String message = taskProblemDescription.getMessage();
            ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (message != null && StringUtil.containsIgnoreCase((String)message, (String)"error")) {
                highlightType = ProblemHighlightType.GENERIC_ERROR;
            }
            String descriptionMessage = TaskProblemsInspection.createDescription(message);
            return manager.createProblemDescriptor(element, descriptionMessage, LocalQuickFix.EMPTY_ARRAY, highlightType, isOnTheFly, afterEndOfLine);
        }
        return null;
    }

    @NotNull
    @InspectionMessage
    private static String createDescription(@Nullable @NlsSafe String message) {
        if (StringUtil.isEmpty((String)message)) {
            String string = BackgroundTaskBundle.message("inspection.empty.message", new Object[0]);
            if (string == null) {
                TaskProblemsInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (message.contains("\n")) {
            String string = new HtmlBuilder().append(message).wrapWith("pre").wrapWith("body").wrapWith("html").toString();
            if (string == null) {
                TaskProblemsInspection.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            TaskProblemsInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static PsiElement findLastElementInLine(@NotNull PsiElement initialElement, @NotNull Document document, int documentLine) {
        if (initialElement == null) {
            TaskProblemsInspection.$$$reportNull$$$0(7);
        }
        if (document == null) {
            TaskProblemsInspection.$$$reportNull$$$0(8);
        }
        PsiElement element = PsiTreeUtil.lastChild((PsiElement)initialElement);
        while (element != null) {
            if (!(element instanceof PsiErrorElement) && element.getTextLength() > 0) {
                int endOffset = element.getTextRange().getEndOffset();
                if (endOffset < 0 || document.getTextLength() < endOffset) {
                    throw new AssertionError((Object)"Element end offset is out of document");
                }
                int endLineNumber = document.getLineNumber(endOffset);
                if (endLineNumber == documentLine) {
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        TaskProblemsInspection.$$$reportNull$$$0(9);
                    }
                    return psiElement;
                }
                if (endLineNumber < documentLine) {
                    PsiElement psiElement = initialElement;
                    if (psiElement == null) {
                        TaskProblemsInspection.$$$reportNull$$$0(10);
                    }
                    return psiElement;
                }
            }
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        PsiElement psiElement = initialElement;
        if (psiElement == null) {
            TaskProblemsInspection.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/inspections/TaskProblemsInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/inspections/TaskProblemsInspection";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescription";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findLastElementInLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findLastElementInLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

