/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.ui.WatchersPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchersConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String CONFIGURABLE_ID = "watcher.settings";
    private final Project myProject;
    private WatchersPanel myPanel;

    public WatchersConfigurable(@NotNull Project project) {
        if (project == null) {
            WatchersConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public String getDisplayName() {
        return BackgroundTaskBundle.message("settings.name", new Object[0]);
    }

    @NotNull
    public String getId() {
        return CONFIGURABLE_ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        if (option.isEmpty()) {
            return null;
        }
        if (this.myPanel == null || !this.myPanel.getComponent().isShowing()) {
            return null;
        }
        for (BackgroundTaskConsumer consumer : BackgroundTaskConsumer.EP_NAME.getExtensionList()) {
            String name = consumer.getOptionsTemplate().getName();
            if (!StringUtil.containsIgnoreCase((String)name, (String)option)) continue;
            return () -> this.myPanel.showTemplatesPopup(name);
        }
        return null;
    }

    public String getHelpTopic() {
        return "settings.project.settings.file.watchers";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new WatchersPanel(this.myProject);
        }
        return this.myPanel.getComponent();
    }

    public WatchersPanel getPanel() {
        this.createComponent();
        return this.myPanel;
    }

    public boolean isModified() {
        if (this.myPanel == null) {
            return false;
        }
        return this.myPanel.isModified();
    }

    public void apply() {
        if (this.myPanel != null) {
            this.myPanel.apply();
        }
    }

    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.reset();
        }
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/config/WatchersConfigurable", "<init>"));
    }
}

