/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfo;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfoProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.FileWatcherOnSaveInfo;
import com.intellij.plugins.watcher.config.NoFileWatchersOnSaveInfo;
import com.intellij.plugins.watcher.config.WatchersConfigurable;
import com.intellij.plugins.watcher.config.ui.WatcherInfo;
import com.intellij.plugins.watcher.config.ui.WatchersPanel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileWatcherOnSaveInfoProvider
extends ActionOnSaveInfoProvider {
    private static final Logger LOG = Logger.getInstance(FileWatcherOnSaveInfoProvider.class);

    @NotNull
    protected Collection<? extends ActionOnSaveInfo> getActionOnSaveInfos(@NotNull ActionOnSaveContext context) {
        Configurable configurable;
        if (context == null) {
            FileWatcherOnSaveInfoProvider.$$$reportNull$$$0(0);
        }
        if ((configurable = context.getSettings().getConfigurableWithInitializedUiComponent("watcher.settings", false)) instanceof ConfigurableWrapper) {
            configurable = ((ConfigurableWrapper)configurable).getRawConfigurable();
        }
        if (configurable == null) {
            return FileWatcherOnSaveInfoProvider.createOnSaveInfos(context, WatchersPanel.getStoredState(context.getProject()));
        }
        if (!(configurable instanceof WatchersConfigurable)) {
            LOG.error("Unexpected configurable type:" + configurable.getClass() + "\n" + (UnnamedConfigurable)configurable);
            List list = Collections.emptyList();
            if (list == null) {
                FileWatcherOnSaveInfoProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        return FileWatcherOnSaveInfoProvider.createOnSaveInfos(context, ((WatchersConfigurable)configurable).getPanel().getCurrentWatcherInfos());
    }

    public Collection<String> getSearchableOptions() {
        return List.of(BackgroundTaskBundle.message("settings.name", new Object[0]));
    }

    @NotNull
    private static Collection<? extends ActionOnSaveInfo> createOnSaveInfos(@NotNull ActionOnSaveContext context, @NotNull List<WatcherInfo> watcherInfos) {
        if (context == null) {
            FileWatcherOnSaveInfoProvider.$$$reportNull$$$0(2);
        }
        if (watcherInfos == null) {
            FileWatcherOnSaveInfoProvider.$$$reportNull$$$0(3);
        }
        if (watcherInfos.isEmpty()) {
            List<NoFileWatchersOnSaveInfo> list = Collections.singletonList(new NoFileWatchersOnSaveInfo(context));
            if (list == null) {
                FileWatcherOnSaveInfoProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = ContainerUtil.map(watcherInfos, info -> new FileWatcherOnSaveInfo(context, watcherInfos, (WatcherInfo)info));
        if (list == null) {
            FileWatcherOnSaveInfoProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/config/FileWatcherOnSaveInfoProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcherInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/config/FileWatcherOnSaveInfoProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionOnSaveInfos";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createOnSaveInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionOnSaveInfos";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createOnSaveInfos";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

