/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.json;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "DevContainersJsonSchemaProvider", "intellij.clouds.docker.gateway"})
public final class DevcontainerJsonSchemaProvider
implements JsonSchemaProviderFactory {
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object)new DevContainersJsonSchemaProvider());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonSchemaProvider$DevContainersJsonSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "()V", "getName", "", "getSchemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "isAvailable", "", "file", "intellij.clouds.docker.gateway"})
    public static final class DevContainersJsonSchemaProvider
    implements JsonSchemaFileProvider {
        @NotNull
        public String getName() {
            return "Dev Containers";
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.embeddedSchema;
        }

        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return StringsKt.equals((String)"devcontainer.json", (String)file.getName(), (boolean)true);
        }

        @Nullable
        public VirtualFile getSchemaFile() {
            URL uRL = this.getClass().getResource("/schemas/devcontainer.json");
            Intrinsics.checkNotNull((Object)uRL);
            return VfsUtil.findFileByURL((URL)uRL);
        }
    }
}

