/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.ideSettings;

import com.intellij.clouds.docker.gateway.ideSettings.DevcontainerIdeSettingsDeployer;
import com.intellij.clouds.docker.gateway.ideSettings.DevcontainerIdeSettingsInitializerKt;
import com.intellij.docker.agent.devcontainers.Devcontainer;
import com.intellij.docker.agent.devcontainers.ideSettings.DevcontainerIdeConfig;
import com.intellij.docker.agent.devcontainers.ideSettings.DevcontainerIntellijIdeConfig;
import com.intellij.docker.agent.devcontainers.ideSettings.DevcontainerSettingsModel;
import com.intellij.openapi.util.text.StringUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/clouds/docker/gateway/ideSettings/DevcontainerIdeSettingsDeployer;", "", "config", "Lcom/intellij/docker/agent/devcontainers/Devcontainer$Config;", "optionsPath", "Ljava/nio/file/Path;", "(Lcom/intellij/docker/agent/devcontainers/Devcontainer$Config;Ljava/nio/file/Path;)V", "getConfig", "()Lcom/intellij/docker/agent/devcontainers/Devcontainer$Config;", "convertValue", "", "value", "propertyDesc", "Lcom/intellij/docker/agent/devcontainers/ideSettings/DevcontainerSettingsModel$PropertyDescriptor;", "storeIdeSettings", "", "storeIdeSettings$intellij_clouds_docker_gateway", "FileSpec", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nDevcontainerIdeSettingsInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerIdeSettingsInitializer.kt\ncom/intellij/clouds/docker/gateway/ideSettings/DevcontainerIdeSettingsDeployer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1855#2,2:169\n1855#2,2:171\n1855#2,2:173\n*S KotlinDebug\n*F\n+ 1 DevcontainerIdeSettingsInitializer.kt\ncom/intellij/clouds/docker/gateway/ideSettings/DevcontainerIdeSettingsDeployer\n*L\n52#1:169,2\n76#1:171,2\n82#1:173,2\n*E\n"})
public final class DevcontainerIdeSettingsDeployer {
    @NotNull
    private final Devcontainer.Config config;
    @NotNull
    private final Path optionsPath;

    public DevcontainerIdeSettingsDeployer(@NotNull Devcontainer.Config config2, @NotNull Path optionsPath) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)optionsPath, (String)"optionsPath");
        this.config = config2;
        this.optionsPath = optionsPath;
    }

    @NotNull
    public final Devcontainer.Config getConfig() {
        return this.config;
    }

    public final void storeIdeSettings$intellij_clouds_docker_gateway() {
        DevcontainerIntellijIdeConfig ideConfig;
        DevcontainerIdeConfig devcontainerIdeConfig = this.config.getCustomizations();
        Object object = ideConfig = devcontainerIdeConfig != null ? devcontainerIdeConfig.getJetbrains() : null;
        if (ideConfig == null) {
            return;
        }
        DevcontainerSettingsModel devcontainerSettingsModel = this.config.getSettingsModel();
        if (devcontainerSettingsModel == null) {
            return;
        }
        DevcontainerSettingsModel settingsModel = devcontainerSettingsModel;
        Map optionMap = new LinkedHashMap();
        Iterable $this$forEach$iv = ideConfig.getSettings().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSpec spec2;
            String writeValue;
            String value;
            DevcontainerSettingsModel.PropertyDescriptor propertyDesc;
            String key = (String)element$iv;
            boolean bl = false;
            DevcontainerIdeSettingsInitializerKt.access$getLogger$p().info("Processing " + key);
            if ((DevcontainerSettingsModel.PropertyDescriptor)settingsModel.getPropertyMap().get(key) == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)optionMap.computeIfAbsent(propertyDesc.getStorage(), arg_0 -> DevcontainerIdeSettingsDeployer.storeIdeSettings$lambda$4$lambda$3$lambda$0(storeIdeSettings.1.1.spec.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
            String targetName = propertyDesc.getMapTo();
            if ((String)ideConfig.getSettings().get(key) == null) continue;
            boolean bl3 = false;
            if (this.convertValue(value, propertyDesc) == null) continue;
            boolean bl4 = false;
            if (StringsKt.startsWith$default((String)targetName, (String)"!", (boolean)false, (int)2, null)) {
                String section2;
                int sectionEnd = StringsKt.indexOf$default((CharSequence)targetName, (String)":", (int)0, (boolean)false, (int)6, null);
                if (sectionEnd <= 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)targetName.substring(1, sectionEnd), (String)"substring(...)");
                String resolvedTemplate = StringsKt.replace$default((String)targetName, (String)"${value}", (String)writeValue, (boolean)false, (int)4, null);
                spec2.addOption(section2, key, resolvedTemplate);
                continue;
            }
            String section3 = StringsKt.removeSuffix((String)key, (CharSequence)("." + propertyDesc.getName()));
            spec2.addOption(section3, targetName, writeValue);
        }
        Files.createDirectories(this.optionsPath, new FileAttribute[0]);
        $this$forEach$iv = optionMap.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSpec it = (FileSpec)element$iv;
            boolean bl = false;
            it.writeTo(this.optionsPath);
        }
    }

    private final String convertValue(String value, DevcontainerSettingsModel.PropertyDescriptor propertyDesc) {
        switch (WhenMappings.$EnumSwitchMapping$0[propertyDesc.getType().ordinal()]) {
            case 1: {
                Iterable $this$forEach$iv = propertyDesc.getVariants();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DevcontainerSettingsModel.VariantInfo it = (DevcontainerSettingsModel.VariantInfo)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
                    String string = it.getMapTo();
                    if (string == null) {
                        string = value;
                    }
                    return string;
                }
                return null;
            }
            case 2: {
                try {
                    return String.valueOf(Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case 3: {
                return StringUtil.equalsIgnoreCase((CharSequence)value, (CharSequence)"true") ? "true" : "false";
            }
            case 4: {
                return value;
            }
            case 5: {
                throw new NotImplementedError(null, 1, null);
            }
            case 6: {
                throw new NotImplementedError(null, 1, null);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final FileSpec storeIdeSettings$lambda$4$lambda$3$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileSpec)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R)\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/clouds/docker/gateway/ideSettings/DevcontainerIdeSettingsDeployer$FileSpec;", "", "fileName", "", "(Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "sections", "", "getSections", "()Ljava/util/Map;", "addOption", "", "sectionName", "name", "value", "parseTemplate", "Lorg/w3c/dom/Element;", "templateContent", "toDomDocument", "Lorg/w3c/dom/Document;", "writeTo", "outputPath", "Ljava/nio/file/Path;", "intellij.clouds.docker.gateway"})
    @SourceDebugExtension(value={"SMAP\nDevcontainerIdeSettingsInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerIdeSettingsInitializer.kt\ncom/intellij/clouds/docker/gateway/ideSettings/DevcontainerIdeSettingsDeployer$FileSpec\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,168:1\n215#2:169\n215#2,2:170\n216#2:172\n*S KotlinDebug\n*F\n+ 1 DevcontainerIdeSettingsInitializer.kt\ncom/intellij/clouds/docker/gateway/ideSettings/DevcontainerIdeSettingsDeployer$FileSpec\n*L\n133#1:169\n136#1:170,2\n133#1:172\n*E\n"})
    private static final class FileSpec {
        @NotNull
        private final String fileName;
        @NotNull
        private final Map<String, Map<String, String>> sections;

        public FileSpec(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            this.fileName = fileName;
            this.sections = new LinkedHashMap();
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final Map<String, Map<String, String>> getSections() {
            return this.sections;
        }

        public final void addOption(@NotNull String sectionName, @NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Map map = this.sections.computeIfAbsent(sectionName, arg_0 -> FileSpec.addOption$lambda$0(addOption.section.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
            Map section2 = map;
            section2.put(name, value);
        }

        public final void writeTo(@NotNull Path outputPath) {
            Transformer transformer;
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            Document document = this.toDomDocument();
            Transformer $this$writeTo_u24lambda_u241 = transformer = TransformerFactory.newInstance().newTransformer();
            boolean bl = false;
            $this$writeTo_u24lambda_u241.setOutputProperty("indent", "yes");
            $this$writeTo_u24lambda_u241.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            $this$writeTo_u24lambda_u241.setOutputProperty("omit-xml-declaration", "yes");
            Transformer transformer2 = transformer;
            StringWriter writer = new StringWriter();
            transformer2.transform(new DOMSource(document), new StreamResult(writer));
            String string = writer.getBuffer().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String content2 = StringsKt.replace$default((String)string, (String)"\r", (String)"", (boolean)false, (int)4, null);
            String[] stringArray = new String[]{this.fileName};
            Path path = Path.of(((Object)outputPath).toString(), stringArray);
            byte[] byArray = content2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Files.write(path, byArray, new OpenOption[0]);
        }

        private final Document toDomDocument() {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element topElement = document.createElement("application");
            document.appendChild(topElement);
            Map<String, Map<String, String>> $this$forEach$iv = this.sections;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Map<String, String>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Map<String, String>> element$iv;
                Map.Entry<String, Map<String, String>> it = element$iv = iterator.next();
                boolean bl = false;
                Element section2 = document.createElement("component");
                section2.setAttribute("name", it.getKey());
                Map<String, String> $this$forEach$iv2 = it.getValue();
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, String> element$iv2;
                    Map.Entry<String, String> optionEntry = element$iv2 = iterator2.next();
                    boolean bl2 = false;
                    if (StringsKt.startsWith$default((String)optionEntry.getValue(), (String)"!", (boolean)false, (int)2, null)) {
                        String templateContent;
                        int templateStart = StringsKt.indexOf$default((CharSequence)optionEntry.getValue(), (String)":", (int)0, (boolean)false, (int)6, null);
                        if (templateStart <= 0) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)optionEntry.getValue().substring(templateStart + 1), (String)"substring(...)");
                        Element parsed = this.parseTemplate(templateContent);
                        section2.appendChild(document.adoptNode(parsed.cloneNode(true)));
                        continue;
                    }
                    Element option = document.createElement("option");
                    option.setAttribute("name", optionEntry.getKey());
                    option.setAttribute("value", optionEntry.getValue());
                    section2.appendChild(option);
                }
                topElement.appendChild(section2);
            }
            Intrinsics.checkNotNull((Object)document);
            return document;
        }

        @NotNull
        public final Element parseTemplate(@NotNull String templateContent) throws Exception {
            Intrinsics.checkNotNullParameter((Object)templateContent, (String)"templateContent");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource input = new InputSource(new StringReader(templateContent));
            Document document = builder.parse(input);
            Element element = document.getDocumentElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getDocumentElement(...)");
            return element;
        }

        private static final Map addOption$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Map)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DevcontainerSettingsModel.PropertyType.values().length];
            try {
                nArray[DevcontainerSettingsModel.PropertyType.Enum.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevcontainerSettingsModel.PropertyType.Integer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevcontainerSettingsModel.PropertyType.Boolean.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevcontainerSettingsModel.PropertyType.String.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevcontainerSettingsModel.PropertyType.StringList.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevcontainerSettingsModel.PropertyType.StringSet.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

