/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.actions;

import com.intellij.clouds.docker.gateway.DockerDevcontainerDeployContext;
import com.intellij.clouds.docker.gateway.DockerGatewayIcons;
import com.intellij.clouds.docker.gateway.actions.DevcontainerCreateAbstractAction;
import com.intellij.clouds.docker.gateway.actions.DevcontainerCreateWithMountedSourcesGroupKt;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.devcontainers.DevcontainerPaths;
import com.intellij.docker.agent.devcontainers.buildStrategy.DevcontainerBuildStrategy;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0094@\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/clouds/docker/gateway/actions/DevcontainerCreateWithMountedSources;", "Lcom/intellij/clouds/docker/gateway/actions/DevcontainerCreateAbstractAction;", "dockerServer", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createContext", "Lcom/intellij/clouds/docker/gateway/DockerDevcontainerDeployContext;", "project", "Lcom/intellij/openapi/project/Project;", "modelFile", "Ljava/io/File;", "workingDir", "(Lcom/intellij/openapi/project/Project;Ljava/io/File;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "update", "intellij.clouds.docker.gateway"})
final class DevcontainerCreateWithMountedSources
extends DevcontainerCreateAbstractAction {
    @NotNull
    private final RemoteServer<DockerCloudConfiguration> dockerServer;

    public DevcontainerCreateWithMountedSources(@NotNull RemoteServer<DockerCloudConfiguration> dockerServer) {
        Intrinsics.checkNotNullParameter(dockerServer, (String)"dockerServer");
        this.dockerServer = dockerServer;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (DevcontainerCreateWithMountedSourcesGroupKt.access$shouldInformUserAboutPerformanceDegradation() && !DevcontainerCreateWithMountedSourcesGroupKt.access$informUserAboutPerformanceDegradation()) {
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setIcon(DockerGatewayIcons.DevContainers);
        e.getPresentation().setText(this.dockerServer.getName());
        super.update(e);
    }

    @Override
    @Nullable
    protected Object createContext(@NotNull Project project, @NotNull File modelFile, @NotNull File workingDir, @NotNull Continuation<? super DockerDevcontainerDeployContext> $completion) {
        DockerDevcontainerDeployContext dockerDevcontainerDeployContext;
        Path path = modelFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path path2 = DevcontainerPaths.INSTANCE.computeSourcesMountPath(path);
        File file = path2 != null ? path2.toFile() : null;
        if (file == null) {
            throw new IllegalStateException("Cannot compute sources dir".toString());
        }
        File sources = file;
        DockerDevcontainerDeployContext it = dockerDevcontainerDeployContext = new DockerDevcontainerDeployContext();
        boolean bl = false;
        it.setConfig(this.dockerServer);
        it.setBuildFromLocalSources(new DevcontainerBuildStrategy.LocalBuildData(workingDir, modelFile, sources, true));
        return dockerDevcontainerDeployContext;
    }
}

