/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.EditableComponentFactory;
import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.codereview.comment.CodeReviewCommentUIUtil;
import com.intellij.collaboration.ui.codereview.timeline.StatusMessageComponentFactory;
import com.intellij.collaboration.ui.codereview.timeline.StatusMessageType;
import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.util.SwingBindingsKt;
import com.intellij.collaboration.util.ComputedResult;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.InlineIconButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHCommitShort;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommitShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.GHPRDetailsFull;
import org.jetbrains.plugins.github.pullrequest.ui.emoji.GHReactionsComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.emoji.GHReactionsPickerComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemUIUtil;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineCommentViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineItem;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineReviewViewModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001 B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0019\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0096\u0002J\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineItem;", "Ljavax/swing/JComponent;", "timelineVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineViewModel;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineViewModel;)V", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "eventComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "htmlImageLoader", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "prAuthor", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "createComponent", "commits", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommitShort;", "createReviewStatus", "review", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineReviewViewModel;", "invoke", "cs", "item", "comment", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineCommentViewModel;", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRTimelineItemComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineItemComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,218:1\n1284#2,3:219\n*S KotlinDebug\n*F\n+ 1 GHPRTimelineItemComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory\n*L\n100#1:219,3\n*E\n"})
public final class GHPRTimelineItemComponentFactory
implements Function2<CoroutineScope, GHPRTimelineItem, JComponent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GHPRTimelineViewModel timelineVm;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final AsyncHtmlImageLoader htmlImageLoader;
    @NotNull
    private final GHUser ghostUser;
    @Nullable
    private final GHActor prAuthor;
    @NotNull
    private final GHPRTimelineEventComponentFactoryImpl eventComponentFactory;
    @NotNull
    private static final String COMMIT_HREF_PREFIX = "commit://";

    public GHPRTimelineItemComponentFactory(@NotNull GHPRTimelineViewModel timelineVm2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)timelineVm2, (String)"timelineVm");
        this.timelineVm = timelineVm2;
        this.avatarIconsProvider = this.timelineVm.getAvatarIconsProvider();
        this.htmlImageLoader = this.timelineVm.getHtmlImageLoader();
        this.ghostUser = this.timelineVm.getGhostUser();
        Object object2 = ((ComputedResult)this.timelineVm.getDetailsVm().getDetails().getValue()).unbox-impl();
        this.prAuthor = object2 != null && (object2 = (GHPRDetailsFull)(Result.isFailure-impl((Object)(object = object2.unbox-impl())) ? null : object)) != null ? ((GHPRDetailsFull)object2).getAuthor() : null;
        this.eventComponentFactory = new GHPRTimelineEventComponentFactoryImpl(this.htmlImageLoader, this.avatarIconsProvider, this.ghostUser);
    }

    @NotNull
    public JComponent invoke(@NotNull CoroutineScope cs, @NotNull GHPRTimelineItem item) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        GHPRTimelineItem gHPRTimelineItem = item;
        if (gHPRTimelineItem instanceof GHPRTimelineItem.Review) {
            jComponent = this.createComponent(cs, (GHPRTimelineReviewViewModel)((Object)item));
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Comment) {
            jComponent = this.createComponent(cs, (GHPRTimelineCommentViewModel)((Object)item));
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Commits) {
            jComponent = this.createComponent(((GHPRTimelineItem.Commits)item).getCommits());
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Event) {
            JComponent jComponent2;
            try {
                jComponent2 = this.eventComponentFactory.createComponent(((GHPRTimelineItem.Event)item).getEvent());
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{e.getMessage()};
                String string = GithubBundle.message("cannot.display.item", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String body2 = string;
                GHActor gHActor = this.prAuthor;
                if (gHActor == null) {
                    gHActor = this.ghostUser;
                }
                jComponent2 = GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, this.avatarIconsProvider, gHActor, null, HtmlEditorPaneUtilKt.SimpleHtmlPane((String)body2), null, 16, null);
            }
            jComponent = jComponent2;
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Unknown) {
            Object[] objectArray = new Object[]{((GHPRTimelineItem.Unknown)item).getTypename()};
            String string = GithubBundle.message("cannot.display.item", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String body3 = string;
            GHActor gHActor = this.prAuthor;
            if (gHActor == null) {
                gHActor = this.ghostUser;
            }
            jComponent = GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, this.avatarIconsProvider, gHActor, null, HtmlEditorPaneUtilKt.SimpleHtmlPane((String)body3), null, 16, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createComponent(List<GHPullRequestCommitShort> commits) {
        GHActor gHActor;
        String string;
        Object object;
        void $this$fold$iv;
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)commits), (Function1)createComponent.commitsPanels.1.INSTANCE), (Function1)((Function1)new Function1<GHCommitShort, String>(this){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull GHCommitShort it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                HtmlChunk[] htmlChunkArray = new HtmlChunk[]{HtmlChunk.link((String)("commit://" + it.getOid()), (String)it.getAbbreviatedOid()), HtmlChunk.nbsp(), HtmlChunk.raw((String)it.getMessageHeadlineHTML())};
                HtmlBuilder builder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.p().children(htmlChunkArray));
                GHGitActor author = it.getAuthor();
                if (author != null) {
                    HtmlBuilder htmlBuilder;
                    GHUser gHUser = author.getUser();
                    if (gHUser == null) {
                        gHUser = GHPRTimelineItemComponentFactory.access$getGhostUser$p(this.this$0);
                    }
                    GHUser actor = gHUser;
                    Date date = author.getDate();
                    HtmlChunk.Element element = HtmlChunk.p();
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"p(...)");
                    HtmlChunk.Element $this$buildChildren$iv = element;
                    boolean $i$f$buildChildren = false;
                    HtmlBuilder $this$invoke_u24lambda_u240 = htmlBuilder = new HtmlBuilder();
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.append((HtmlChunk)HtmlChunk.link((String)actor.getUrl(), (String)actor.getPresentableName()));
                    if (date != null) {
                        $this$invoke_u24lambda_u240.append(HtmlChunk.nbsp());
                        $this$invoke_u24lambda_u240.append(DateFormatUtil.formatPrettyDateTime((Date)date));
                    }
                    HtmlChunk.Element element2 = htmlBuilder.wrapWith($this$buildChildren$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"wrapWith(...)");
                    HtmlChunk.Element chunk = element2;
                    builder.append((HtmlChunk)chunk);
                }
                return builder.toString();
            }
        })), (Function1)((Function1)new Function1<String, JEditorPane>(this){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final JEditorPane invoke(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                JEditorPane jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, null, null, (int)13, null);
                GHPRTimelineItemComponentFactory gHPRTimelineItemComponentFactory = this.this$0;
                JEditorPane $this$invoke_u24lambda_u240 = jEditorPane;
                boolean bl = false;
                HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)$this$invoke_u24lambda_u240, (String)text);
                HtmlEditorPaneUtilKt.onHyperlinkActivated((JEditorPane)$this$invoke_u24lambda_u240, (Function1)((Function1)new Function1<HyperlinkEvent, Unit>(gHPRTimelineItemComponentFactory){
                    final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull HyperlinkEvent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String href = it.getDescription();
                        Intrinsics.checkNotNull((Object)href);
                        if (StringsKt.startsWith$default((String)href, (String)"commit://", (boolean)false, (int)2, null)) {
                            GHPRTimelineItemComponentFactory.access$getTimelineVm$p(this.this$0).showCommit(StringsKt.removePrefix((String)href, (CharSequence)"commit://"));
                        }
                    }
                }));
                return jEditorPane;
            }
        }));
        JPanel initial$iv = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
        boolean $i$f$fold = false;
        JPanel accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void commitPane;
            JPanel jPanel;
            object = (JEditorPane)element$iv;
            JPanel panel = accumulator$iv;
            boolean bl = false;
            JPanel $this$createComponent_u24lambda_u241_u24lambda_u240 = jPanel = panel;
            boolean bl2 = false;
            $this$createComponent_u24lambda_u241_u24lambda_u240.add((Component)commitPane);
            accumulator$iv = jPanel;
        }
        JPanel commitsPanels2 = accumulator$iv;
        int commitsCount = commits.size();
        JPanel $this$createComponent_u24lambda_u242 = $i$f$fold = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
        boolean bl = false;
        if (commitsCount == 1) {
            string = GithubBundle.message("pull.request.timeline.commit.added", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{commitsCount};
            string = GithubBundle.message("pull.request.timeline.commits.added", objectArray);
        }
        object = string;
        Intrinsics.checkNotNull((Object)object);
        Object titleText = object;
        $this$createComponent_u24lambda_u242.add(HtmlEditorPaneUtilKt.SimpleHtmlPane((String)titleText));
        $this$createComponent_u24lambda_u242.add(StatusMessageComponentFactory.create$default((StatusMessageComponentFactory)StatusMessageComponentFactory.INSTANCE, (JComponent)commitsPanels2, null, (int)2, null));
        JPanel contentPanel = $i$f$fold;
        Object object2 = (GHPullRequestCommitShort)CollectionsKt.singleOrNull(commits);
        if (object2 != null && (object2 = ((GHPullRequestCommitShort)object2).getCommit()) != null && (object2 = ((GHCommitShort)object2).getAuthor()) != null && (object2 = ((GHGitActor)object2).getUser()) != null) {
            gHActor = (GHActor)object2;
        } else {
            gHActor = this.prAuthor;
            if (gHActor == null) {
                gHActor = this.ghostUser;
            }
        }
        GHActor actor = gHActor;
        Object object3 = (GHPullRequestCommitShort)CollectionsKt.singleOrNull(commits);
        return GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, this.avatarIconsProvider, actor, object3 != null && (object3 = ((GHPullRequestCommitShort)object3).getCommit()) != null && (object3 = ((GHCommitShort)object3).getAuthor()) != null ? ((GHGitActor)object3).getDate() : null, contentPanel, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createComponent(CoroutineScope $this$createComponent, GHPRTimelineCommentViewModel comment) {
        JPanel jPanel;
        JEditorPane jEditorPane;
        CoroutineScope cs = $this$createComponent;
        JEditorPane $this$createComponent_u24lambda_u243 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, (AsyncHtmlImageLoader)this.htmlImageLoader, null, (int)11, null);
        boolean bl = false;
        SwingBindingsKt.bindTextIn((JEditorPane)$this$createComponent_u24lambda_u243, (CoroutineScope)cs, (Flow)((Flow)comment.getBodyHtml()));
        JEditorPane textPane2 = jEditorPane;
        JComponent content2 = EditableComponentFactory.INSTANCE.create(cs, (JComponent)textPane2, (Flow)comment.getEditVm(), (Function2)createComponent.content.1.INSTANCE);
        JPanel $this$createComponent_u24lambda_u244 = bl = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
        boolean bl2 = false;
        $this$createComponent_u24lambda_u244.add(content2);
        $this$createComponent_u24lambda_u244.add(GHReactionsComponentFactory.INSTANCE.create(cs, comment.getReactionsVm()));
        JPanel mainPanel2 = bl;
        JPanel $this$createComponent_u24lambda_u246 = jPanel = CollaborationToolsUIUtilKt.HorizontalListPanel((int)8);
        boolean bl3 = false;
        if (comment.getCanEdit()) {
            void $this$createComponent_u24lambda_u246_u24lambda_u245;
            InlineIconButton inlineIconButton;
            InlineIconButton inlineIconButton2 = inlineIconButton = CodeReviewCommentUIUtil.INSTANCE.createEditButton((Function1)new Function1<ActionEvent, Unit>(comment){
                final /* synthetic */ GHPRTimelineCommentViewModel $comment;
                {
                    this.$comment = $comment;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$comment.editBody();
                }
            });
            JPanel jPanel2 = $this$createComponent_u24lambda_u246;
            boolean bl4 = false;
            SwingBindingsKt.bindDisabledIn((JComponent)((JComponent)$this$createComponent_u24lambda_u246_u24lambda_u245), (CoroutineScope)cs, (Flow)((Flow)comment.isBusy()));
            jPanel2.add((Component)inlineIconButton);
        }
        if (comment.getCanDelete()) {
            $this$createComponent_u24lambda_u246.add(CodeReviewCommentUIUtil.INSTANCE.createDeleteCommentIconButton((Function1)new Function1<ActionEvent, Unit>(comment){
                final /* synthetic */ GHPRTimelineCommentViewModel $comment;
                {
                    this.$comment = $comment;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$comment.delete();
                }
            }));
        }
        if (comment.getCanReact()) {
            $this$createComponent_u24lambda_u246.add((Component)CodeReviewCommentUIUtil.INSTANCE.createAddReactionButton((Function1)new Function1<ActionEvent, Unit>(comment){
                final /* synthetic */ GHPRTimelineCommentViewModel $comment;
                {
                    this.$comment = $comment;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object object = it.getSource();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                    JComponent parentComponent = (JComponent)object;
                    GHReactionsPickerComponentFactory.INSTANCE.showPopup(this.$comment.getReactionsVm(), parentComponent);
                }
            }));
        }
        JPanel actionsPanel2 = jPanel;
        return GHPRTimelineItemUIUtil.INSTANCE.createTimelineItem(this.avatarIconsProvider, comment.getAuthor(), comment.getCreatedAt(), mainPanel2, actionsPanel2);
    }

    private final JComponent createComponent(CoroutineScope $this$createComponent, GHPRTimelineReviewViewModel review) {
        JPanel jPanel;
        JEditorPane jEditorPane;
        CoroutineScope cs = $this$createComponent;
        JEditorPane $this$createComponent_u24lambda_u247 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, (AsyncHtmlImageLoader)this.htmlImageLoader, null, (int)11, null);
        boolean bl = false;
        SwingBindingsKt.bindTextIn((JEditorPane)$this$createComponent_u24lambda_u247, (CoroutineScope)cs, (Flow)((Flow)review.getBodyHtml()));
        JEditorPane textPane2 = jEditorPane;
        JComponent content2 = EditableComponentFactory.wrapTextComponent$default((EditableComponentFactory)EditableComponentFactory.INSTANCE, (CoroutineScope)cs, (JComponent)textPane2, (Flow)((Flow)review.getEditVm()), null, (int)8, null);
        JPanel $this$createComponent_u24lambda_u248 = bl = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        boolean bl2 = false;
        $this$createComponent_u24lambda_u248.add(content2);
        $this$createComponent_u24lambda_u248.add(this.createReviewStatus(review));
        JPanel contentPanel = bl;
        JPanel $this$createComponent_u24lambda_u249 = $this$createComponent_u24lambda_u248 = CollaborationToolsUIUtilKt.HorizontalListPanel((int)8);
        boolean bl3 = false;
        if (review.getCanEdit()) {
            $this$createComponent_u24lambda_u249.add((Component)CodeReviewCommentUIUtil.INSTANCE.createEditButton((Function1)new Function1<ActionEvent, Unit>(review){
                final /* synthetic */ GHPRTimelineReviewViewModel $review;
                {
                    this.$review = $review;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$review.editBody();
                }
            }));
        }
        JPanel actionsPanel2 = $this$createComponent_u24lambda_u248;
        JComponent reviewItem = GHPRTimelineItemUIUtil.INSTANCE.createTimelineItem(this.avatarIconsProvider, review.getAuthor(), review.getCreatedAt(), contentPanel, actionsPanel2);
        JPanel $this$createComponent_u24lambda_u2410 = jPanel = CollaborationToolsUIUtilKt.VerticalListPanel((int)0);
        boolean bl4 = false;
        $this$createComponent_u24lambda_u2410.add(reviewItem);
        SwingBindingsKt.bindChildIn$default((JPanel)$this$createComponent_u24lambda_u2410, (CoroutineScope)cs, (Flow)((Flow)review.getThreads()), null, (Integer)0, (Function2)createComponent.1.1.INSTANCE, (int)4, null);
        return jPanel;
    }

    private final JComponent createReviewStatus(GHPRTimelineReviewViewModel review) {
        String string = switch (WhenMappings.$EnumSwitchMapping$0[review.getState().ordinal()]) {
            case 1 -> GithubBundle.message("pull.request.timeline.approved.changes", new Object[0]);
            case 2 -> GithubBundle.message("pull.request.timeline.requested.changes", new Object[0]);
            case 3 -> GithubBundle.message("pull.request.timeline.started.review", new Object[0]);
            case 4, 5 -> GithubBundle.message("pull.request.timeline.reviewed", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)string);
        String stateText = string;
        StatusMessageType stateType = switch (WhenMappings.$EnumSwitchMapping$0[review.getState().ordinal()]) {
            case 1 -> StatusMessageType.SUCCESS;
            case 2 -> StatusMessageType.ERROR;
            case 3 -> StatusMessageType.SECONDARY_INFO;
            case 4, 5 -> StatusMessageType.INFO;
            default -> throw new NoWhenBranchMatchedException();
        };
        return StatusMessageComponentFactory.INSTANCE.create((JComponent)HtmlEditorPaneUtilKt.SimpleHtmlPane((String)stateText), stateType);
    }

    public static final /* synthetic */ GHUser access$getGhostUser$p(GHPRTimelineItemComponentFactory $this) {
        return $this.ghostUser;
    }

    public static final /* synthetic */ GHPRTimelineViewModel access$getTimelineVm$p(GHPRTimelineItemComponentFactory $this) {
        return $this.timelineVm;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Companion;", "", "()V", "COMMIT_HREF_PREFIX", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GHPullRequestReviewState.values().length];
            try {
                nArray[GHPullRequestReviewState.APPROVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.CHANGES_REQUESTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.PENDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.COMMENTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.DISMISSED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

