/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.GHNewPRDiffVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRStatisticsCollector;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016RP\u0010\u0007\u001aD\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f* \u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\r\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u000e\u001aD\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f \f* \u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f0\r\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManagerImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "diffFiles", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/diff/editor/DiffVirtualFileBase;", "kotlin.jvm.PlatformType", "", "files", "Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile;", "id", "", "getId", "()Ljava/lang/String;", "newPRDiffFile", "Ljava/util/concurrent/atomic/AtomicReference;", "createAndOpenDiffFile", "", "pullRequest", "requestFocus", "", "createAndOpenTimelineFile", "createOrGetNewPRDiffFile", "dispose", "findDiffFile", "findTimelineFile", "updateTimelineFilePresentation", "details", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRFilesManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRFilesManagerImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManagerImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,78:1\n372#2,7:79\n372#2,7:86\n*S KotlinDebug\n*F\n+ 1 GHPRFilesManagerImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManagerImpl\n*L\n37#1:79,7\n46#1:86,7\n*E\n"})
public final class GHPRFilesManagerImpl
implements GHPRFilesManager {
    @NotNull
    private final Project project;
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private final String id;
    @NotNull
    private final Map<GHPRIdentifier, GHPRTimelineVirtualFile> files;
    @NotNull
    private final Map<GHPRIdentifier, DiffVirtualFileBase> diffFiles;
    @NotNull
    private AtomicReference<DiffVirtualFileBase> newPRDiffFile;

    public GHPRFilesManagerImpl(@NotNull Project project, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.project = project;
        this.repository = repository;
        this.id = String.valueOf(System.currentTimeMillis());
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakValueMap(...)");
        this.files = map2;
        Map map3 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createWeakValueMap(...)");
        this.diffFiles = map3;
        this.newPRDiffFile = new AtomicReference();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public DiffVirtualFileBase createOrGetNewPRDiffFile() {
        DiffVirtualFileBase diffVirtualFileBase = this.newPRDiffFile.updateAndGet(arg_0 -> GHPRFilesManagerImpl.createOrGetNewPRDiffFile$lambda$0(this, arg_0));
        Intrinsics.checkNotNull((Object)diffVirtualFileBase);
        return diffVirtualFileBase;
    }

    @Override
    public void createAndOpenTimelineFile(@NotNull GHPRIdentifier pullRequest, boolean requestFocus) {
        GHPRTimelineVirtualFile gHPRTimelineVirtualFile;
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        Map<GHPRIdentifier, GHPRTimelineVirtualFile> $this$getOrPut$iv = this.files;
        boolean $i$f$getOrPut = false;
        GHPRTimelineVirtualFile value$iv = $this$getOrPut$iv.get(pullRequest);
        if (value$iv == null) {
            boolean bl = false;
            GHPRTimelineVirtualFile answer$iv = new GHPRTimelineVirtualFile(this.getId(), this.project, this.repository, pullRequest);
            $this$getOrPut$iv.put(pullRequest, answer$iv);
            gHPRTimelineVirtualFile = answer$iv;
        } else {
            gHPRTimelineVirtualFile = value$iv;
        }
        GHPRTimelineVirtualFile it = gHPRTimelineVirtualFile;
        boolean bl = false;
        FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)it, requestFocus);
        GHPRStatisticsCollector.INSTANCE.logTimelineOpened(this.project);
    }

    @Override
    public void createAndOpenDiffFile(@NotNull GHPRIdentifier pullRequest, boolean requestFocus) {
        DiffVirtualFileBase diffVirtualFileBase;
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        Map<GHPRIdentifier, DiffVirtualFileBase> $this$getOrPut$iv = this.diffFiles;
        boolean $i$f$getOrPut = false;
        DiffVirtualFileBase value$iv = $this$getOrPut$iv.get(pullRequest);
        if (value$iv == null) {
            boolean bl = false;
            DiffVirtualFileBase answer$iv = (DiffVirtualFileBase)new GHPRDiffVirtualFile(this.getId(), this.project, this.repository, pullRequest);
            $this$getOrPut$iv.put(pullRequest, answer$iv);
            diffVirtualFileBase = answer$iv;
        } else {
            diffVirtualFileBase = value$iv;
        }
        DiffVirtualFileBase it = diffVirtualFileBase;
        boolean bl = false;
        DiffEditorTabFilesManager.Companion.getInstance(this.project).showDiffFile((VirtualFile)it, requestFocus);
        GHPRStatisticsCollector.INSTANCE.logDiffOpened(this.project);
    }

    @Override
    @Nullable
    public GHPRTimelineVirtualFile findTimelineFile(@NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        return this.files.get(pullRequest);
    }

    @Override
    @Nullable
    public DiffVirtualFileBase findDiffFile(@NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        return this.diffFiles.get(pullRequest);
    }

    @Override
    public void updateTimelineFilePresentation(@NotNull GHPullRequestShort details2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
            GHPRTimelineVirtualFile gHPRTimelineVirtualFile = this.findTimelineFile(details2.getPrId());
            if (gHPRTimelineVirtualFile == null) break block0;
            GHPRTimelineVirtualFile it = gHPRTimelineVirtualFile;
            boolean bl = false;
            FileEditorManagerEx.Companion.getInstanceEx(this.project).updateFilePresentation((VirtualFile)it);
        }
    }

    public void dispose() {
        if (this.project.isDisposed()) {
            return;
        }
        FileEditorManager fileManager = FileEditorManager.getInstance((Project)this.project);
        TransactionGuard transactionGuard = TransactionGuard.getInstance();
        Intrinsics.checkNotNull((Object)transactionGuard, (String)"null cannot be cast to non-null type com.intellij.openapi.application.TransactionGuardImpl");
        ((TransactionGuardImpl)transactionGuard).performUserActivity(() -> GHPRFilesManagerImpl.dispose$lambda$7(this, fileManager));
    }

    private static final DiffVirtualFileBase createOrGetNewPRDiffFile$lambda$0(GHPRFilesManagerImpl this$0, DiffVirtualFileBase it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DiffVirtualFileBase diffVirtualFileBase = it;
        if (diffVirtualFileBase == null) {
            diffVirtualFileBase = (DiffVirtualFileBase)new GHNewPRDiffVirtualFile(this$0.getId(), this$0.project, this$0.repository);
        }
        return diffVirtualFileBase;
    }

    private static final void dispose$lambda$7(GHPRFilesManagerImpl this$0, FileEditorManager $fileManager) {
        block1: {
            DiffVirtualFileBase diffVirtualFileBase;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            for (Object file2 : CollectionsKt.plus(this$0.files.values(), (Iterable)this$0.diffFiles.values())) {
                $fileManager.closeFile((VirtualFile)file2);
            }
            DiffVirtualFileBase diffVirtualFileBase2 = this$0.newPRDiffFile.get();
            if (diffVirtualFileBase2 == null) break block1;
            DiffVirtualFileBase it = diffVirtualFileBase = diffVirtualFileBase2;
            boolean bl = false;
            $fileManager.closeFile((VirtualFile)it);
        }
    }
}

