/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.api.data.GraphQLRequestPagination;
import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.collaboration.auth.Account;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.PatternUtil;
import git4idea.config.GitSharedSettings;
import git4idea.fetch.GitFetchHandler;
import git4idea.remote.hosting.HostedGitRepositoriesManager;
import git4idea.remote.hosting.HostedGitRepositoriesManagerKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHBranchProtectionRule;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.extensions.GHProtectedBranchRulesLoaderKt;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubProjectSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/extensions/GHProtectedBranchRulesLoader;", "Lgit4idea/fetch/GitFetchHandler;", "()V", "doAfterSuccessfulFetch", "", "project", "Lcom/intellij/openapi/project/Project;", "fetches", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadProtectionRules", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHProtectedBranchRulesLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHProtectedBranchRulesLoader.kt\norg/jetbrains/plugins/github/extensions/GHProtectedBranchRulesLoader\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n42#2,3:105\n42#2,3:113\n31#3,2:108\n31#3,2:111\n1#4:110\n1855#5,2:116\n*S KotlinDebug\n*F\n+ 1 GHProtectedBranchRulesLoader.kt\norg/jetbrains/plugins/github/extensions/GHProtectedBranchRulesLoader\n*L\n51#1:105,3\n90#1:113,3\n70#1:108,2\n75#1:111,2\n94#1:116,2\n*E\n"})
public final class GHProtectedBranchRulesLoader
implements GitFetchHandler {
    public void doAfterSuccessfulFetch(@NotNull Project project, @NotNull Map<GitRepository, ? extends List<GitRemote>> fetches, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(fetches, (String)"fetches");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        try {
            this.loadProtectionRules(indicator, fetches, project);
        }
        catch (Exception e) {
            if (e instanceof ProcessCanceledException) {
                throw e;
            }
            if (GHProtectedBranchRulesLoaderKt.access$getLOG$p().isDebugEnabled()) {
                GHProtectedBranchRulesLoaderKt.access$getLOG$p().info("Error occurred while trying to load branch protection rules", (Throwable)e);
            }
            GHProtectedBranchRulesLoaderKt.access$getLOG$p().info("Error occurred while trying to load branch protection rules: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadProtectionRules(ProgressIndicator indicator, Map<GitRepository, ? extends List<GitRemote>> fetches, Project project) {
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Iterator<Map.Entry<GitRepository, ? extends List<GitRemote>>> iterator = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (iterator == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GHAccountManager accountManager = (GHAccountManager)((Object)iterator);
        Set accounts = (Set)accountManager.getAccountsState().getValue();
        if (!GitSharedSettings.getInstance((Project)project).isSynchronizeBranchProtectionRules() || accounts.isEmpty()) {
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    GithubProjectSettings.Companion.getInstance(this.$project).setBranchProtectionPatterns((List<String>)new ArrayList<E>());
                }
            }), (int)1, null);
            return;
        }
        indicator.setText(GithubBundle.message("progress.text.loading.protected.branches", new Object[0]));
        Set branchProtectionPatterns = new LinkedHashSet();
        for (Map.Entry<GitRepository, ? extends List<GitRemote>> entry : fetches.entrySet()) {
            GitRepository repository = entry.getKey();
            List<GitRemote> remotes = entry.getValue();
            indicator.checkCanceled();
            for (GitRemote remote : remotes) {
                void $this$forEach$iv;
                String token2;
                GithubAccount account;
                Object object;
                GithubAccount githubAccount;
                GHGitRepositoryMapping repositoryMapping;
                Object v1;
                Object it;
                block12: {
                    indicator.checkCanceled();
                    ComponentManager $this$service$iv = (ComponentManager)project;
                    boolean $i$f$service22 = false;
                    Class<GHHostedRepositoriesManager> serviceClass$iv2 = GHHostedRepositoriesManager.class;
                    Object object2 = $this$service$iv.getService(serviceClass$iv2);
                    if (object2 == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv2);
                    }
                    Iterable $i$f$service22 = HostedGitRepositoriesManagerKt.findKnownRepositories((HostedGitRepositoriesManager)((HostedGitRepositoriesManager)object2), (GitRepository)repository);
                    for (Object e : $i$f$service22) {
                        it = (GHGitRepositoryMapping)e;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)((GHGitRepositoryMapping)it).getRemote().getRemote(), (Object)remote)) continue;
                        v1 = e;
                        break block12;
                    }
                    v1 = null;
                }
                if ((GHGitRepositoryMapping)v1 == null) continue;
                GithubServerPath serverPath = repositoryMapping.getRepository().getServerPath();
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service2 = false;
                Class<GithubProjectDefaultAccountHolder> serviceClass$iv3 = GithubProjectDefaultAccountHolder.class;
                Object object3 = $this$service$iv.getService(serviceClass$iv3);
                if (object3 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv3);
                }
                GithubAccount defaultAccount = (GithubAccount)((GithubProjectDefaultAccountHolder)((Object)object3)).getAccount();
                if (defaultAccount != null && defaultAccount.getServer().equals(serverPath, true)) {
                    githubAccount = defaultAccount;
                } else {
                    Object v4;
                    block13: {
                        it = accounts;
                        Iterator bl = it.iterator();
                        while (bl.hasNext()) {
                            object = bl.next();
                            GithubAccount it2 = (GithubAccount)((Object)object);
                            boolean bl2 = false;
                            if (!it2.getServer().equals(serverPath, true)) continue;
                            v4 = object;
                            break block13;
                        }
                        v4 = null;
                    }
                    githubAccount = v4;
                }
                if (githubAccount == null || (String)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(accountManager, account = githubAccount, null){
                    int label;
                    final /* synthetic */ GHAccountManager $accountManager;
                    final /* synthetic */ GithubAccount $account;
                    {
                        this.$accountManager = $accountManager;
                        this.$account = $account;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$accountManager.findCredentials((Account)this.$account, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })) == null) continue;
                boolean $i$f$service32 = false;
                Class<GithubApiRequestExecutor.Factory> serviceClass$iv4 = GithubApiRequestExecutor.Factory.class;
                object = ApplicationManager.getApplication().getService(serviceClass$iv4);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv4.getName() + " (classloader=" + serviceClass$iv4.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                GithubApiRequestExecutor requestExecutor = ((GithubApiRequestExecutor.Factory)object).create(account.getServer(), token2);
                Iterable $i$f$service32 = new SimpleGHGQLPagesLoader(requestExecutor, (Function1)new Function1<GraphQLRequestPagination, GithubApiRequest.Post<? extends GraphQLPagedResponseDataDTO<? extends GHBranchProtectionRule>>>(repositoryMapping){
                    final /* synthetic */ GHGitRepositoryMapping $repositoryMapping;
                    {
                        this.$repositoryMapping = $repositoryMapping;
                        super(1);
                    }

                    @NotNull
                    public final GithubApiRequest.Post<GraphQLPagedResponseDataDTO<GHBranchProtectionRule>> invoke(@NotNull GraphQLRequestPagination it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return GHGQLRequests.Repo.getProtectionRules$default(GHGQLRequests.Repo.INSTANCE, this.$repositoryMapping.getRepository(), null, 2, null);
                    }
                }, false, 0, 12, null).loadAll((ProgressIndicator)new SensitiveProgressWrapper(indicator));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GHBranchProtectionRule rule = (GHBranchProtectionRule)element$iv;
                    boolean bl = false;
                    String string = PatternUtil.convertToRegex((String)rule.getPattern());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToRegex(...)");
                    branchProtectionPatterns.add(string);
                }
            }
        }
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(project, (Set<String>)branchProtectionPatterns){
            final /* synthetic */ Project $project;
            final /* synthetic */ Set<String> $branchProtectionPatterns;
            {
                this.$project = $project;
                this.$branchProtectionPatterns = $branchProtectionPatterns;
                super(0);
            }

            public final void invoke() {
                GithubProjectSettings.Companion.getInstance(this.$project).setBranchProtectionPatterns(CollectionsKt.toMutableList((Collection)this.$branchProtectionPatterns));
            }
        }), (int)1, null);
    }
}

