/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.api.httpclient.HttpClientUtil;
import com.intellij.collaboration.ui.SimpleEventListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.HttpSecurityUtil;
import com.intellij.util.io.RequestBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.github.api.GHEServerVersionChecker;
import org.jetbrains.plugins.github.api.GHRequestExecutorBreaker;
import org.jetbrains.plugins.github.api.GithubApiContentHelper;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GithubSettings;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00122\u00020\u0001:\u0006\u0011\u0012\u0013\u0014\u0015\u0016B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J)\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000eH'\u00a2\u0006\u0002\u0010\u000fJ!\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000eH\u0007\u00a2\u0006\u0002\u0010\u0010\u0082\u0001\u0001\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "", "()V", "addListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function0;", "execute", "T", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "request", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/GithubApiRequest;)Ljava/lang/Object;", "(Lorg/jetbrains/plugins/github/api/GithubApiRequest;)Ljava/lang/Object;", "Base", "Companion", "Factory", "MutableTokenSupplier", "NoAuth", "WithTokenAuth", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubApiRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequestExecutor.kt\norg/jetbrains/plugins/github/api/GithubApiRequestExecutor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,290:1\n11#2:291\n*S KotlinDebug\n*F\n+ 1 GithubApiRequestExecutor.kt\norg/jetbrains/plugins/github/api/GithubApiRequestExecutor\n*L\n246#1:291\n*E\n"})
public abstract class GithubApiRequestExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PLUGIN_USER_AGENT_NAME = "IntelliJ-GitHub-Plugin";
    @NotNull
    private static final Logger LOG;

    private GithubApiRequestExecutor() {
    }

    public void addListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
    }

    @RequiresBackgroundThread
    public abstract <T> T execute(@NotNull ProgressIndicator var1, @NotNull GithubApiRequest<? extends T> var2) throws IOException, ProcessCanceledException;

    @TestOnly
    @RequiresBackgroundThread
    public final <T> T execute(@NotNull GithubApiRequest<? extends T> request2) throws IOException, ProcessCanceledException {
        Intrinsics.checkNotNullParameter(request2, (String)"request");
        return this.execute((ProgressIndicator)new EmptyProgressIndicator(), request2);
    }

    public /* synthetic */ GithubApiRequestExecutor(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GithubApiRequestExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J-\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00190\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "githubSettings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "(Lorg/jetbrains/plugins/github/util/GithubSettings;)V", "checkResponseCode", "", "connection", "Ljava/net/HttpURLConnection;", "checkServerVersion", "createRequestBuilder", "Lcom/intellij/util/io/RequestBuilder;", "request", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "createResponse", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "Lcom/intellij/util/io/HttpRequests$Request;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getErrorText", "", "getJsonError", "Lorg/jetbrains/plugins/github/api/data/GithubErrorMessage;", "errorText", "execute", "T", "(Lcom/intellij/util/io/RequestBuilder;Lorg/jetbrains/plugins/github/api/GithubApiRequest;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGithubApiRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequestExecutor.kt\norg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 GithubApiContentHelper.kt\norg/jetbrains/plugins/github/api/GithubApiContentHelper\n*L\n1#1,290:1\n1#2:291\n47#3:292\n*S KotlinDebug\n*F\n+ 1 GithubApiRequestExecutor.kt\norg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base\n*L\n197#1:292\n*E\n"})
    public static abstract class Base
    extends GithubApiRequestExecutor {
        @NotNull
        private final GithubSettings githubSettings;

        public Base(@NotNull GithubSettings githubSettings) {
            Intrinsics.checkNotNullParameter((Object)githubSettings, (String)"githubSettings");
            super(null);
            this.githubSettings = githubSettings;
        }

        protected final <T> T execute(@NotNull RequestBuilder $this$execute, @NotNull GithubApiRequest<? extends T> request2, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.checkCanceled();
            try {
                LOG.debug("Request: " + request2.getUrl() + " " + request2.getOperationName() + " : Connecting");
                return (T)$this$execute.connect(arg_0 -> Base.execute$lambda$1(request2, this, indicator, arg_0));
            }
            catch (GithubStatusCodeException e) {
                if (request2 instanceof GithubApiRequest.Get.Optional && e.getStatusCode() == 404) {
                    return null;
                }
                throw e;
            }
            catch (GithubConfusingException e) {
                if (request2.getOperationName() != null) {
                    String errorText = "Can't " + request2.getOperationName();
                    e.setDetails(errorText);
                    LOG.debug(errorText, (Throwable)e);
                }
                throw e;
            }
        }

        @NotNull
        protected final RequestBuilder createRequestBuilder(@NotNull GithubApiRequest<?> request2) {
            RequestBuilder requestBuilder;
            Intrinsics.checkNotNullParameter(request2, (String)"request");
            GithubApiRequest<?> githubApiRequest = request2;
            if (githubApiRequest instanceof GithubApiRequest.Get) {
                requestBuilder = HttpRequests.request((String)request2.getUrl());
            } else if (githubApiRequest instanceof GithubApiRequest.Patch) {
                requestBuilder = HttpRequests.patch((String)request2.getUrl(), (String)((GithubApiRequest.Patch)request2).getBodyMimeType());
            } else if (githubApiRequest instanceof GithubApiRequest.Post) {
                requestBuilder = HttpRequests.post((String)request2.getUrl(), (String)((GithubApiRequest.Post)request2).getBodyMimeType());
            } else if (githubApiRequest instanceof GithubApiRequest.Put) {
                requestBuilder = HttpRequests.put((String)request2.getUrl(), (String)((GithubApiRequest.Put)request2).getBodyMimeType());
            } else if (githubApiRequest instanceof GithubApiRequest.Head) {
                requestBuilder = HttpRequests.head((String)request2.getUrl());
            } else if (githubApiRequest instanceof GithubApiRequest.Delete) {
                requestBuilder = ((GithubApiRequest.Delete)request2).getBody() == null ? HttpRequests.delete((String)request2.getUrl()) : HttpRequests.delete((String)request2.getUrl(), (String)((GithubApiRequest.Delete)request2).getBodyMimeType());
            } else {
                throw new UnsupportedOperationException(request2.getClass() + " is not supported");
            }
            RequestBuilder requestBuilder2 = requestBuilder.connectTimeout(this.githubSettings.getConnectionTimeout()).userAgent(HttpClientUtil.INSTANCE.getUserAgentValue(GithubApiRequestExecutor.PLUGIN_USER_AGENT_NAME)).throwStatusCodeException(false).forceHttps(false).accept(request2.getAcceptMimeType());
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder2, (String)"accept(...)");
            return requestBuilder2;
        }

        private final void checkResponseCode(HttpURLConnection connection) throws IOException {
            GithubErrorMessage jsonError;
            GithubErrorMessage githubErrorMessage;
            GithubErrorMessage githubErrorMessage2;
            if (connection.getResponseCode() < 400) {
                return;
            }
            String statusLine = connection.getResponseCode() + " " + connection.getResponseMessage();
            String errorText = this.getErrorText(connection);
            LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " : Error " + statusLine + " body:\n" + errorText);
            String string = errorText;
            if (string != null) {
                String it = string;
                boolean bl = false;
                githubErrorMessage2 = this.getJsonError(connection, it);
            } else {
                githubErrorMessage2 = null;
            }
            if ((githubErrorMessage = (jsonError = githubErrorMessage2)) == null) {
                LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " : Unable to parse JSON error");
                githubErrorMessage = Unit.INSTANCE;
            }
            throw switch (connection.getResponseCode()) {
                case 401, 402, 403 -> {
                    IOException v5;
                    GithubErrorMessage v3 = jsonError;
                    boolean v4 = v3 != null ? v3.containsReasonMessage("API rate limit exceeded") : false;
                    if (v4) {
                        v5 = new GithubRateLimitExceededException(jsonError.getPresentableError());
                    } else {
                        Object[] var5_4 = new Object[1];
                        Object v6 = jsonError;
                        if ((v6 == null || (v6 = ((GithubErrorMessage)v6).getPresentableError()) == null) && (v6 = errorText) == null) {
                            v6 = statusLine;
                        }
                        var5_4[0] = v6;
                        v5 = new GithubAuthenticationException(GithubBundle.message("request.response.0", var5_4));
                    }
                    yield v5;
                }
                default -> jsonError != null ? new GithubStatusCodeException(statusLine + " - " + jsonError.getPresentableError(), jsonError, connection.getResponseCode()) : new GithubStatusCodeException(statusLine + " - " + errorText, connection.getResponseCode());
            };
        }

        private final void checkServerVersion(HttpURLConnection connection) {
            String string = connection.getHeaderField("x-github-enterprise-version");
            if (string == null) {
                return;
            }
            String versionHeader = string;
            GHEServerVersionChecker.INSTANCE.checkVersionSupported(versionHeader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String getErrorText(HttpURLConnection connection) {
            String string;
            InputStream inputStream = connection.getErrorStream();
            if (inputStream == null) {
                return null;
            }
            InputStream errorStream = inputStream;
            InputStream stream = Intrinsics.areEqual((Object)connection.getContentEncoding(), (Object)"gzip") ? (InputStream)new GZIPInputStream(errorStream) : errorStream;
            Closeable closeable = new InputStreamReader(stream, Charsets.UTF_8);
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)closeable;
                boolean bl = false;
                string = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return string;
        }

        private final GithubErrorMessage getJsonError(HttpURLConnection connection, String errorText) {
            String contentType = connection.getContentType();
            if (contentType == null || !StringsKt.startsWith$default((String)contentType, (String)"application/json", (boolean)false, (int)2, null)) {
                return null;
            }
            try {
                GithubApiContentHelper this_$iv = GithubApiContentHelper.INSTANCE;
                boolean $i$f$fromJson = false;
                return (GithubErrorMessage)GithubApiContentHelper.fromJson$default(errorText, GithubErrorMessage.class, false, 4, null);
            }
            catch (GithubJsonException jse) {
                return null;
            }
        }

        private final GithubApiResponse createResponse(HttpRequests.Request request2, ProgressIndicator indicator) {
            return new GithubApiResponse(request2, indicator){
                final /* synthetic */ HttpRequests.Request $request;
                final /* synthetic */ ProgressIndicator $indicator;
                {
                    this.$request = $request;
                    this.$indicator = $indicator;
                }

                @Nullable
                public String findHeader(@NotNull String headerName) {
                    Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
                    return this.$request.getConnection().getHeaderField(headerName);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public <T> T readBody(@NotNull ThrowableConvertor<Reader, T, IOException> converter) {
                    Object object;
                    Intrinsics.checkNotNullParameter(converter, (String)"converter");
                    Closeable closeable = this.$request.getReader(this.$indicator);
                    Throwable throwable = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl = false;
                        object = converter.convert((Object)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return (T)object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public <T> T handleBody(@NotNull ThrowableConvertor<InputStream, T, IOException> converter) {
                    Object object;
                    Intrinsics.checkNotNullParameter(converter, (String)"converter");
                    Closeable closeable = this.$request.getInputStream();
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl = false;
                        object = converter.convert((Object)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return (T)object;
                }
            };
        }

        private static final Object execute$lambda$1(GithubApiRequest $request, Base this$0, ProgressIndicator $indicator, HttpRequests.Request it) {
            Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            URLConnection uRLConnection = it.getConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            if ($request instanceof GithubApiRequest.WithBody) {
                LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " with body:\n" + ((GithubApiRequest.WithBody)$request).getBody() + " : Connected");
                String string = ((GithubApiRequest.WithBody)$request).getBody();
                if (string != null) {
                    String body2 = string;
                    boolean bl = false;
                    it.write(body2);
                }
            } else {
                LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " : Connected");
            }
            this$0.checkResponseCode(connection);
            this$0.checkServerVersion(connection);
            $indicator.checkCanceled();
            Object result = $request.extractResult(this$0.createResponse(it, $indicator));
            LOG.debug("Request: " + connection.getRequestMethod() + " " + connection.getURL() + " : Result extracted");
            return result;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PLUGIN_USER_AGENT_NAME", "", "isAuthorizedUrl", "", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "url", "Ljava/net/URL;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAuthorizedUrl(GithubServerPath serverPath, URL url) {
            if (!Intrinsics.areEqual((Object)url.getHost(), (Object)serverPath.getHost()) && !Intrinsics.areEqual((Object)url.getHost(), (Object)serverPath.getApiHost())) {
                LOG.debug("URL " + url + " host does not match the server " + serverPath + ". Authorization will not be granted");
                return false;
            }
            int n = url.getPort();
            Integer n2 = serverPath.getPort();
            if (n2 == null) {
                n2 = -1;
            }
            if (n != n2) {
                LOG.debug("URL " + url + " port does not match the server " + serverPath + ". Authorization will not be granted");
                return false;
            }
            if (url.getProtocol() != null && !Intrinsics.areEqual((Object)url.getProtocol(), (Object)serverPath.getSchema())) {
                LOG.debug("URL " + url + " protocol does not match the server " + serverPath + ". Authorization will not be granted");
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J(\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bH\u0002J \u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\nH\u0007J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "useProxy", "", "tokenSupplier", "Lkotlin/Function1;", "Ljava/net/URL;", "", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "token", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$MutableTokenSupplier;", "create$intellij_vcs_github", "Companion", "intellij.vcs.github"})
    public static final class Factory {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Deprecated(message="Server must be provided to match URL for authorization")
        @NotNull
        public final GithubApiRequestExecutor create(@NotNull String token2) {
            Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
            return this.create(true, (Function1<? super URL, String>)((Function1)new Function1<URL, String>(token2){
                final /* synthetic */ String $token;
                {
                    this.$token = $token;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull URL it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$token;
                }
            }));
        }

        @NotNull
        public final GithubApiRequestExecutor create(@NotNull GithubServerPath serverPath, @NotNull String token2) {
            Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
            Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
            return this.create(true, serverPath, token2);
        }

        @NotNull
        public final GithubApiRequestExecutor create$intellij_vcs_github(@NotNull MutableTokenSupplier tokenSupplier) {
            Intrinsics.checkNotNullParameter((Object)tokenSupplier, (String)"tokenSupplier");
            return this.create(true, (Function1<? super URL, String>)((Function1)tokenSupplier));
        }

        @NotNull
        public final GithubApiRequestExecutor create(boolean useProxy, @NotNull GithubServerPath serverPath, @NotNull String token2) {
            Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
            Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
            return this.create(useProxy, (Function1<? super URL, String>)((Function1)new Function1<URL, String>(serverPath, token2){
                final /* synthetic */ GithubServerPath $serverPath;
                final /* synthetic */ String $token;
                {
                    this.$serverPath = $serverPath;
                    this.$token = $token;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull URL it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return org.jetbrains.plugins.github.api.GithubApiRequestExecutor$Companion.access$isAuthorizedUrl(GithubApiRequestExecutor.Companion, this.$serverPath, it) ? this.$token : null;
                }
            }));
        }

        public static /* synthetic */ GithubApiRequestExecutor create$default(Factory factory, boolean bl, GithubServerPath githubServerPath, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return factory.create(bl, githubServerPath, string);
        }

        private final GithubApiRequestExecutor create(boolean useProxy, Function1<? super URL, String> tokenSupplier) {
            GithubSettings githubSettings = GithubSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"getInstance(...)");
            return new WithTokenAuth(githubSettings, tokenSupplier, useProxy);
        }

        static /* synthetic */ GithubApiRequestExecutor create$default(Factory factory, boolean bl, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return factory.create(bl, (Function1<? super URL, String>)function1);
        }

        @NotNull
        public final GithubApiRequestExecutor create() {
            GithubSettings githubSettings = GithubSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"getInstance(...)");
            return new NoAuth(githubSettings);
        }

        @JvmStatic
        @NotNull
        public static final Factory getInstance() {
            return Companion.getInstance();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequestExecutor.kt\norg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,290:1\n42#2,3:291\n*S KotlinDebug\n*F\n+ 1 GithubApiRequestExecutor.kt\norg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory$Companion\n*L\n240#1:291,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Factory getInstance() {
                boolean $i$f$service = false;
                Class<Factory> serviceClass$iv = Factory.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                return (Factory)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017J\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$MutableTokenSupplier;", "Lkotlin/Function1;", "Ljava/net/URL;", "", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "token", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;)V", "authDataChangedEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/collaboration/ui/SimpleEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "value", "getToken", "()Ljava/lang/String;", "setToken", "(Ljava/lang/String;)V", "addListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function0;", "invoke", "url", "intellij.vcs.github"})
    public static final class MutableTokenSupplier
    implements Function1<URL, String> {
        @NotNull
        private final GithubServerPath serverPath;
        @NotNull
        private final EventDispatcher<SimpleEventListener> authDataChangedEventDispatcher;
        @NotNull
        private volatile String token;

        public MutableTokenSupplier(@NotNull GithubServerPath serverPath, @NotNull String token2) {
            Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
            Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
            this.serverPath = serverPath;
            EventDispatcher eventDispatcher = EventDispatcher.create(SimpleEventListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
            this.authDataChangedEventDispatcher = eventDispatcher;
            this.token = token2;
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        public final void setToken(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.token = value;
            ActionsKt.runInEdt((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MutableTokenSupplier this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ((SimpleEventListener)MutableTokenSupplier.access$getAuthDataChangedEventDispatcher$p(this.this$0).getMulticaster()).eventOccurred();
                }
            }));
        }

        @Nullable
        public String invoke(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return Companion.isAuthorizedUrl(this.serverPath, url) ? this.token : null;
        }

        public final void addListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            SimpleEventListener.Companion.addDisposableListener(this.authDataChangedEventDispatcher, disposable, listener2);
        }

        public static final /* synthetic */ EventDispatcher access$getAuthDataChangedEventDispatcher$p(MutableTokenSupplier $this) {
            return $this.authDataChangedEventDispatcher;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$NoAuth;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base;", "githubSettings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "(Lorg/jetbrains/plugins/github/util/GithubSettings;)V", "execute", "T", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "request", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/GithubApiRequest;)Ljava/lang/Object;", "intellij.vcs.github"})
    public static final class NoAuth
    extends Base {
        public NoAuth(@NotNull GithubSettings githubSettings) {
            Intrinsics.checkNotNullParameter((Object)githubSettings, (String)"githubSettings");
            super(githubSettings);
        }

        @Override
        public <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubApiRequest<? extends T> request2) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(request2, (String)"request");
            indicator.checkCanceled();
            RequestBuilder requestBuilder = this.createRequestBuilder(request2).tuner(arg_0 -> NoAuth.execute$lambda$1(request2, arg_0)).useProxy(true);
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"useProxy(...)");
            return this.execute(requestBuilder, request2, indicator);
        }

        private static final void execute$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void execute$lambda$1(GithubApiRequest $request, URLConnection connection) {
            Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            $request.getAdditionalHeaders().forEach((arg_0, arg_1) -> NoAuth.execute$lambda$1$lambda$0((Function2)new Function2<String, String, Unit>((Object)connection){

                public final void invoke(String p0, String p1) {
                    ((URLConnection)this.receiver).addRequestProperty(p0, p1);
                }
            }, arg_0, arg_1));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0016J)\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithTokenAuth;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base;", "githubSettings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "tokenSupplier", "Lkotlin/Function1;", "Ljava/net/URL;", "", "useProxy", "", "(Lorg/jetbrains/plugins/github/util/GithubSettings;Lkotlin/jvm/functions/Function1;Z)V", "addListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function0;", "execute", "T", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "request", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/GithubApiRequest;)Ljava/lang/Object;", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGithubApiRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequestExecutor.kt\norg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithTokenAuth\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,290:1\n42#2,3:291\n*S KotlinDebug\n*F\n+ 1 GithubApiRequestExecutor.kt\norg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithTokenAuth\n*L\n57#1:291,3\n*E\n"})
    public static final class WithTokenAuth
    extends Base {
        @NotNull
        private final Function1<URL, String> tokenSupplier;
        private final boolean useProxy;

        public WithTokenAuth(@NotNull GithubSettings githubSettings, @NotNull Function1<? super URL, String> tokenSupplier, boolean useProxy) {
            Intrinsics.checkNotNullParameter((Object)githubSettings, (String)"githubSettings");
            Intrinsics.checkNotNullParameter(tokenSupplier, (String)"tokenSupplier");
            super(githubSettings);
            this.tokenSupplier = tokenSupplier;
            this.useProxy = useProxy;
        }

        @Override
        public <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubApiRequest<? extends T> request2) throws IOException, ProcessCanceledException {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(request2, (String)"request");
            boolean $i$f$service = false;
            Class<GHRequestExecutorBreaker> serviceClass$iv = GHRequestExecutorBreaker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            if (!(!((GHRequestExecutorBreaker)object).isRequestsShouldFail())) {
                boolean bl = false;
                String string = "Request failure was triggered by user action. This a pretty long description of this failure that should resemble some long error which can go out of bounds.";
                throw new IllegalStateException(string.toString());
            }
            indicator.checkCanceled();
            RequestBuilder requestBuilder = this.createRequestBuilder(request2).tuner(arg_0 -> WithTokenAuth.execute$lambda$2(request2, this, arg_0)).useProxy(this.useProxy);
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"useProxy(...)");
            return this.execute(requestBuilder, request2, indicator);
        }

        @Override
        public void addListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            if (this.tokenSupplier instanceof MutableTokenSupplier) {
                ((MutableTokenSupplier)this.tokenSupplier).addListener(disposable, listener2);
            }
        }

        private static final void execute$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void execute$lambda$2(GithubApiRequest $request, WithTokenAuth this$0, URLConnection connection) {
            Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            $request.getAdditionalHeaders().forEach((arg_0, arg_1) -> WithTokenAuth.execute$lambda$2$lambda$1((Function2)new Function2<String, String, Unit>((Object)connection){

                public final void invoke(String p0, String p1) {
                    ((URLConnection)this.receiver).addRequestProperty(p0, p1);
                }
            }, arg_0, arg_1));
            Function1<URL, String> function1 = this$0.tokenSupplier;
            URL uRL = connection.getURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getURL(...)");
            String token2 = (String)function1.invoke((Object)uRL);
            if (token2 != null) {
                connection.addRequestProperty("Authorization", HttpSecurityUtil.createBearerAuthHeaderValue((String)token2));
            }
        }
    }
}

