/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.Account;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.remote.hosting.HostedGitRepositoriesManager;
import git4idea.remote.hosting.HostedGitRepositoriesManagerKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GHShareProjectUtil;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.request.Type;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.exceptions.GithubMissingTokenException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.ui.dialog.GithubExistingRemotesDialog;
import org.jetbrains.plugins.github.ui.dialog.GithubUntrackedFilesDialog;
import org.jetbrains.plugins.github.util.GHCompatibilityUtil;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/GHShareProjectUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "shareProjectOnGithub", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHShareProjectUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHShareProjectUtil.kt\norg/jetbrains/plugins/github/GHShareProjectUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,338:1\n31#2,2:339\n1#3:341\n1549#4:342\n1620#4,3:343\n1549#4:349\n1620#4,3:350\n42#5,3:346\n*S KotlinDebug\n*F\n+ 1 GHShareProjectUtil.kt\norg/jetbrains/plugins/github/GHShareProjectUtil\n*L\n68#1:339,2\n69#1:342\n69#1:343,3\n116#1:349\n116#1:350,3\n78#1:346,3\n*E\n"})
public final class GHShareProjectUtil {
    @NotNull
    public static final GHShareProjectUtil INSTANCE = new GHShareProjectUtil();
    @NotNull
    private static final Logger LOG = GithubUtil.LOG;

    private GHShareProjectUtil() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @JvmStatic
    public static final void shareProjectOnGithub(@NotNull Project project, @Nullable VirtualFile file) {
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                FileDocumentManager.getInstance().saveAllDocuments();
                gitRepository = GithubGitHelper.Companion.findGitRepository(project, file);
                if (gitRepository == null) ** GOTO lbl-1000
                var5_3 /* !! */  = gitRepository;
                $this$service$iv /* !! */  = (ComponentManager)project;
                $i$f$service = false;
                serviceClass$iv = GHHostedRepositoriesManager.class;
                v0 = $this$service$iv /* !! */ .getService(serviceClass$iv);
                if (v0 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv /* !! */ , serviceClass$iv);
                }
                $this$service$iv /* !! */  = (GHHostedRepositoriesManager)v0;
                p0 = var5_3 /* !! */ ;
                $i$a$-let-GHShareProjectUtil$shareProjectOnGithub$possibleRemotes$1 = false;
                var4_15 = HostedGitRepositoriesManagerKt.findKnownRepositories((HostedGitRepositoriesManager)((HostedGitRepositoriesManager)$this$service$iv /* !! */ ), (GitRepository)p0);
                if (var4_15 != null) {
                    var5_3 /* !! */  = var4_15;
                    $i$f$map = false;
                    p0 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    var10_18 = $this$mapTo$iv$iv.iterator();
                    while (var10_18.hasNext()) {
                        item$iv$iv = var10_18.next();
                        var12_21 = (GHGitRepositoryMapping)item$iv$iv;
                        var21_24 = destination$iv$iv;
                        $i$a$-map-GHShareProjectUtil$shareProjectOnGithub$possibleRemotes$2 = false;
                        var21_24.add(it.getRemote().getUrl());
                    }
                    v1 = (List)destination$iv$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = v2 = null;
                }
                if (v1 == null) {
                    v2 = CollectionsKt.emptyList();
                }
                if (((Collection)(possibleRemotes = v2)).isEmpty() == false) {
                    existingRemotesDialog = new GithubExistingRemotesDialog(project, possibleRemotes);
                    DialogManager.show((DialogWrapper)existingRemotesDialog);
                    if (!existingRemotesDialog.isOK()) {
                        return;
                    }
                }
                $i$f$service = false;
                serviceClass$iv = ProgressManager.class;
                $this$mapTo$iv$iv = ApplicationManager.getApplication().getService(serviceClass$iv);
                if ($this$mapTo$iv$iv == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                progressManager = (ProgressManager)$this$mapTo$iv$iv;
                accountInformationProvider = GithubAccountInformationProvider.Companion.getInstance();
                gitHelper = GithubGitHelper.Companion.getInstance();
                v3 = Git.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                git = v3;
                accountInformationLoader = new Function2<GithubAccount, Component, Pair<? extends Boolean, ? extends Set<? extends String>>>(progressManager, project){
                    @NotNull
                    private final Map<GithubAccount, Pair<Boolean, Set<String>>> loadedInfo;
                    final /* synthetic */ ProgressManager $progressManager;
                    final /* synthetic */ Project $project;
                    {
                        this.$progressManager = $progressManager;
                        this.$project = $project;
                        this.loadedInfo = new LinkedHashMap<K, V>();
                    }

                    @NotNull
                    public Pair<Boolean, Set<String>> invoke(@NotNull GithubAccount account, @NotNull Component comp) throws IOException {
                        Pair<Boolean, Set<String>> pair;
                        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
                        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                        Map<GithubAccount, Pair<Boolean, Set<String>>> $this$getOrPut$iv = this.loadedInfo;
                        boolean $i$f$getOrPut = false;
                        Pair<Boolean, Set<String>> value$iv = $this$getOrPut$iv.get((Object)((Object)account));
                        if (value$iv == null) {
                            boolean bl = false;
                            Pair<Boolean, Set<String>> answer$iv = this.loadEnsuringTokenExistsToken(account, comp);
                            $this$getOrPut$iv.put(account, answer$iv);
                            pair = answer$iv;
                        } else {
                            pair = value$iv;
                        }
                        return pair;
                    }

                    private final Pair<Boolean, Set<String>> loadEnsuringTokenExistsToken(GithubAccount account, Component comp) {
                        while (true) {
                            try {
                                Object[] objectArray = new Object[]{account};
                                Object object = this.$progressManager.runProcessWithProgressSynchronously(() -> shareProjectOnGithub.accountInformationLoader.1.loadEnsuringTokenExistsToken$lambda$2(account, this.$progressManager), GithubBundle.message("share.process.loading.account.info", objectArray), true, this.$project);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
                                return (Pair)object;
                            }
                            catch (GithubMissingTokenException mte) {
                                if (GHAccountsUtil.requestNewToken$intellij_vcs_github(account, this.$project, comp) != null) continue;
                                throw mte;
                                continue;
                            }
                            break;
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private static final Pair loadEnsuringTokenExistsToken$lambda$2(GithubAccount $account, ProgressManager $progressManager) {
                        Set set;
                        void $this$mapSmartSet$iv;
                        Intrinsics.checkNotNullParameter((Object)((Object)$account), (String)"$account");
                        Intrinsics.checkNotNullParameter((Object)$progressManager, (String)"$progressManager");
                        String token2 = (String)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>($account, null){
                            int label;
                            final /* synthetic */ GithubAccount $account;
                            {
                                this.$account = $account;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $i$f$service = false;
                                        serviceClass$iv = GHAccountManager.class;
                                        var4_5 = ApplicationManager.getApplication().getService(serviceClass$iv);
                                        if (var4_5 == null) {
                                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                                        }
                                        this.label = 1;
                                        v0 = ((GHAccountManager)var4_5).findCredentials((Account)this.$account, (Continuation)this);
                                        if (v0 == var5_2) {
                                            return var5_2;
                                        }
                                        ** GOTO lbl18
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl18:
                                        // 2 sources

                                        v1 = (String)v0;
                                        if (v1 == null) {
                                            throw new GithubMissingTokenException(this.$account);
                                        }
                                        return v1;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        GithubApiRequestExecutor requestExecutor = GithubApiRequestExecutor.Factory.Companion.getInstance().create($account.getServer(), token2);
                        ProgressIndicator progressIndicator = $progressManager.getProgressIndicator();
                        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
                        GithubAuthenticatedUser user = requestExecutor.execute(progressIndicator, GithubApiRequests.CurrentUser.get($account.getServer()));
                        ProgressIndicator progressIndicator2 = $progressManager.getProgressIndicator();
                        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator2, (String)"getProgressIndicator(...)");
                        Collection collection = GithubApiPagesLoader.loadAll(requestExecutor, progressIndicator2, GithubApiRequests.CurrentUser.Repos.pages$default($account.getServer(), Type.OWNER, null, null, null, 28, null));
                        boolean $i$f$mapSmartSet = false;
                        int size$iv = $this$mapSmartSet$iv.size();
                        switch (size$iv) {
                            case 1: {
                                GithubRepo it = (GithubRepo)CollectionsKt.first((Iterable)((Iterable)$this$mapSmartSet$iv));
                                boolean bl = false;
                                Set set2 = Collections.singleton(it.getName());
                                Intrinsics.checkNotNull(set2);
                                set = set2;
                                break;
                            }
                            case 0: {
                                set = SetsKt.emptySet();
                                break;
                            }
                            default: {
                                void $this$mapTo$iv$iv;
                                Iterable iterable = (Iterable)$this$mapSmartSet$iv;
                                Collection destination$iv$iv = new HashSet<E>(size$iv);
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    GithubRepo githubRepo = (GithubRepo)item$iv$iv;
                                    Collection collection2 = destination$iv$iv;
                                    boolean bl = false;
                                    collection2.add(it.getName());
                                }
                                set = (Set)destination$iv$iv;
                            }
                        }
                        Set names = set;
                        return TuplesKt.to((Object)user.canCreatePrivateRepo(), (Object)names);
                    }
                };
                v4 = project;
                v5 /* !! */  = gitRepository;
                if (v5 /* !! */  == null || (v5 /* !! */  = v5 /* !! */ .getRemotes()) == null) break block13;
                it = (Iterable)v5 /* !! */ ;
                var22_26 = v4;
                $i$f$map = false;
                var14_27 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var19_32 = (GitRemote)item$iv$iv;
                    var23_34 = destination$iv$iv;
                    $i$a$-map-GHShareProjectUtil$shareProjectOnGithub$shareDialog$1 = false;
                    var23_34.add(it.getName());
                }
                v4 = var22_26;
                v5 /* !! */  = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (v5 /* !! */  != null) break block14;
            }
            v5 /* !! */  = SetsKt.emptySet();
        }
        var24_35 = (Function2)accountInformationLoader;
        var25_36 /* !! */  = v5 /* !! */ ;
        var26_37 = v4;
        shareDialog = new GithubShareDialog(var26_37, (Set<String>)var25_36 /* !! */ , (Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>>)var24_35);
        DialogManager.show((DialogWrapper)shareDialog);
        if (!shareDialog.isOK()) {
            return;
        }
        name = shareDialog.getRepositoryName();
        isPrivate = shareDialog.isPrivate();
        remoteName = shareDialog.getRemoteName();
        description = shareDialog.getDescription();
        v6 = shareDialog.getAccount();
        Intrinsics.checkNotNull((Object)v6);
        account = v6;
        var15_28 = GithubBundle.message("share.process", new Object[0]);
        new Task.Backgroundable(project, account, name, description, isPrivate, gitRepository, accountInformationProvider, gitHelper, git, remoteName, var15_28){
            private String url;
            final /* synthetic */ Project $project;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ String $name;
            final /* synthetic */ String $description;
            final /* synthetic */ boolean $isPrivate;
            final /* synthetic */ GitRepository $gitRepository;
            final /* synthetic */ GithubAccountInformationProvider $accountInformationProvider;
            final /* synthetic */ GithubGitHelper $gitHelper;
            final /* synthetic */ Git $git;
            final /* synthetic */ String $remoteName;
            {
                this.$project = $project;
                this.$account = $account;
                this.$name = $name;
                this.$description = $description;
                this.$isPrivate = $isPrivate;
                this.$gitRepository = $gitRepository;
                this.$accountInformationProvider = $accountInformationProvider;
                this.$gitHelper = $gitHelper;
                this.$git = $git;
                this.$remoteName = $remoteName;
                super($project, $super_call_param$1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                String string = GHCompatibilityUtil.getOrRequestToken(this.$account, this.$project);
                if (string == null) {
                    return;
                }
                String token2 = string;
                GithubApiRequestExecutor requestExecutor = GithubApiRequestExecutor.Factory.Companion.getInstance().create(this.$account.getServer(), token2);
                GHShareProjectUtil.access$getLOG$p().info("Creating GitHub repository");
                indicator.setText(GithubBundle.message("share.process.creating.repository", new Object[0]));
                String string2 = ((GithubRepo)requestExecutor.execute(indicator, GithubApiRequests.CurrentUser.Repos.create$default(this.$account.getServer(), this.$name, this.$description, this.$isPrivate, null, 16, null))).getHtmlUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHtmlUrl(...)");
                this.url = string2;
                GHShareProjectUtil.access$getLOG$p().info("Successfully created GitHub repository");
                GitRepository gitRepository = this.$gitRepository;
                if (gitRepository == null || (gitRepository = gitRepository.getRoot()) == null) {
                    gitRepository = this.$project.getBaseDir();
                }
                GitRepository root = gitRepository;
                GHShareProjectUtil.access$getLOG$p().info("Binding local project with GitHub");
                if (this.$gitRepository == null) {
                    GHShareProjectUtil.access$getLOG$p().info("No git detected, creating empty git repo");
                    indicator.setText(GithubBundle.message("share.process.creating.git.repository", new Object[0]));
                    Intrinsics.checkNotNull((Object)root);
                    if (!this.createEmptyGitRepository(this.$project, (VirtualFile)root)) {
                        return;
                    }
                }
                GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"getRepositoryManager(...)");
                GitRepositoryManager repositoryManager = gitRepositoryManager;
                GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot((VirtualFile)root);
                if (repository == null) {
                    GithubNotifications.showError(this.$project, "github.share.cannot.find.git.repo", GithubBundle.message("share.error.failed.to.create.repo", new Object[0]), GithubBundle.message("cannot.find.git.repo", new Object[0]));
                    return;
                }
                indicator.setText(GithubBundle.message("share.process.retrieving.username", new Object[0]));
                String string3 = this.$accountInformationProvider.getInformation(requestExecutor, indicator, this.$account).getLogin();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLogin(...)");
                String username = string3;
                String remoteUrl = this.$gitHelper.getRemoteUrl(this.$account.getServer(), username, this.$name);
                GHShareProjectUtil.access$getLOG$p().info("Adding GitHub as a remote host");
                indicator.setText(GithubBundle.message("share.process.adding.gh.as.remote.host", new Object[0]));
                this.$git.addRemote(repository, this.$remoteName, remoteUrl).throwOnError(new int[0]);
                repository.update();
                Intrinsics.checkNotNull((Object)root);
                String string4 = this.url;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    string4 = null;
                }
                if (!this.performFirstCommitIfRequired(this.$project, (VirtualFile)root, repository, indicator, this.$name, string4)) {
                    return;
                }
                GHShareProjectUtil.access$getLOG$p().info("Pushing to github master");
                indicator.setText(GithubBundle.message("share.process.pushing.to.github.master", new Object[0]));
                String string5 = this.url;
                if (string5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    string5 = null;
                }
                if (!this.pushCurrentBranch(this.$project, repository, this.$remoteName, remoteUrl, this.$name, string5)) {
                    return;
                }
                String string6 = GithubBundle.message("share.process.successfully.shared", new Object[0]);
                String string7 = this.url;
                if (string7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    string7 = null;
                }
                GithubNotifications.showInfoURL(this.$project, "github.share.project.successfully.shared", string6, this.$name, string7);
            }

            private final boolean createEmptyGitRepository(Project project, VirtualFile root) {
                GitCommandResult gitCommandResult = Git.getInstance().init(project, root, new GitLineHandlerListener[0]);
                Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"init(...)");
                GitCommandResult result = gitCommandResult;
                if (!result.success()) {
                    VcsNotifier.getInstance((Project)project).notifyError("github.git.repo.init.error", GitBundle.message((String)"initializing.title", (Object[])new Object[0]), result.getErrorOutputAsHtmlString());
                    GHShareProjectUtil.access$getLOG$p().info("Failed to create empty git repo: " + result.getErrorOutputAsJoinedString());
                    return false;
                }
                GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
                GitUtil.generateGitignoreFileIfNeeded((Project)project, (VirtualFile)root);
                return true;
            }

            /*
             * WARNING - void declaration
             */
            private final boolean performFirstCommitIfRequired(Project project, VirtualFile root, GitRepository repository, ProgressIndicator indicator, String name, String url) {
                if (!repository.isFresh()) {
                    return true;
                }
                GHShareProjectUtil.access$getLOG$p().info("Trying to commit");
                try {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    GHShareProjectUtil.access$getLOG$p().info("Adding files for commit");
                    indicator.setText(GithubBundle.message("share.process.adding.files", new Object[0]));
                    List list = ChangeListManager.getInstance((Project)project).getAffectedFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAffectedFiles(...)");
                    List trackedFiles = list;
                    Collection collection = repository.getUntrackedFilesHolder().retrieveUntrackedFilePaths();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"retrieveUntrackedFilePaths(...)");
                    Iterable iterable = collection;
                    Project project2 = project;
                    var var24_11 = this;
                    boolean $i$f$mapNotNull = false;
                    void var11_14 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        VirtualFile it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        FilePath p0 = (FilePath)element$iv$iv;
                        boolean bl2 = false;
                        if (p0.getVirtualFile() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    Collection<VirtualFile> untrackedFiles = var24_11.filterOutIgnored(project2, list2);
                    trackedFiles.removeAll(untrackedFiles);
                    ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
                    allFiles.addAll(trackedFiles);
                    allFiles.addAll(untrackedFiles);
                    Pair data2 = (Pair)ActionsKt.invokeAndWaitIfNeeded((ModalityState)indicator.getModalityState(), (Function0)((Function0)new Function0<Pair<? extends Collection<VirtualFile>, ? extends String>>(project, allFiles, (List<VirtualFile>)trackedFiles){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ ArrayList<VirtualFile> $allFiles;
                        final /* synthetic */ List<VirtualFile> $trackedFiles;
                        {
                            this.$project = $project;
                            this.$allFiles = $allFiles;
                            this.$trackedFiles = $trackedFiles;
                            super(0);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Pair<Collection<VirtualFile>, String> invoke() {
                            GithubUntrackedFilesDialog githubUntrackedFilesDialog = new GithubUntrackedFilesDialog(this.$project, (List<? extends VirtualFile>)this.$allFiles);
                            List<VirtualFile> list = this.$trackedFiles;
                            GithubUntrackedFilesDialog $this$invoke_u24lambda_u240 = githubUntrackedFilesDialog;
                            boolean bl = false;
                            if (!list.isEmpty()) {
                                $this$invoke_u24lambda_u240.setSelectedFiles(list);
                            }
                            DialogManager.show((DialogWrapper)((DialogWrapper)$this$invoke_u24lambda_u240));
                            GithubUntrackedFilesDialog dialog = githubUntrackedFilesDialog;
                            if (!dialog.isOK()) return null;
                            Collection collection = dialog.getSelectedFiles();
                            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelectedFiles(...)");
                            if (collection.isEmpty()) return null;
                            boolean bl2 = true;
                            if (!bl2) return null;
                            Pair pair = TuplesKt.to((Object)dialog.getSelectedFiles(), (Object)dialog.getCommitMessage());
                            return pair;
                        }
                    }));
                    if (data2 == null) {
                        GithubNotifications.showInfoURL(project, "github.share.empty.repo.created", GithubBundle.message("share.process.empty.project.created", new Object[0]), name, url);
                        return false;
                    }
                    Collection files2commit = (Collection)data2.component1();
                    String commitMessage = (String)data2.component2();
                    Collection collection2 = ContainerUtil.intersection(untrackedFiles, (Collection)files2commit);
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"intersection(...)");
                    Collection files2add = collection2;
                    Collection collection3 = ContainerUtil.subtract((Collection)trackedFiles, (Collection)files2commit);
                    Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"subtract(...)");
                    Collection files2rm = collection3;
                    HashSet<E> modified = new HashSet<E>(trackedFiles);
                    modified.addAll(files2commit);
                    GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)files2add);
                    GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)files2rm);
                    GHShareProjectUtil.access$getLOG$p().info("Performing commit");
                    indicator.setText(GithubBundle.message("share.process.performing.commit", new Object[0]));
                    GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
                    handler.setStdoutSuppressed(false);
                    String[] stringArray = new String[]{"-m", commitMessage};
                    handler.addParameters(stringArray);
                    handler.endOptions();
                    Git.getInstance().runCommand(handler).throwOnError(new int[0]);
                    VcsFileUtil.markFilesDirty((Project)project, (Collection)modified);
                }
                catch (VcsException e) {
                    GHShareProjectUtil.access$getLOG$p().warn((Throwable)e);
                    GithubNotifications.showErrorURL(project, "github.share.project.created.init.commit.failed", GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.init.commit.failed", new Object[0]) + GithubUtil.getErrorTextFromException(e), url);
                    return false;
                }
                GHShareProjectUtil.access$getLOG$p().info("Successfully created initial commit");
                return true;
            }

            private final Collection<VirtualFile> filterOutIgnored(Project project, Collection<? extends VirtualFile> files) {
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
                ChangeListManager changeListManager2 = changeListManager;
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                List list = ContainerUtil.filter(files, arg_0 -> shareProjectOnGithub.1.filterOutIgnored$lambda$0((Function1)new Function1<VirtualFile, Boolean>(changeListManager2, vcsManager){
                    final /* synthetic */ ChangeListManager $changeListManager;
                    final /* synthetic */ ProjectLevelVcsManager $vcsManager;
                    {
                        this.$changeListManager = $changeListManager;
                        this.$vcsManager = $vcsManager;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(VirtualFile file2) {
                        return !this.$changeListManager.isIgnoredFile(file2) && !this.$vcsManager.isIgnored(file2);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"filter(...)");
                return list;
            }

            private final boolean pushCurrentBranch(Project project, GitRepository repository, String remoteName, String remoteUrl, String name, String url) {
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                if (currentBranch == null) {
                    GithubNotifications.showErrorURL(project, "github.share.init.push.failed", GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.push.no.current.branch", new Object[0]), url);
                    return false;
                }
                GitCommandResult gitCommandResult = this.$git.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
                Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"push(...)");
                GitCommandResult result = gitCommandResult;
                if (!result.success()) {
                    Object[] objectArray = new Object[]{result.getErrorOutputAsHtmlString()};
                    GithubNotifications.showErrorURL(project, "github.share.init.push.failed", GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.push.failed", objectArray), url);
                    return false;
                }
                return true;
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                GithubNotifications.showError(this.$project, "github.share.cannot.create.repo", GithubBundle.message("share.error.failed.to.create.repo", new Object[0]), error);
            }

            private static final boolean filterOutIgnored$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }.queue();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

