/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.ide.inspections;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.vcs.github.ultimate.cache.GitHubActionsCatalog;
import com.intellij.vcs.github.ultimate.cache.metadata.GitHubActionMetadata;
import com.intellij.vcs.github.ultimate.contexts.ActionYamlPatternsKt;
import com.intellij.vcs.github.ultimate.ide.inspections.ActionInspectionsUtilKt$findActionReference$lambda$1$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a&\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u00a8\u0006\u000f"}, d2={"findActionReference", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "sequenceItem", "Lorg/jetbrains/yaml/psi/YAMLSequenceItem;", "getActionInputs", "", "", "Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadata$Input;", "project", "Lcom/intellij/openapi/project/Project;", "actionReference", "getActionMetadata", "Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadata;", "getStepParams", "stepYamlItemSequence", "intellij.vcs.github.ultimate"})
@SourceDebugExtension(value={"SMAP\nActionInspectionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionInspectionsUtil.kt\ncom/intellij/vcs/github/ultimate/ide/inspections/ActionInspectionsUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 ActionYamlPatterns.kt\ncom/intellij/vcs/github/ultimate/contexts/ActionYamlPatternsKt\n*L\n1#1,36:1\n288#2,2:37\n288#2:41\n289#2:58\n31#3,2:39\n46#4:42\n38#4,7:43\n20#4,8:50\n*S KotlinDebug\n*F\n+ 1 ActionInspectionsUtil.kt\ncom/intellij/vcs/github/ultimate/ide/inspections/ActionInspectionsUtilKt\n*L\n16#1:37,2\n31#1:41\n31#1:58\n25#1:39,2\n32#1:42\n32#1:43,7\n32#1:50,8\n*E\n"})
public final class ActionInspectionsUtilKt {
    @Nullable
    public static final YAMLKeyValue getStepParams(@NotNull YAMLSequenceItem stepYamlItemSequence) {
        Object v3;
        block1: {
            Intrinsics.checkNotNullParameter((Object)stepYamlItemSequence, (String)"stepYamlItemSequence");
            Collection collection = stepYamlItemSequence.getKeysValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeysValues(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                YAMLKeyValue kv = (YAMLKeyValue)element$iv;
                boolean bl = false;
                PsiElement psiElement = kv.getKey();
                boolean bl2 = psiElement != null ? psiElement.textMatches((CharSequence)"with") : false;
                if (!bl2) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    @NotNull
    public static final Map<String, GitHubActionMetadata.Input> getActionInputs(@NotNull Project project, @NotNull YAMLKeyValue actionReference2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionReference2, (String)"actionReference");
        YAMLValue yAMLValue = actionReference2.getValue();
        Object object = ActionInspectionsUtilKt.getActionMetadata(project, yAMLValue != null ? yAMLValue.getText() : null);
        return object != null && (object = ((GitHubActionMetadata)object).getInputs()) != null ? (Map)object : MapsKt.emptyMap();
    }

    @Nullable
    public static final GitHubActionMetadata getActionMetadata(@NotNull Project project, @Nullable String actionReference2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitHubActionsCatalog> serviceClass$iv = GitHubActionsCatalog.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitHubActionMetadata actionMetadata = ((GitHubActionsCatalog)object).resolveActionMetadata(actionReference2);
        return actionMetadata;
    }

    @Nullable
    public static final YAMLKeyValue findActionReference(@NotNull YAMLSequenceItem sequenceItem) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sequenceItem, (String)"sequenceItem");
            Collection collection = sequenceItem.getKeysValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeysValues(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                YAMLKeyValue it = (YAMLKeyValue)element$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{"runs\\.steps\\.uses", "(jobs)\\.([a-zA-Z_][a-zA-Z0-9_-]*)\\.(steps)\\.(uses)"};
                Object[] keyTextValue$iv = objectArray;
                boolean $i$f$yamlKeysPattern = false;
                List keys$iv$iv = ArraysKt.toList((Object[])keyTextValue$iv);
                boolean $i$f$yamlKeysPattern2 = false;
                boolean $i$f$yamlKeysPatternCondition = false;
                ObjectPattern objectPattern = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>(){

                    public boolean accepts(@NotNull PsiElement element, @Nullable ProcessingContext context) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        return GithubYamlFileDetectionKt.isGithubActionsFile(element.getContainingFile());
                    }
                })).with((PatternCondition)new PatternCondition<PsiElement>(keys$iv$iv){
                    @NotNull
                    private final List<Regex> regexList;
                    {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = $keys;
                        findActionReference$lambda$1$$inlined$yamlKeysPattern$1 var3_3 = this;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new Regex((String)it));
                        }
                        var3_3.regexList = (List)destination$iv$iv;
                    }

                    @NotNull
                    public final List<Regex> getRegexList() {
                        return this.regexList;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean accepts(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                        CharSequence charSequence;
                        Regex it;
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        if (!(element instanceof YAMLKeyValue)) return false;
                        Iterable $this$any$iv = this.regexList;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            return false;
                        }
                        Iterator<T> iterator = $this$any$iv.iterator();
                        do {
                            if (!iterator.hasNext()) return false;
                            T element$iv = iterator.next();
                            it = (Regex)element$iv;
                            boolean bl = false;
                            charSequence = StringUtil.newBombedCharSequence((CharSequence)ActionYamlPatternsKt.fullYamlKey(element), (long)1000L);
                            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
                        } while (!it.matches(charSequence));
                        return true;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
                if (!((PsiElementPattern.Capture)objectPattern).accepts((Object)it)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }
}

