/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.expression;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.vcs.github.ultimate.expression.GithubExpressionElementType;
import com.intellij.vcs.github.ultimate.expression.GithubExpressionTokenType;
import com.intellij.vcs.github.ultimate.expression.impl.GAEBooleanAndExpressionImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAEBooleanOrExpressionImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAEConditionalExpressionImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAEElementByIndexAccessImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAEEqualityExpressionImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAEFunctionCallImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAEParenthesizedExpressionImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAEPrimitiveImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAESelectorImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAESelectorSegmentImpl;
import com.intellij.vcs.github.ultimate.expression.impl.GAEUnaryNotExpressionImpl;

public interface GithubExpressionTokens {
    public static final IElementType BOOLEAN_AND_EXPRESSION = new GithubExpressionElementType("BOOLEAN_AND_EXPRESSION");
    public static final IElementType BOOLEAN_OR_EXPRESSION = new GithubExpressionElementType("BOOLEAN_OR_EXPRESSION");
    public static final IElementType CONDITIONAL_EXPRESSION = new GithubExpressionElementType("CONDITIONAL_EXPRESSION");
    public static final IElementType ELEMENT_BY_INDEX_ACCESS = new GithubExpressionElementType("ELEMENT_BY_INDEX_ACCESS");
    public static final IElementType EQUALITY_EXPRESSION = new GithubExpressionElementType("EQUALITY_EXPRESSION");
    public static final IElementType EXPRESSION = new GithubExpressionElementType("EXPRESSION");
    public static final IElementType FUNCTION_CALL = new GithubExpressionElementType("FUNCTION_CALL");
    public static final IElementType PARENTHESIZED_EXPRESSION = new GithubExpressionElementType("PARENTHESIZED_EXPRESSION");
    public static final IElementType PRIMITIVE = new GithubExpressionElementType("PRIMITIVE");
    public static final IElementType SELECTOR = new GithubExpressionElementType("SELECTOR");
    public static final IElementType SELECTOR_SEGMENT = new GithubExpressionElementType("SELECTOR_SEGMENT");
    public static final IElementType UNARY_NOT_EXPRESSION = new GithubExpressionElementType("UNARY_NOT_EXPRESSION");
    public static final IElementType ANY_NODE = new GithubExpressionTokenType("*");
    public static final IElementType BINARY_AND = new GithubExpressionTokenType("&&");
    public static final IElementType BINARY_EQUAL = new GithubExpressionTokenType("==");
    public static final IElementType BINARY_GREATER = new GithubExpressionTokenType(">");
    public static final IElementType BINARY_GREATER_OR_EQUAL = new GithubExpressionTokenType(">=");
    public static final IElementType BINARY_LESS = new GithubExpressionTokenType("<");
    public static final IElementType BINARY_LESS_OR_EQUAL = new GithubExpressionTokenType("<=");
    public static final IElementType BINARY_NOT_EQUAL = new GithubExpressionTokenType("!=");
    public static final IElementType BINARY_OR = new GithubExpressionTokenType("||");
    public static final IElementType COMMA = new GithubExpressionTokenType(",");
    public static final IElementType DOT = new GithubExpressionTokenType(".");
    public static final IElementType EXPRESSION_END_MARKER = new GithubExpressionTokenType("}}");
    public static final IElementType EXPRESSION_START_MARKER = new GithubExpressionTokenType("${{");
    public static final IElementType FALSE = new GithubExpressionTokenType("false");
    public static final IElementType IDENTIFIER = new GithubExpressionTokenType("IDENTIFIER");
    public static final IElementType INTEGER = new GithubExpressionTokenType("INTEGER");
    public static final IElementType LEFT_GROUPING_PARENTHESIS = new GithubExpressionTokenType("(");
    public static final IElementType LEFT_INDEX_BRACE = new GithubExpressionTokenType("[");
    public static final IElementType NULL = new GithubExpressionTokenType("null");
    public static final IElementType NUMBER = new GithubExpressionTokenType("NUMBER");
    public static final IElementType RIGHT_GROUPING_PARENTHESIS = new GithubExpressionTokenType(")");
    public static final IElementType RIGHT_INDEX_BRACE = new GithubExpressionTokenType("]");
    public static final IElementType SINGLE_QUOTED_STRING = new GithubExpressionTokenType("SINGLE_QUOTED_STRING");
    public static final IElementType TRUE = new GithubExpressionTokenType("true");
    public static final IElementType UNARY_NOT = new GithubExpressionTokenType("!");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == BOOLEAN_AND_EXPRESSION) {
                return new GAEBooleanAndExpressionImpl(node);
            }
            if (type == BOOLEAN_OR_EXPRESSION) {
                return new GAEBooleanOrExpressionImpl(node);
            }
            if (type == CONDITIONAL_EXPRESSION) {
                return new GAEConditionalExpressionImpl(node);
            }
            if (type == ELEMENT_BY_INDEX_ACCESS) {
                return new GAEElementByIndexAccessImpl(node);
            }
            if (type == EQUALITY_EXPRESSION) {
                return new GAEEqualityExpressionImpl(node);
            }
            if (type == FUNCTION_CALL) {
                return new GAEFunctionCallImpl(node);
            }
            if (type == PARENTHESIZED_EXPRESSION) {
                return new GAEParenthesizedExpressionImpl(node);
            }
            if (type == PRIMITIVE) {
                return new GAEPrimitiveImpl(node);
            }
            if (type == SELECTOR) {
                return new GAESelectorImpl(node);
            }
            if (type == SELECTOR_SEGMENT) {
                return new GAESelectorSegmentImpl(node);
            }
            if (type == UNARY_NOT_EXPRESSION) {
                return new GAEUnaryNotExpressionImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

