/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.cache.metadata;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.vcs.github.ultimate.action.inputs.InputsContext;
import com.intellij.vcs.github.ultimate.action.outputs.StepsOutputsContext;
import com.intellij.vcs.github.ultimate.cache.GitHubActionCacheCommonsKt;
import com.intellij.vcs.github.ultimate.cache.GitHubActionsCatalog;
import com.intellij.vcs.github.ultimate.cache.metadata.GitHubActionMetadata;
import com.intellij.vcs.github.ultimate.cache.metadata.GitHubActionMetadataFactory$createDescription$lambda$0$;
import com.intellij.vcs.github.ultimate.contexts.ActionYamlPatternsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadataFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createDescription", "", "actionMetadata", "Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadata;", "actionFile", "Lcom/intellij/psi/PsiElement;", "createMetadata", "actionReference", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveInputs", "resolveOutputs", "intellij.vcs.github.ultimate"})
@SourceDebugExtension(value={"SMAP\nGitHubActionMetadataFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubActionMetadataFactory.kt\ncom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadataFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ActionYamlPatterns.kt\ncom/intellij/vcs/github/ultimate/contexts/ActionYamlPatternsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,71:1\n288#2:72\n289#2:89\n1179#2,2:92\n1253#2,4:94\n1179#2,2:101\n1253#2,4:103\n46#3:73\n38#3,7:74\n20#3,8:81\n1313#4:90\n1314#4:98\n1313#4:99\n1314#4:107\n430#5:91\n430#5:100\n*S KotlinDebug\n*F\n+ 1 GitHubActionMetadataFactory.kt\ncom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadataFactory\n*L\n38#1:72\n38#1:89\n49#1:92,2\n49#1:94,4\n63#1:101,2\n63#1:103,4\n39#1:73\n39#1:74,7\n39#1:81,8\n47#1:90\n47#1:98\n61#1:99\n61#1:107\n49#1:91\n63#1:100\n*E\n"})
public final class GitHubActionMetadataFactory {
    @NotNull
    private final Project project;

    public GitHubActionMetadataFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Object createMetadata(@NotNull String actionReference2, @NotNull VirtualFile virtualFile, @NotNull Continuation<? super GitHubActionMetadata> $completion) {
        Pair<String, String> pair = GitHubActionCacheCommonsKt.splitActionReference(actionReference2);
        String actionRef = (String)pair.component1();
        String version = (String)pair.component2();
        return CoroutinesKt.readAction((Function0)((Function0)new Function0<GitHubActionMetadata>(actionRef, version, virtualFile, this){
            final /* synthetic */ String $actionRef;
            final /* synthetic */ String $version;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ GitHubActionMetadataFactory this$0;
            {
                this.$actionRef = $actionRef;
                this.$version = $version;
                this.$virtualFile = $virtualFile;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final GitHubActionMetadata invoke() {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitHubActionsCatalog.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Creating action metadata for " + this.$actionRef + "@" + this.$version);
                if (!this.$virtualFile.isValid()) {
                    return null;
                }
                PsiFile psiFile = PsiUtilCore.getPsiFile((Project)this.this$0.getProject(), (VirtualFile)this.$virtualFile);
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getPsiFile(...)");
                PsiFile psiFile2 = psiFile;
                String string = this.$virtualFile.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                GitHubActionMetadata actionMetadata = new GitHubActionMetadata(this.$actionRef, this.$version, string);
                GitHubActionMetadataFactory.access$createDescription(this.this$0, actionMetadata, (PsiElement)psiFile2);
                GitHubActionMetadataFactory.access$resolveInputs(this.this$0, actionMetadata, (PsiElement)psiFile2);
                GitHubActionMetadataFactory.access$resolveOutputs(this.this$0, actionMetadata, (PsiElement)psiFile2);
                return actionMetadata;
            }
        }), $completion);
    }

    /*
     * WARNING - void declaration
     */
    private final void createDescription(GitHubActionMetadata actionMetadata, PsiElement actionFile) {
        Object v2;
        block1: {
            void $this$firstOrNull$iv;
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)actionFile);
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
            Iterable iterable = (Iterable)syntaxTraverser;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                void keyTextValue$iv;
                PsiElement psiElement = (PsiElement)element$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"description"};
                boolean $i$f$yamlKeysPattern = false;
                List keys$iv$iv = ArraysKt.toList((Object[])keyTextValue$iv);
                boolean $i$f$yamlKeysPattern2 = false;
                boolean $i$f$yamlKeysPatternCondition = false;
                ObjectPattern objectPattern = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>(){

                    public boolean accepts(@NotNull PsiElement element, @Nullable ProcessingContext context) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        return GithubYamlFileDetectionKt.isGithubActionsFile(element.getContainingFile());
                    }
                })).with((PatternCondition)new PatternCondition<PsiElement>(keys$iv$iv){
                    @NotNull
                    private final List<Regex> regexList;
                    {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = $keys;
                        createDescription$lambda$0$$inlined$yamlKeysPattern$1 var3_3 = this;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new Regex((String)it));
                        }
                        var3_3.regexList = (List)destination$iv$iv;
                    }

                    @NotNull
                    public final List<Regex> getRegexList() {
                        return this.regexList;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean accepts(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                        CharSequence charSequence;
                        Regex it;
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        if (!(element instanceof YAMLKeyValue)) return false;
                        Iterable $this$any$iv = this.regexList;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            return false;
                        }
                        Iterator<T> iterator = $this$any$iv.iterator();
                        do {
                            if (!iterator.hasNext()) return false;
                            T element$iv = iterator.next();
                            it = (Regex)element$iv;
                            boolean bl = false;
                            charSequence = StringUtil.newBombedCharSequence((CharSequence)ActionYamlPatternsKt.fullYamlKey(element), (long)1000L);
                            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
                        } while (!it.matches(charSequence));
                        return true;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
                if (!((PsiElementPattern.Capture)objectPattern).accepts((Object)psiElement)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        Object var5_14 = v2;
        YAMLKeyValue yAMLKeyValue = var5_14 instanceof YAMLKeyValue ? (YAMLKeyValue)var5_14 : null;
        String description = yAMLKeyValue != null ? yAMLKeyValue.getValueText() : null;
        actionMetadata.setDescription(description);
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveInputs(GitHubActionMetadata actionMetadata, PsiElement actionFile) {
        Sequence<YAMLKeyValue> $this$forEach$iv = InputsContext.INSTANCE.getResolver().findAllElements(actionFile);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            void $this$associateTo$iv$iv;
            YAMLKeyValue element = (YAMLKeyValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)element.getKeyText(), (String)"getKeyText(...)");
            YAMLValue yAMLValue = element.getValue();
            Object object = yAMLValue;
            if (object == null) continue;
            Intrinsics.checkNotNull((Object)object);
            PsiElement $this$childrenOfType$iv = (PsiElement)yAMLValue;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, YAMLKeyValue.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            object = list;
            if (list == null) continue;
            Iterable $this$associate$iv = (Iterable)object;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Object object2 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                boolean bl2 = false;
                Pair pair = new Pair((Object)it.getKeyText(), (Object)it.getValueText());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map dataMap = destination$iv$iv;
            boolean bl3 = false;
            boolean bl4 = Boolean.parseBoolean((String)dataMap.get("required"));
            String string = (String)dataMap.get("description");
            if (string == null) {
                string = "";
            }
            object2 = string;
            Intrinsics.checkNotNull((Object)object2);
            GitHubActionMetadata.Input input = new GitHubActionMetadata.Input(name, bl4, (String)object2, (String)dataMap.get("default"), (String)dataMap.get("deprecationMessage"));
            ((Map)actionMetadata.getInputs()).put(name, input);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveOutputs(GitHubActionMetadata actionMetadata, PsiElement actionFile) {
        Sequence<YAMLKeyValue> $this$forEach$iv = StepsOutputsContext.INSTANCE.getResolver().findAllElements(actionFile);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            String string;
            void $this$associateTo$iv$iv;
            YAMLKeyValue element = (YAMLKeyValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)element.getKeyText(), (String)"getKeyText(...)");
            YAMLValue yAMLValue = element.getValue();
            Object object = yAMLValue;
            if (object == null) continue;
            Intrinsics.checkNotNull((Object)object);
            PsiElement $this$childrenOfType$iv = (PsiElement)yAMLValue;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, YAMLKeyValue.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            object = list;
            if (list == null) continue;
            Iterable $this$associate$iv = (Iterable)object;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Object object2 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                boolean bl2 = false;
                Pair pair = new Pair((Object)it.getKeyText(), (Object)it.getValueText());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map dataMap = destination$iv$iv;
            boolean bl3 = false;
            String string2 = (String)dataMap.get("value");
            if (string2 == null) {
                string2 = "";
            }
            if ((string = (String)dataMap.get("description")) == null) {
                string = "";
            }
            object2 = string;
            Intrinsics.checkNotNull((Object)object2);
            GitHubActionMetadata.Output output = new GitHubActionMetadata.Output(name, string2, (String)object2);
            ((Map)actionMetadata.getOutputs()).put(name, output);
        }
    }

    public static final /* synthetic */ void access$createDescription(GitHubActionMetadataFactory $this, GitHubActionMetadata actionMetadata, PsiElement actionFile) {
        $this.createDescription(actionMetadata, actionFile);
    }

    public static final /* synthetic */ void access$resolveInputs(GitHubActionMetadataFactory $this, GitHubActionMetadata actionMetadata, PsiElement actionFile) {
        $this.resolveInputs(actionMetadata, actionFile);
    }

    public static final /* synthetic */ void access$resolveOutputs(GitHubActionMetadataFactory $this, GitHubActionMetadata actionMetadata, PsiElement actionFile) {
        $this.resolveOutputs(actionMetadata, actionFile);
    }
}

