/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.cache;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.vcs.github.ultimate.cache.GitHubActionCacheCommonsKt;
import com.intellij.vcs.github.ultimate.cache.GitHubActionsCatalog;
import com.intellij.vcs.github.ultimate.cache.GitHubActionsCatalog$refreshCache$1$1$1$invokeSuspend$;
import com.intellij.vcs.github.ultimate.cache.metadata.GitHubActionMetadata;
import com.intellij.vcs.github.ultimate.cache.metadata.GitHubActionMetadataFactory;
import com.intellij.vcs.github.ultimate.cache.providers.ActionsProvider;
import com.intellij.vcs.github.ultimate.cache.providers.LocalActionsProvider;
import com.intellij.vcs.github.ultimate.cache.providers.RemoteActionsProvider;
import com.intellij.vcs.github.ultimate.cache.state.CacheInternalState;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="GitHubActionsCache", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DEFAULT, exportable=true)})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u001c\u001a\u00020\u0013J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0006\u0010 \u001a\u00020\u0010J\u001a\u0010!\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010#\u0018\u00010\"2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010%\u001a\u0004\u0018\u00010#2\b\u0010&\u001a\u0004\u0018\u00010\u0013J\u0018\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\"2\b\u0010&\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/vcs/github/ultimate/cache/GitHubActionsCatalog;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/vcs/github/ultimate/cache/state/CacheInternalState;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "filesCacheDir", "Ljava/nio/file/Path;", "metadataFactory", "Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadataFactory;", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "clearCache", "", "deleteActionMetadata", "actionReference", "", "deleteFileFromCache", "deleteLocalActionEntry", "actionFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllActions", "Lkotlin/sequences/Sequence;", "getState", "getVersions", "actionName", "loadFileToCache", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadState", "refreshCache", "reloadActionFileAsync", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadata;", "reloadLocalActionEntry", "resolveActionMetadata", "referenceString", "resolveActionMetadataAsync", "intellij.vcs.github.ultimate"})
@SourceDebugExtension(value={"SMAP\nGitHubActionsCatalog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubActionsCatalog.kt\ncom/intellij/vcs/github/ultimate/cache/GitHubActionsCatalog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n43#2:220\n22#2,2:221\n43#2:223\n22#2,2:224\n43#2:226\n22#2,2:227\n43#2:240\n22#2,2:241\n43#2:243\n22#2,2:244\n43#2:248\n22#2,2:249\n31#3,2:229\n31#3,2:231\n31#3,2:235\n31#3,2:237\n31#3,2:246\n1855#4,2:233\n1#5:239\n*S KotlinDebug\n*F\n+ 1 GitHubActionsCatalog.kt\ncom/intellij/vcs/github/ultimate/cache/GitHubActionsCatalog\n*L\n51#1:220\n51#1:221,2\n65#1:223\n65#1:224,2\n84#1:226\n84#1:227,2\n173#1:240\n173#1:241,2\n177#1:243\n177#1:244,2\n214#1:248\n214#1:249,2\n120#1:229,2\n121#1:231,2\n148#1:235,2\n157#1:237,2\n186#1:246,2\n122#1:233,2\n*E\n"})
public final class GitHubActionsCatalog
implements PersistentStateComponent<CacheInternalState> {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private volatile CacheInternalState state;
    @NotNull
    private final Path filesCacheDir;
    @NotNull
    private final GitHubActionMetadataFactory metadataFactory;

    public GitHubActionsCatalog(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.state = new CacheInternalState();
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("github-actions").resolve("cache");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.filesCacheDir = path;
        this.metadataFactory = new GitHubActionMetadataFactory(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void loadState(@NotNull CacheInternalState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        try {
            XmlSerializerUtil.copyBean((Object)state2, (Object)this.state);
        }
        catch (Exception ignore) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot load state", (Throwable)ignore);
        }
    }

    @NotNull
    public CacheInternalState getState() {
        return this.state;
    }

    @NotNull
    public final Sequence<String> getAllActions() {
        return this.state.getAllActions();
    }

    @NotNull
    public final Sequence<String> getVersions(@NotNull String actionName) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        return this.state.getVersions(actionName);
    }

    public final void clearCache() {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Clearing GitHub Actions cache");
        this.state.reset();
        NioFiles.deleteRecursively((Path)this.filesCacheDir);
    }

    @Nullable
    public final GitHubActionMetadata resolveActionMetadata(@Nullable String referenceString) {
        CharSequence charSequence = referenceString;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        String string = StringUtil.unquoteString((String)((Object)StringsKt.trim((CharSequence)referenceString)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        String actionReference2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        GitHubActionMetadata actionMetadata = this.state.getMetadata(actionReference2);
        if (actionMetadata != null) {
            return actionMetadata;
        }
        this.resolveActionMetadataAsync(actionReference2);
        return null;
    }

    public final void deleteActionMetadata(@Nullable String actionReference2) {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Deleting GitHub Actions metadata: " + actionReference2);
        this.state.deleteEntry(actionReference2);
    }

    @NotNull
    public final Deferred<GitHubActionMetadata> resolveActionMetadataAsync(@Nullable String referenceString) {
        CharSequence charSequence = referenceString;
        if (charSequence == null || charSequence.length() == 0 || StringsKt.contains$default((CharSequence)referenceString, (CharSequence)"IntellijIdeaRulezzz", (boolean)false, (int)2, null)) {
            return (Deferred)GitHubActionCacheCommonsKt.deferredNull();
        }
        String string = StringUtil.unquoteString((String)((Object)StringsKt.trim((CharSequence)referenceString)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        String actionReference2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Pair<String, String> pair = GitHubActionCacheCommonsKt.splitActionReference(actionReference2);
        String actionRef = (String)pair.component1();
        String version = (String)pair.component2();
        return BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GitHubActionMetadata>, Object>(actionRef, version, this, actionReference2, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ String $actionRef;
            final /* synthetic */ String $version;
            final /* synthetic */ GitHubActionsCatalog this$0;
            final /* synthetic */ String $actionReference;
            {
                this.$actionRef = $actionRef;
                this.$version = $version;
                this.this$0 = $receiver;
                this.$actionReference = $actionReference;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block11: {
                    var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $i$f$fileLogger = false;
                            $i$f$currentClassLogger = false;
                            clazz$iv$iv = MethodHandles.lookup().lookupClass();
                            v0 = Logger.getInstance(clazz$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                            v0.debug("Resolving action metadata for " + this.$actionRef + "@" + this.$version);
                            $i$f$currentClassLogger = GitHubActionsCatalog.access$getState$p(this.this$0).getReferenceAndContent();
                            clazz$iv$iv = this.$actionReference;
                            var5_8 = this.this$0;
                            var6_10 = this.$actionReference;
                            $i$f$getOrPut = false;
                            value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv != null) break;
                            $i$a$-getOrPut-GitHubActionsCatalog$resolveActionMetadataAsync$1$virtualFile$1 = false;
                            this.L$0 = $this$getOrPut$iv;
                            this.L$1 = key$iv;
                            this.label = 1;
                            v1 = GitHubActionsCatalog.access$loadFileToCache(var5_8, var6_10, (Continuation)this);
                            if (v1 == var14_2) {
                                return var14_2;
                            }
                            ** GOTO lbl34
                        }
                        case 1: {
                            $i$f$getOrPut = false;
                            $i$a$-getOrPut-GitHubActionsCatalog$resolveActionMetadataAsync$1$virtualFile$1 = false;
                            key$iv = (String)this.L$1;
                            $this$getOrPut$iv = (Map)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl34:
                            // 2 sources

                            v2 = (String)v1;
                            if (v2 == null) {
                                return null;
                            }
                            answer$iv = v2;
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            v3 /* !! */  = answer$iv;
                            break block11;
                        }
                    }
                    v3 /* !! */  = value$iv;
                }
                it = v3 /* !! */ ;
                $i$a$-let-GitHubActionsCatalog$resolveActionMetadataAsync$1$virtualFile$2 = false;
                virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(it);
                if (virtualFile == null || !virtualFile.isValid()) {
                    this.this$0.deleteActionMetadata(this.$actionReference);
                    return null;
                }
                GitHubActionsCatalog.access$getState$p(this.this$0).addVersion(this.$actionRef, this.$version);
                this.L$0 = virtualFile;
                this.L$1 = null;
                this.label = 2;
                v4 = GitHubActionsCatalog.access$getState$p(this.this$0).addDocumentListener(this.$actionReference, this.this$0.getProject(), (Continuation<? super Unit>)((Continuation)this));
                if (v4 == var14_2) {
                    return var14_2;
                }
                ** GOTO lbl65
                {
                    case 2: {
                        virtualFile = (VirtualFile)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl65:
                        // 2 sources

                        var12_17 = this.$actionReference;
                        var11_18 = GitHubActionsCatalog.access$getState$p(this.this$0);
                        this.L$0 = var11_18;
                        this.L$1 = var12_17;
                        this.label = 3;
                        v5 = GitHubActionsCatalog.access$getMetadataFactory$p(this.this$0).createMetadata(this.$actionReference, virtualFile, (Continuation<? super GitHubActionMetadata>)((Continuation)this));
                        if (v5 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl79
                    }
                    case 3: {
                        var12_17 = (String)this.L$1;
                        var11_18 = (CacheInternalState)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl79:
                        // 2 sources

                        var13_19 = v5;
                        return var11_18.addMetadata(var12_17, (GitHubActionMetadata)var13_19);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GitHubActionMetadata> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void refreshCache() {
        Object[] objectArray = new ActionsProvider[2];
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class serviceClass$iv = LocalActionsProvider.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            Object cfr_ignored_0 = objectArray[0];
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        $this$service$iv = (ComponentManager)this.project;
        $i$f$service = false;
        serviceClass$iv = RemoteActionsProvider.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            Object cfr_ignored_1 = objectArray[1];
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        List providers = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ActionsProvider provider = (ActionsProvider)element$iv;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(provider, this, null){
                int label;
                final /* synthetic */ ActionsProvider $provider;
                final /* synthetic */ GitHubActionsCatalog this$0;
                {
                    this.$provider = $provider;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = this.$provider.fetchActionNames((Continuation<? super Flow<String>>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.label = 2;
                            v1 = FlowKt.collect((Flow)FlowKt.onEach((Flow)FlowKt.flatMapMerge$default((Flow)FlowKt.filterNotNull((Flow)((Flow)v0)), (int)0, (Function2)((Function2)new Function2<String, Continuation<? super Flow<? extends Pair<? extends String, ? extends String>>>, Object>(this.$provider, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ ActionsProvider $provider;
                                {
                                    this.$provider = $provider;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            actionRef = (String)this.L$0;
                                            this.L$0 = actionRef;
                                            this.label = 1;
                                            v0 = ActionsProvider.fetchActionVersions$default(this.$provider, actionRef, null, (Continuation)this, 2, null);
                                            if (v0 == var8_2) {
                                                return var8_2;
                                            }
                                            ** GOTO lbl16
                                        }
                                        case 1: {
                                            actionRef = (String)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl16:
                                            // 2 sources

                                            $this$mapNotNull$iv = (Flow)v0;
                                            $i$f$mapNotNull = false;
                                            $this$unsafeTransform$iv$iv = $this$mapNotNull$iv;
                                            $i$f$unsafeTransform = false;
                                            $i$f$unsafeFlow = false;
                                            return (Flow)new Flow<Pair<? extends String, ? extends String>>($this$unsafeTransform$iv$iv, actionRef){
                                                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                                                final /* synthetic */ String $actionRef$inlined;
                                                {
                                                    this.$this_unsafeTransform$inlined = flow;
                                                    this.$actionRef$inlined = string;
                                                }

                                                @Nullable
                                                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                                                    Continuation continuation = $completion;
                                                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                                    boolean bl = false;
                                                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.$actionRef$inlined){
                                                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                                                        final /* synthetic */ String $actionRef$inlined;
                                                        {
                                                            this.$this_unsafeFlow = $receiver;
                                                            this.$actionRef$inlined = string;
                                                        }

                                                        /*
                                                         * Unable to fully structure code
                                                         */
                                                        @Nullable
                                                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                                            if (!(var2_2 instanceof refreshCache$1$1$1$invokeSuspend$$inlined$mapNotNull$1$2$1)) ** GOTO lbl-1000
                                                            var3_3 = var2_2;
                                                            if ((var3_3.label & -2147483648) != 0) {
                                                                var3_3.label -= -2147483648;
                                                            } else lbl-1000:
                                                            // 2 sources

                                                            {
                                                                $continuation = new ContinuationImpl(this, var2_2){
                                                                    /* synthetic */ Object result;
                                                                    int label;
                                                                    Object L$0;
                                                                    final /* synthetic */ refreshCache$1$1$1$invokeSuspend$$inlined$mapNotNull$1$2 this$0;
                                                                    {
                                                                        this.this$0 = this$0;
                                                                        super($completion);
                                                                    }

                                                                    @Nullable
                                                                    public final Object invokeSuspend(@NotNull Object $result) {
                                                                        this.result = $result;
                                                                        this.label |= Integer.MIN_VALUE;
                                                                        return this.this$0.emit(null, (Continuation)this);
                                                                    }
                                                                };
                                                            }
                                                            $result = $continuation.result;
                                                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch ($continuation.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    var6_6 = value;
                                                                    $this$mapNotNull_u24lambda_u246 = this.$this_unsafeFlow;
                                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                                                    (Continuation)$continuation;
                                                                    tag = (String)value;
                                                                    $i$a$-mapNotNull-GitHubActionsCatalog$refreshCache$1$1$1$1 = false;
                                                                    transformed = new Pair((Object)this.$actionRef$inlined, (Object)tag);
                                                                    $continuation.label = 1;
                                                                    v0 = $this$mapNotNull_u24lambda_u246.emit((Object)transformed, (Continuation)$continuation);
                                                                    if (v0 == var5_5) {
                                                                        return var5_5;
                                                                    }
                                                                    ** GOTO lbl29
                                                                }
                                                                case 1: {
                                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v0 = $result;
lbl29:
                                                                    // 2 sources

                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }
                                                    }, $completion);
                                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                        return object;
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            };
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                @Nullable
                                public final Object invoke(@NotNull String p1, @Nullable Continuation<? super Flow<Pair<String, String>>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null), (Function2)((Function2)new Function2<Pair<? extends String, ? extends String>, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ GitHubActionsCatalog this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Pair pair = (Pair)this.L$0;
                                            String actionRef = (String)pair.component1();
                                            String version = (String)pair.component2();
                                            boolean $i$f$fileLogger = false;
                                            boolean $i$f$currentClassLogger = false;
                                            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                                            Logger logger = Logger.getInstance(clazz$iv$iv);
                                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                            logger.debug("Processing action: " + actionRef + " version " + version);
                                            GitHubActionsCatalog.access$getState$p(this.this$0).addVersion(actionRef, version);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                @Nullable
                                public final Object invoke(@NotNull Pair<String, String> p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            })), (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl21
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ GitHubActionsCatalog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = GitHubActionsCatalog.access$getState$p(this.this$0).getReferenceAndContent().keySet();
                        var3_4 = this.this$0;
                        $i$f$forEach = false;
                        var5_6 = $this$forEach$iv.iterator();
lbl9:
                        // 3 sources

                        while (var5_6.hasNext()) {
                            element$iv = var5_6.next();
                            actionReference = (String)element$iv;
                            $i$a$-forEach-GitHubActionsCatalog$refreshCache$2$1 = false;
                            this.L$0 = var3_4;
                            this.L$1 = var5_6;
                            this.label = 1;
                            v0 = GitHubActionsCatalog.access$getState$p(var3_4).addDocumentListener(actionReference, var3_4.getProject(), (Continuation<? super Unit>)this);
                            if (v0 != var9_2) continue;
                            return var9_2;
                        }
                        break;
                    }
                    case 1: {
                        $i$f$forEach = false;
                        $i$a$-forEach-GitHubActionsCatalog$refreshCache$2$1 = false;
                        var5_6 = (Iterator<T>)this.L$1;
                        var3_4 = (GitHubActionsCatalog)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl9
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Deferred<GitHubActionMetadata> reloadActionFileAsync(@Nullable String actionReference2) {
        if (actionReference2 == null) {
            return null;
        }
        this.deleteFileFromCache(actionReference2);
        this.deleteActionMetadata(actionReference2);
        return this.resolveActionMetadataAsync(actionReference2);
    }

    public final void reloadLocalActionEntry(@NotNull VirtualFile actionFile) {
        Intrinsics.checkNotNullParameter((Object)actionFile, (String)"actionFile");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<LocalActionsProvider> serviceClass$iv = LocalActionsProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        LocalActionsProvider localActionsProvider = (LocalActionsProvider)object;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(actionFile, localActionsProvider, this, null){
            int label;
            final /* synthetic */ VirtualFile $actionFile;
            final /* synthetic */ LocalActionsProvider $localActionsProvider;
            final /* synthetic */ GitHubActionsCatalog this$0;
            {
                this.$actionFile = $actionFile;
                this.$localActionsProvider = $localActionsProvider;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)((Function0)new Function0<Boolean>(this.this$0, this.$actionFile){
                            final /* synthetic */ GitHubActionsCatalog this$0;
                            final /* synthetic */ VirtualFile $actionFile;
                            {
                                this.this$0 = $receiver;
                                this.$actionFile = $actionFile;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return ProjectFileIndex.getInstance((Project)this.this$0.getProject()).isInProject(this.$actionFile);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue() || !this.$actionFile.isInLocalFileSystem()) ** GOTO lbl30
                        this.label = 2;
                        v1 = this.$localActionsProvider.constructActionReference(this.$actionFile, (Continuation<? super String>)((Continuation)this));
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        v2 = (String)v1;
                        if (v2 != null) {
                            var2_3 = v2;
                            var3_4 = this.this$0;
                            it = var2_3;
                            $i$a$-let-GitHubActionsCatalog$reloadLocalActionEntry$1$2 = false;
                            var3_4.reloadActionFileAsync(it);
                        }
lbl30:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void deleteLocalActionEntry(@NotNull VirtualFile actionFile) {
        Intrinsics.checkNotNullParameter((Object)actionFile, (String)"actionFile");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<LocalActionsProvider> serviceClass$iv = LocalActionsProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        LocalActionsProvider localActionsProvider = (LocalActionsProvider)object;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(actionFile, localActionsProvider, this, null){
            int label;
            final /* synthetic */ VirtualFile $actionFile;
            final /* synthetic */ LocalActionsProvider $localActionsProvider;
            final /* synthetic */ GitHubActionsCatalog this$0;
            {
                this.$actionFile = $actionFile;
                this.$localActionsProvider = $localActionsProvider;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)((Function0)new Function0<Boolean>(this.this$0, this.$actionFile){
                            final /* synthetic */ GitHubActionsCatalog this$0;
                            final /* synthetic */ VirtualFile $actionFile;
                            {
                                this.this$0 = $receiver;
                                this.$actionFile = $actionFile;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return ProjectFileIndex.getInstance((Project)this.this$0.getProject()).isInProject(this.$actionFile);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue() || !this.$actionFile.isInLocalFileSystem()) ** GOTO lbl29
                        this.label = 2;
                        v1 = this.$localActionsProvider.constructActionReference(this.$actionFile, (Continuation<? super String>)((Continuation)this));
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        v2 = (String)v1;
                        if (v2 != null) {
                            var2_3 = v2;
                            var3_4 = this.this$0;
                            it = var2_3;
                            $i$a$-let-GitHubActionsCatalog$deleteLocalActionEntry$1$2 = false;
                            var3_4.deleteActionMetadata(it);
                        }
lbl29:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void deleteFileFromCache(String actionReference2) {
        VirtualFile virtualFile;
        String fileUrl;
        String version;
        Pair<String, String> pair = GitHubActionCacheCommonsKt.splitActionReference(actionReference2);
        String actionRef = (String)pair.component1();
        if (!GitHubActionCacheCommonsKt.isRemoteAction(actionRef, version = (String)pair.component2())) {
            return;
        }
        String string = fileUrl = this.state.getReferenceAndContent().get(actionReference2);
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByUrl(it);
        } else {
            virtualFile = null;
        }
        VirtualFile virtualFile2 = virtualFile;
        try {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Deleting file " + virtualFile2 + " for action " + actionReference2 + " from filesystem cache");
            Object object = virtualFile2;
            if (object != null && (object = object.toNioPath()) != null) {
                Object it = object;
                boolean bl = false;
                FileUtil.delete((Path)it);
            }
        }
        catch (IOException ex) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot delete action file " + virtualFile2 + " for action " + actionReference2, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object loadFileToCache(String var1_1, Continuation<? super String> var2_2) {
        if (!(var2_2 instanceof loadFileToCache.1)) ** GOTO lbl-1000
        var11_3 = var2_2;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ GitHubActionsCatalog this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GitHubActionsCatalog.access$loadFileToCache(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = GitHubActionCacheCommonsKt.splitActionReference(actionReference);
                actionRef = (String)var3_6.component1();
                version = (String)var3_6.component2();
                if (!GitHubActionCacheCommonsKt.isLocalAction(actionRef, version)) ** GOTO lbl35
                $this$service$iv = (ComponentManager)this.project;
                $i$f$service = false;
                serviceClass$iv = LocalActionsProvider.class;
                v0 = $this$service$iv.getService(serviceClass$iv);
                if (v0 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                localActionsProvider = (LocalActionsProvider)v0;
                $continuation.label = 1;
                v1 = localActionsProvider.resolveActionFile(actionReference).await((Continuation)$continuation);
                if (v1 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                v2 = (VirtualFile)v1;
                if (v2 == null) return null;
                v3 = v2.getUrl();
                return v3;
            }
lbl35:
            // 1 sources

            try {
                v4 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"separator");
                v5 = PathUtil.makeFileName((String)(StringsKt.replace$default((String)actionReference, (String)"@", (String)v4, (boolean)false, (int)4, null) + File.separator + "action"), (String)"yml");
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"makeFileName(...)");
                supposedFileName = v5;
                filePath = this.filesCacheDir.resolve(supposedFileName);
                Intrinsics.checkNotNull((Object)filePath);
                v6 = new LinkOption[]{};
                if (!Files.exists(filePath, Arrays.copyOf(v6, v6.length))) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = actionReference;
                    $continuation.L$2 = filePath;
                    $continuation.label = 2;
                    v7 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(actionReference, this, actionRef, version, filePath, null){
                        int label;
                        final /* synthetic */ String $actionReference;
                        final /* synthetic */ GitHubActionsCatalog this$0;
                        final /* synthetic */ String $actionRef;
                        final /* synthetic */ String $version;
                        final /* synthetic */ Path $filePath;
                        {
                            this.$actionReference = $actionReference;
                            this.this$0 = $receiver;
                            this.$actionRef = $actionRef;
                            this.$version = $version;
                            this.$filePath = $filePath;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         * Could not resolve type clashes
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $i$f$fileLogger = false;
                                    $i$f$currentClassLogger = false;
                                    clazz$iv$iv = MethodHandles.lookup().lookupClass();
                                    v0 = Logger.getInstance(clazz$iv$iv);
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                                    v0.debug("Fetching file for " + this.$actionReference);
                                    $this$service$iv = (ComponentManager)this.this$0.getProject();
                                    $i$f$service = false;
                                    serviceClass$iv = RemoteActionsProvider.class;
                                    v1 = $this$service$iv.getService(serviceClass$iv);
                                    if (v1 == null) {
                                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                    }
                                    v2 = RemoteActionsProvider.resolveActionFile$default((RemoteActionsProvider)v1, this.$actionRef, this.$version, null, 0L, 12, null);
                                    if (v2 == null) ** GOTO lbl29
                                    this.label = 1;
                                    v3 = v2.await((Continuation)this);
                                    if (v3 == var14_2) {
                                        return var14_2;
                                    }
                                    ** GOTO lbl28
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v3 = $result;
lbl28:
                                    // 2 sources

                                    if ((v2 = (VirtualFile)v3) != null) ** GOTO lbl30
lbl29:
                                    // 2 sources

                                    return null;
lbl30:
                                    // 1 sources

                                    virtualFile = v2;
                                    $i$f$fileLogger = false;
                                    $i$f$currentClassLogger = false;
                                    clazz$iv$iv /* !! */  = MethodHandles.lookup().lookupClass();
                                    v4 = Logger.getInstance(clazz$iv$iv /* !! */ );
                                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(...)");
                                    v4.debug("Copying file " + virtualFile + " to " + this.$filePath);
                                    v5 = this.$filePath;
                                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"$filePath");
                                    PathsKt.createParentDirectories((Path)v5, (FileAttribute[])new FileAttribute[0]);
                                    this.$filePath.toFile().createNewFile();
                                    $i$f$fileLogger = virtualFile.getInputStream();
                                    $i$f$currentClassLogger = this.$filePath;
                                    clazz$iv$iv /* !! */  = null;
                                    try {
                                        inputStream = (InputStream)$i$f$fileLogger;
                                        $i$a$-use-GitHubActionsCatalog$loadFileToCache$2$1 = false;
                                        Intrinsics.checkNotNull((Object)$i$f$currentClassLogger);
                                        var9_19 = $i$f$currentClassLogger;
                                        var10_20 /* !! */  = new OpenOption[]{StandardOpenOption.WRITE};
                                        v6 = Files.newOutputStream((Path)var9_19, Arrays.copyOf(var10_20 /* !! */ , var10_20 /* !! */ .length));
                                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"newOutputStream(...)");
                                        var9_19 = v6;
                                        var10_20 /* !! */  = null;
                                        try {
                                            outputStream = (OutputStream)var9_19;
                                            $i$a$-use-GitHubActionsCatalog$loadFileToCache$2$1$1 = false;
                                            Intrinsics.checkNotNull((Object)inputStream);
                                            var11_22 = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
                                        }
                                        catch (Throwable var11_23) {
                                            var10_20 /* !! */  = var11_23;
                                            throw var11_23;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)var9_19, (Throwable)var10_20 /* !! */ );
                                        }
                                        var6_15 = var11_22;
                                    }
                                    catch (Throwable var6_16) {
                                        clazz$iv$iv /* !! */  = var6_16;
                                        throw var6_16;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)$i$f$fileLogger, clazz$iv$iv /* !! */ );
                                    }
                                    $i$f$fileLogger = false;
                                    $i$f$currentClassLogger = false;
                                    clazz$iv$iv /* !! */  = MethodHandles.lookup().lookupClass();
                                    v7 = Logger.getInstance(clazz$iv$iv /* !! */ );
                                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getInstance(...)");
                                    v7.debug("Finished copying " + virtualFile + " to cache " + this.$filePath);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                }
                ** GOTO lbl73
            }
            catch (IOException ex) {
                $i$f$fileLogger = false;
                $i$f$currentClassLogger = false;
                clazz$iv$iv = MethodHandles.lookup().lookupClass();
                v8 = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getInstance(...)");
                v8.warn("Error saving file for action " + actionReference + " to " + this.filesCacheDir, (Throwable)ex);
                return null;
            }
            v9 = v7;
            if (v7 == var12_5) {
                return var12_5;
            }
            ** GOTO lbl73
            case 2: {
                filePath = (Path)$continuation.L$2;
                actionReference = (String)$continuation.L$1;
                this = (GitHubActionsCatalog)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl73:
                    // 3 sources

                    Intrinsics.checkNotNull((Object)filePath);
                    v10 = VfsUtil.pathToUrl((String)PathsKt.getInvariantSeparatorsPathString((Path)filePath));
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"pathToUrl(...)");
                    return v10;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ CacheInternalState access$getState$p(GitHubActionsCatalog $this) {
        return $this.state;
    }

    public static final /* synthetic */ GitHubActionMetadataFactory access$getMetadataFactory$p(GitHubActionsCatalog $this) {
        return $this.metadataFactory;
    }

    public static final /* synthetic */ Object access$loadFileToCache(GitHubActionsCatalog $this, String actionReference2, Continuation $completion) {
        return $this.loadFileToCache(actionReference2, (Continuation<? super String>)$completion);
    }
}

