/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.action.context.steps;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.vcs.github.ultimate.action.context.ReferenceContext;
import com.intellij.vcs.github.ultimate.action.context.steps.StepIdReference;
import com.intellij.vcs.github.ultimate.action.context.steps.StepResolver;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/vcs/github/ultimate/action/context/steps/StepsContext;", "Lcom/intellij/vcs/github/ultimate/action/context/ReferenceContext;", "()V", "completePrefixRegex", "Lkotlin/text/Regex;", "getCompletePrefixRegex", "()Lkotlin/text/Regex;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "propertyName", "", "getPropertyName", "()Ljava/lang/String;", "referencePrefixRegex", "getReferencePrefixRegex", "resolver", "Lcom/intellij/vcs/github/ultimate/action/context/steps/StepResolver;", "getResolver", "()Lcom/intellij/vcs/github/ultimate/action/context/steps/StepResolver;", "calculateRange", "Lcom/intellij/openapi/util/TextRange;", "matchResult", "Lkotlin/text/MatchResult;", "createLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "element", "Lcom/intellij/psi/PsiElement;", "createPsiReference", "Lcom/intellij/psi/PsiReference;", "Lorg/jetbrains/yaml/psi/YAMLValue;", "intellij.vcs.github.ultimate"})
public final class StepsContext
extends ReferenceContext {
    @NotNull
    public static final StepsContext INSTANCE = new StepsContext();
    @NotNull
    private static final Regex referencePrefixRegex = new Regex("(steps)\\.([a-zA-Z_][a-zA-Z0-9_-]*)");
    @NotNull
    private static final Regex completePrefixRegex = new Regex("steps");
    @NotNull
    private static final StepResolver resolver = new StepResolver();

    private StepsContext() {
    }

    @Override
    @NotNull
    public String getPropertyName() {
        return "steps";
    }

    @Override
    @NotNull
    public Regex getReferencePrefixRegex() {
        return referencePrefixRegex;
    }

    @Override
    @NotNull
    protected Regex getCompletePrefixRegex() {
        return completePrefixRegex;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Debugger.SmartStepInto;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SmartStepInto");
        return icon;
    }

    @Override
    @NotNull
    public StepResolver getResolver() {
        return resolver;
    }

    @Override
    @Nullable
    protected PsiReference createPsiReference(@NotNull YAMLValue element, @NotNull MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        return (PsiReference)new StepIdReference(element, this.calculateRange(matchResult));
    }

    @Override
    @NotNull
    public TextRange calculateRange(@NotNull MatchResult matchResult) {
        MatchGroup matchGroup;
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        MatchGroup matchGroup2 = matchResult.getGroups().get(2);
        return new TextRange(matchGroup2 != null && (matchGroup2 = matchGroup2.getRange()) != null ? matchGroup2.getFirst() : matchResult.getRange().getFirst(), ((matchGroup = matchResult.getGroups().get(2)) != null && (matchGroup = matchGroup.getRange()) != null ? matchGroup.getEndInclusive().intValue() : matchResult.getRange().getLast()) + 1);
    }

    @Override
    @NotNull
    protected LookupElement createLookupElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement lookupElement = element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() instanceof YAMLScalar && ((YAMLKeyValue)element).getValue() != null ? (PsiElement)((YAMLKeyValue)element).getValue() : element;
        PsiElement psiElement = lookupElement;
        if (psiElement == null) {
            psiElement = element;
        }
        return super.createLookupElement(psiElement);
    }
}

