/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.action.context;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.vcs.github.ultimate.action.GitHubActionContext;
import com.intellij.vcs.github.ultimate.action.context.ContextElementResolver;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\u0006\u0010#\u001a\u00020\u001dH\u0016J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0%2\u0006\u0010\u001c\u001a\u00020 R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/github/ultimate/action/context/ReferenceContext;", "Lcom/intellij/vcs/github/ultimate/action/GitHubActionContext;", "()V", "completePrefixRegex", "Lkotlin/text/Regex;", "getCompletePrefixRegex", "()Lkotlin/text/Regex;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "referencePrefixRegex", "getReferencePrefixRegex", "resolver", "Lcom/intellij/vcs/github/ultimate/action/context/ContextElementResolver;", "getResolver", "()Lcom/intellij/vcs/github/ultimate/action/context/ContextElementResolver;", "calculateRange", "Lcom/intellij/openapi/util/TextRange;", "matchResult", "Lkotlin/text/MatchResult;", "canComplete", "", "s", "", "createLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "element", "Lcom/intellij/psi/PsiElement;", "createPsiReference", "Lcom/intellij/psi/PsiReference;", "Lorg/jetbrains/yaml/psi/YAMLValue;", "provideElements", "Lkotlin/sequences/Sequence;", "yamlElement", "providePsiReferences", "", "intellij.vcs.github.ultimate"})
public abstract class ReferenceContext
implements GitHubActionContext {
    @Nullable
    private final ContextElementResolver resolver;

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Vcs.Vendors.Github;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Github");
        return icon;
    }

    @NotNull
    public abstract Regex getReferencePrefixRegex();

    @NotNull
    protected abstract Regex getCompletePrefixRegex();

    @NotNull
    protected LookupElement createLookupElement(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiNamedElement) {
            string = ((PsiNamedElement)element).getName();
            if (string == null) {
                string = "";
            }
        } else {
            string = element.getText();
        }
        String elementString = string;
        LookupElement lookupElement = LookupElementBuilder.create((String)elementString).withIcon(this.getIcon()).withAutoCompletionPolicy(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"withAutoCompletionPolicy(...)");
        return lookupElement;
    }

    @Nullable
    public ContextElementResolver getResolver() {
        return this.resolver;
    }

    public boolean canComplete(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Regex regex = this.getCompletePrefixRegex();
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)s, (long)1000L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        return regex.matches(charSequence);
    }

    @NotNull
    public final List<PsiReference> providePsiReferences(@NotNull YAMLValue element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)element.getText(), (long)1000L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        CharSequence expressionString = charSequence;
        Sequence matches = Regex.findAll$default((Regex)this.getReferencePrefixRegex(), (CharSequence)expressionString, (int)0, (int)2, null);
        return (List)ExtensionsKt.toImmutableList((Sequence)SequencesKt.mapNotNull((Sequence)matches, (Function1)((Function1)new Function1<MatchResult, PsiReference>(this, element){
            final /* synthetic */ ReferenceContext this$0;
            final /* synthetic */ YAMLValue $element;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                super(1);
            }

            @Nullable
            public final PsiReference invoke(@NotNull MatchResult matchResult) {
                Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
                return this.this$0.createPsiReference(this.$element, matchResult);
            }
        })));
    }

    @Nullable
    protected PsiReference createPsiReference(@NotNull YAMLValue element, @NotNull MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        return null;
    }

    @NotNull
    public Sequence<LookupElement> provideElements(@NotNull PsiElement yamlElement) {
        ContextElementResolver contextElementResolver;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)yamlElement, (String)"yamlElement");
                contextElementResolver = this.getResolver();
                if (contextElementResolver == null || (contextElementResolver = contextElementResolver.getSearchContext(yamlElement)) == null) break block3;
                ContextElementResolver it = contextElementResolver;
                boolean bl = false;
                Sequence<YAMLKeyValue> sequence = this.getResolver();
                Sequence sequence2 = sequence != null && (sequence = sequence.findAllElements((PsiElement)it)) != null ? SequencesKt.map(sequence, (Function1)((Function1)new Function1<YAMLKeyValue, LookupElement>(this){
                    final /* synthetic */ ReferenceContext this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final LookupElement invoke(@NotNull YAMLKeyValue it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.this$0.createLookupElement((PsiElement)it);
                    }
                })) : null;
                contextElementResolver = sequence2;
                if (sequence2 != null) break block4;
            }
            contextElementResolver = SequencesKt.emptySequence();
        }
        return contextElementResolver;
    }

    @NotNull
    public TextRange calculateRange(@NotNull MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        return textRange;
    }
}

