/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import git4idea.conflicts.GitConflictsView;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitStagingAreaHolder;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GitConflictsToolWindowManager {
    @NotNull
    @NonNls
    public static final String CONFLICTS = "Git Conflicts";

    public static class MyRepositoryListener
    implements VcsRepositoryMappingListener {
        private final Project myProject;

        public MyRepositoryListener(@NotNull Project project) {
            if (project == null) {
                MyRepositoryListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void mappingChanged() {
            if (!Registry.is((String)"git.merge.conflicts.toolwindow")) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> ((ChangesViewContentManagerListener)this.myProject.getMessageBus().syncPublisher(ChangesViewContentManagerListener.TOPIC)).toolWindowMappingChanged(), ModalityState.nonModal());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/conflicts/GitConflictsToolWindowManager$MyRepositoryListener", "<init>"));
        }
    }

    public static class MyStagingAreaListener
    implements GitStagingAreaHolder.StagingAreaListener {
        @Override
        public void stagingAreaChanged(@NotNull GitRepository repository) {
            if (repository == null) {
                MyStagingAreaListener.$$$reportNull$$$0(0);
            }
            if (!Registry.is((String)"git.merge.conflicts.toolwindow")) {
                return;
            }
            Project project = repository.getProject();
            ApplicationManager.getApplication().invokeLater(() -> ((ChangesViewContentManagerListener)project.getMessageBus().syncPublisher(ChangesViewContentManagerListener.TOPIC)).toolWindowMappingChanged(), ModalityState.nonModal(), project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/conflicts/GitConflictsToolWindowManager$MyStagingAreaListener", "stagingAreaChanged"));
        }
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        public String get() {
            return GitBundle.message("tab.title.conflicts", new Object[0]);
        }
    }

    static class ContentProvider
    implements ChangesViewContentProvider {
        private final Project myProject;

        ContentProvider(@NotNull Project project) {
            if (project == null) {
                ContentProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void initTabContent(@NotNull Content content) {
            if (content == null) {
                ContentProvider.$$$reportNull$$$0(1);
            }
            GitDefaultMergeDialogCustomizer mergeDialogCustomizer = new GitDefaultMergeDialogCustomizer(this.myProject);
            GitConflictsView panel2 = new GitConflictsView(this.myProject, mergeDialogCustomizer);
            content.setComponent(panel2.getComponent());
            content.setPreferredFocusedComponent(() -> panel2.getPreferredFocusableComponent());
            content.setDisposer((Disposable)panel2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "git4idea/conflicts/GitConflictsToolWindowManager$ContentProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ContentPreloader
    implements ChangesViewContentProvider.Preloader {
        ContentPreloader() {
        }

        public void preloadTabContent(@NotNull Content content) {
            if (content == null) {
                ContentPreloader.$$$reportNull$$$0(0);
            }
            content.putUserData(ChangesViewContentManager.ORDER_WEIGHT_KEY, (Object)(ChangesViewContentManager.TabOrderWeight.REPOSITORY.getWeight() + 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "git4idea/conflicts/GitConflictsToolWindowManager$ContentPreloader", "preloadTabContent"));
        }
    }

    static final class ContentPredicate
    implements Predicate<Project> {
        ContentPredicate() {
        }

        @Override
        public boolean test(Project project) {
            if (!Registry.is((String)"git.merge.conflicts.toolwindow")) {
                return false;
            }
            return ContainerUtil.exists(GitRepositoryManager.getInstance(project).getRepositories(), repo -> repo.getStagingAreaHolder().hasConflicts());
        }
    }
}

