/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.VcsExecutablePathSelector;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.GitVcs;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableInlineComponent;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.InlineComponent;
import git4idea.config.InlineErrorNotifier;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 $2\u00020\u0001:\u0003$%&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\f\u0010!\u001a\u00020\"*\u00020#H\u0002R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\n \t*\u0004\u0018\u00010\u00130\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lgit4idea/config/GitExecutableSelectorPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "applicationSettings", "Lgit4idea/config/GitVcsApplicationSettings;", "kotlin.jvm.PlatformType", "getApplicationSettings", "()Lgit4idea/config/GitVcsApplicationSettings;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "pathSelector", "Lcom/intellij/util/ui/VcsExecutablePathSelector;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectSettings", "Lgit4idea/config/GitVcsSettings;", "getProjectSettings", "()Lgit4idea/config/GitVcsSettings;", "versionCheckRequested", "", "getModalityState", "Lcom/intellij/openapi/application/ModalityState;", "Lorg/jetbrains/annotations/NotNull;", "resetPathSelector", "", "testGitExecutable", "pathToGit", "", "validateExecutableOnceAfterClose", "createRow", "Lcom/intellij/ui/dsl/builder/Row;", "Lcom/intellij/ui/dsl/builder/Panel;", "Companion", "GitExecutableHandler", "InlineErrorNotifierFromSettings", "intellij.vcs.git"})
public final class GitExecutableSelectorPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final VcsExecutablePathSelector pathSelector;
    private volatile boolean versionCheckRequested;

    public GitExecutableSelectorPanel(@NotNull Project project, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.disposable = disposable;
        this.pathSelector = new VcsExecutablePathSelector(GitVcs.DISPLAY_NAME.get(), this.disposable, (VcsExecutablePathSelector.ExecutableHandler)new GitExecutableHandler());
        MessageBusConnection messageBusConnection = ApplicationKt.getApplication().getMessageBus().connect(this.disposable);
        Topic<GitExecutableListener> topic = GitExecutableManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, () -> GitExecutableSelectorPanel._init_$lambda$0(this));
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.disposable, () -> GitExecutableSelectorPanel._init_$lambda$1(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    private final GitVcsApplicationSettings getApplicationSettings() {
        return GitVcsApplicationSettings.getInstance();
    }

    private final GitVcsSettings getProjectSettings() {
        return GitVcsSettings.getInstance(this.project);
    }

    private final Row createRow(Panel $this$createRow) {
        return Panel.row$default((Panel)$this$createRow, null, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GitExecutableSelectorPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.cell((JComponent)GitExecutableSelectorPanel.access$getPathSelector$p(this.this$0).getMainPanel()).align((Align)AlignX.FILL.INSTANCE).onReset((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ GitExecutableSelectorPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        GitExecutableSelectorPanel.access$resetPathSelector(this.this$0);
                    }
                }).onIsModified((Function0)new Function0<Boolean>(this.this$0){
                    final /* synthetic */ GitExecutableSelectorPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return GitExecutableSelectorPanel.access$getPathSelector$p(this.this$0).isModified(GitExecutableSelectorPanel.access$getApplicationSettings(this.this$0).getSavedPathToGit(), GitExecutableSelectorPanel.access$getProjectSettings(this.this$0).getPathToGit() != null, GitExecutableSelectorPanel.access$getProjectSettings(this.this$0).getPathToGit());
                    }
                }).onApply((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ GitExecutableSelectorPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        String currentPath = GitExecutableSelectorPanel.access$getPathSelector$p(this.this$0).getCurrentPath();
                        if (GitExecutableSelectorPanel.access$getPathSelector$p(this.this$0).isOverridden()) {
                            GitExecutableSelectorPanel.access$getProjectSettings(this.this$0).setPathToGit(currentPath);
                        } else {
                            GitExecutableSelectorPanel.access$getApplicationSettings(this.this$0).setPathToGit(currentPath);
                            GitExecutableSelectorPanel.access$getProjectSettings(this.this$0).setPathToGit(null);
                        }
                        GitExecutableSelectorPanel.access$validateExecutableOnceAfterClose(this.this$0);
                        VcsDirtyScopeManager.getInstance((Project)this.this$0.getProject()).markEverythingDirty();
                    }
                });
            }
        }), (int)1, null);
    }

    private final void resetPathSelector() {
        this.pathSelector.setAutoDetectedPath(GitExecutableManager.getInstance().getDetectedExecutable(this.project, false));
        this.pathSelector.reset(this.getApplicationSettings().getSavedPathToGit(), this.getProjectSettings().getPathToGit() != null, this.getProjectSettings().getPathToGit());
    }

    private final void testGitExecutable(String pathToGit) {
        ModalityState modalityState = this.getModalityState();
        BorderLayoutPanel borderLayoutPanel = this.pathSelector.getErrorComponent();
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"getErrorComponent(...)");
        InlineErrorNotifierFromSettings errorNotifier = new InlineErrorNotifierFromSettings(new GitExecutableInlineComponent(borderLayoutPanel, modalityState, null), modalityState, this.disposable);
        if (!this.project.isDefault() && !TrustedProjects.isTrusted((Project)this.project)) {
            String string = GitBundle.message("git.executable.validation.cant.run.in.safe.mode", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            errorNotifier.showError(string, null);
            return;
        }
        Project project = this.project;
        String string = GitBundle.message("git.executable.version.progress.title", new Object[0]);
        new Task.Modal(pathToGit, errorNotifier, project, string){
            private GitVersion gitVersion;
            final /* synthetic */ String $pathToGit;
            final /* synthetic */ InlineErrorNotifierFromSettings $errorNotifier;
            {
                this.$pathToGit = $pathToGit;
                this.$errorNotifier = $errorNotifier;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitExecutableManager executableManager = GitExecutableManager.getInstance();
                GitExecutable gitExecutable = executableManager.getExecutable(this.$pathToGit);
                Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
                GitExecutable executable = gitExecutable;
                executableManager.dropVersionCache(executable);
                GitVersion gitVersion = executableManager.identifyVersion(executable);
                Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"identifyVersion(...)");
                this.gitVersion = gitVersion;
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                GitExecutableProblemHandler problemHandler = GitExecutableProblemHandlersKt.findGitExecutableProblemHandler(project);
                problemHandler.showError(error, this.$errorNotifier);
            }

            public void onSuccess() {
                GitVersion gitVersion = this.gitVersion;
                if (gitVersion == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gitVersion");
                    gitVersion = null;
                }
                if (gitVersion.isSupported()) {
                    Object[] objectArray = new Object[1];
                    GitVersion gitVersion2 = this.gitVersion;
                    if (gitVersion2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"gitVersion");
                        gitVersion2 = null;
                    }
                    objectArray[0] = gitVersion2.getPresentation();
                    String string = GitBundle.message("git.executable.version.is", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.$errorNotifier.showMessage(string);
                } else {
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    GitVersion gitVersion3 = this.gitVersion;
                    if (gitVersion3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"gitVersion");
                        gitVersion3 = null;
                    }
                    GitExecutableProblemHandlersKt.showUnsupportedVersionError(project, gitVersion3, this.$errorNotifier);
                }
            }
        }.queue();
    }

    private final void validateExecutableOnceAfterClose() {
        if (this.versionCheckRequested) {
            return;
        }
        this.versionCheckRequested = true;
        ActionsKt.runInEdt((ModalityState)ModalityState.nonModal(), (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GitExecutableSelectorPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void cancellable$iv;
                void title$iv;
                void project$iv;
                GitExecutableSelectorPanel.access$setVersionCheckRequested$p(this.this$0, false);
                String string = GitBundle.message("git.executable.version.progress.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = string;
                Project project = this.this$0.getProject();
                boolean bl = true;
                GitExecutableSelectorPanel gitExecutableSelectorPanel = this.this$0;
                boolean $i$f$runBackgroundableTask = false;
                ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, (boolean)cancellable$iv, gitExecutableSelectorPanel){
                    final /* synthetic */ GitExecutableSelectorPanel this$0;
                    {
                        this.this$0 = gitExecutableSelectorPanel;
                        super($project, $title, $cancellable);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator it = indicator;
                        boolean bl = false;
                        GitExecutableManager.getInstance().testGitExecutableVersionValid(this.this$0.getProject());
                    }
                });
            }
        }));
    }

    private final ModalityState getModalityState() {
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.pathSelector.getMainPanel());
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        return modalityState;
    }

    private static final void _init_$lambda$0(GitExecutableSelectorPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActionsKt.runInEdt((ModalityState)this$0.getModalityState(), (Function0)((Function0)new Function0<Unit>(this$0){
            final /* synthetic */ GitExecutableSelectorPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GitExecutableSelectorPanel.access$resetPathSelector(this.this$0);
            }
        }));
    }

    private static final void _init_$lambda$1(GitExecutableSelectorPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        GitExecutableManager.getInstance().getDetectedExecutable(this$0.project, true);
    }

    public static final /* synthetic */ VcsExecutablePathSelector access$getPathSelector$p(GitExecutableSelectorPanel $this) {
        return $this.pathSelector;
    }

    public static final /* synthetic */ void access$resetPathSelector(GitExecutableSelectorPanel $this) {
        $this.resetPathSelector();
    }

    public static final /* synthetic */ GitVcsApplicationSettings access$getApplicationSettings(GitExecutableSelectorPanel $this) {
        return $this.getApplicationSettings();
    }

    public static final /* synthetic */ GitVcsSettings access$getProjectSettings(GitExecutableSelectorPanel $this) {
        return $this.getProjectSettings();
    }

    public static final /* synthetic */ void access$validateExecutableOnceAfterClose(GitExecutableSelectorPanel $this) {
        $this.validateExecutableOnceAfterClose();
    }

    public static final /* synthetic */ void access$setVersionCheckRequested$p(GitExecutableSelectorPanel $this, boolean bl) {
        $this.versionCheckRequested = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lgit4idea/config/GitExecutableSelectorPanel$Companion;", "", "()V", "createGitExecutableSelectorRow", "", "Lcom/intellij/ui/dsl/builder/Panel;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final void createGitExecutableSelectorRow(@NotNull Panel $this$createGitExecutableSelectorRow, @NotNull Project project, @NotNull Disposable disposable) {
            GitExecutableSelectorPanel panel2;
            Intrinsics.checkNotNullParameter((Object)$this$createGitExecutableSelectorRow, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            GitExecutableSelectorPanel $this$createGitExecutableSelectorRow_u24lambda_u240 = panel2 = new GitExecutableSelectorPanel(project, disposable);
            boolean bl = false;
            $this$createGitExecutableSelectorRow_u24lambda_u240.createRow($this$createGitExecutableSelectorRow);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/config/GitExecutableSelectorPanel$GitExecutableHandler;", "Lcom/intellij/util/ui/VcsExecutablePathSelector$ExecutableHandler;", "(Lgit4idea/config/GitExecutableSelectorPanel;)V", "patchExecutable", "", "executable", "testExecutable", "", "intellij.vcs.git"})
    private final class GitExecutableHandler
    implements VcsExecutablePathSelector.ExecutableHandler {
        @Nullable
        public String patchExecutable(@NotNull String executable) {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            return GitExecutableDetector.patchExecutablePath(executable);
        }

        public void testExecutable(@NotNull String executable) {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            GitExecutableSelectorPanel.this.testGitExecutable(executable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/config/GitExecutableSelectorPanel$InlineErrorNotifierFromSettings;", "Lgit4idea/config/InlineErrorNotifier;", "inlineComponent", "Lgit4idea/config/InlineComponent;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lgit4idea/config/GitExecutableSelectorPanel;Lgit4idea/config/InlineComponent;Lcom/intellij/openapi/application/ModalityState;Lcom/intellij/openapi/Disposable;)V", "resetGitExecutable", "", "showError", "text", "", "description", "fixOption", "Lgit4idea/config/ErrorNotifier$FixOption;", "intellij.vcs.git"})
    private final class InlineErrorNotifierFromSettings
    extends InlineErrorNotifier {
        @NotNull
        private final ModalityState modalityState;

        public InlineErrorNotifierFromSettings(@NotNull InlineComponent inlineComponent, @NotNull ModalityState modalityState, Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)inlineComponent, (String)"inlineComponent");
            Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            super(inlineComponent, modalityState, disposable);
            this.modalityState = modalityState;
        }

        @Override
        public void showError(@NotNull String text2, @Nullable String description2, @Nullable ErrorNotifier.FixOption fixOption) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (fixOption instanceof ErrorNotifier.FixOption.Configure) {
                super.showError(text2, description2, null);
            } else {
                super.showError(text2, description2, fixOption);
            }
        }

        @Override
        public void resetGitExecutable() {
            super.resetGitExecutable();
            GitExecutableManager.getInstance().getDetectedExecutable(GitExecutableSelectorPanel.this.getProject(), true);
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, (Function0)((Function0)new Function0<Unit>(GitExecutableSelectorPanel.this){
                final /* synthetic */ GitExecutableSelectorPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    GitExecutableSelectorPanel.access$resetPathSelector(this.this$0);
                }
            }));
        }
    }
}

