/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.google.common.collect.HashMultiset;
import com.intellij.diff.util.Side;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.PostCommitChangeConverter;
import com.intellij.openapi.vcs.ex.PartialCommitHelper;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.EditedCommitDetails;
import com.intellij.vcs.commit.LocalChangesCommitterKt;
import com.intellij.vcs.commit.ToggleAmendCommitOption;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.checkin.GitAmendCommitService;
import git4idea.checkin.GitCheckinExplicitMovementProvider;
import git4idea.checkin.GitCommitAndPushExecutorKt;
import git4idea.checkin.GitCommitOptions;
import git4idea.checkin.GitCommitOptionsKt;
import git4idea.checkin.GitCommitOptionsUi;
import git4idea.checkin.GitPostCommitChangeConverter;
import git4idea.checkin.GitPushAfterCommitDialog;
import git4idea.checkin.GitRepositoryCommitter;
import git4idea.checkin.GitSkipHooksCommitHandlerFactoryKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitCommitTemplateTracker;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmoduleKt;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

@Service(value={Service.Level.PROJECT})
public final class GitCheckinEnvironment
implements CheckinEnvironment,
AmendCommitAware {
    private static final Logger LOG = Logger.getInstance(GitCheckinEnvironment.class);
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_PREFIX = "git-commit-msg-";
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_EXT = ".txt";
    private final Project myProject;
    public static final SimpleDateFormat COMMIT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private VcsUser myNextCommitAuthor;
    private boolean myNextCommitAmend;
    private Date myNextCommitAuthorDate;
    private boolean myNextCommitSignOff;
    private boolean myNextCommitSkipHook;
    private boolean myNextCleanupCommitMessage;

    public GitCheckinEnvironment(@NotNull Project project) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    @NotNull
    public RefreshableOnComponent createCommitOptions(@NotNull CheckinProjectPanel commitPanel, @NotNull CommitContext commitContext) {
        if (commitPanel == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(1);
        }
        if (commitContext == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(2);
        }
        return new GitCheckinOptions(commitPanel, commitContext, ToggleAmendCommitOption.isAmendCommitOptionSupported((CheckinProjectPanel)commitPanel, (AmendCommitAware)this));
    }

    @Nullable
    public String getDefaultMessageFor(FilePath @NotNull [] filesToCheckin) {
        if (filesToCheckin == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(3);
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        GitRepositoryManager manager2 = GitUtil.getRepositoryManager(this.myProject);
        Set repositories2 = ContainerUtil.map2SetNotNull(Arrays.asList(filesToCheckin), arg_0 -> ((GitRepositoryManager)manager2).getRepositoryForFileQuick(arg_0));
        for (GitRepository repository : repositories2) {
            File mergeMsg = repository.getRepositoryFiles().getMergeMessageFile();
            File squashMsg = repository.getRepositoryFiles().getSquashMessageFile();
            try {
                if (!mergeMsg.exists() && !squashMsg.exists()) continue;
                String encoding = GitConfigUtil.getCommitEncoding(this.myProject, repository.getRoot());
                if (mergeMsg.exists()) {
                    messages.add(GitCheckinEnvironment.loadMessage(mergeMsg, encoding));
                    continue;
                }
                messages.add(GitCheckinEnvironment.loadMessage(squashMsg, encoding));
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unable to load merge message", (Throwable)e);
            }
        }
        return DvcsUtil.joinMessagesOrNull(messages);
    }

    private static String loadMessage(@NotNull File messageFile, @NotNull @NonNls String encoding) throws IOException {
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(4);
        }
        if (encoding == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(5);
        }
        return FileUtil.loadFile((File)messageFile, (String)encoding);
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return GitBundle.message("commit.action.name", new Object[0]);
    }

    public boolean isAmendCommitSupported() {
        return this.getAmendService().isAmendCommitSupported();
    }

    @Nullable
    public String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(6);
        }
        return this.getAmendService().getLastCommitMessage(root);
    }

    @NotNull
    public CancellablePromise<EditedCommitDetails> getAmendCommitDetails(@NotNull VirtualFile root) {
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(7);
        }
        CancellablePromise cancellablePromise = this.getAmendService().getAmendCommitDetails(root);
        if (cancellablePromise == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(8);
        }
        return cancellablePromise;
    }

    @NotNull
    private GitAmendCommitService getAmendService() {
        GitAmendCommitService gitAmendCommitService = (GitAmendCommitService)((Object)this.myProject.getService(GitAmendCommitService.class));
        if (gitAmendCommitService == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(9);
        }
        return gitAmendCommitService;
    }

    private void updateState(@NotNull CommitContext commitContext) {
        if (commitContext == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(10);
        }
        this.myNextCommitAmend = AbstractCommitWorkflowKt.isAmendCommitMode((CommitContext)commitContext);
        this.myNextCommitSkipHook = GitSkipHooksCommitHandlerFactoryKt.isSkipHooks(commitContext);
        this.myNextCommitAuthor = GitCommitOptionsKt.getCommitAuthor(commitContext);
        this.myNextCommitAuthorDate = GitCommitOptionsKt.getCommitAuthorDate(commitContext);
        this.myNextCommitSignOff = GitCommitOptionsKt.isSignOffCommit(commitContext);
        this.myNextCleanupCommitMessage = GitCommitTemplateTracker.getInstance(this.myProject).exists();
    }

    @NotNull
    public List<VcsException> commit(@NotNull List<? extends Change> changes, @NotNull @NonNls String commitMessage, @NotNull CommitContext commitContext, @NotNull Set<? super String> feedback) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(11);
        }
        if (commitMessage == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(12);
        }
        if (commitContext == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(13);
        }
        if (feedback == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(14);
        }
        this.updateState(commitContext);
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Map<GitRepository, Collection<Change>> sortedChanges = GitCheckinEnvironment.sortChangesByGitRoot(this.myProject, changes, exceptions);
        Collection commitWithoutChangesRoots = LocalChangesCommitterKt.getCommitWithoutChangesRoots((CommitContext)commitContext);
        LOG.assertTrue(!sortedChanges.isEmpty() || !commitWithoutChangesRoots.isEmpty(), (Object)("Trying to commit an empty list of changes: " + changes));
        List<GitRepository> repositories2 = this.collectRepositories(sortedChanges.keySet(), commitWithoutChangesRoots);
        for (GitRepository repository : repositories2) {
            Collection<Change> rootChanges = sortedChanges.getOrDefault(repository, ContainerUtil.emptyList());
            Collection<CommitChange> toCommit = GitCheckinEnvironment.collectChangesToCommit(rootChanges);
            if (GitCommitOptionsKt.isCommitRenamesSeparately(commitContext)) {
                Pair<Collection<CommitChange>, List<VcsException>> pair = this.commitExplicitRenames(repository, toCommit, commitMessage);
                toCommit = (Collection)pair.first;
                List moveExceptions = (List)pair.second;
                if (!moveExceptions.isEmpty()) {
                    exceptions.addAll(moveExceptions);
                    continue;
                }
            }
            exceptions.addAll(this.commitRepository(repository, toCommit, commitMessage, commitContext));
        }
        if (GitCommitAndPushExecutorKt.isPushAfterCommit(commitContext) && exceptions.isEmpty()) {
            GitPushAfterCommitDialog.showOrPush(this.myProject, repositories2);
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private List<GitRepository> collectRepositories(@NotNull Collection<GitRepository> changesRepositories, @NotNull Collection<VcsRoot> noChangesRoots) {
        if (changesRepositories == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(16);
        }
        if (noChangesRoots == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(17);
        }
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.myProject);
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        Collection<GitRepository> noChangesRepositories = GitUtil.getRepositoriesFromRoots(repositoryManager, ContainerUtil.mapNotNull(noChangesRoots, it -> it.getVcs() == vcs ? it.getPath() : null));
        List<GitRepository> list2 = repositoryManager.sortByDependency(ContainerUtil.union(changesRepositories, noChangesRepositories));
        if (list2 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    private List<VcsException> commitRepository(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes, @NotNull @NonNls String message, @NotNull CommitContext commitContext) {
        List partialCommitHelpers;
        ArrayList<VcsException> exceptions;
        block13: {
            List<CommitChange> caseOnlyRenameChanges;
            HashSet<CommitChange> changedWithIndex;
            VirtualFile root;
            block12: {
                if (repository == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(19);
                }
                if (changes == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(20);
                }
                if (message == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(21);
                }
                if (commitContext == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(22);
                }
                exceptions = new ArrayList<VcsException>();
                root = repository.getRoot();
                Pair<List<PartialCommitHelper>, List<CommitChange>> partialAddResult = this.addPartialChangesToIndex(repository, changes);
                partialCommitHelpers = (List)partialAddResult.first;
                changedWithIndex = new HashSet<CommitChange>((Collection)partialAddResult.second);
                caseOnlyRenameChanges = this.addCaseOnlyRenamesToIndex(repository, changes, changedWithIndex, exceptions);
                if (exceptions.isEmpty()) break block12;
                ArrayList<VcsException> arrayList = exceptions;
                if (arrayList == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(23);
                }
                return arrayList;
            }
            changedWithIndex.addAll(caseOnlyRenameChanges);
            GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)messageFile -> exceptions.addAll(GitCheckinEnvironment.commitUsingIndex(this.myProject, repository, changes, changedWithIndex, messageFile, this.createCommitOptions()))));
            if (exceptions.isEmpty()) break block13;
            ArrayList<VcsException> arrayList = exceptions;
            if (arrayList == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(24);
            }
            return arrayList;
        }
        try {
            GitCheckinEnvironment.applyPartialChanges(partialCommitHelpers);
            repository.update();
            if (GitSubmoduleKt.isSubmodule(repository)) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(repository.getRoot().getParent());
            }
            GitPostCommitChangeConverter.markRepositoryCommit(commitContext, repository);
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static List<VcsException> commitUsingIndex(@NotNull Project project, @NotNull GitRepository repository, @NotNull Collection<? extends ChangedPath> rootChanges, @NotNull Set<? extends ChangedPath> changedWithIndex, @NotNull File messageFile, @NotNull GitCommitOptions commitOptions) {
        ArrayList<VcsException> exceptions;
        block20: {
            HashSet<FilePath> excludedUnstagedDeletions;
            ArrayList excludedStagedChanges;
            VirtualFile root;
            block18: {
                ArrayList<VcsException> arrayList;
                block19: {
                    if (project == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(26);
                    }
                    if (repository == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(27);
                    }
                    if (rootChanges == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(28);
                    }
                    if (changedWithIndex == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(29);
                    }
                    if (messageFile == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(30);
                    }
                    if (commitOptions == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(31);
                    }
                    exceptions = new ArrayList<VcsException>();
                    Set added = ContainerUtil.map2SetNotNull(rootChanges, it -> it.afterPath);
                    Set removed = ContainerUtil.map2SetNotNull(rootChanges, it -> it.beforePath);
                    root = repository.getRoot();
                    String rootPath = root.getPath();
                    List<FilePath> unmergedFiles = GitChangeUtils.getUnmergedFiles(repository);
                    if (!unmergedFiles.isEmpty()) {
                        throw new VcsException(GitBundle.message("error.commit.cant.commit.with.unmerged.paths", new Object[0]));
                    }
                    Collection<GitChangeUtils.GitDiffChange> stagedChanges2 = GitChangeUtils.getStagedChanges(project, root);
                    LOG.debug("Found staged changes: " + GitUtil.getLogStringGitDiffChanges(rootPath, stagedChanges2));
                    excludedStagedChanges = new ArrayList();
                    ArrayList<FilePath> excludedStagedAdditions = new ArrayList<FilePath>();
                    GitCheckinEnvironment.processExcludedPaths(stagedChanges2, added, removed, (PairConsumer<? super FilePath, ? super FilePath>)((PairConsumer)(before, after) -> {
                        if (before != null || after != null) {
                            excludedStagedChanges.add(new ChangedPath((FilePath)before, (FilePath)after));
                        }
                        if (before == null && after != null) {
                            excludedStagedAdditions.add((FilePath)after);
                        }
                    }));
                    Collection<GitChangeUtils.GitDiffChange> unstagedChanges = GitChangeUtils.getUnstagedChanges(project, root, excludedStagedAdditions, false);
                    LOG.debug("Found unstaged changes: " + GitUtil.getLogStringGitDiffChanges(rootPath, unstagedChanges));
                    excludedUnstagedDeletions = new HashSet<FilePath>();
                    GitCheckinEnvironment.processExcludedPaths(unstagedChanges, added, removed, (PairConsumer<? super FilePath, ? super FilePath>)((PairConsumer)(before, after) -> {
                        if (before != null && after == null) {
                            excludedUnstagedDeletions.add((FilePath)before);
                        }
                    }));
                    if (!excludedStagedChanges.isEmpty()) {
                        LOG.info("Staged changes excluded for commit: " + GitCheckinEnvironment.getLogString(rootPath, excludedStagedChanges));
                        GitCheckinEnvironment.resetExcluded(project, root, excludedStagedChanges);
                    }
                    List<FilePath> alreadyHandledPaths = GitCheckinEnvironment.getPaths(changedWithIndex);
                    HashSet toAdd = new HashSet(added);
                    toAdd.removeAll(alreadyHandledPaths);
                    HashSet toRemove = new HashSet(removed);
                    toRemove.removeAll(toAdd);
                    toRemove.removeAll(alreadyHandledPaths);
                    LOG.debug(String.format("Updating index: added: %s, removed: %s", toAdd, toRemove));
                    GitCheckinEnvironment.updateIndex(project, root, toAdd, toRemove, exceptions);
                    if (exceptions.isEmpty()) break block18;
                    arrayList = exceptions;
                    if (excludedStagedChanges.isEmpty()) break block19;
                    GitCheckinEnvironment.restoreExcluded(project, root, excludedStagedChanges, excludedUnstagedDeletions);
                }
                ArrayList<VcsException> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(32);
                }
                return arrayList2;
            }
            try {
                LOG.debug("Performing commit...");
                GitRepositoryCommitter committer = new GitRepositoryCommitter(repository, commitOptions);
                committer.commitStaged(messageFile);
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (!excludedStagedChanges.isEmpty()) {
                        GitCheckinEnvironment.restoreExcluded(project, root, excludedStagedChanges, excludedUnstagedDeletions);
                    }
                }
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    private GitCommitOptions createCommitOptions() {
        return new GitCommitOptions(this.myNextCommitAmend, this.myNextCommitSignOff, this.myNextCommitSkipHook, this.myNextCommitAuthor, this.myNextCommitAuthorDate, this.myNextCleanupCommitMessage);
    }

    @NotNull
    private Pair<List<PartialCommitHelper>, List<CommitChange>> addPartialChangesToIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes) throws VcsException {
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(34);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(35);
        }
        if (!ContainerUtil.exists(changes, it -> it.changelistIds != null)) {
            Pair pair = Pair.create((Object)ContainerUtil.emptyList(), (Object)ContainerUtil.emptyList());
            if (pair == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(36);
            }
            return pair;
        }
        Pair result2 = (Pair)GitCheckinEnvironment.computeAfterLSTManagerUpdate(repository.getProject(), () -> {
            ArrayList<PartialCommitHelper> helpers = new ArrayList<PartialCommitHelper>();
            ArrayList<CommitChange> partialChanges = new ArrayList<CommitChange>();
            for (CommitChange change : changes) {
                PartialLocalLineStatusTracker tracker;
                if (change.changelistIds == null || change.virtualFile == null || change.beforePath == null || change.afterPath == null || (tracker = PartialChangesUtil.getPartialTracker((Project)this.myProject, (VirtualFile)change.virtualFile)) == null || !tracker.hasPartialChangesToCommit()) continue;
                if (!tracker.isOperational()) {
                    LOG.warn("Tracker is not operational for " + tracker.getVirtualFile().getPresentableUrl());
                    return null;
                }
                helpers.add(tracker.handlePartialCommit(Side.LEFT, change.changelistIds, true));
                partialChanges.add(change);
            }
            return Pair.create(helpers, partialChanges);
        });
        if (result2 == null) {
            throw new VcsException(GitBundle.message("error.commit.cant.collect.partial.changes", new Object[0]));
        }
        List helpers = (List)result2.first;
        List partialChanges = (List)result2.second;
        ArrayList<FilePath> pathsToDelete = new ArrayList<FilePath>();
        for (CommitChange change : partialChanges) {
            if (!change.isMove()) continue;
            pathsToDelete.add(Objects.requireNonNull(change.beforePath));
        }
        LOG.debug(String.format("Updating index for partial changes: removing: %s", pathsToDelete));
        GitFileUtils.deletePaths(this.myProject, repository.getRoot(), pathsToDelete, "--ignore-unmatch");
        LOG.debug(String.format("Updating index for partial changes: changes: %s", partialChanges));
        for (int i = 0; i < partialChanges.size(); ++i) {
            CommitChange change;
            change = (CommitChange)partialChanges.get(i);
            FilePath path = Objects.requireNonNull(change.afterPath);
            PartialCommitHelper helper = (PartialCommitHelper)helpers.get(i);
            VirtualFile file2 = change.virtualFile;
            if (file2 == null) {
                throw new VcsException(DiffBundle.message((String)"cannot.find.file.error", (Object[])new Object[]{path.getPresentableUrl()}));
            }
            GitIndexUtil.StagedFile stagedFile = GitCheckinEnvironment.getStagedFile(repository, change);
            boolean isExecutable = stagedFile != null && stagedFile.isExecutable();
            byte[] fileContent = GitCheckinEnvironment.convertDocumentContentToBytesWithBOM(repository, helper.getContent(), file2);
            GitIndexUtil.write(repository, path, fileContent, isExecutable);
        }
        Pair pair = Pair.create((Object)helpers, (Object)partialChanges);
        if (pair == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(37);
        }
        return pair;
    }

    private static void applyPartialChanges(@NotNull List<PartialCommitHelper> partialCommitHelpers) {
        if (partialCommitHelpers == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(38);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (PartialCommitHelper helper : partialCommitHelpers) {
                try {
                    helper.applyChanges();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        });
    }

    private static byte @NotNull [] convertDocumentContentToBytes(@NotNull GitRepository repository, @NotNull @NonNls String documentContent, @NotNull VirtualFile file2) {
        String lineSeparator;
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(39);
        }
        if (documentContent == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(40);
        }
        if (file2 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(41);
        }
        String text2 = (lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file2, repository.getProject())).equals("\n") ? documentContent : StringUtil.convertLineSeparators((String)documentContent, (String)lineSeparator);
        byte[] byArray = (byte[])LoadTextUtil.charsetForWriting((Project)repository.getProject(), (VirtualFile)file2, (String)text2, (Charset)file2.getCharset()).second;
        if (byArray == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(42);
        }
        return byArray;
    }

    public static byte @NotNull [] convertDocumentContentToBytesWithBOM(@NotNull GitRepository repository, @NotNull @NonNls String documentContent, @NotNull VirtualFile file2) {
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(43);
        }
        if (documentContent == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(44);
        }
        if (file2 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(45);
        }
        byte[] fileContent = GitCheckinEnvironment.convertDocumentContentToBytes(repository, documentContent, file2);
        byte[] bom = file2.getBOM();
        if (bom != null && !ArrayUtil.startsWith((byte[])fileContent, (byte[])bom)) {
            fileContent = ArrayUtil.mergeArrays((byte[])bom, (byte[])fileContent);
        }
        if (fileContent == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(46);
        }
        return fileContent;
    }

    @Nullable
    private static GitIndexUtil.StagedFile getStagedFile(@NotNull GitRepository repository, @NotNull CommitChange change) throws VcsException {
        GitIndexUtil.StagedFile file2;
        GitIndexUtil.StagedFile file3;
        FilePath bPath;
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(47);
        }
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(48);
        }
        if ((bPath = change.beforePath) != null && (file3 = GitIndexUtil.listStaged(repository, bPath)) != null) {
            return file3;
        }
        FilePath aPath = change.afterPath;
        if (aPath != null && (file2 = GitIndexUtil.listStaged(repository, aPath)) != null) {
            return file2;
        }
        return null;
    }

    @Nullable
    private static <T> T computeAfterLSTManagerUpdate(@NotNull Project project, @NotNull Computable<T> computation) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(49);
        }
        if (computation == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(50);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        CompletableFuture ref = new CompletableFuture();
        LineStatusTrackerManager.getInstance((Project)project).invokeAfterUpdate(() -> {
            try {
                ref.complete(computation.compute());
            }
            catch (Throwable e) {
                ref.completeExceptionally(e);
            }
        });
        try {
            return (T)ProgressIndicatorUtils.awaitWithCheckCanceled(ref);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.warn(e);
            return null;
        }
    }

    @NotNull
    private List<CommitChange> addCaseOnlyRenamesToIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes, @NotNull Set<CommitChange> alreadyProcessed, @NotNull List<? super VcsException> exceptions) {
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(51);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(52);
        }
        if (alreadyProcessed == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(53);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(54);
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            List<CommitChange> list2 = Collections.emptyList();
            if (list2 == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(55);
            }
            return list2;
        }
        List caseOnlyRenames = ContainerUtil.filter(changes, change -> !alreadyProcessed.contains(change) && GitCheckinEnvironment.isCaseOnlyRename(change));
        if (caseOnlyRenames.isEmpty()) {
            List<CommitChange> list3 = Collections.emptyList();
            if (list3 == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(56);
            }
            return list3;
        }
        LOG.info("Committing case only rename: " + GitCheckinEnvironment.getLogString(repository.getRoot().getPath(), caseOnlyRenames) + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
        List pathsToAdd = ContainerUtil.map((Collection)caseOnlyRenames, it -> it.afterPath);
        List pathsToDelete = ContainerUtil.map((Collection)caseOnlyRenames, it -> it.beforePath);
        LOG.debug(String.format("Updating index for case only changes: added: %s,\n removed: %s", pathsToAdd, pathsToDelete));
        GitCheckinEnvironment.updateIndex(this.myProject, repository.getRoot(), pathsToAdd, pathsToDelete, exceptions);
        List list4 = caseOnlyRenames;
        if (list4 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(57);
        }
        return list4;
    }

    private static boolean isCaseOnlyRename(@NotNull ChangedPath change) {
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(58);
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            return false;
        }
        if (!change.isMove()) {
            return false;
        }
        FilePath afterPath = Objects.requireNonNull(change.afterPath);
        FilePath beforePath = Objects.requireNonNull(change.beforePath);
        return GitUtil.isCaseOnlyChange(beforePath.getPath(), afterPath.getPath());
    }

    @NotNull
    private static List<FilePath> getPaths(@NotNull Collection<? extends ChangedPath> changes) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(59);
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (ChangedPath changedPath : changes) {
            if (ChangesUtil.equalsCaseSensitive((FilePath)changedPath.beforePath, (FilePath)changedPath.afterPath)) {
                ContainerUtil.addIfNotNull(files, (Object)changedPath.beforePath);
                continue;
            }
            ContainerUtil.addIfNotNull(files, (Object)changedPath.beforePath);
            ContainerUtil.addIfNotNull(files, (Object)changedPath.afterPath);
        }
        ArrayList<FilePath> arrayList = files;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    private static void processExcludedPaths(@NotNull Collection<? extends GitChangeUtils.GitDiffChange> changes, @NotNull Set<FilePath> added, @NotNull Set<FilePath> removed, @NotNull PairConsumer<? super FilePath, ? super FilePath> function) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(61);
        }
        if (added == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(62);
        }
        if (removed == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(63);
        }
        if (function == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(64);
        }
        for (GitChangeUtils.GitDiffChange gitDiffChange : changes) {
            FilePath before = gitDiffChange.getBeforePath();
            FilePath after = gitDiffChange.getAfterPath();
            if (removed.contains(before)) {
                before = null;
            }
            if (added.contains(after)) {
                after = null;
            }
            function.consume((Object)before, (Object)after);
        }
    }

    @NonNls
    @NotNull
    private static String getLogString(@NotNull String root, @NotNull Collection<? extends ChangedPath> changes) {
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(65);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(66);
        }
        String string = GitUtil.getLogString(root, changes, it -> it.beforePath, it -> it.afterPath);
        if (string == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(67);
        }
        return string;
    }

    @NotNull
    private Pair<Collection<CommitChange>, List<VcsException>> commitExplicitRenames(@NotNull GitRepository repository, @NotNull Collection<CommitChange> changes, @NotNull @NonNls String message) {
        Pair pair;
        Pair<List<CommitChange>, List<CommitChange>> committedAndNewChanges;
        Object newMessage;
        VirtualFile root;
        ArrayList<VcsException> exceptions;
        List providers;
        block12: {
            if (repository == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(68);
            }
            if (changes == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(69);
            }
            if (message == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(70);
            }
            providers = ContainerUtil.filter((Collection)GitCheckinExplicitMovementProvider.EP_NAME.getExtensionList(), it -> it.isEnabled(this.myProject));
            exceptions = new ArrayList<VcsException>();
            root = repository.getRoot();
            newMessage = message;
            String issueLinks = this.getIssueLinks((String)newMessage);
            List beforePaths = ContainerUtil.mapNotNull(changes, it -> it.beforePath);
            List afterPaths = ContainerUtil.mapNotNull(changes, it -> it.afterPath);
            HashSet<GitCheckinExplicitMovementProvider.Movement> movedPaths = new HashSet<GitCheckinExplicitMovementProvider.Movement>();
            for (GitCheckinExplicitMovementProvider provider : providers) {
                Collection<GitCheckinExplicitMovementProvider.Movement> providerMovements = provider.collectExplicitMovements(this.myProject, beforePaths, afterPaths);
                if (providerMovements.isEmpty()) continue;
                newMessage = provider.getCommitMessage((String)newMessage);
                movedPaths.addAll(providerMovements);
            }
            if (!issueLinks.isBlank()) {
                newMessage = (String)newMessage + "\n\n" + issueLinks;
            }
            committedAndNewChanges = this.addExplicitMovementsToIndex(repository, changes, movedPaths);
            if (committedAndNewChanges != null) break block12;
            Pair pair2 = Pair.create(changes, exceptions);
            if (pair2 == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(71);
            }
            return pair2;
        }
        try {
            List movedChanges = (List)committedAndNewChanges.first;
            Collection newRootChanges = (Collection)committedAndNewChanges.second;
            GitCheckinEnvironment.runWithMessageFile(this.myProject, root, (String)newMessage, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)moveMessageFile -> exceptions.addAll(GitCheckinEnvironment.commitUsingIndex(this.myProject, repository, movedChanges, new HashSet(movedChanges), moveMessageFile, this.createCommitOptions()))));
            List committedMovements = ContainerUtil.mapNotNull((Collection)movedChanges, it -> Couple.of((Object)it.beforePath, (Object)it.afterPath));
            for (GitCheckinExplicitMovementProvider provider : providers) {
                provider.afterMovementsCommitted(this.myProject, committedMovements);
            }
            pair = Pair.create((Object)newRootChanges, exceptions);
        }
        catch (VcsException e) {
            exceptions.add(e);
            Pair pair3 = Pair.create(changes, exceptions);
            if (pair3 == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(73);
            }
            return pair3;
        }
        if (pair == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(72);
        }
        return pair;
    }

    private String getIssueLinks(String message) {
        List matches = IssueNavigationConfiguration.getInstance((Project)this.myProject).findIssueLinks((CharSequence)message);
        StringBuilder builder = new StringBuilder();
        for (IssueNavigationConfiguration.LinkMatch match2 : matches) {
            String issueId = match2.getRange().substring(message);
            builder.append(issueId).append("\n");
        }
        return builder.toString();
    }

    @Nullable
    private Pair<List<CommitChange>, List<CommitChange>> addExplicitMovementsToIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes, @NotNull Collection<? extends GitCheckinExplicitMovementProvider.Movement> explicitMoves) throws VcsException {
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(74);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(75);
        }
        if (explicitMoves == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(76);
        }
        if ((explicitMoves = GitCheckinEnvironment.filterExcludedChanges(explicitMoves, changes)).isEmpty()) {
            return null;
        }
        LOG.info("Committing explicit rename: " + explicitMoves + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
        HashMap<FilePath, GitCheckinExplicitMovementProvider.Movement> movesMap = new HashMap<FilePath, GitCheckinExplicitMovementProvider.Movement>();
        for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
            movesMap.put(movement.getBefore(), movement);
            movesMap.put(movement.getAfter(), movement);
        }
        ArrayList<CommitChange> nextCommitChanges = new ArrayList<CommitChange>();
        ArrayList<CommitChange> arrayList = new ArrayList<CommitChange>();
        HashMap<FilePath, CommitChange> affectedBeforePaths = new HashMap<FilePath, CommitChange>();
        HashMap<FilePath, CommitChange> affectedAfterPaths = new HashMap<FilePath, CommitChange>();
        for (CommitChange commitChange : changes) {
            if (!movesMap.containsKey(commitChange.beforePath) && !movesMap.containsKey(commitChange.afterPath)) {
                nextCommitChanges.add(commitChange);
                continue;
            }
            if (commitChange.beforePath != null) {
                affectedBeforePaths.put(commitChange.beforePath, commitChange);
            }
            if (commitChange.afterPath == null) continue;
            affectedAfterPaths.put(commitChange.afterPath, commitChange);
        }
        List pathsToDelete = ContainerUtil.map(explicitMoves, move -> move.getBefore());
        LOG.debug(String.format("Updating index for explicit movements: removing: %s", pathsToDelete));
        GitFileUtils.deletePaths(this.myProject, repository.getRoot(), pathsToDelete, "--ignore-unmatch");
        for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
            FilePath beforeFilePath = movement.getBefore();
            FilePath afterFilePath = movement.getAfter();
            CommitChange bChange = Objects.requireNonNull((CommitChange)affectedBeforePaths.get(beforeFilePath));
            CommitChange aChange = Objects.requireNonNull((CommitChange)affectedAfterPaths.get(afterFilePath));
            if (bChange.beforeRevision == null) {
                LOG.warn(String.format("Unknown before revision: %s, %s", bChange, aChange));
                continue;
            }
            GitIndexUtil.StagedFile stagedFile = GitIndexUtil.listTree(repository, beforeFilePath, bChange.beforeRevision);
            if (stagedFile == null) {
                LOG.warn(String.format("Can't get revision for explicit move: %s -> %s", beforeFilePath, afterFilePath));
                continue;
            }
            LOG.debug(String.format("Updating index for explicit movements: adding movement: %s -> %s", beforeFilePath, afterFilePath));
            Hash hash = HashImpl.build((String)stagedFile.getBlobHash());
            boolean isExecutable = stagedFile.isExecutable();
            GitIndexUtil.updateIndex(repository, afterFilePath, hash, isExecutable);
            nextCommitChanges.add(new CommitChange(afterFilePath, afterFilePath, null, null, aChange.changelistIds, aChange.virtualFile));
            arrayList.add(new CommitChange(beforeFilePath, afterFilePath, null, null, null, null));
            affectedBeforePaths.remove(beforeFilePath);
            affectedAfterPaths.remove(afterFilePath);
        }
        affectedBeforePaths.forEach((bPath, change) -> nextCommitChanges.add(new CommitChange(change.beforePath, null, change.beforeRevision, null, change.changelistIds, change.virtualFile)));
        affectedAfterPaths.forEach((aPath, change) -> nextCommitChanges.add(new CommitChange(null, change.afterPath, null, change.afterRevision, change.changelistIds, change.virtualFile)));
        if (arrayList.isEmpty()) {
            return null;
        }
        return Pair.create(arrayList, nextCommitChanges);
    }

    @NotNull
    private static List<GitCheckinExplicitMovementProvider.Movement> filterExcludedChanges(@NotNull Collection<? extends GitCheckinExplicitMovementProvider.Movement> explicitMoves, @NotNull Collection<? extends CommitChange> changes) {
        if (explicitMoves == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(77);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(78);
        }
        HashMultiset movedPathsMultiSet = HashMultiset.create();
        for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
            movedPathsMultiSet.add((Object)movement.getBefore());
            movedPathsMultiSet.add((Object)movement.getAfter());
        }
        HashMultiset beforePathsMultiSet = HashMultiset.create();
        HashMultiset hashMultiset = HashMultiset.create();
        for (CommitChange commitChange : changes) {
            ContainerUtil.addIfNotNull((Collection)beforePathsMultiSet, (Object)commitChange.beforePath);
            ContainerUtil.addIfNotNull((Collection)hashMultiset, (Object)commitChange.afterPath);
        }
        List list2 = ContainerUtil.filter(explicitMoves, move -> movedPathsMultiSet.count((Object)move.getBefore()) == 1 && movedPathsMultiSet.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getBefore()) == 1 && afterPathsMultiSet.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getAfter()) == 0 && afterPathsMultiSet.count((Object)move.getBefore()) == 0);
        if (list2 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(79);
        }
        return list2;
    }

    @NotNull
    private static List<CommitChange> collectChangesToCommit(@NotNull Collection<Change> changes) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(80);
        }
        ArrayList<CommitChange> result2 = new ArrayList<CommitChange>();
        MultiMap map2 = new MultiMap();
        for (Change change2 : changes) {
            CommitChange commitChange = GitCheckinEnvironment.createCommitChange(change2);
            if (commitChange.virtualFile != null) {
                map2.putValue((Object)commitChange.virtualFile, (Object)commitChange);
                continue;
            }
            result2.add(commitChange);
        }
        for (Map.Entry entry : map2.entrySet()) {
            VirtualFile virtualFile = (VirtualFile)entry.getKey();
            Collection fileCommitChanges = (Collection)entry.getValue();
            if (fileCommitChanges.size() < 2) {
                result2.addAll(fileCommitChanges);
                continue;
            }
            boolean hasSpecificChangelists = ContainerUtil.exists((Iterable)fileCommitChanges, change -> change.changelistIds != null);
            if (!hasSpecificChangelists) {
                result2.addAll(fileCommitChanges);
                continue;
            }
            boolean hasNonChangelists = ContainerUtil.exists((Iterable)fileCommitChanges, change -> change.changelistIds == null);
            boolean hasDeletions = ContainerUtil.exists((Iterable)fileCommitChanges, change -> change.afterPath == null);
            boolean hasAdditions = ContainerUtil.exists((Iterable)fileCommitChanges, change -> change.beforePath == null);
            if (hasNonChangelists || hasDeletions) {
                LOG.warn(String.format("Ignoring changelists on commit of %s: %s", virtualFile, fileCommitChanges));
                result2.addAll(ContainerUtil.map((Collection)fileCommitChanges, change -> new CommitChange(change.beforePath, change.afterPath, change.beforeRevision, change.afterRevision, null, change.virtualFile)));
                continue;
            }
            CommitChange firstChange = (CommitChange)ContainerUtil.getFirstItem((Collection)fileCommitChanges);
            FilePath beforePath = hasAdditions ? null : firstChange.beforePath;
            FilePath afterPath = firstChange.afterPath;
            VcsRevisionNumber beforeRevision = firstChange.beforeRevision;
            VcsRevisionNumber afterRevision = firstChange.afterRevision;
            HashSet combinedChangeListIds = new HashSet();
            boolean hasMismatch = false;
            for (CommitChange change3 : fileCommitChanges) {
                combinedChangeListIds.addAll(ContainerUtil.notNullize(change3.changelistIds));
                if (Objects.equals(beforePath, change3.beforePath) && Objects.equals(afterPath, change3.afterPath)) continue;
                hasMismatch = true;
            }
            if (hasMismatch) {
                LOG.error(String.format("Change mismatch on commit of %s: %s", virtualFile, fileCommitChanges));
            }
            result2.add(new CommitChange(beforePath, afterPath, beforeRevision, afterRevision, new ArrayList<String>(combinedChangeListIds), virtualFile));
        }
        ArrayList<CommitChange> arrayList = result2;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(81);
        }
        return arrayList;
    }

    @NotNull
    private static CommitChange createCommitChange(@NotNull Change change) {
        VirtualFile virtualFile;
        List<String> changelistIds;
        VcsRevisionNumber afterRevision;
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(82);
        }
        FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
        FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        VcsRevisionNumber beforeRevision = bRev != null ? bRev.getRevisionNumber() : null;
        VcsRevisionNumber vcsRevisionNumber = afterRevision = aRev != null ? aRev.getRevisionNumber() : null;
        if (change instanceof ChangeListChange) {
            ChangeListChange changeListChange = (ChangeListChange)change;
            v1 = Collections.singletonList(changeListChange.getChangeListId());
        } else {
            v1 = changelistIds = null;
        }
        if (aRev instanceof CurrentContentRevision) {
            CurrentContentRevision currentRevision = (CurrentContentRevision)aRev;
            virtualFile = currentRevision.getVirtualFile();
        } else {
            virtualFile = null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return new CommitChange(beforePath, afterPath, beforeRevision, afterRevision, changelistIds, virtualFile2);
    }

    private static void resetExcluded(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends ChangedPath> changes) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(83);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(84);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(85);
        }
        Set allPaths = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
        for (ChangedPath changedPath : changes) {
            ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.afterPath);
            ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.beforePath);
        }
        for (List list2 : VcsFileUtil.chunkPaths((VirtualFile)root, (Collection)allPaths)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
            handler.endOptions();
            handler.addParameters(list2);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    private static void restoreExcluded(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends ChangedPath> changes, @NotNull Set<FilePath> unstagedDeletions) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(86);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(87);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(88);
        }
        if (unstagedDeletions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(89);
        }
        ArrayList restoreExceptions = new ArrayList();
        HashSet toAdd = new HashSet();
        HashSet toRemove = new HashSet();
        for (ChangedPath changedPath : changes) {
            if (GitCheckinEnvironment.addAsCaseOnlyRename(project, root, changedPath, restoreExceptions)) continue;
            if (changedPath.beforePath == null && unstagedDeletions.contains(changedPath.afterPath)) {
                LOG.info("Ignored added-deleted staged change in " + changedPath.afterPath);
                continue;
            }
            ContainerUtil.addIfNotNull(toAdd, (Object)changedPath.afterPath);
            ContainerUtil.addIfNotNull(toRemove, (Object)changedPath.beforePath);
        }
        toRemove.removeAll(toAdd);
        LOG.debug(String.format("Restoring staged changes after commit: added: %s, removed: %s", toAdd, toRemove));
        GitCheckinEnvironment.updateIndex(project, root, toAdd, toRemove, restoreExceptions);
        for (VcsException vcsException : restoreExceptions) {
            LOG.warn((Throwable)vcsException);
        }
    }

    private static boolean addAsCaseOnlyRename(@NotNull Project project, @NotNull VirtualFile root, @NotNull ChangedPath change, @NotNull List<? super VcsException> exceptions) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(90);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(91);
        }
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(92);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(93);
        }
        try {
            if (!GitCheckinEnvironment.isCaseOnlyRename(change)) {
                return false;
            }
            FilePath beforePath = Objects.requireNonNull(change.beforePath);
            FilePath afterPath = Objects.requireNonNull(change.afterPath);
            LOG.debug(String.format("Restoring staged case-only rename after commit: %s", change));
            GitLineHandler h = new GitLineHandler(project, root, GitCommand.MV);
            h.addParameters("-f", beforePath.getPath(), afterPath.getPath());
            Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
            return true;
        }
        catch (VcsException e) {
            exceptions.add(e);
            return false;
        }
    }

    private static void updateIndex(Project project, VirtualFile root, Collection<? extends FilePath> added, Collection<? extends FilePath> removed, List<? super VcsException> exceptions) {
        if (!removed.isEmpty()) {
            try {
                GitFileUtils.deletePaths(project, root, removed, "--ignore-unmatch", "--cached", "-r");
            }
            catch (VcsException ex) {
                exceptions.add(ex);
            }
        }
        if (!added.isEmpty()) {
            try {
                GitFileUtils.addPathsForce(project, root, added);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
            }
        }
    }

    @NotNull
    public static File createCommitMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String message) throws IOException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(94);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(95);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(96);
        }
        File file2 = FileUtil.createTempFile((String)GIT_COMMIT_MSG_FILE_PREFIX, (String)GIT_COMMIT_MSG_FILE_EXT);
        file2.deleteOnExit();
        @NonNls String encoding = GitConfigUtil.getCommitEncoding(project, root);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), encoding);){
            out.write(message);
        }
        File file3 = file2;
        if (file3 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(97);
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String message, @NotNull ThrowableConsumer<? super File, ? extends VcsException> task) throws VcsException {
        File messageFile;
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(98);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(99);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(100);
        }
        if (task == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(101);
        }
        try {
            messageFile = GitCheckinEnvironment.createCommitMessageFile(project, root, message);
        }
        catch (IOException ex) {
            throw new VcsException(GitBundle.message("error.commit.cant.create.message.file", new Object[0]), (Throwable)ex);
        }
        try {
            task.consume((Object)messageFile);
        }
        finally {
            if (!messageFile.delete()) {
                LOG.warn("Failed to remove temporary file: " + messageFile);
            }
        }
    }

    public List<VcsException> scheduleMissingFileForDeletion(@NotNull List<? extends FilePath> files) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        if (files == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(102);
        }
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(this.myProject, files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<FilePath>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.deletePaths(this.myProject, root, (Collection<? extends FilePath>)e.getValue(), new String[0]);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(@NotNull List<? extends VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        if (files == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(103);
        }
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(this.myProject, files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.addFiles(this.myProject, root, (Collection<? extends VirtualFile>)e.getValue());
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    @NotNull
    public PostCommitChangeConverter getPostCommitChangeConverter() {
        return new GitPostCommitChangeConverter(this.myProject);
    }

    @NotNull
    private static Map<GitRepository, Collection<Change>> sortChangesByGitRoot(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull List<? super VcsException> exceptions) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(104);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(105);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(106);
        }
        HashMap<GitRepository, Collection<Change>> result2 = new HashMap<GitRepository, Collection<Change>>();
        for (Change change : changes) {
            try {
                FilePath filePath = ChangesUtil.getFilePath((Change)change);
                GitRepository repository = GitUtil.getRepositoryForFile(project, Objects.requireNonNull(filePath.getParentPath()));
                Collection changeList = result2.computeIfAbsent(repository, key -> new ArrayList());
                changeList.add(change);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        HashMap<GitRepository, Collection<Change>> hashMap = result2;
        if (hashMap == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(107);
        }
        return hashMap;
    }

    private void markRootDirty(VirtualFile root) {
        VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(root);
    }

    @NotNull
    static List<GitCheckinExplicitMovementProvider> collectActiveMovementProviders(@NotNull Project project) {
        List allProviders;
        List enabledProviders;
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(108);
        }
        if ((enabledProviders = ContainerUtil.filter((Collection)(allProviders = GitCheckinExplicitMovementProvider.EP_NAME.getExtensionList()), it -> it.isEnabled(project))).isEmpty()) {
            List<GitCheckinExplicitMovementProvider> list2 = Collections.emptyList();
            if (list2 == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(109);
            }
            return list2;
        }
        List<CommitChange> changes = GitCheckinEnvironment.collectChangesToCommit(ChangeListManager.getInstance((Project)project).getAllChanges());
        List beforePaths = ContainerUtil.mapNotNull(changes, it -> it.beforePath);
        List afterPaths = ContainerUtil.mapNotNull(changes, it -> it.afterPath);
        List list3 = ContainerUtil.filter((Collection)enabledProviders, it -> {
            Collection<GitCheckinExplicitMovementProvider.Movement> movements = it.collectExplicitMovements(project, beforePaths, afterPaths);
            List<GitCheckinExplicitMovementProvider.Movement> filteredMovements = GitCheckinEnvironment.filterExcludedChanges(movements, changes);
            return !filteredMovements.isEmpty();
        });
        if (list3 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(110);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 15, 18, 23, 24, 25, 32, 33, 36, 37, 42, 46, 55, 56, 57, 60, 67, 71, 72, 73, 79, 81, 97, 107, 109, 110 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitPanel";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToCheckin";
                break;
            }
            case 4: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 6: 
            case 7: 
            case 65: 
            case 84: 
            case 87: 
            case 91: 
            case 95: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 42: 
            case 46: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 79: 
            case 81: 
            case 97: 
            case 107: 
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/checkin/GitCheckinEnvironment";
                break;
            }
            case 11: 
            case 20: 
            case 35: 
            case 52: 
            case 59: 
            case 61: 
            case 66: 
            case 69: 
            case 75: 
            case 78: 
            case 80: 
            case 85: 
            case 88: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feedback";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesRepositories";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noChangesRoots";
                break;
            }
            case 19: 
            case 27: 
            case 34: 
            case 39: 
            case 43: 
            case 47: 
            case 51: 
            case 68: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 21: 
            case 70: 
            case 96: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootChanges";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedWithIndex";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitOptions";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialCommitHelpers";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentContent";
                break;
            }
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 48: 
            case 58: 
            case 82: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyProcessed";
                break;
            }
            case 54: 
            case 93: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitMoves";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unstagedDeletions";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAmendCommitDetails";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAmendService";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "commit";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRepositories";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "commitRepository";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "commitUsingIndex";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "addPartialChangesToIndex";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDocumentContentToBytes";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDocumentContentToBytesWithBOM";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "addCaseOnlyRenamesToIndex";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogString";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "commitExplicitRenames";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExcludedChanges";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChangesToCommit";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessageFile";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "sortChangesByGitRoot";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "collectActiveMovementProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCommitOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMessageFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommitMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAmendCommitDetails";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 42: 
            case 46: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 79: 
            case 81: 
            case 97: 
            case 107: 
            case 109: 
            case 110: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateState";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectRepositories";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "commitRepository";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "commitUsingIndex";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addPartialChangesToIndex";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "applyPartialChanges";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "convertDocumentContentToBytes";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "convertDocumentContentToBytesWithBOM";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getStagedFile";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "computeAfterLSTManagerUpdate";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addCaseOnlyRenamesToIndex";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isCaseOnlyRename";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "processExcludedPaths";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getLogString";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "commitExplicitRenames";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitMovementsToIndex";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "filterExcludedChanges";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "collectChangesToCommit";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createCommitChange";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "resetExcluded";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "restoreExcluded";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "addAsCaseOnlyRename";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessageFile";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "runWithMessageFile";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "scheduleMissingFileForDeletion";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUnversionedFilesForAddition";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "sortChangesByGitRoot";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "collectActiveMovementProviders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 15, 18, 23, 24, 25, 32, 33, 36, 37, 42, 46, 55, 56, 57, 60, 67, 71, 72, 73, 79, 81, 97, 107, 109, 110 -> new IllegalStateException(string);
        };
    }

    public class GitCheckinOptions
    implements CheckinChangeListSpecificComponent,
    RefreshableOnComponent,
    Disposable {
        @NotNull
        private final GitCommitOptionsUi myOptionsUi;

        GitCheckinOptions(@NotNull CheckinProjectPanel commitPanel, CommitContext commitContext, boolean showAmendOption) {
            if (commitPanel == null) {
                GitCheckinOptions.$$$reportNull$$$0(0);
            }
            if (commitContext == null) {
                GitCheckinOptions.$$$reportNull$$$0(1);
            }
            this.myOptionsUi = new GitCommitOptionsUi(commitPanel, commitContext, showAmendOption);
            Disposer.register((Disposable)this, (Disposable)this.myOptionsUi);
        }

        @Nullable
        public String getAuthor() {
            VcsUser author = this.myOptionsUi.getAuthor();
            return author != null ? author.toString() : null;
        }

        public boolean isAmend() {
            return this.myOptionsUi.getAmendHandler().isAmendCommitMode();
        }

        public JComponent getComponent() {
            return this.myOptionsUi.getComponent();
        }

        public void restoreState() {
            this.myOptionsUi.restoreState();
        }

        public void saveState() {
            this.myOptionsUi.saveState();
        }

        public void onChangeListSelected(@NotNull LocalChangeList list2) {
            if (list2 == null) {
                GitCheckinOptions.$$$reportNull$$$0(2);
            }
            this.myOptionsUi.onChangeListSelected(list2);
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onChangeListSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CommitChange
    extends ChangedPath {
        @Nullable
        public final VcsRevisionNumber beforeRevision;
        @Nullable
        public final VcsRevisionNumber afterRevision;
        @Nullable
        public final List<String> changelistIds;
        @Nullable
        public final VirtualFile virtualFile;

        CommitChange(@Nullable FilePath beforePath, @Nullable FilePath afterPath, @Nullable VcsRevisionNumber beforeRevision, @Nullable VcsRevisionNumber afterRevision, @Nullable List<String> changelistIds, @Nullable VirtualFile virtualFile) {
            super(beforePath, afterPath);
            this.beforeRevision = beforeRevision;
            this.afterRevision = afterRevision;
            this.changelistIds = changelistIds;
            this.virtualFile = virtualFile;
        }

        @Override
        @NonNls
        public String toString() {
            return super.toString() + ", changelists: " + this.changelistIds;
        }
    }

    public static class ChangedPath {
        @Nullable
        public final FilePath beforePath;
        @Nullable
        public final FilePath afterPath;

        public ChangedPath(@Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            assert (beforePath != null || afterPath != null);
            this.beforePath = beforePath;
            this.afterPath = afterPath;
        }

        public boolean isMove() {
            if (this.beforePath == null || this.afterPath == null) {
                return false;
            }
            return !ChangesUtil.equalsCaseSensitive((FilePath)this.beforePath, (FilePath)this.afterPath);
        }

        @NonNls
        public String toString() {
            return String.format("%s -> %s", this.beforePath, this.afterPath);
        }
    }
}

