/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.icons.ExpUiIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class GitResolveConflictsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(0);
        }
        Project project = Objects.requireNonNull(event.getProject());
        GitVcs vcs = GitVcs.getInstance(project);
        TreeSet<VirtualFile> conflictedFiles2 = new TreeSet<VirtualFile>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (Change change : ChangeListManager.getInstance((Project)project).getAllChanges()) {
            VirtualFile file2;
            if (change.getFileStatus() != FileStatus.MERGED_WITH_CONFLICTS) continue;
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            if (before != null && (file2 = before.getFile().getVirtualFile()) != null) {
                conflictedFiles2.add(file2);
            }
            if (after == null || (file2 = after.getFile().getVirtualFile()) == null) continue;
            conflictedFiles2.add(file2);
        }
        AbstractVcsHelper.getInstance((Project)project).showMergeDialog(new ArrayList<VirtualFile>(conflictedFiles2), vcs.getMergeProvider());
    }

    private static boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(1);
        }
        Collection changes = ChangeListManager.getInstance((Project)project).getAllChanges();
        return ContainerUtil.exists((Iterable)changes, it -> it.getFileStatus() == FileStatus.MERGED_WITH_CONFLICTS);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDisposed()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        presentation2.setEnabledAndVisible(GitResolveConflictsAction.isEnabled(project));
        if (presentation2.isVisible() && e.getPlace().equals("GitMergeRebaseWidgetPlace")) {
            presentation2.setIcon(ExpUiIcons.Vcs.ResolveContinue);
            Collection<GitRepository> rebasingRepositories = GitUtil.getRepositoriesInState(project, Repository.State.REBASING);
            if (!rebasingRepositories.isEmpty()) {
                presentation2.setEnabledAndVisible(false);
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitResolveConflictsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitResolveConflictsAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

