/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.history.ActivityId;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import git4idea.GitApplyChangesProcess;
import git4idea.GitApplyChangesProcessKt;
import git4idea.GitUtil;
import git4idea.actions.GitAbortOperationAction;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageContentProviderKt;
import git4idea.index.GitStageManagerKt;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\b\u0000\u0018\u0000 V2\u00020\u0001:\u0006TUVWXYB\u00f5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\n\u00129\u0010\f\u001a5\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0005\u0012\u0004\u0012\u00020\u00140\r\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0\u0018\u0012\u001d\u0010\u0019\u001a\u0019\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0006\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u001b0\u001a\u0012\u0006\u0010\u001c\u001a\u00020\b\u0012)\b\u0002\u0010\u001d\u001a#\u0012\u0004\u0012\u00020\u000e\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u001e0\u001a\u0012\u000b\u0010\u001f\u001a\u00070\n\u00a2\u0006\u0002\b \u0012\u0006\u0010!\u001a\u00020\"\u00a2\u0006\u0002\u0010#JD\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u0006052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000605H\u0002J\u0010\u00107\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0006H\u0003J\u0010\u00108\u001a\u0002092\u0006\u00100\u001a\u00020\u0006H\u0002J\u0006\u0010:\u001a\u00020\u001eJ4\u0010;\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00062\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u0006052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000605H\u0002J\u001e\u0010<\u001a\u00020\n2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010>\u001a\u00020\bH\u0003J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010$\u001a\u00020@H\u0002J\u0016\u0010A\u001a\u00020\n2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0003J\u0016\u0010B\u001a\u00020\n2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0003J\u0016\u0010C\u001a\u00020\u001e2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002J\u001e\u0010G\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u00062\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J&\u0010H\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00062\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J(\u0010I\u001a\u00020\u001e2\b\b\u0001\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020\u00062\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J$\u0010L\u001a\u00020\u001e2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010M\u001a\u00020\u001e2\u0006\u0010N\u001a\u00020OH\u0002J.\u0010P\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\n2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002J\"\u0010Q\u001a\u00020\n2\u0018\u0010R\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050SH\u0002R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001f\u001a\u00070\n\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010$\u001a\u00070%\u00a2\u0006\u0002\b&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u001d\u001a#\u0012\u0004\u0012\u00020\u000e\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u001e0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\f\u001a5\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0005\u0012\u0004\u0012\u00020\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0019\u001a\u0019\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0006\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010'\u001a\u00070(\u00a2\u0006\u0002\b&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010)\u001a\u00070*\u00a2\u0006\u0002\b&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\n -*\u0004\u0018\u00010,0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lgit4idea/GitApplyChangesProcess;", "", "project", "Lcom/intellij/openapi/project/Project;", "commits", "", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "forceAutoCommit", "", "operationName", "", "appliedWord", "command", "Lkotlin/Function4;", "Lgit4idea/repo/GitRepository;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "Lkotlin/ParameterName;", "name", "autoCommit", "Lgit4idea/commands/GitLineHandlerListener;", "Lgit4idea/commands/GitCommandResult;", "abortCommand", "Lgit4idea/actions/GitAbortOperationAction;", "emptyCommitDetector", "Lkotlin/Function1;", "defaultCommitMessageGenerator", "Lkotlin/Function2;", "Lorg/jetbrains/annotations/NonNls;", "preserveCommitMetadata", "cleanupBeforeCommit", "", "activityName", "Lcom/intellij/openapi/util/NlsContexts$Label;", "activityId", "Lcom/intellij/history/ActivityId;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;ZLjava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function4;Lgit4idea/actions/GitAbortOperationAction;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;ZLkotlin/jvm/functions/Function2;Ljava/lang/String;Lcom/intellij/history/ActivityId;)V", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerEx;", "Lorg/jetbrains/annotations/NotNull;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "vcsHelper", "Lcom/intellij/openapi/vcs/AbstractVcsHelper;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "commitChangelist", "repository", "commit", "commitMessage", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "successfulCommits", "", "alreadyPicked", "commitDetails", "createChangeListData", "Lcom/intellij/openapi/vcs/changes/ChangeListData;", "execute", "executeForCommit", "formSkippedDescription", "skipped", "but", "getAllChangesInLogFriendlyPresentation", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "getCommitsDetails", "getSuccessfulCommitDetailsIfAny", "markDirty", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "notifyCommitCancelled", "notifyConflictWarning", "notifyError", "content", "failedCommit", "notifyResult", "refreshStagedVfs", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "showCommitDialogAndWaitForCommit", "toString", "commitsInRoots", "", "ChangeListCommit", "CommitStrategy", "Companion", "ConflictResolver", "SimplifiedCommit", "StagingAreaCommit", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitApplyChangesProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitApplyChangesProcess.kt\ngit4idea/GitApplyChangesProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,523:1\n1549#2:524\n1620#2,3:525\n11#3:528\n*S KotlinDebug\n*F\n+ 1 GitApplyChangesProcess.kt\ngit4idea/GitApplyChangesProcess\n*L\n305#1:524\n305#1:525,3\n489#1:528\n*E\n"})
public final class GitApplyChangesProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<VcsFullCommitDetails> commits;
    @NotNull
    private final String operationName;
    @NotNull
    private final String appliedWord;
    @NotNull
    private final Function4<GitRepository, VcsCommitMetadata, Boolean, List<? extends GitLineHandlerListener>, GitCommandResult> command;
    @NotNull
    private final GitAbortOperationAction abortCommand;
    @NotNull
    private final Function1<GitCommandResult, Boolean> emptyCommitDetector;
    @NotNull
    private final Function2<GitRepository, VcsFullCommitDetails, String> defaultCommitMessageGenerator;
    private final boolean preserveCommitMetadata;
    @NotNull
    private final Function2<GitRepository, Boolean, Unit> cleanupBeforeCommit;
    @NotNull
    private final String activityName;
    @NotNull
    private final ActivityId activityId;
    @NotNull
    private final GitRepositoryManager repositoryManager;
    private final VcsNotifier vcsNotifier;
    @NotNull
    private final ChangeListManagerEx changeListManager;
    @NotNull
    private final AbstractVcsHelper vcsHelper;
    private final boolean autoCommit;
    @NotNull
    private static final Logger LOG;

    public GitApplyChangesProcess(@NotNull Project project, @NotNull List<? extends VcsFullCommitDetails> commits2, boolean forceAutoCommit, @Nls @NotNull String operationName, @Nls @NotNull String appliedWord, @NotNull Function4<? super GitRepository, ? super VcsCommitMetadata, ? super Boolean, ? super List<? extends GitLineHandlerListener>, ? extends GitCommandResult> command, @NotNull GitAbortOperationAction abortCommand, @NotNull Function1<? super GitCommandResult, Boolean> emptyCommitDetector, @NotNull Function2<? super GitRepository, ? super VcsFullCommitDetails, String> defaultCommitMessageGenerator, boolean preserveCommitMetadata, @NotNull Function2<? super GitRepository, ? super Boolean, Unit> cleanupBeforeCommit, @NotNull String activityName, @NotNull ActivityId activityId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)appliedWord, (String)"appliedWord");
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)abortCommand, (String)"abortCommand");
        Intrinsics.checkNotNullParameter(emptyCommitDetector, (String)"emptyCommitDetector");
        Intrinsics.checkNotNullParameter(defaultCommitMessageGenerator, (String)"defaultCommitMessageGenerator");
        Intrinsics.checkNotNullParameter(cleanupBeforeCommit, (String)"cleanupBeforeCommit");
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        this.project = project;
        this.commits = commits2;
        this.operationName = operationName;
        this.appliedWord = appliedWord;
        this.command = command;
        this.abortCommand = abortCommand;
        this.emptyCommitDetector = emptyCommitDetector;
        this.defaultCommitMessageGenerator = defaultCommitMessageGenerator;
        this.preserveCommitMetadata = preserveCommitMetadata;
        this.cleanupBeforeCommit = cleanupBeforeCommit;
        this.activityName = activityName;
        this.activityId = activityId;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        this.repositoryManager = gitRepositoryManager;
        this.vcsNotifier = VcsNotifier.getInstance((Project)this.project);
        ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManagerEx, (String)"getInstanceEx(...)");
        this.changeListManager = changeListManagerEx;
        AbstractVcsHelper abstractVcsHelper = AbstractVcsHelper.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsHelper, (String)"getInstance(...)");
        this.vcsHelper = abstractVcsHelper;
        this.autoCommit = forceAutoCommit || !this.changeListManager.areChangeListsEnabled();
    }

    public /* synthetic */ GitApplyChangesProcess(Project project, List list2, boolean bl, String string, String string2, Function4 function4, GitAbortOperationAction gitAbortOperationAction, Function1 function1, Function2 function2, boolean bl2, Function2 function22, String string3, ActivityId activityId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x400) != 0) {
            function22 = 1.INSTANCE;
        }
        this(project, list2, bl, string, string2, (Function4<? super GitRepository, ? super VcsCommitMetadata, ? super Boolean, ? super List<? extends GitLineHandlerListener>, ? extends GitCommandResult>)function4, gitAbortOperationAction, (Function1<? super GitCommandResult, Boolean>)function1, (Function2<? super GitRepository, ? super VcsFullCommitDetails, String>)function2, bl2, (Function2<? super GitRepository, ? super Boolean, Unit>)function22, string3, activityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        if (this.changeListManager.areChangeListsEnabled()) {
            CountDownLatch semaphore = new CountDownLatch(1);
            this.changeListManager.invokeAfterUpdate(false, () -> GitApplyChangesProcess.execute$lambda$0(semaphore));
            ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)semaphore);
        }
        Map map2 = DvcsUtil.groupCommitsByRoots((RepositoryManager)((RepositoryManager)this.repositoryManager), this.commits);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"groupCommitsByRoots(...)");
        Map commitsInRoots = map2;
        LOG.info(this.operationName + "ing commits: " + this.toString(commitsInRoots));
        List successfulCommits = new ArrayList();
        List skippedCommits = new ArrayList();
        for (Map.Entry entry : commitsInRoots.entrySet()) {
            GitRepository repository = (GitRepository)entry.getKey();
            List repoCommits = (List)entry.getValue();
            try {
                for (VcsFullCommitDetails commit : repoCommits) {
                    Intrinsics.checkNotNull((Object)repository);
                    Intrinsics.checkNotNull((Object)commit);
                    boolean success2 = this.executeForCommit(repository, commit, successfulCommits, skippedCommits);
                    if (success2) continue;
                    return;
                }
            }
            finally {
                repository.update();
            }
        }
        this.notifyResult(successfulCommits, skippedCommits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean executeForCommit(GitRepository repository, VcsFullCommitDetails commit, List<VcsFullCommitDetails> successfulCommits, List<VcsFullCommitDetails> alreadyPicked) {
        GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.CHERRY_PICK_CONFLICT);
        GitSimpleEventDetector localChangesOverwrittenDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.LOCAL_CHANGES_OVERWRITTEN_BY_CHERRY_PICK);
        GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(repository.getRoot());
        String commitMessage = (String)this.defaultCommitMessageGenerator.invoke((Object)repository, (Object)commit);
        CommitStrategy strategy = GitStageManagerKt.isStagingAreaAvailable(this.project) ? (CommitStrategy)new StagingAreaCommit(repository, commit, commitMessage) : (this.changeListManager.areChangeListsEnabled() && VcsApplicationSettings.getInstance().CREATE_CHANGELISTS_AUTOMATICALLY ? (CommitStrategy)new ChangeListCommit(repository, commit, commitMessage) : (CommitStrategy)new SimplifiedCommit(repository, commit, commitMessage));
        LocalHistoryAction action = LocalHistory.Companion.getInstance().startAction(this.activityName, this.activityId);
        strategy.start();
        try {
            Hash startHash = GitUtil.getHead(repository);
            Object[] objectArray = new GitLineHandlerListener[]{conflictDetector, localChangesOverwrittenDetector, untrackedFilesDetector};
            GitCommandResult result2 = (GitCommandResult)this.command.invoke((Object)repository, (Object)commit, (Object)this.autoCommit, (Object)CollectionsKt.listOf((Object[])objectArray));
            if (result2.success()) {
                if (this.autoCommit) {
                    GitUtil.refreshChangedVfs(repository, startHash);
                    successfulCommits.add(commit);
                    boolean bl = true;
                    return bl;
                }
                VirtualFile virtualFile = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                this.refreshStagedVfs(virtualFile);
                VcsDirtyScopeManager.getInstance((Project)this.project).dirDirtyRecursively(repository.getRoot());
                this.changeListManager.waitForUpdate();
                strategy.afterChangesRefreshed();
                boolean bl = strategy.doUserCommit(successfulCommits, alreadyPicked);
                return bl;
            }
            if (conflictDetector.hasHappened()) {
                VirtualFile virtualFile = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                String string = ((Hash)commit.getId()).toShortString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortString(...)");
                String string2 = VcsUserUtil.getShortPresentation((VcsUser)commit.getAuthor());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortPresentation(...)");
                String string3 = commit.getSubject();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSubject(...)");
                boolean mergeCompleted = new ConflictResolver(this.project, virtualFile, string, string2, string3, this.operationName).merge();
                VirtualFile virtualFile2 = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
                this.refreshStagedVfs(virtualFile2);
                VcsDirtyScopeManager.getInstance((Project)this.project).dirDirtyRecursively(repository.getRoot());
                this.changeListManager.waitForUpdate();
                strategy.afterChangesRefreshed();
                if (mergeCompleted) {
                    LOG.debug("All conflicts resolved, will show commit dialog.");
                    boolean bl = strategy.doUserCommit(successfulCommits, alreadyPicked);
                    return bl;
                }
                this.notifyConflictWarning(repository, commit, successfulCommits);
                boolean bl = false;
                return bl;
            }
            if (untrackedFilesDetector.wasMessageDetected()) {
                String description2 = this.getSuccessfulCommitDetailsIfAny(successfulCommits);
                GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.project, repository.getRoot(), (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), this.operationName, description2);
                boolean bl = false;
                return bl;
            }
            if (localChangesOverwrittenDetector.hasHappened()) {
                Object[] objectArray2 = new Object[]{this.operationName};
                String string = GitBundle.message("apply.changes.would.be.overwritten", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.notifyError(string, commit, successfulCommits);
                boolean bl = false;
                return bl;
            }
            if (((Boolean)this.emptyCommitDetector.invoke((Object)result2)).booleanValue()) {
                alreadyPicked.add(commit);
                boolean bl = true;
                return bl;
            }
            String string = result2.getErrorOutputAsHtmlString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorOutputAsHtmlString(...)");
            this.notifyError(string, commit, successfulCommits);
            boolean bl = false;
            return bl;
        }
        finally {
            strategy.finish();
            action.finish();
        }
    }

    private final boolean commitChangelist(GitRepository repository, VcsFullCommitDetails commit, String commitMessage, LocalChangeList changeList, List<VcsFullCommitDetails> successfulCommits, List<VcsFullCommitDetails> alreadyPicked) {
        LocalChangeList actualList = this.changeListManager.getChangeList(changeList.getId());
        if (actualList == null) {
            String string = changeList.getId();
            String string2 = changeList.getName();
            List list2 = this.changeListManager.getChangeLists();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChangeLists(...)");
            LOG.error("Couldn't find the changelist with id " + string + " and name " + string2 + " among " + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)commitChangelist.1.INSTANCE, (int)31, null));
            return false;
        }
        Collection changes = actualList.getChanges();
        if (changes.isEmpty()) {
            LOG.debug("No changes in the " + actualList + ". All changes in the CLM: " + this.getAllChangesInLogFriendlyPresentation((ChangeListManager)this.changeListManager));
            alreadyPicked.add(commit);
            return true;
        }
        LOG.debug("Showing commit dialog for changes: " + changes);
        Intrinsics.checkNotNull((Object)changes);
        boolean committed = this.showCommitDialogAndWaitForCommit(repository, changeList, commitMessage, changes);
        if (committed) {
            this.markDirty(changes);
            this.changeListManager.waitForUpdate();
            successfulCommits.add(commit);
            return true;
        }
        this.notifyCommitCancelled(commit, successfulCommits);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAllChangesInLogFriendlyPresentation(ChangeListManager changeListManager) {
        void $this$mapTo$iv$iv;
        List list2 = changeListManager.getChangeLists();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChangeLists(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalChangeList localChangeList = (LocalChangeList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("[" + it.getName() + "] " + it.getChanges());
        }
        return (List)destination$iv$iv;
    }

    private final void refreshStagedVfs(VirtualFile root) {
        Collection<GitChangeUtils.GitDiffChange> collection = GitChangeUtils.getStagedChanges(this.project, root);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getStagedChanges(...)");
        Collection<GitChangeUtils.GitDiffChange> staged = collection;
        RefreshVFsSynchronously.refresh$default((RefreshVFsSynchronously)RefreshVFsSynchronously.INSTANCE, staged, (boolean)false, (int)2, null);
    }

    private final void markDirty(Collection<? extends Change> changes) {
        VcsDirtyScopeManager.getInstance((Project)this.project).filePathsDirty((Collection)ChangesUtil.getPaths(changes), null);
    }

    private final boolean showCommitDialogAndWaitForCommit(GitRepository repository, LocalChangeList changeList, String commitMessage, Collection<? extends Change> changes) {
        AtomicBoolean commitSucceeded = new AtomicBoolean();
        Semaphore sem = new Semaphore(0);
        ApplicationManager.getApplication().invokeAndWait(() -> GitApplyChangesProcess.showCommitDialogAndWaitForCommit$lambda$2(this, repository, changes, changeList, commitMessage, commitSucceeded, sem), ModalityState.nonModal());
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return commitSucceeded.get();
    }

    private final ChangeListData createChangeListData(VcsFullCommitDetails commit) {
        return new ChangeListData(commit.getAuthor(), new Date(commit.getAuthorTime()));
    }

    private final void notifyResult(List<? extends VcsFullCommitDetails> successfulCommits, List<? extends VcsFullCommitDetails> skipped) {
        if (skipped.isEmpty()) {
            Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.operationName)};
            this.vcsNotifier.notifySuccess(null, GitBundle.message("apply.changes.operation.successful", objectArray), this.getCommitsDetails(successfulCommits));
        } else if (!((Collection)successfulCommits).isEmpty()) {
            Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.appliedWord), successfulCommits.size(), successfulCommits.size() + skipped.size()};
            String string = GitBundle.message("apply.changes.applied.for.commits", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            String description2 = this.getCommitsDetails(successfulCommits) + "<hr/>" + this.formSkippedDescription(skipped, true);
            this.vcsNotifier.notifySuccess(null, title, description2);
        } else {
            Object[] objectArray = new Object[]{this.operationName};
            this.vcsNotifier.notifyImportantWarning(null, GitBundle.message("apply.changes.nothing.to.do", objectArray), this.formSkippedDescription(skipped, false));
        }
    }

    private final void notifyConflictWarning(GitRepository repository, VcsFullCommitDetails commit, List<? extends VcsFullCommitDetails> successfulCommits) {
        Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.operationName)};
        String string = GitBundle.message("apply.changes.operation.performed.with.conflicts", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        Object description2 = this.commitDetails(commit);
        description2 = (String)description2 + "<br/>" + GitBundle.message("apply.changes.unresolved.conflicts.text", new Object[0]);
        description2 = (String)description2 + this.getSuccessfulCommitDetailsIfAny(successfulCommits);
        Object[] objectArray2 = new Object[]{StringsKt.capitalize((String)this.operationName)};
        Notification notification2 = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, (String)description2, NotificationType.WARNING).addAction((AnAction)NotificationAction.createSimple((String)GitBundle.message("apply.changes.unresolved.conflicts.notification.resolve.action.text", new Object[0]), () -> GitApplyChangesProcess.notifyConflictWarning$lambda$3(commit, this, repository))).addAction((AnAction)NotificationAction.create((String)GitBundle.message("apply.changes.unresolved.conflicts.notification.abort.action.text", objectArray2), (arg_0, arg_1) -> GitApplyChangesProcess.notifyConflictWarning$lambda$4((Function2)new Function2<AnActionEvent, Notification, Unit>(this, repository){
            final /* synthetic */ GitApplyChangesProcess this$0;
            final /* synthetic */ GitRepository $repository;
            {
                this.this$0 = $receiver;
                this.$repository = $repository;
                super(2);
            }

            public final void invoke(AnActionEvent anActionEvent, Notification notification2) {
                if (GitApplyChangesProcess.access$getAbortCommand$p(this.this$0).performInBackground(this.$repository)) {
                    notification2.expire();
                }
            }
        }, arg_0, arg_1)));
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"addAction(...)");
        Notification notification3 = notification2;
        VcsNotifier.getInstance((Project)this.project).notify(notification3);
    }

    private final void notifyCommitCancelled(VcsFullCommitDetails commit, List<? extends VcsFullCommitDetails> successfulCommits) {
        if (successfulCommits.isEmpty()) {
            return;
        }
        Object description2 = this.commitDetails(commit);
        description2 = (String)description2 + this.getSuccessfulCommitDetailsIfAny(successfulCommits);
        Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.operationName)};
        this.vcsNotifier.notifyMinorWarning("git.commit.cancelled", GitBundle.message("apply.changes.operation.canceled", objectArray), (String)description2);
    }

    private final void notifyError(@Nls String content, VcsFullCommitDetails failedCommit, List<? extends VcsFullCommitDetails> successfulCommits) {
        String description2 = this.commitDetails(failedCommit) + "<br/>" + content;
        description2 = description2 + this.getSuccessfulCommitDetailsIfAny(successfulCommits);
        Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.operationName)};
        this.vcsNotifier.notifyError(null, GitBundle.message("apply.changes.operation.failed", objectArray), description2);
    }

    @Nls
    private final String getSuccessfulCommitDetailsIfAny(List<? extends VcsFullCommitDetails> successfulCommits) {
        Object description2 = "";
        if (!((Collection)successfulCommits).isEmpty()) {
            Object[] objectArray = new Object[]{this.operationName, successfulCommits.size()};
            description2 = (String)description2 + "<hr/>" + GitBundle.message("apply.changes.operation.successful.for.commits", objectArray) + "<br/>";
            description2 = (String)description2 + this.getCommitsDetails(successfulCommits);
        }
        return description2;
    }

    @Nls
    private final String formSkippedDescription(List<? extends VcsFullCommitDetails> skipped, boolean but) {
        String string = StringUtil.join((Collection)skipped, arg_0 -> GitApplyChangesProcess.formSkippedDescription$lambda$5(formSkippedDescription.hashes.1.INSTANCE, arg_0), (String)", ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String hashes2 = string;
        if (but) {
            Object[] objectArray = new Object[]{hashes2, skipped.size(), this.appliedWord};
            String string2 = GitBundle.message("apply.changes.skipped", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        Object[] objectArray = new Object[]{hashes2, this.appliedWord};
        String string3 = GitBundle.message("apply.changes.everything.applied", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return string3;
    }

    @NlsSafe
    private final String getCommitsDetails(List<? extends VcsFullCommitDetails> successfulCommits) {
        Object description2 = "";
        for (VcsFullCommitDetails vcsFullCommitDetails : successfulCommits) {
            if (((CharSequence)description2).length() > 0) {
                description2 = (String)description2 + "<br/>";
            }
            description2 = (String)description2 + this.commitDetails(vcsFullCommitDetails);
        }
        return description2;
    }

    @NlsSafe
    private final String commitDetails(VcsFullCommitDetails commit) {
        return ((Hash)commit.getId()).toShortString() + " " + StringUtil.escapeXmlEntities((String)commit.getSubject());
    }

    private final String toString(Map<GitRepository, ? extends List<? extends VcsFullCommitDetails>> commitsInRoots) {
        return CollectionsKt.joinToString$default((Iterable)commitsInRoots.entrySet(), (CharSequence)"; ", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null);
    }

    private static final void execute$lambda$0(CountDownLatch $semaphore) {
        Intrinsics.checkNotNullParameter((Object)$semaphore, (String)"$semaphore");
        $semaphore.countDown();
    }

    private static final void showCommitDialogAndWaitForCommit$lambda$2(GitApplyChangesProcess this$0, GitRepository $repository, Collection $changes, LocalChangeList $changeList, String $commitMessage, AtomicBoolean $commitSucceeded, Semaphore $sem) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        Intrinsics.checkNotNullParameter((Object)$changes, (String)"$changes");
        Intrinsics.checkNotNullParameter((Object)$changeList, (String)"$changeList");
        Intrinsics.checkNotNullParameter((Object)$commitMessage, (String)"$commitMessage");
        Intrinsics.checkNotNullParameter((Object)$commitSucceeded, (String)"$commitSucceeded");
        Intrinsics.checkNotNullParameter((Object)$sem, (String)"$sem");
        try {
            this$0.cleanupBeforeCommit.invoke((Object)$repository, (Object)this$0.autoCommit);
            boolean commitNotCancelled2 = this$0.vcsHelper.commitChanges($changes, $changeList, $commitMessage, new CommitResultHandler($commitSucceeded, $sem){
                final /* synthetic */ AtomicBoolean $commitSucceeded;
                final /* synthetic */ Semaphore $sem;
                {
                    this.$commitSucceeded = $commitSucceeded;
                    this.$sem = $sem;
                }

                public void onSuccess(@NotNull String commitMessage1) {
                    Intrinsics.checkNotNullParameter((Object)commitMessage1, (String)"commitMessage1");
                    this.$commitSucceeded.set(true);
                    this.$sem.release();
                }

                public void onCancel() {
                    this.$commitSucceeded.set(false);
                    this.$sem.release();
                }

                public void onFailure(@NotNull List<? extends VcsException> errors) {
                    Intrinsics.checkNotNullParameter(errors, (String)"errors");
                    this.$commitSucceeded.set(false);
                    this.$sem.release();
                }
            });
            if (!commitNotCancelled2) {
                $commitSucceeded.set(false);
                $sem.release();
            }
        }
        catch (Throwable t) {
            LOG.error(t);
            $commitSucceeded.set(false);
            $sem.release();
        }
    }

    private static final void notifyConflictWarning$lambda$3(VcsFullCommitDetails $commit, GitApplyChangesProcess this$0, GitRepository $repository) {
        Intrinsics.checkNotNullParameter((Object)$commit, (String)"$commit");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        String string = ((Hash)$commit.getId()).toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortString(...)");
        String hash = string;
        String string2 = VcsUserUtil.getShortPresentation((VcsUser)$commit.getAuthor());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortPresentation(...)");
        String commitAuthor = string2;
        String string3 = $commit.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSubject(...)");
        String commitMessage = string3;
        Project project = this$0.project;
        VirtualFile virtualFile = $repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        new ConflictResolver(project, virtualFile, hash, commitAuthor, commitMessage, this$0.operationName).mergeNoProceedInBackground();
    }

    private static final void notifyConflictWarning$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final String formSkippedDescription$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ GitAbortOperationAction access$getAbortCommand$p(GitApplyChangesProcess $this) {
        return $this.abortCommand;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitApplyChangesProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lgit4idea/GitApplyChangesProcess$ChangeListCommit;", "Lgit4idea/GitApplyChangesProcess$CommitStrategy;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "commitMessage", "", "(Lgit4idea/GitApplyChangesProcess;Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsFullCommitDetails;Ljava/lang/String;)V", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "getChangeList", "()Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "setChangeList", "(Lcom/intellij/openapi/vcs/changes/LocalChangeList;)V", "getCommit", "()Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getCommitMessage", "()Ljava/lang/String;", "previousDefaultChangelist", "getPreviousDefaultChangelist", "setPreviousDefaultChangelist", "getRepository", "()Lgit4idea/repo/GitRepository;", "doUserCommit", "", "successfulCommits", "", "alreadyPicked", "finish", "", "start", "intellij.vcs.git"})
    private final class ChangeListCommit
    extends CommitStrategy {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final VcsFullCommitDetails commit;
        @NotNull
        private final String commitMessage;
        public LocalChangeList changeList;
        public LocalChangeList previousDefaultChangelist;

        public ChangeListCommit(@NotNull GitRepository repository, @NotNull VcsFullCommitDetails commit, String commitMessage) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            this.repository = repository;
            this.commit = commit;
            this.commitMessage = commitMessage;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final VcsFullCommitDetails getCommit() {
            return this.commit;
        }

        @NotNull
        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @NotNull
        public final LocalChangeList getChangeList() {
            LocalChangeList localChangeList = this.changeList;
            if (localChangeList != null) {
                return localChangeList;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeList");
            return null;
        }

        public final void setChangeList(@NotNull LocalChangeList localChangeList) {
            Intrinsics.checkNotNullParameter((Object)localChangeList, (String)"<set-?>");
            this.changeList = localChangeList;
        }

        @NotNull
        public final LocalChangeList getPreviousDefaultChangelist() {
            LocalChangeList localChangeList = this.previousDefaultChangelist;
            if (localChangeList != null) {
                return localChangeList;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousDefaultChangelist");
            return null;
        }

        public final void setPreviousDefaultChangelist(@NotNull LocalChangeList localChangeList) {
            Intrinsics.checkNotNullParameter((Object)localChangeList, (String)"<set-?>");
            this.previousDefaultChangelist = localChangeList;
        }

        @Override
        public void start() {
            LocalChangeList localChangeList = GitApplyChangesProcess.this.changeListManager.getDefaultChangeList();
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
            this.setPreviousDefaultChangelist(localChangeList);
            String changeListName = ChangeListUtil.createNameForChangeList((Project)GitApplyChangesProcess.this.project, (String)this.commitMessage);
            ChangeListData changeListData = GitApplyChangesProcess.this.preserveCommitMetadata ? GitApplyChangesProcess.this.createChangeListData(this.commit) : null;
            LocalChangeList localChangeList2 = GitApplyChangesProcess.this.changeListManager.addChangeList(changeListName, this.commitMessage, changeListData);
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList2, (String)"addChangeList(...)");
            this.setChangeList(localChangeList2);
            GitApplyChangesProcess.this.changeListManager.setDefaultChangeList(this.getChangeList(), true);
        }

        @Override
        public void finish() {
            GitApplyChangesProcess.this.changeListManager.setDefaultChangeList(this.getPreviousDefaultChangelist(), true);
            GitApplyChangesProcess.this.changeListManager.scheduleAutomaticEmptyChangeListDeletion(this.getChangeList(), true);
        }

        @Override
        public boolean doUserCommit(@NotNull List<VcsFullCommitDetails> successfulCommits, @NotNull List<VcsFullCommitDetails> alreadyPicked) {
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
            return GitApplyChangesProcess.this.commitChangelist(this.repository, this.commit, this.commitMessage, this.getChangeList(), successfulCommits, alreadyPicked);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J$\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/GitApplyChangesProcess$CommitStrategy;", "", "()V", "afterChangesRefreshed", "", "doUserCommit", "", "successfulCommits", "", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "alreadyPicked", "finish", "start", "intellij.vcs.git"})
    private static abstract class CommitStrategy {
        public void start() {
        }

        public void finish() {
        }

        public abstract boolean doUserCommit(@NotNull List<VcsFullCommitDetails> var1, @NotNull List<VcsFullCommitDetails> var2);

        public void afterChangesRefreshed() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/GitApplyChangesProcess$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0001\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lgit4idea/GitApplyChangesProcess$ConflictResolver;", "Lgit4idea/merge/GitConflictResolver;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "commitHash", "", "commitAuthor", "commitMessage", "operationName", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "notifyUnresolvedRemain", "", "intellij.vcs.git"})
    public static final class ConflictResolver
    extends GitConflictResolver {
        public ConflictResolver(@NotNull Project project, @NotNull VirtualFile root, @NotNull String commitHash, @NotNull String commitAuthor, @NotNull String commitMessage, @Nls @NotNull String operationName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)commitAuthor, (String)"commitAuthor");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
            super(project, SetsKt.setOf((Object)root), GitApplyChangesProcessKt.access$makeParams(project, commitHash, commitAuthor, commitMessage, operationName));
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lgit4idea/GitApplyChangesProcess$SimplifiedCommit;", "Lgit4idea/GitApplyChangesProcess$CommitStrategy;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "commitMessage", "", "(Lgit4idea/GitApplyChangesProcess;Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsFullCommitDetails;Ljava/lang/String;)V", "getCommit", "()Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getCommitMessage", "()Ljava/lang/String;", "getRepository", "()Lgit4idea/repo/GitRepository;", "afterChangesRefreshed", "", "doUserCommit", "", "successfulCommits", "", "alreadyPicked", "intellij.vcs.git"})
    private final class SimplifiedCommit
    extends CommitStrategy {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final VcsFullCommitDetails commit;
        @NotNull
        private final String commitMessage;

        public SimplifiedCommit(@NotNull GitRepository repository, @NotNull VcsFullCommitDetails commit, String commitMessage) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            this.repository = repository;
            this.commit = commit;
            this.commitMessage = commitMessage;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final VcsFullCommitDetails getCommit() {
            return this.commit;
        }

        @NotNull
        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public boolean doUserCommit(@NotNull List<VcsFullCommitDetails> successfulCommits, @NotNull List<VcsFullCommitDetails> alreadyPicked) {
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
            LocalChangeList localChangeList = GitApplyChangesProcess.this.changeListManager.getDefaultChangeList();
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
            LocalChangeList list2 = localChangeList;
            return GitApplyChangesProcess.this.commitChangelist(this.repository, this.commit, this.commitMessage, list2, successfulCommits, alreadyPicked);
        }

        @Override
        public void afterChangesRefreshed() {
            LocalChangeList localChangeList = GitApplyChangesProcess.this.changeListManager.getDefaultChangeList();
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
            LocalChangeList list2 = localChangeList;
            if (GitApplyChangesProcess.this.preserveCommitMetadata && GitApplyChangesProcess.this.changeListManager.areChangeListsEnabled()) {
                Collection collection = list2.getChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
                if (!collection.isEmpty()) {
                    GitApplyChangesProcess.this.changeListManager.editChangeListData(list2.getName(), GitApplyChangesProcess.this.createChangeListData(this.commit));
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lgit4idea/GitApplyChangesProcess$StagingAreaCommit;", "Lgit4idea/GitApplyChangesProcess$CommitStrategy;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "commitMessage", "", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsFullCommitDetails;Ljava/lang/String;)V", "getCommit", "()Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getCommitMessage", "()Ljava/lang/String;", "getRepository", "()Lgit4idea/repo/GitRepository;", "doUserCommit", "", "successfulCommits", "", "alreadyPicked", "intellij.vcs.git"})
    private static final class StagingAreaCommit
    extends CommitStrategy {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final VcsFullCommitDetails commit;
        @NotNull
        private final String commitMessage;

        public StagingAreaCommit(@NotNull GitRepository repository, @NotNull VcsFullCommitDetails commit, @NotNull String commitMessage) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            this.repository = repository;
            this.commit = commit;
            this.commitMessage = commitMessage;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final VcsFullCommitDetails getCommit() {
            return this.commit;
        }

        @NotNull
        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public boolean doUserCommit(@NotNull List<VcsFullCommitDetails> successfulCommits, @NotNull List<VcsFullCommitDetails> alreadyPicked) {
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ StagingAreaCommit this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Project project = this.this$0.getRepository().getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    GitStageContentProviderKt.showStagingArea(project, this.this$0.getCommitMessage());
                }
            }), (int)1, null);
            return false;
        }
    }
}

