/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormats;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.csv.CsvSettingsService;
import com.intellij.database.csv.PersistentCsvFormat;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="CsvSettings", storages={@Storage(value="csvSettings.xml")}, category=SettingsCategory.TOOLS)
public final class CsvSettings
implements PersistentStateComponent<CsvSettings>,
ModificationTracker,
CsvFormatsSettings {
    private static final int CURRENT_VERSION = 1;
    static final String STATE_NAME = "csvSettings";
    private final AtomicLong myModificationCount = new AtomicLong();
    @Attribute(value="version")
    @Property(alwaysWrite=true)
    private int version = 0;
    @XCollection(propertyElementName="csv-formats", elementName="format", elementTypes={PersistentCsvFormat.class})
    public List<PersistentCsvFormat> csvFormats = new ArrayList<PersistentCsvFormat>();

    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CsvSettings getSettings() {
        CsvSettings settings = (CsvSettings)ApplicationManager.getApplication().getService(CsvSettings.class);
        if (settings != null && settings.version == 0) {
            CsvSettings csvSettings = settings;
            synchronized (csvSettings) {
                settings.ensureDefaultsSet();
            }
        }
        return settings;
    }

    @Override
    public void fireChanged() {
        CsvSettings.fireSettingsChanged();
    }

    public static void fireSettingsChanged() {
        CsvSettings instance = CsvSettings.getSettings();
        instance.myModificationCount.incrementAndGet();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        ((CsvFormatsSettings.Listener)messageBus.syncPublisher(CsvFormatsSettings.TOPIC)).settingsChanged();
    }

    public static CsvSettings create() {
        CsvSettings settings = new CsvSettings();
        settings.ensureDefaultsSet();
        return settings;
    }

    private CsvSettings() {
    }

    @NotNull
    public CsvSettings getState() {
        CsvSettings csvSettings = this;
        if (csvSettings == null) {
            CsvSettings.$$$reportNull$$$0(0);
        }
        return csvSettings;
    }

    @TestOnly
    public CsvSettings copy() {
        return (CsvSettings)XmlSerializer.deserialize((Element)XmlSerializer.serialize((Object)this), CsvSettings.class);
    }

    public void loadState(@NotNull CsvSettings state) {
        if (state == null) {
            CsvSettings.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        this.ensureDefaultsSet();
    }

    @Override
    @NotNull
    public List<CsvFormat> getCsvFormats() {
        List<CsvFormat> formats = CsvSettings.getImmutableFormats(this.csvFormats);
        List<CsvFormat> list = formats.isEmpty() ? CsvSettings.getDefaultFormats() : formats;
        if (list == null) {
            CsvSettings.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<CsvFormat> getDefaultFormats() {
        List<CsvFormat> list = Arrays.asList((CsvFormat)CsvFormats.CSV_FORMAT.getValue(), (CsvFormat)CsvFormats.TSV_FORMAT.getValue(), (CsvFormat)CsvFormats.PIPE_SEPARATED_FORMAT.getValue(), (CsvFormat)CsvFormats.SEMICOLON_SEPARATED_FORMAT.getValue());
        if (list == null) {
            CsvSettings.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void setCsvFormats(@NotNull List<CsvFormat> formats) {
        if (formats == null) {
            CsvSettings.$$$reportNull$$$0(4);
        }
        this.csvFormats = ContainerUtil.map(formats, PersistentCsvFormat::new);
    }

    private void ensureDefaultsSet() {
        if (CsvSettings.getImmutableFormats(this.csvFormats).isEmpty()) {
            CsvFormatsSettings databaseSettings = CsvSettingsService.getDatabaseSettings();
            if (databaseSettings != null) {
                for (CsvFormat format : databaseSettings.getCsvFormats()) {
                    this.csvFormats.add(new PersistentCsvFormat(format));
                }
            } else {
                this.setCsvFormats(CsvSettings.getDefaultFormats());
            }
            this.myModificationCount.incrementAndGet();
        }
        this.version = 1;
    }

    public static void addNewFormat(@NotNull List<PersistentCsvFormat> csvFormats, @NotNull CsvFormat newFormat, @Nullable CsvFormat addAfterThis) {
        if (csvFormats == null) {
            CsvSettings.$$$reportNull$$$0(5);
        }
        if (newFormat == null) {
            CsvSettings.$$$reportNull$$$0(6);
        }
        if (ContainerUtil.exists(csvFormats, f -> CsvSettings.formatsSimilar(newFormat, f))) {
            return;
        }
        int tsvIndex = addAfterThis == null ? csvFormats.size() - 1 : ContainerUtil.indexOf(csvFormats, f -> f.id.equals(addAfterThis.id));
        csvFormats.add(tsvIndex + 1, new PersistentCsvFormat(newFormat));
    }

    public static boolean formatsSimilar(@NotNull CsvFormat format, @NotNull PersistentCsvFormat f) {
        if (format == null) {
            CsvSettings.$$$reportNull$$$0(7);
        }
        if (f == null) {
            CsvSettings.$$$reportNull$$$0(8);
        }
        if (StringUtil.equals((CharSequence)f.name, (CharSequence)format.name)) {
            return true;
        }
        CsvFormat immutable = f.immutable();
        return CsvFormatsSettings.formatsSimilar(format, immutable);
    }

    @NotNull
    private static List<CsvFormat> getImmutableFormats(@NotNull List<PersistentCsvFormat> persistentFormats) {
        if (persistentFormats == null) {
            CsvSettings.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.mapNotNull(persistentFormats, format -> format == null ? null : format.immutable());
        if (list == null) {
            CsvSettings.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/CsvSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "csvFormats";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFormat";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentFormats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/CsvSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCsvFormats";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFormats";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableFormats";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCsvFormats";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNewFormat";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatsSimilar";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getImmutableFormats";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

